/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.consumo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.opcoesmanutencaoativos.EnumConstTipoMovimentoConsumo;
import com.touchcomp.basementor.constants.enums.profrota.EnumProFrotaTipoVeiculo;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.ItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Motorista;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.OpcoesCtf;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtfPessoa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.Veiculo;
import com.touchcomp.basementorclientwebservices.profrota.model.RetornoAbastecimento;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.ctf.EnumCTF;
import com.touchcomp.basementorexceptions.exceptions.impl.ctf.ExceptionCTF;
import com.touchcomp.basementorexceptions.exceptions.impl.database.ExceptionDatabase;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.coleta.CompColeta;
import com.touchcomp.basementorservice.components.pessoa.CompPessoa;
import com.touchcomp.basementorservice.helpers.impl.consumoativo.HelperConsumoAtivo;
import com.touchcomp.basementorservice.helpers.impl.fornecedor.HelperFornecedor;
import com.touchcomp.basementorservice.helpers.impl.requisicao.HelperRequisicao;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.consumoativo.ServiceConsumoAtivoImpl;
import com.touchcomp.basementorservice.service.impl.fornecedor.ServiceFornecedorImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.motorista.ServiceMotoristaImpl;
import com.touchcomp.basementorservice.service.impl.opcoesmanutencequip.ServiceOpcoesManutencEquipImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctfpessoa.ServiceParametrizacaoCtfPessoaImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.veiculo.ServiceVeiculoImpl;
import com.touchcomp.basementorservice.service.interfaces.ServicePessoa;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import java.util.List;

class AuxConsumoAtivoProFrota {
    private final ServiceConsumoAtivoImpl serviceConsumoAtivo;
    private final HelperConsumoAtivo helperConsumoAtivo;
    private final ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    private final ServiceVeiculoImpl serviceVeiculo;
    private final HelperRequisicao helperRequisicao;
    private final ServiceProdutoImpl serviceProduto;
    private final ServiceParametrizacaoCtfPessoaImpl serviceParametrizacaoCtfPessoaImpl;
    private final ServiceOpcoesManutencEquipImpl serviceOpcoesManutencEquipImpl;
    private final ServiceGradeCorImpl serviceGradeCorImpl;
    private final ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;
    private final ServiceMotoristaImpl serviceMotoristaImpl;
    private final HelperFornecedor compFornecedor;
    private final CompPessoa compPessoa;
    private final ServiceFornecedorImpl serviceFornecedor;
    private final ServicePessoa servicePessoa;
    private final CompColeta compColeta;

    public AuxConsumoAtivoProFrota(ServiceConsumoAtivoImpl serviceConsumoAtivo, HelperConsumoAtivo helperConsumoAtivo, ServiceSaldoEstoqueImpl serviceSaldoEstoque, ServiceVeiculoImpl serviceVeiculo, HelperRequisicao helperRequisicao, ServiceProdutoImpl serviceProduto, ServiceParametrizacaoCtfPessoaImpl serviceParametrizacaoCtfPessoaImpl, ServiceOpcoesManutencEquipImpl serviceOpcoesManutencEquipImpl, ServiceGradeCorImpl serviceGradeCorImpl, ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl, ServiceMotoristaImpl serviceMotoristaImpl, HelperFornecedor compFornecedor, CompPessoa compPessoa, ServiceFornecedorImpl serviceFornecedor, ServicePessoa servicePessoa, CompColeta compColeta) {
        this.serviceConsumoAtivo = serviceConsumoAtivo;
        this.helperConsumoAtivo = helperConsumoAtivo;
        this.serviceSaldoEstoque = serviceSaldoEstoque;
        this.serviceVeiculo = serviceVeiculo;
        this.helperRequisicao = helperRequisicao;
        this.serviceProduto = serviceProduto;
        this.serviceParametrizacaoCtfPessoaImpl = serviceParametrizacaoCtfPessoaImpl;
        this.serviceOpcoesManutencEquipImpl = serviceOpcoesManutencEquipImpl;
        this.serviceGradeCorImpl = serviceGradeCorImpl;
        this.serviceLoteFabricacaoImpl = serviceLoteFabricacaoImpl;
        this.serviceMotoristaImpl = serviceMotoristaImpl;
        this.compFornecedor = compFornecedor;
        this.compPessoa = compPessoa;
        this.serviceFornecedor = serviceFornecedor;
        this.servicePessoa = servicePessoa;
        this.compColeta = compColeta;
    }

    ConsumoAtivo criarAtualizarConsumoAtivo(ConsumoAtivo consumo, RetornoAbastecimento.Registro registros, OpcoesCtf opcoesCtf, TaskProcessResult result) throws ExceptionCTF, ExceptionBase, ExceptionParamCtbRequisicao {
        if (consumo == null) {
            consumo = new ConsumoAtivo();
        }
        consumo.setConsumoGeradoProFrota(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        consumo.setDataCadastro(new Date());
        consumo.setEmpresa(opcoesCtf.getEmpresa());
        consumo.setDataMovimentacao(ToolDate.strToDate((String)registros.getData(), (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        consumo.setDataConsumo(ToolDate.strToDate((String)registros.getData(), (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        consumo.setObservacao(MessagesBaseMentor.getTextDetailsMsg((String)"M.ERP.1079.001", (Object[])new Object[0]));
        consumo.setNrDocOrigem(registros.getIdentificador());
        if (ToolMethods.isNotNull((Object)registros.getHodometro()).booleanValue()) {
            consumo.setHodometro(registros.getHodometro());
        } else {
            consumo.setHodometro(registros.getHorimetro());
        }
        consumo.setHodometroAnterior(this.serviceConsumoAtivo.getHodometroAnterior(ToolString.refina((String)registros.getVeiculo().getPlaca()), consumo.getDataConsumo(), consumo.getIdentificador()));
        consumo.setCodigoCTF(String.valueOf(registros.getIdentificador()));
        consumo.setEquipamento(this.pesquisarEquipamento(registros.getVeiculo().getPlaca()));
        String cpf = ToolString.completaZerosEsquerda((String)ToolString.refina((String)registros.getMotorista().getCpf()), (int)11);
        consumo.setMotorista(this.serviceMotoristaImpl.findByCNPJ(cpf));
        if (ToolMethods.isNull((Object)consumo.getMotorista()).booleanValue()) {
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "Consumo: " + consumo.getCodigoCTF() + " nao registro o Motorista com o CPF " + cpf + ".");
        }
        consumo.setItemConsumoAtivo(this.criarItemConsumoAtivo(consumo, opcoesCtf, registros));
        consumo.setRequisicao(this.helperRequisicao.gerarRequisicaoConsumoAtivo(consumo));
        if (opcoesCtf.getCriarColeta().equals(EnumConstantsMentorSimNao.SIM.getValue()) && opcoesCtf.getTipoPontoControleColeta() != null && consumo.getHodometro() > 0.0) {
            consumo.setGerarColeta(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            consumo.setTipoPontoControleColeta(opcoesCtf.getTipoPontoControleColeta());
            consumo.setDataHoraColeta(ToolDate.toTimestamp((Date)consumo.getDataMovimentacao()));
            consumo.setValorColeta(Integer.valueOf(consumo.getHodometro().intValue()));
            Coleta coleta = this.compColeta.getColeta(consumo, consumo.getEmpresa());
            consumo.setColeta(coleta);
        }
        return consumo;
    }

    private Equipamento pesquisarEquipamento(String placa) throws ExceptionCTF {
        Veiculo veiculo = this.serviceVeiculo.getByPlaca(ToolString.refina((String)placa));
        if (veiculo != null) {
            return veiculo.getEquipamento();
        }
        return null;
    }

    private List<ItemConsumoAtivo> criarItemConsumoAtivo(ConsumoAtivo consumoAtivo, OpcoesCtf opcoesCtf, RetornoAbastecimento.Registro registros) throws ExceptionCTF, ExceptionBase {
        UnidadeFatFornecedor unidadeFatForn = this.getUnidadeFatFornecedor(registros, opcoesCtf);
        EnumConstTipoMovimentoConsumo tipoConsumoIntExterno = this.helperConsumoAtivo.build(consumoAtivo).getTipoConsumoIntExterno(opcoesCtf.getEmpresa(), unidadeFatForn);
        List itemConsumoAtivo = consumoAtivo.getItemConsumoAtivo();
        itemConsumoAtivo.clear();
        for (RetornoAbastecimento.Item items : registros.getItems()) {
            if (!ToolMethods.isEquals((Object)items.getTipo().getCodigo(), (Object)EnumProFrotaTipoVeiculo.CAMINHAO_SIMPLES.getValue())) continue;
            ItemConsumoAtivo i = new ItemConsumoAtivo();
            i.setConsumoAtivo(consumoAtivo);
            i.setMovInterno(tipoConsumoIntExterno.getValue());
            i.setCentroCusto(consumoAtivo.getEquipamento() != null ? consumoAtivo.getEquipamento().getCentroCusto() : null);
            i.setProduto(this.pesquisarProduto(items.getIdentificador()));
            i.setNaturezaRequisicao(this.pesquisarNaturezaRequisicao(unidadeFatForn, i.getCentroCusto()));
            i.setCentroEstoque(this.pesquisarCentroEstoque(opcoesCtf.getEmpresa()));
            i.setQuantidadeTotal(ToolMethods.isNulThen0((Number)items.getQuantidade()));
            i.setValorDesconto(Double.valueOf(0.0));
            i.setGradeItemConsumoAtivo(this.criarGradeItemConsumo(i, consumoAtivo.getEmpresa()));
            if (TMethods.isEquals((Object)tipoConsumoIntExterno, (Object)EnumConstTipoMovimentoConsumo.CONSUMO_EXTERNO)) {
                i.setUnidadeFatFornecedor(unidadeFatForn);
                i.setValorTotal(ToolMethods.isNulThen0((Number)Math.abs(items.getValorTotal())));
                i.setValorUnitario(ToolMethods.isNulThen0((Number)Math.abs(items.getValorUnitario())));
            } else {
                i.setValorUnitario(this.getCustoMedioProd(i.getProduto(), consumoAtivo.getEmpresa(), consumoAtivo.getDataMovimentacao()));
                i.setValorTotal(Double.valueOf(i.getQuantidadeTotal() * i.getValorUnitario()));
            }
            itemConsumoAtivo.add(i);
        }
        return itemConsumoAtivo;
    }

    private UnidadeFatFornecedor getUnidadeFatFornecedor(RetornoAbastecimento.Registro registros, OpcoesCtf opcoesCtf) throws ExceptionBase {
        Fornecedor fornecedor;
        String cnpj = ToolString.completaZerosEsquerda((String)ToolString.refina((String)registros.getPontoVenda().getCnpj()), (int)14);
        Pessoa pessoa = this.servicePessoa.getByCPFCNPJAtiva(cnpj);
        if (pessoa == null) {
            String nome = registros.getPontoVenda().getRazaoSocial();
            String logradouro = registros.getPontoVenda().getEndereco().getLogradouro();
            Integer numero = registros.getPontoVenda().getEndereco().getNumero();
            String bairro = registros.getPontoVenda().getEndereco().getBairro();
            String cep = registros.getPontoVenda().getEndereco().getCep();
            String uf = registros.getPontoVenda().getEndereco().getUf();
            String complemento = registros.getPontoVenda().getEndereco().getComplemento();
            String municipio = registros.getPontoVenda().getEndereco().getMunicipio();
            Double latitude = registros.getPontoVenda().getEndereco().getLatitude();
            Double longitude = registros.getPontoVenda().getEndereco().getLongitude();
            String numeroStr = numero != null && numero > 0 ? String.valueOf(numero) : null;
            pessoa = this.compPessoa.criarPessoa(opcoesCtf.getEmpresa(), nome, cnpj, logradouro, bairro, cep, complemento, latitude, longitude, null, numeroStr);
            if (pessoa.getEndereco().getCidade() == null) {
                pessoa.getEndereco().setCidade(opcoesCtf.getEmpresa().getPessoa().getEndereco().getCidade());
            }
            pessoa.getEndereco().setObservacao("Criado pro frota: " + municipio + "/" + uf);
            pessoa.setAtivo(Short.valueOf((short)1));
            pessoa = this.servicePessoa.saveOrUpdateFlush(pessoa);
        }
        if ((fornecedor = this.serviceFornecedor.get(pessoa)) == null) {
            fornecedor = this.compFornecedor.criarFornecedor(pessoa, opcoesCtf.getEmpresa(), opcoesCtf.getCategoriaPessoaFornec());
            fornecedor.setAtivo(Short.valueOf((short)1));
            fornecedor = this.serviceFornecedor.saveOrUpdateFlush(fornecedor);
        }
        return (UnidadeFatFornecedor)fornecedor.getUnidadesFatForn().get(0);
    }

    private Double getCustoMedioProd(Produto produto, Empresa empresa, Date dataMovimentacao) {
        return this.serviceSaldoEstoque.findPrecoMedioIdProduto(produto.getIdentificador(), empresa.getIdentificador(), dataMovimentacao);
    }

    private Produto pesquisarProduto(String tipoCombustivel) throws ExceptionCTF {
        List<Produto> listProduto = this.serviceProduto.getByCodSincronizacaoLike(tipoCombustivel);
        Produto produto = null;
        for (Produto p : listProduto) {
            int indice;
            String codSincronizacao = p.getCodSincronizacao();
            do {
                String temp = "";
                indice = codSincronizacao.indexOf(";");
                temp = indice < 1 ? codSincronizacao : codSincronizacao.substring(0, indice);
                if (!ToolMethods.isEquals((Object)temp, (Object)tipoCombustivel)) continue;
                produto = p;
            } while ((codSincronizacao = codSincronizacao.substring(indice + 1, codSincronizacao.length())).contains(";"));
        }
        if (produto == null) {
            throw new ExceptionCTF(EnumCTF.NENHUM_PROD_COMBUSTIVEL_ENC_COD_AUX, new Object[]{tipoCombustivel});
        }
        return produto;
    }

    private NaturezaRequisicao pesquisarNaturezaRequisicao(UnidadeFatFornecedor unidadeFatFornecedor, CentroCusto centroCusto) throws ExceptionCTF {
        ParametrizacaoCtfPessoa para;
        if (ToolMethods.isNotNull((Object)unidadeFatFornecedor).booleanValue() && (para = this.serviceParametrizacaoCtfPessoaImpl.get(unidadeFatFornecedor.getFornecedor().getPessoa())) != null) {
            return para.getNaturezaRequisicao();
        }
        if (ToolMethods.isNotNull((Object)centroCusto).booleanValue() && (para = this.serviceParametrizacaoCtfPessoaImpl.get(centroCusto)) != null) {
            return para.getNaturezaRequisicao();
        }
        return null;
    }

    private CentroEstoque pesquisarCentroEstoque(Empresa empresa) throws ExceptionCTF {
        OpcoesManutencEquip op = this.serviceOpcoesManutencEquipImpl.get(empresa);
        if (op == null || op.getCentroEstoque() == null) {
            throw new ExceptionCTF(EnumCTF.OPCOES_MAN_CENTRO_EST_INFORMADO, new Object[]{empresa});
        }
        return op.getCentroEstoque();
    }

    private List<GradeItemConsumoAtivo> criarGradeItemConsumo(ItemConsumoAtivo itemConsumoAtivo, Empresa empresa) throws ExceptionDatabase {
        List<GradeCor> grades = this.serviceGradeCorImpl.get(itemConsumoAtivo.getProduto());
        List gradeItemConsumoAtivo = itemConsumoAtivo.getGradeItemConsumoAtivo();
        gradeItemConsumoAtivo.clear();
        for (GradeCor gc : grades) {
            GradeItemConsumoAtivo g = new GradeItemConsumoAtivo();
            g.setItemConsumoAtivo(itemConsumoAtivo);
            g.setGradeCor(gc);
            g.setDataCadastro(new Date());
            g.setEmpresa(empresa);
            g.setQuantidade(itemConsumoAtivo.getQuantidadeTotal());
            if (ToolMethods.isEquals((Object)g.getItemConsumoAtivo().getMovInterno(), (Object)EnumConstTipoMovimentoConsumo.CONSUMO_INTERNO.getValue())) {
                g.setLoteFabricacao(this.pesquisarLoteUnico(itemConsumoAtivo.getProduto()));
            }
            gradeItemConsumoAtivo.add(g);
        }
        return gradeItemConsumoAtivo;
    }

    private LoteFabricacao pesquisarLoteUnico(Produto produto) throws ExceptionDatabase {
        LoteFabricacao loteFabricacao = this.serviceLoteFabricacaoImpl.findOrCreateLoteUnico(produto);
        return loteFabricacao;
    }

    public void atualizarConsumoAtivo(ConsumoAtivo consumoAtivo, RetornoAbastecimento.Registro registro, TaskProcessResult result) throws ExceptionCTF {
        Motorista motorista = this.serviceMotoristaImpl.findByCNPJ(ToolString.completaZerosEsquerda((String)ToolString.refina((String)registro.getMotorista().getCpf()), (int)11));
        if (ToolMethods.isNotNull((Object)motorista).booleanValue()) {
            consumoAtivo.setMotorista(motorista);
        }
        consumoAtivo.setDataMovimentacao(ToolDate.strToDate((String)registro.getData(), (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        consumoAtivo.setDataConsumo(ToolDate.strToDate((String)registro.getData(), (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        consumoAtivo.setHodometro(registro.getHodometro());
        consumoAtivo.setHodometroAnterior(this.serviceConsumoAtivo.getHodometroAnterior(ToolString.refina((String)registro.getVeiculo().getPlaca()), consumoAtivo.getDataConsumo(), consumoAtivo.getIdentificador()));
        consumoAtivo.setEquipamento(this.pesquisarEquipamento(registro.getVeiculo().getPlaca()));
        for (ItemConsumoAtivo itemConsumoAtivo : consumoAtivo.getItemConsumoAtivo()) {
            itemConsumoAtivo.setNaturezaRequisicao(this.pesquisarNaturezaRequisicao(itemConsumoAtivo.getUnidadeFatFornecedor(), itemConsumoAtivo.getCentroCusto()));
        }
    }
}

