/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.contabil;

import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbModFiscal;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbmodfiscal.ServiceParametrizacaoCtbModFiscalImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorservice.service.impl.planoconta.ServicePlanoContaImpl;
import com.touchcomp.basementorservice.service.impl.planocontagerencial.ServicePlanoContaGerencialImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatfornecedor.ServiceUnidadeFatFornecedorImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.planoconta.DTODadosContas;
import com.touchcomp.touchvomodel.vo.planoconta.DTOPlanoContaRes;
import com.touchcomp.touchvomodel.vo.planocontagerencial.DTOPlanoContaGerencialRes;
import org.springframework.stereotype.Component;

@Component
public class CompParametrizacaoContabilNF {
    private SCompPlanoConta scPlanoConta = (SCompPlanoConta)Context.get(SCompPlanoConta.class);

    public DadosContas getPlanoContasNfPropria(ModeloFiscal modeloFiscal, Produto produto, UnidadeFatCliente unidadeFatCliente, NaturezaOperacao nat, Empresa empresa, CategoriaPessoa categoriaPessoa, OpcoesContabeis opcoesContabeis, Cfop cfop) throws ExceptionParametrizacao, ExceptionInvalidData {
        DadosContas dados = new DadosContas();
        if (produto == null) {
            return dados;
        }
        dados.setPcGerencial(produto.getPlanoContaGerencial());
        Object pcFornecedor = null;
        if (modeloFiscal == null) {
            return new DadosContas();
        }
        if (!ToolMethods.isEquals((Object)modeloFiscal.getOpcaoContabilizacao(), (Object)1)) {
            return dados;
        }
        ServiceParametrizacaoCtbModFiscalImpl service = (ServiceParametrizacaoCtbModFiscalImpl)ConfApplicationContext.getBean(ServiceParametrizacaoCtbModFiscalImpl.class);
        ParametrizacaoCtbModFiscal parametrizacao = service.get(modeloFiscal, nat, produto.getSubEspecie(), empresa, categoriaPessoa, opcoesContabeis, unidadeFatCliente.getPessoa().getEndereco().getCidade().getUf(), unidadeFatCliente.getCliente().getClassificacaoClientes());
        if (parametrizacao == null) {
            throw new ExceptionParametrizacao("Parametriza\u00e7\u00e3o nao encontrada para: \nNatureza Opera\u00e7\u00e3o: " + String.valueOf(nat) + "\nModelo Fiscal: " + String.valueOf(modeloFiscal) + "\nSubesp\u00e9cie: " + String.valueOf(produto.getSubEspecie()) + "\nEmpresa: " + String.valueOf(empresa) + "\nClassificacao: " + String.valueOf(unidadeFatCliente.getCliente().getClassificacaoClientes()) + "\nCategoria Pessoa: " + String.valueOf(categoriaPessoa), new Object[0]);
        }
        if (cfop != null && ToolMethods.isAffirmative((Number)cfop.getCfopCompra())) {
            ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedor = (ServiceUnidadeFatFornecedorImpl)ConfApplicationContext.getBean(ServiceUnidadeFatFornecedorImpl.class);
            UnidadeFatFornecedor unidadeFatFornecedor = serviceUnidadeFatFornecedor.findUnidadeFatByPessoa(unidadeFatCliente.getPessoa());
            if (unidadeFatFornecedor == null) {
                throw new ExceptionParametrizacao("Est\u00e1 sendo utilizado um CFOP de Compra, onde neste caso deve ser cadastrado o fornecedor. Realize o cadastro de fornecedor para a pessoa " + String.valueOf(unidadeFatCliente.getPessoa()), new Object[0]);
            }
            return this.getPlanosContaEntrada(parametrizacao, produto, unidadeFatFornecedor, modeloFiscal, opcoesContabeis);
        }
        if (cfop != null && ToolMethods.isAffirmative((Number)cfop.getCfopDevolucaoCompra())) {
            ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedor = (ServiceUnidadeFatFornecedorImpl)ConfApplicationContext.getBean(ServiceUnidadeFatFornecedorImpl.class);
            UnidadeFatFornecedor unidadeFatFornecedor = serviceUnidadeFatFornecedor.findUnidadeFatByPessoa(unidadeFatCliente.getPessoa());
            if (unidadeFatFornecedor == null) {
                throw new ExceptionParametrizacao("Est\u00e1 sendo utilizado um CFOP de Devolu\u00e7\u00e3o Compra, onde neste caso deve ser cadastrado o fornecedor. Realize o cadastro de fornecedor para a pessoa " + String.valueOf(unidadeFatCliente.getPessoa()), new Object[0]);
            }
            PlanoConta planoContaFornecedor = this.scPlanoConta.getPlanoConta(unidadeFatFornecedor.getFornecedor(), opcoesContabeis);
            return this.getPlanoContasSaida(parametrizacao, planoContaFornecedor, produto, modeloFiscal);
        }
        PlanoConta planoContaCliente = this.scPlanoConta.getPlanoConta(unidadeFatCliente.getCliente(), opcoesContabeis);
        return this.getPlanoContasSaida(parametrizacao, planoContaCliente, produto, modeloFiscal);
    }

    private DadosContas getPlanoContasSaida(ParametrizacaoCtbModFiscal parametrizacao, PlanoConta pcClienteFornecedor, Produto produto, ModeloFiscal modeloFiscal) throws ExceptionParametrizacao {
        PlanoConta planoContaCred = parametrizacao.getPlanoContaCredora() != null ? parametrizacao.getPlanoContaCredora() : (parametrizacao.getRespeitarPlanoContaProdutoCredor().equals((short)1) ? produto.getPlanoConta() : pcClienteFornecedor);
        PlanoConta planoContaDeb = parametrizacao.getPlanoContaDevedora() != null ? parametrizacao.getPlanoContaDevedora() : (parametrizacao.getRespeitarPlanoContaProdutoDevedor().equals((short)1) ? produto.getPlanoConta() : pcClienteFornecedor);
        PlanoContaGerencial pcGerencial = parametrizacao.getPlanoContaGerencial() != null ? parametrizacao.getPlanoContaGerencial() : produto.getPlanoContaGerencial();
        if (pcGerencial == null) {
            throw new ExceptionParametrizacao("Plano de conta gerencial n\u00e3o definido na parametriza\u00e7\u00e3o cont\u00e1bil do modelo fiscal: " + modeloFiscal.getIdentificador() + " ou no produto: " + produto.getIdentificador(), new Object[0]);
        }
        return new DadosContas(planoContaDeb, planoContaCred, pcGerencial, parametrizacao);
    }

    public DTODadosContas getDtoPlanoContasNfTerceiros(ModeloFiscal modeloFiscal, Produto produto, UnidadeFatFornecedor unidadeFatFornecedor, NaturezaOperacao nat, Empresa empresa, CategoriaPessoa categoriaPessoa, OpcoesContabeis opcoesContabeis) throws ExceptionParametrizacao, ExceptionInvalidData {
        DadosContas dados = this.getPlanoContasNfTerceiros(modeloFiscal, produto, unidadeFatFornecedor, nat, empresa, categoriaPessoa, opcoesContabeis);
        if (dados != null) {
            ServicePlanoContaImpl servicePlanoConta = (ServicePlanoContaImpl)ConfApplicationContext.getBean(ServicePlanoContaImpl.class);
            ServicePlanoContaGerencialImpl servicePlanoContaGer = (ServicePlanoContaGerencialImpl)ConfApplicationContext.getBean(ServicePlanoContaGerencialImpl.class);
            DTODadosContas returned = new DTODadosContas();
            returned.setPlanoContaDeb(servicePlanoConta.buildToDTO(dados.getPlanoContaDeb(), DTOPlanoContaRes.class));
            returned.setPlanoContaCred(servicePlanoConta.buildToDTO(dados.getPlanoContaCred(), DTOPlanoContaRes.class));
            returned.setPcGerencial(servicePlanoContaGer.buildToDTO(dados.getPcGerencial(), DTOPlanoContaGerencialRes.class));
            return returned;
        }
        return null;
    }

    public DadosContas getPlanoContasNfTerceiros(ModeloFiscal modeloFiscal, Produto produto, UnidadeFatFornecedor unidadeFatFornecedor, NaturezaOperacao nat, Empresa empresa, CategoriaPessoa categoriaPessoa, OpcoesContabeis opcoesContabeis) throws ExceptionParametrizacao, ExceptionInvalidData {
        DadosContas dados = new DadosContas();
        if (produto == null) {
            return dados;
        }
        dados.setPcGerencial(produto.getPlanoContaGerencial());
        if (modeloFiscal == null) {
            return dados;
        }
        if (!ToolMethods.isEquals((Object)modeloFiscal.getOpcaoContabilizacao(), (Object)1)) {
            return dados;
        }
        ServiceParametrizacaoCtbModFiscalImpl service = (ServiceParametrizacaoCtbModFiscalImpl)ConfApplicationContext.getBean(ServiceParametrizacaoCtbModFiscalImpl.class);
        ParametrizacaoCtbModFiscal parametrizacao = service.get(modeloFiscal, nat, produto.getSubEspecie(), empresa, categoriaPessoa, opcoesContabeis, unidadeFatFornecedor.getPessoa().getEndereco().getCidade().getUf(), unidadeFatFornecedor.getFornecedor().getClassificacaoPessoa());
        if (parametrizacao == null) {
            throw new ExceptionParametrizacao(MessagesBaseMentor.getMsg((String)"E.PARAM.000001", (Object[])new Object[]{nat, modeloFiscal, produto.getSubEspecie(), empresa, categoriaPessoa, unidadeFatFornecedor.getFornecedor().getClassificacaoPessoa(), unidadeFatFornecedor.getPessoa().getEndereco().getCidade().getUf()}), new Object[0]);
        }
        return this.getPlanosContaEntrada(parametrizacao, produto, unidadeFatFornecedor, modeloFiscal, opcoesContabeis);
    }

    private DadosContas getPlanosContaEntrada(ParametrizacaoCtbModFiscal parametrizacao, Produto produto, UnidadeFatFornecedor unidadeFatFornecedor, ModeloFiscal modeloFiscal, OpcoesContabeis opcoesContabeis) throws ExceptionParametrizacao, ExceptionInvalidData {
        PlanoConta planoContaCred = parametrizacao.getPlanoContaCredora() != null ? parametrizacao.getPlanoContaCredora() : (parametrizacao.getRespeitarPlanoContaProdutoCredor().equals((short)1) ? produto.getPlanoConta() : this.scPlanoConta.getPlanoConta(unidadeFatFornecedor.getFornecedor(), opcoesContabeis));
        Object planoContaDeb = parametrizacao.getPlanoContaDevedora() != null ? parametrizacao.getPlanoContaDevedora() : (parametrizacao.getRespeitarPlanoContaProdutoDevedor().equals((short)1) ? produto.getPlanoConta() : null);
        PlanoContaGerencial pcGerencial = parametrizacao.getPlanoContaGerencial() != null ? parametrizacao.getPlanoContaGerencial() : produto.getPlanoContaGerencial();
        if (pcGerencial == null) {
            throw new ExceptionParametrizacao("Plano de conta gerencial n\u00e3o definido na parametriza\u00e7\u00e3o cont\u00e1bil do modelo fiscal: " + modeloFiscal.getIdentificador() + " ou no produto: " + produto.getIdentificador(), new Object[0]);
        }
        return new DadosContas((PlanoConta)planoContaDeb, planoContaCred, pcGerencial, parametrizacao);
    }

    public static class DadosContas {
        private PlanoConta planoContaDeb;
        private PlanoConta planoContaCred;
        private PlanoContaGerencial pcGerencial;
        private ParametrizacaoCtbModFiscal parametrizacaoCtbModFiscal;

        public DadosContas() {
        }

        public DadosContas(PlanoConta planoContaDeb, PlanoConta planoContaCred, PlanoContaGerencial pcGerencial, ParametrizacaoCtbModFiscal parametrizacaoCtbModFiscal) {
            this.planoContaDeb = planoContaDeb;
            this.planoContaCred = planoContaCred;
            this.pcGerencial = pcGerencial;
            this.parametrizacaoCtbModFiscal = parametrizacaoCtbModFiscal;
        }

        public PlanoConta getPlanoContaDeb() {
            return this.planoContaDeb;
        }

        public void setPlanoContaDeb(PlanoConta planoContaDeb) {
            this.planoContaDeb = planoContaDeb;
        }

        public PlanoConta getPlanoContaCred() {
            return this.planoContaCred;
        }

        public void setPlanoContaCred(PlanoConta planoContaCred) {
            this.planoContaCred = planoContaCred;
        }

        public PlanoContaGerencial getPcGerencial() {
            return this.pcGerencial;
        }

        public void setPcGerencial(PlanoContaGerencial pcGerencial) {
            this.pcGerencial = pcGerencial;
        }

        public ParametrizacaoCtbModFiscal getParametrizacaoCtbModFiscal() {
            return this.parametrizacaoCtbModFiscal;
        }

        public void setParametrizacaoCtbModFiscal(ParametrizacaoCtbModFiscal parametrizacaoCtbModFiscal) {
            this.parametrizacaoCtbModFiscal = parametrizacaoCtbModFiscal;
        }
    }
}

