/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.contabil;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloRPS;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbRPS;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.UnidadeFatTomPrestRPS;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbrps.ServiceParametrizacaoCtbRPSImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class CompParametrizacaoContabilRps {
    public DadosContas getPlanoContasNfPropria(ModeloRPS modeloRps, UnidadeFatTomPrestRPS unidade, Empresa empresa, CategoriaPessoa categoriaPessoa, OpcoesContabeis opcoesContabeis, ClassificacaoClientes classificaoClientes) throws ExceptionParametrizacao {
        DadosContas dados = new DadosContas();
        if (empresa == null) {
            return dados;
        }
        if (unidade == null) {
            return dados;
        }
        if (modeloRps == null) {
            return new DadosContas();
        }
        if (!ToolMethods.isEquals((Object)modeloRps.getContabilizar(), (Object)1)) {
            return dados;
        }
        ServiceParametrizacaoCtbRPSImpl service = (ServiceParametrizacaoCtbRPSImpl)ConfApplicationContext.getBean(ServiceParametrizacaoCtbRPSImpl.class);
        ParametrizacaoCtbRPS parametrizacao = service.get(modeloRps, empresa, categoriaPessoa, opcoesContabeis, classificaoClientes);
        if (parametrizacao == null) {
            throw new ExceptionParametrizacao("Parametriza\u00e7\u00e3o nao encontrada para: \nClassificacao: " + String.valueOf(classificaoClientes) + "\nModelo: " + String.valueOf(modeloRps) + "\nEmpresa: " + String.valueOf(empresa) + "\nCategoria Pessoa: " + String.valueOf(categoriaPessoa), new Object[0]);
        }
        PlanoConta credito = null;
        PlanoConta debito = null;
        credito = modeloRps.getEntradaSaida().shortValue() == EnumConstantsMentorEntSaida.SAIDA.getValue() ? parametrizacao.getContaCredito() : (parametrizacao.getContaCredito() != null ? parametrizacao.getContaCredito() : unidade.getTomadorPrestadorRPS().getPlanoContaFornecedor());
        debito = modeloRps.getEntradaSaida().shortValue() == EnumConstantsMentorEntSaida.SAIDA.getValue() ? (parametrizacao.getContaDebito() != null ? parametrizacao.getContaDebito() : unidade.getTomadorPrestadorRPS().getPlanoContaCliente()) : parametrizacao.getContaDebito();
        dados.setPlanoContaCred(credito);
        dados.setPlanoContaDeb(debito);
        dados.setParamCtbRps(parametrizacao);
        if (parametrizacao.getContaGerencial() != null) {
            dados.setPcGerencial(parametrizacao.getContaGerencial());
        }
        return dados;
    }

    public static class DadosContas {
        private PlanoConta planoContaDeb;
        private PlanoConta planoContaCred;
        private PlanoContaGerencial pcGerencial;
        private ParametrizacaoCtbRPS paramCtbRps;

        public DadosContas() {
        }

        public DadosContas(PlanoConta planoContaDeb, PlanoConta planoContaCred, PlanoContaGerencial pcGerencial, ParametrizacaoCtbRPS paramCtbRps) {
            this.planoContaDeb = planoContaDeb;
            this.planoContaCred = planoContaCred;
            this.pcGerencial = pcGerencial;
            this.paramCtbRps = paramCtbRps;
        }

        @Generated
        public PlanoConta getPlanoContaDeb() {
            return this.planoContaDeb;
        }

        @Generated
        public PlanoConta getPlanoContaCred() {
            return this.planoContaCred;
        }

        @Generated
        public PlanoContaGerencial getPcGerencial() {
            return this.pcGerencial;
        }

        @Generated
        public ParametrizacaoCtbRPS getParamCtbRps() {
            return this.paramCtbRps;
        }

        @Generated
        public void setPlanoContaDeb(PlanoConta planoContaDeb) {
            this.planoContaDeb = planoContaDeb;
        }

        @Generated
        public void setPlanoContaCred(PlanoConta planoContaCred) {
            this.planoContaCred = planoContaCred;
        }

        @Generated
        public void setPcGerencial(PlanoContaGerencial pcGerencial) {
            this.pcGerencial = pcGerencial;
        }

        @Generated
        public void setParamCtbRps(ParametrizacaoCtbRPS paramCtbRps) {
            this.paramCtbRps = paramCtbRps;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DadosContas)) {
                return false;
            }
            DadosContas other = (DadosContas)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PlanoConta this$planoContaDeb = this.getPlanoContaDeb();
            PlanoConta other$planoContaDeb = other.getPlanoContaDeb();
            if (this$planoContaDeb == null ? other$planoContaDeb != null : !this$planoContaDeb.equals(other$planoContaDeb)) {
                return false;
            }
            PlanoConta this$planoContaCred = this.getPlanoContaCred();
            PlanoConta other$planoContaCred = other.getPlanoContaCred();
            if (this$planoContaCred == null ? other$planoContaCred != null : !this$planoContaCred.equals(other$planoContaCred)) {
                return false;
            }
            PlanoContaGerencial this$pcGerencial = this.getPcGerencial();
            PlanoContaGerencial other$pcGerencial = other.getPcGerencial();
            if (this$pcGerencial == null ? other$pcGerencial != null : !this$pcGerencial.equals(other$pcGerencial)) {
                return false;
            }
            ParametrizacaoCtbRPS this$paramCtbRps = this.getParamCtbRps();
            ParametrizacaoCtbRPS other$paramCtbRps = other.getParamCtbRps();
            return !(this$paramCtbRps == null ? other$paramCtbRps != null : !this$paramCtbRps.equals(other$paramCtbRps));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DadosContas;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PlanoConta $planoContaDeb = this.getPlanoContaDeb();
            result = result * 59 + ($planoContaDeb == null ? 43 : $planoContaDeb.hashCode());
            PlanoConta $planoContaCred = this.getPlanoContaCred();
            result = result * 59 + ($planoContaCred == null ? 43 : $planoContaCred.hashCode());
            PlanoContaGerencial $pcGerencial = this.getPcGerencial();
            result = result * 59 + ($pcGerencial == null ? 43 : $pcGerencial.hashCode());
            ParametrizacaoCtbRPS $paramCtbRps = this.getParamCtbRps();
            result = result * 59 + ($paramCtbRps == null ? 43 : $paramCtbRps.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CompParametrizacaoContabilRps.DadosContas(planoContaDeb=" + String.valueOf(this.getPlanoContaDeb()) + ", planoContaCred=" + String.valueOf(this.getPlanoContaCred()) + ", pcGerencial=" + String.valueOf(this.getPcGerencial()) + ", paramCtbRps=" + String.valueOf(this.getParamCtbRps()) + ")";
        }
    }
}

