/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.convexpressoesdinamica;

import com.touchcomp.basementor.model.vo.ConversorExpressoesDinamico;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.constants.EnumConstantsTextDynamic;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.jep.ToolJepExpressionParser;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompConvExpressoesDinamica {
    public String getAuxToken(String token) {
        return EnumConstantsTextDynamic.PREFIX_TOKEN_AUX.getToken() + token;
    }

    public String getAuxField(String token) {
        return EnumConstantsTextDynamic.PREFIX_TOKEN_FIELD.getToken() + token;
    }

    public String getAuxSubObs(String token, ConversorExpressoesDinamico aux) {
        return EnumConstantsTextDynamic.PREFIX_TOKEN_SUB_OBS.getToken() + aux.getIdentificador() + "," + EnumConstantsTextDynamic.PREFIX_TOKEN_FIELD.getToken() + token;
    }

    public List<StringToken> getAuxTokens(ConversorExpressoesDinamico objectObsDinamica, List<StringToken> tokens) {
        return ToolString.getReplaceTokens((String)EnumConstantsTextDynamic.PREFIX_TOKEN_AUX.getToken(), (String)objectObsDinamica.getObservacao());
    }

    public Double build(Object source, List<StringToken> tokens, ConversorExpressoesDinamico conversor) throws ExceptionInvalidData {
        if (conversor == null) {
            return 0.0;
        }
        String formula = conversor.getObservacao();
        if (!TMethods.isStrWithData((String)formula)) {
            return 0.0;
        }
        if (tokens == null) {
            tokens = new LinkedList<StringToken>();
        }
        try {
            List all = ToolString.getReplaceTokens((String)conversor.getObservacao());
            for (StringToken a : all) {
                if (a.getChave().startsWith(EnumConstantsTextDynamic.PREFIX_TOKEN_AUX.getToken())) {
                    a.setValor(this.getValorDigitado(tokens, a.getChave()));
                    continue;
                }
                if (a.getChave().startsWith(EnumConstantsTextDynamic.PREFIX_TOKEN_FIELD.getToken())) {
                    a.setValor(this.getField(a.getChave(), source));
                    continue;
                }
                throw new ExceptionInvalidData("", new Object[]{a.getChave()});
            }
            return ToolJepExpressionParser.evaluate((String)ToolString.build((String)conversor.getObservacao(), (List)all), new HashMap());
        }
        catch (ExceptionJEPParser ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionInvalidData("", new Object[]{ex});
        }
    }

    private String getField(String token, Object source) throws ExceptionInvalidData {
        try {
            String field = token;
            field = field.substring(EnumConstantsTextDynamic.PREFIX_TOKEN_FIELD.getToken().length());
            Object value = ToolReflections.getFieldValueFromGetMethod((String)field, (Object)source);
            return String.valueOf(value);
        }
        catch (ExceptionReflection ex) {
            throw new ExceptionInvalidData("", new Object[]{ex});
        }
    }

    private String getValorDigitado(List<StringToken> tokens, String chave) {
        for (StringToken token : tokens) {
            if (!token.getChave().equalsIgnoreCase(chave)) continue;
            return token.getValor();
        }
        return "";
    }
}

