/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.cotacaocompra;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorspringcontext.Context;

public abstract class BaseCotacaoCompra
extends BaseMethods {
    void setDadosContabeis(Empresa empresa, OpcoesContabeis opcoesContabeis, ItemCotacaoCompra item) throws ExceptionParametrizacao, ExceptionInvalidData {
        NaturezaOperacao natOperacao = item.getNaturezaOperacao();
        Produto produto = item.getGradeCor().getProdutoGrade().getProduto();
        for (FornecedorItemCotacaoCompra f : item.getFornecedoresItemCotacaoCompra()) {
            this.setPlanoContaFornecedor(f, produto, natOperacao, empresa, opcoesContabeis);
        }
    }

    private void setPlanoContaFornecedor(FornecedorItemCotacaoCompra f, Produto produto, NaturezaOperacao natOperacao, Empresa empresa, OpcoesContabeis opcoesContabeis) throws ExceptionParametrizacao, ExceptionInvalidData {
        CompParametrizacaoContabilNF comp = (CompParametrizacaoContabilNF)Context.get(CompParametrizacaoContabilNF.class);
        CompParametrizacaoContabilNF.DadosContas dados = comp.getPlanoContasNfTerceiros(f.getModeloFiscal(), produto, f.getUnidadeFaturamentoFornecedor(), natOperacao, empresa, f.getUnidadeFaturamentoFornecedor().getCategoriaPessoa(), opcoesContabeis);
        f.setPlanoConta(dados.getPlanoContaDeb());
        f.setPlanoContaGerencial(dados.getPcGerencial());
        f.setPlanoContaGerencial(produto.getPlanoContaGerencial());
    }

    void setDadosContabeis(Empresa empresa, OpcoesContabeis opcoesContabeis, FornecedorItemCotacaoCompra item) throws ExceptionParametrizacao, ExceptionInvalidData {
        NaturezaOperacao natOperacao = item.getItemCotacaoCompra().getNaturezaOperacao();
        Produto produto = item.getItemCotacaoCompra().getGradeCor().getProdutoGrade().getProduto();
        this.setPlanoContaFornecedor(item, produto, natOperacao, empresa, opcoesContabeis);
    }

    Boolean existeItemSemModeloFiscal(ItemCotacaoCompra i) {
        for (FornecedorItemCotacaoCompra f : i.getFornecedoresItemCotacaoCompra()) {
            if (f.getModeloFiscal() != null) continue;
            return true;
        }
        return false;
    }
}

