/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.cotacaocompra;

import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.cotacaocompra.CompItemCotacaoCompra;
import com.touchcomp.basementorservice.components.cotacaocompra.calculoitemcotacao.CompCalculoImpostosFiscaisCotacao;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperCotacaoCompra;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatfornecedor.ServiceUnidadeFatFornecedorImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.res.DTOProdutoRes;
import com.touchcomp.touchvomodel.res.DTOUnidadeFatFornecedorRes;
import com.touchcomp.touchvomodel.vo.cotacaocompra.web.DTOFornecedorXProduto;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompCotacaoCompra {
    @Autowired
    private HelperCotacaoCompra helperCotacaoCompra;
    @Autowired
    ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedor;
    @Autowired
    ServiceProdutoImpl serviceProduto;
    @Autowired
    private CompItemCotacaoCompra compItemCotacaoCompra;

    public CotacaoCompra gerarCotacaoCompraFromNecessidade(List<NecessidadeCompra> mapNecessidade, Usuario usuario, Empresa empresa, OpcoesCompraSuprimentos opcoesCompra, OpcoesContabeis opcoesContabeis, OpcoesEstoque opcoesEstoque) throws Exception {
        CotacaoCompra cotacaoCompra = this.helperCotacaoCompra.buildCotacaoCompra(empresa, usuario, opcoesCompra);
        StringBuilder observacao = new StringBuilder();
        Short gerarObsNecessidade = opcoesCompra.getReplicarObsNecessidadeCotacao();
        Short gerarObsGrupoNecessidade = opcoesCompra.getReplicarObsGrupoNecessidadeCotacao();
        StringBuilder obsGrupoNecessidade = new StringBuilder("");
        for (NecessidadeCompra necessidadeCompra : mapNecessidade) {
            if (necessidadeCompra.getObservacao() != null && ToolMethods.isAffirmative((Number)gerarObsNecessidade)) {
                observacao.append(necessidadeCompra.getObservacao()).append(" ");
            }
            if (necessidadeCompra.getGrupoNecCompra() != null && ToolMethods.isAffirmative((Number)gerarObsGrupoNecessidade) && ToolMethods.isStrWithData((String)necessidadeCompra.getGrupoNecCompra().getObservacao())) {
                obsGrupoNecessidade.append(necessidadeCompra.getGrupoNecCompra().getObservacao());
            }
            if (necessidadeCompra.getItemCotacaoCompraGerada() != null) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1066.012", new Object[]{necessidadeCompra.getIdentificador(), necessidadeCompra.getItemCotacaoCompraGerada().getCotacaoCompra().getIdentificador()}));
            }
            this.compItemCotacaoCompra.buildItemCotacaoCompra(cotacaoCompra, necessidadeCompra, opcoesCompra, opcoesContabeis, opcoesEstoque);
            necessidadeCompra.setSituacaoNecessidadeCompra(opcoesCompra.getSituacaoNecessidadeCotacao());
        }
        cotacaoCompra.setObservacao(observacao.toString().trim() + " " + obsGrupoNecessidade.toString());
        return cotacaoCompra;
    }

    public List<DTOFornecedorXProduto> getFornecedorXItemCotacao(CotacaoCompra vo) {
        if (vo != null && vo.getItensCotacaoCompra() != null) {
            List<UnidadeFatFornecedor> fornecedores = this.getAllFornecedoresCotacao(vo);
            ArrayList<DTOFornecedorXProduto> hashFornecedores = new ArrayList<DTOFornecedorXProduto>();
            for (UnidadeFatFornecedor forn : fornecedores) {
                ArrayList<DTOFornecedorXProduto.DTOItemFornecedor> produtos = new ArrayList<DTOFornecedorXProduto.DTOItemFornecedor>();
                for (ItemCotacaoCompra i : vo.getItensCotacaoCompra()) {
                    for (FornecedorItemCotacaoCompra f : i.getFornecedoresItemCotacaoCompra()) {
                        if (!f.getUnidadeFaturamentoFornecedor().equals((Object)forn)) continue;
                        produtos.add(this.getItemFornecedor(i, f));
                    }
                }
                DTOFornecedorXProduto h = new DTOFornecedorXProduto();
                h.setFornecedor(this.serviceUnidadeFatFornecedor.buildToDTO(forn, DTOUnidadeFatFornecedorRes.class));
                h.setItens(produtos);
                hashFornecedores.add(h);
            }
            return hashFornecedores;
        }
        return new ArrayList<DTOFornecedorXProduto>();
    }

    private List<UnidadeFatFornecedor> getAllFornecedoresCotacao(CotacaoCompra vo) {
        ArrayList<UnidadeFatFornecedor> fornecedores = new ArrayList<UnidadeFatFornecedor>();
        for (ItemCotacaoCompra i : vo.getItensCotacaoCompra()) {
            for (FornecedorItemCotacaoCompra f : i.getFornecedoresItemCotacaoCompra()) {
                if (fornecedores.contains(f.getUnidadeFaturamentoFornecedor())) continue;
                fornecedores.add(f.getUnidadeFaturamentoFornecedor());
            }
        }
        return fornecedores;
    }

    private DTOFornecedorXProduto.DTOItemFornecedor getItemFornecedor(ItemCotacaoCompra i, FornecedorItemCotacaoCompra f) {
        DTOFornecedorXProduto.DTOItemFornecedor item = new DTOFornecedorXProduto.DTOItemFornecedor();
        item.setProduto(this.serviceProduto.buildToDTO(i.getGradeCor().getProdutoGrade().getProduto(), DTOProdutoRes.class));
        item.setQuantidade(i.getQuantidade());
        item.setValorUnitario(f.getValorUnitario());
        if (f.getFornecedorItemCotacaoCompraLivroFiscal() != null) {
            item.setValorTotal(f.getFornecedorItemCotacaoCompraLivroFiscal().getValorTotal());
        } else {
            item.setValorTotal(Double.valueOf(0.0));
        }
        Object condicoes = "";
        if (f.getCondicoesPagamento() != null) {
            condicoes = f.getCondicoesPagamento().toString();
            condicoes = (String)condicoes + " " + f.getCondicaoPagamentoMutante();
        }
        item.setCondicoesPag((String)condicoes);
        item.setAquisicaoPreferencial(f.getAquisicaoPreferencial());
        item.setValorCusto(f.getValorCusto());
        item.setValorDesconto(f.getValorDesconto());
        item.setSelecionado(f.getSelecionado());
        return item;
    }

    public void recalcularCotacao(CotacaoCompra cotacaoCompra, OpcoesCompraSuprimentos opcoes) throws Exception {
        CompCalculoImpostosFiscaisCotacao compCalculo = (CompCalculoImpostosFiscaisCotacao)ConfApplicationContext.getBean(CompCalculoImpostosFiscaisCotacao.class);
        for (ItemCotacaoCompra item : cotacaoCompra.getItensCotacaoCompra()) {
            if (ToolMethods.isAffirmative((Number)item.getNaoGerarOC())) continue;
            List<FornecedorItemCotacaoCompra> fornecedoresValidados = this.helperCotacaoCompra.build(cotacaoCompra).getFornecedoresValidados(item, opcoes);
            for (FornecedorItemCotacaoCompra fornecedor : fornecedoresValidados) {
                compCalculo.calcularImpostosFiscaisFornecedorItemCotacaoCompra(fornecedor, item.getGradeCor(), item.getQuantidade(), item.getFatorConversao(), cotacaoCompra.getEmpresa(), opcoes);
            }
        }
    }
}

