/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.cotacaocompra;

import com.touchcomp.basementor.model.vo.AliquotaSt;
import com.touchcomp.basementor.model.vo.CategoriaSt;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.CotacaoMoeda;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.LeadTimeFornProduto;
import com.touchcomp.basementor.model.vo.LeadTimeFornProdutoInfFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.moeda.ExceptionCotacaoMoeda;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.components.cotacaocompra.BaseCotacaoCompra;
import com.touchcomp.basementorservice.components.cotacaocompra.calculoitemcotacao.CompCalculoImpostosFiscaisCotacao;
import com.touchcomp.basementorservice.components.cotacaocompra.calculoitemcotacao.impl.totalizador.AuxTotalizadoresItemCotacao;
import com.touchcomp.basementorservice.components.cotacaomoedabancocentral.CompCotacaoMoedaBancoCentral;
import com.touchcomp.basementorservice.components.notaterceiros.CompNotaTerceiros;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperCotacaoCompra;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperFornecedorItemCotCompra;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.service.impl.aliquotast.ServiceAliquotaStImpl;
import com.touchcomp.basementorservice.service.impl.cfop.ServiceCfopImpl;
import com.touchcomp.basementorservice.service.impl.condicoespagamento.ServiceCondicoesPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.leadtimefornecedor.ServiceLeadTimeFornProdutoImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscal.ServiceModeloFiscalImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.cotacaocompra.web.DTOCotacaoCompra;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompFornecedorItemCotCompra
extends BaseCotacaoCompra {
    @Autowired
    private HelperModeloFiscal helperModeloFiscal;
    @Autowired
    private HelperFornecedorItemCotCompra helperFornecedorItemCotCompra;
    @Autowired
    private ServiceCondicoesPagamentoImpl serviceCondicoesPagamento;
    @Autowired
    private ServiceLeadTimeFornProdutoImpl serviceLeadTimeFornecedor;
    @Autowired
    private ServiceModeloFiscalImpl serviceModeloFiscal;
    @Autowired
    private ServiceCfopImpl serviceCfop;
    @Autowired
    private ServiceAliquotaStImpl serviceAliquotaSt;

    public List<FornecedorItemCotacaoCompra> pesquisaFornecedoresSugeridos(GradeCor gradeCor, Double quantidade, NaturezaOperacao naturezaOperacao, Date dataCadastro, Empresa emp, OpcoesCompraSuprimentos opcoes, OpcoesContabeis opcoesContabeis) throws Exception {
        HelperCotacaoCompra helper = (HelperCotacaoCompra)ConfApplicationContext.getBean(HelperCotacaoCompra.class);
        ItemCotacaoCompra itemCotacaoCompra = helper.buildItemCotacaoCompra(gradeCor, quantidade, naturezaOperacao, dataCadastro, null);
        List<FornecedorItemCotacaoCompra> fornecedores = this.findFornecedoresItemCotacaoCompra(itemCotacaoCompra, emp, opcoes);
        if (fornecedores.isEmpty()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1066.002"));
        }
        for (FornecedorItemCotacaoCompra f : fornecedores) {
            if (!this.isEquals(f.getAquisicaoPreferencial(), null) && this.isAffimative(f.getAquisicaoPreferencial()) || !this.isEquals(f.getModeloFiscal(), null)) continue;
            this.setModeloFiscalFornecedor(itemCotacaoCompra.getGradeCor(), naturezaOperacao, emp, f);
            this.setDadosContabeis(emp, opcoesContabeis, f);
        }
        return fornecedores;
    }

    private void setModeloFiscalFornecedor(GradeCor gradeCor, NaturezaOperacao naturezaOperacao, Empresa empresa, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra) throws ExceptionObjNotFound {
        if (gradeCor == null || gradeCor.getProdutoGrade() == null) {
            return;
        }
        Produto produto = gradeCor.getProdutoGrade().getProduto();
        UnidadeFatFornecedor unidadeFatFornecedor = fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor();
        if (naturezaOperacao != null && produto != null && unidadeFatFornecedor != null && unidadeFatFornecedor.getFornecedor() != null) {
            HelperModeloFiscal helper = (HelperModeloFiscal)ConfApplicationContext.getBean(HelperModeloFiscal.class);
            ModeloFiscal mod = helper.getFirst(produto, unidadeFatFornecedor, naturezaOperacao, empresa);
            fornecedorItemCotacaoCompra.setModeloFiscal(mod);
        }
    }

    private List<FornecedorItemCotacaoCompra> findFornecedoresItemCotacaoCompra(ItemCotacaoCompra itemCotacaoCompra, Empresa emp, OpcoesCompraSuprimentos opcoes) throws Exception {
        List<LeadTimeFornProduto> leadTimeFornecedor = this.serviceLeadTimeFornecedor.findLeadTimeGradeCorHomologado(itemCotacaoCompra.getGradeCor(), emp);
        if (!ToolMethods.isWithData(leadTimeFornecedor)) {
            leadTimeFornecedor = this.serviceLeadTimeFornecedor.findLeadTimeProduto(itemCotacaoCompra.getGradeCor(), emp);
        }
        ArrayList<FornecedorItemCotacaoCompra> fornecedoresItemCotacaoCompra = new ArrayList<FornecedorItemCotacaoCompra>();
        if (!TMethods.isWithData(leadTimeFornecedor)) {
            return fornecedoresItemCotacaoCompra;
        }
        for (LeadTimeFornProduto leadProd : leadTimeFornecedor) {
            FornecedorItemCotacaoCompra f = this.buildFornecedorItemCotacaoCompra(itemCotacaoCompra, leadProd, emp, opcoes);
            if (ToolMethods.isNull((Object)f).booleanValue() || ToolMethods.isNull((Object)f.getUnidadeFaturamentoFornecedor()).booleanValue() || !ToolMethods.isAffirmative((Number)f.getUnidadeFaturamentoFornecedor().getFornecedor().getAtivo())) continue;
            fornecedoresItemCotacaoCompra.add(f);
        }
        return fornecedoresItemCotacaoCompra;
    }

    private FornecedorItemCotacaoCompra buildFornecedorItemCotacaoCompra(ItemCotacaoCompra itemCotacaoCompra, LeadTimeFornProduto leadTimeFornProduto, Empresa emp, OpcoesCompraSuprimentos opcoes) throws Exception {
        FornecedorItemCotacaoCompra fornecedor;
        LeadTimeFornProdutoInfFiscal leadTime = this.getInfFiscalLeadTime(leadTimeFornProduto);
        HelperFornecedorItemCotCompra helper = new HelperFornecedorItemCotCompra();
        if (leadTime != null) {
            fornecedor = helper.buildFornecedorItemCotCompra(itemCotacaoCompra, leadTimeFornProduto, emp, opcoes, leadTime);
            fornecedor.setCondicoesPagamento(this.findCondicaoPagamentoMutante());
            this.setFornecedorItemCotacaoCompraLivroFiscal(fornecedor, itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), emp, opcoes);
        } else {
            fornecedor = helper.buildFornecedorItemCotCompra(itemCotacaoCompra, leadTimeFornProduto, emp, opcoes);
            fornecedor.setModeloFiscal(helper.getModeloFiscal(itemCotacaoCompra.getNaturezaOperacao(), itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), fornecedor.getUnidadeFaturamentoFornecedor(), emp));
        }
        return fornecedor;
    }

    private LeadTimeFornProdutoInfFiscal getInfFiscalLeadTime(LeadTimeFornProduto leadPref) {
        return leadPref.getInfFiscalLeadTime() != null && !leadPref.getInfFiscalLeadTime().isEmpty() ? (LeadTimeFornProdutoInfFiscal)leadPref.getInfFiscalLeadTime().get(0) : null;
    }

    private CondicoesPagamento findCondicaoPagamentoMutante() {
        List<CondicoesPagamento> list = this.serviceCondicoesPagamento.getCondicoesPagamentoMutante();
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1066.001"));
    }

    public List<FornecedorItemCotacaoCompra> criarFornecedoresItemCotacaoCompra(ItemCotacaoCompra itemCotacaoCompra, NecessidadeCompra necessidadeCompra, Empresa empresa, OpcoesContabeis opcoesContabeis, OpcoesCompraSuprimentos opcoes) throws Exception {
        HelperFornecedorItemCotCompra helper = new HelperFornecedorItemCotCompra();
        CompParametrizacaoContabilNF comp = this.getBean(CompParametrizacaoContabilNF.class);
        ArrayList<FornecedorItemCotacaoCompra> ret = new ArrayList<FornecedorItemCotacaoCompra>();
        FornecedorItemCotacaoCompra fornecedorItemCotacao = helper.buildFornecedorItemCotCompra(itemCotacaoCompra, necessidadeCompra);
        CompParametrizacaoContabilNF.DadosContas dados = comp.getPlanoContasNfTerceiros(fornecedorItemCotacao.getModeloFiscal(), itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), necessidadeCompra.getUnidadeFatFornecedor(), itemCotacaoCompra.getNaturezaOperacao(), empresa, necessidadeCompra.getUnidadeFatFornecedor().getCategoriaPessoa(), opcoesContabeis);
        fornecedorItemCotacao.setPlanoConta(dados.getPlanoContaDeb());
        fornecedorItemCotacao.setPlanoContaGerencial(dados.getPcGerencial());
        if (fornecedorItemCotacao.getModeloFiscal() != null) {
            this.setFornecedorItemCotacaoCompraLivroFiscal(fornecedorItemCotacao, itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), empresa, opcoes);
        }
        fornecedorItemCotacao.setValorUnitario(necessidadeCompra.getValor());
        if (itemCotacaoCompra.getGradeCor() != null && !ToolMethods.isAffirmative((Number)opcoes.getNaoSugCustoAutoCotCompras())) {
            fornecedorItemCotacao.setCustoMedio(CompNotaTerceiros.getCustoMedioProd(itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), empresa));
            fornecedorItemCotacao.setUltimoCusto(CompNotaTerceiros.getUltimoCustoProd(itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), empresa));
            fornecedorItemCotacao.setMenorCusto(CompNotaTerceiros.getMenorCustoProd(itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), empresa));
        }
        ret.add(fornecedorItemCotacao);
        return ret;
    }

    private Cfop getCfop(FornecedorItemCotacaoCompra f, Empresa emp) throws Exception {
        Cfop cfop = this.serviceCfop.findCfopEntrada(emp.getPessoa().getEndereco().getCidade().getUf(), f.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf(), f.getModeloFiscal());
        return cfop;
    }

    public void setFornecedorItemCotacaoCompraLivroFiscal(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Produto produto, Empresa emp, OpcoesCompraSuprimentos opcoes) throws Exception {
        FornecedorItemCotacaoCompraLivroFiscal itemFornCotacaoLivroFiscal = this.helperFornecedorItemCotCompra.buildFornecedorItemCotacaoCompraLivroFiscal(fornecedorItemCotacaoCompra);
        itemFornCotacaoLivroFiscal.setPercentualReducaoBaseCalculoIcms(this.serviceModeloFiscal.getPercRedBC(produto, fornecedorItemCotacaoCompra.getModeloFiscal()));
        itemFornCotacaoLivroFiscal.setCfop(this.getCfop(fornecedorItemCotacaoCompra, emp));
        Double aliquotaIpi = BaseCalculoValores.getAliquotaIpi(produto, fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalIpi());
        itemFornCotacaoLivroFiscal.setAliquotaIpi(aliquotaIpi);
        Double alICMS = this.helperModeloFiscal.getAliquotaICMS(fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf(), emp.getPessoa().getEndereco().getCidade().getUf(), produto, fornecedorItemCotacaoCompra.getModeloFiscal());
        itemFornCotacaoLivroFiscal.setAliquotaIcms(alICMS);
        CompCalculoImpostosFiscaisCotacao compCalculoImpostosFiscaisCotacao = this.getBean(CompCalculoImpostosFiscaisCotacao.class);
        compCalculoImpostosFiscaisCotacao.calcularImpostosFiscaisFornecedorItemCotacaoCompra(fornecedorItemCotacaoCompra, fornecedorItemCotacaoCompra.getItemCotacaoCompra().getGradeCor(), fornecedorItemCotacaoCompra.getItemCotacaoCompra().getQuantidade(), fornecedorItemCotacaoCompra.getItemCotacaoCompra().getFatorConversao(), emp, opcoes);
        AliquotaSt aliquotaSt = null;
        ModeloFiscal modeloFiscal = fornecedorItemCotacaoCompra.getModeloFiscal();
        if (itemFornCotacaoLivroFiscal.getCategoriaSt() != null && itemFornCotacaoLivroFiscal.getUnidadeFederativaIcmsSt() != null) {
            aliquotaSt = this.procurarAliquotaSt(itemFornCotacaoLivroFiscal.getCategoriaSt(), itemFornCotacaoLivroFiscal.getUnidadeFederativaIcmsSt());
        } else if (modeloFiscal.getModeloFiscalIcms() != null && modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms() != null && ToolMethods.isAffirmative((Number)modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms().getIcmsSt()) && produto != null && produto.getCategoriaSutr() != null) {
            aliquotaSt = this.procurarAliquotaSt(produto.getCategoriaSutr(), fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf());
            itemFornCotacaoLivroFiscal.setCategoriaSt(produto.getCategoriaSutr());
            itemFornCotacaoLivroFiscal.setUnidadeFederativaIcmsSt(fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf());
        }
        if (aliquotaSt != null) {
            itemFornCotacaoLivroFiscal.setIndicadorAlteracaoIcmsST(aliquotaSt.getIndiceAlteracao());
            itemFornCotacaoLivroFiscal.setDescontoPadraoIcmsST(aliquotaSt.getDescontoPadrao());
            itemFornCotacaoLivroFiscal.setAliquotaIcmsST(aliquotaSt.getAliquotaIcms());
        } else {
            itemFornCotacaoLivroFiscal.setIndicadorAlteracaoIcmsST(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setDescontoPadraoIcmsST(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setAliquotaIcmsST(Double.valueOf(0.0));
        }
        AuxTotalizadoresItemCotacao auxTotalizadoresItemCotacao = new AuxTotalizadoresItemCotacao();
        itemFornCotacaoLivroFiscal.setValorBaseCalculoIcmsSt(auxTotalizadoresItemCotacao.getValorBaseCalculoIcmsS(itemFornCotacaoLivroFiscal));
        itemFornCotacaoLivroFiscal.setValorIcmsSt(auxTotalizadoresItemCotacao.getValorIcmsSt(itemFornCotacaoLivroFiscal));
        if (itemFornCotacaoLivroFiscal.getValorIcmsSt() < 0.0) {
            itemFornCotacaoLivroFiscal.setValorIcmsSt(Double.valueOf(0.0));
        }
    }

    private AliquotaSt procurarAliquotaSt(CategoriaSt categoriaSt, UnidadeFederativa unidadeFederativaCliente) throws Exception {
        AliquotaSt aliquotaSt = this.serviceAliquotaSt.get(categoriaSt, unidadeFederativaCliente);
        if (aliquotaSt == null) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1066.013", new String[]{categoriaSt != null ? categoriaSt.getNome() : "", unidadeFederativaCliente.getSigla()}));
        }
        return aliquotaSt;
    }

    public String findComposicaoValorCusto(DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Double quantidade) {
        if (quantidade == null) {
            quantidade = 1.0;
        }
        if (fornecedorItemCotacaoCompra != null) {
            return MessagesBaseMentor.getMsg((String)"M.ERP.1066.001", (Object[])new Object[]{ToolFormatter.formataNumero((Number)(fornecedorItemCotacaoCompra.getValorUnitario() * quantidade), (int)2), ToolFormatter.formataNumero((Number)fornecedorItemCotacaoCompra.getValorDesconto(), (int)2), ToolFormatter.formataNumero((Number)fornecedorItemCotacaoCompra.getValorFrete(), (int)2), ToolFormatter.formataNumero((Number)fornecedorItemCotacaoCompra.getValorSeguro(), (int)2), ToolFormatter.formataNumero((Number)fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), (int)2), ToolFormatter.formataNumero((Number)fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal().getValorIcmsSt(), (int)2), ToolFormatter.formataNumero((Number)fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal().getValorDiferencaAliquota(), (int)2), ToolFormatter.formataNumero((Number)fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal().getValorPis(), (int)2), ToolFormatter.formataNumero((Number)fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal().getValorCofins(), (int)2), ToolFormatter.formataNumero((Number)fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal().getValorIpiObservacao(), (int)2), ToolFormatter.formataNumero((Number)fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal().getValorIpiComercio(), (int)2), ToolFormatter.formataNumero((Number)this.getValorIcmsComposicaoCusto(fornecedorItemCotacaoCompra), (int)2), ToolFormatter.formataNumero((Number)(fornecedorItemCotacaoCompra.getValorCusto() * quantidade), (int)2), ToolFormatter.formataNumero((Number)quantidade, (int)2), ToolFormatter.formataNumero((Number)fornecedorItemCotacaoCompra.getValorCusto(), (int)6)});
        }
        return MessagesBaseMentor.getMsg((String)"M.ERP.1066.001", (Object[])new Object[0]);
    }

    private Double getValorIcmsComposicaoCusto(DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra fornecedor) {
        ModeloFiscal modeloFiscal;
        if ((fornecedor.getModeloFiscalIdentificador() == null || fornecedor.getModeloFiscalIdentificador() <= 0L) && (modeloFiscal = (ModeloFiscal)this.serviceModeloFiscal.get(fornecedor.getModeloFiscalIdentificador())) != null && modeloFiscal.getModeloFiscalIcms() != null && ToolMethods.isAffirmative((Number)modeloFiscal.getModeloFiscalIcms().getRecuperarTributosIcms())) {
            return fornecedor.getFornecedorItemCotacaoCompraLivroFiscal().getValorIcms();
        }
        return 0.0;
    }

    public DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra pesquisarCotacaoAtualMoeda(DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra dto, CotacaoMoeda cotacao, Moeda moeda) throws ExceptionCotacaoMoeda {
        if (cotacao == null) {
            CompCotacaoMoedaBancoCentral comp = (CompCotacaoMoedaBancoCentral)ConfApplicationContext.getBean(CompCotacaoMoedaBancoCentral.class);
            cotacao = comp.consultarCotacao(moeda);
        }
        if (cotacao != null) {
            if (moeda != null) {
                dto.setMoedaIdentificador(moeda.getIdentificador());
                dto.setMoeda(moeda.toString());
            }
            dto.setCotacaoMoeda(cotacao.toString());
            dto.setCotacaoMoedaIdentificador(cotacao.getIdentificador());
            dto.setValorUnitarioMoeda(cotacao.getValor());
            dto.setValorUnitario(Double.valueOf(dto.getValorUnitario() * dto.getValorUnitarioMoeda()));
        }
        return dto;
    }
}

