/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.cotacaocompra;

import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemUnidadeMedida;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.MotivoAquisicaoPref;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.components.cotacaocompra.BaseCotacaoCompra;
import com.touchcomp.basementorservice.components.cotacaocompra.CompFornecedorItemCotCompra;
import com.touchcomp.basementorservice.components.cotacaocompra.calculoitemcotacao.CompCalculoImpostosFiscaisCotacao;
import com.touchcomp.basementorservice.components.estoque.CompEstoque;
import com.touchcomp.basementorservice.components.notaterceiros.CompNotaTerceiros;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperCotacaoCompra;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesestoque.HelperOpcoesEstoque;
import com.touchcomp.basementorservice.helpers.impl.produto.HelperProduto;
import com.touchcomp.basementorservice.service.impl.centrocusto.ServiceCentroCustoImpl;
import com.touchcomp.basementorservice.service.impl.condicoespagamento.ServiceCondicoesPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscal.ServiceModeloFiscalImpl;
import com.touchcomp.basementorservice.service.impl.moeda.ServiceMoedaImpl;
import com.touchcomp.basementorservice.service.impl.motivoaquisicaopref.ServiceMotivoAquisicaoPrefImpl;
import com.touchcomp.basementorservice.service.impl.naturezaoperacao.ServiceNaturezaOperacaoImpl;
import com.touchcomp.basementorservice.service.impl.tipofrete.ServiceTipoFreteImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatfornecedor.ServiceUnidadeFatFornecedorImpl;
import com.touchcomp.basementorservice.service.impl.unidademedida.ServiceUnidadeMedidaImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceNotaFiscalTerceiros;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.cotacaocompra.ValidBeforeCalcItemCotacao;
import com.touchcomp.touchvomodel.vo.cotacaocompra.web.DTOCotacaoCompra;
import com.touchcomp.touchvomodel.vo.cotacaocompra.web.DTOValoresProdutoCotacao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompItemCotacaoCompra
extends BaseCotacaoCompra {
    @Autowired
    private HelperCotacaoCompra helperCotacaoCompra;
    @Autowired
    private ServiceGradeCorImpl serviceGradeCor;
    @Autowired
    private ServiceUnidadeMedidaImpl serviceUnidadeMedida;
    @Autowired
    private ServiceNaturezaOperacaoImpl serviceNaturezaOperacao;
    @Autowired
    private CompFornecedorItemCotCompra compFornecedorItemCotCompra;
    @Autowired
    private ServiceCondicoesPagamentoImpl serviceCondicoesPagamento;
    @Autowired
    private ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedor;
    @Autowired
    private ServiceModeloFiscalImpl serviceModeloFiscal;
    @Autowired
    private ServiceTipoFreteImpl serviceTipoFrete;
    @Autowired
    private ServiceMotivoAquisicaoPrefImpl serviceMotivoAquisicaoPref;
    @Autowired
    private ServiceCentroCustoImpl serviceCentroCusto;
    @Autowired
    HelperOpcoesEstoque helperOpcoesEstoque;
    @Autowired
    private ServiceMoedaImpl serviceMoeda;

    public ItemCotacaoCompra buildItemCotacaoCompra(CotacaoCompra cotacaoCompra, NecessidadeCompra necessidadeCompra, OpcoesCompraSuprimentos opcoesCompra, OpcoesContabeis opcoesContabeis, OpcoesEstoque opcoesEstoque) throws Exception {
        ItemCotacaoCompra item = null;
        if (ToolMethods.isAffirmative((Number)((Number)CompOpcoes.getOption(this.helperOpcoesEstoque.build(opcoesEstoque).getItens(), (EnumOpDinamicasInterface)EnumConstOpEstoqueOp.UNIFICAR_ITENS_NECESSIDADE_COTACAO, Short.class)))) {
            for (ItemCotacaoCompra existentItemCotacaoCompra : cotacaoCompra.getItensCotacaoCompra()) {
                if (!this.isEquals(existentItemCotacaoCompra.getGradeCor().getIdentificador(), necessidadeCompra.getGradeCor().getIdentificador()) || necessidadeCompra.getNaturezaOperacao() != null && !this.isEquals(necessidadeCompra.getNaturezaOperacao(), existentItemCotacaoCompra.getNaturezaOperacao()) || necessidadeCompra.getCentroCusto() != null && !this.isEquals(necessidadeCompra.getCentroCusto(), existentItemCotacaoCompra.getCentroCustoReq())) continue;
                item = existentItemCotacaoCompra;
            }
        }
        if (item == null) {
            item = this.helperCotacaoCompra.buildItemCotacaoCompra(necessidadeCompra.getGradeCor(), necessidadeCompra.getQuantidadeNecessidade(), this.helperCotacaoCompra.getNaturezaOperacaoCotacao(necessidadeCompra, opcoesCompra), cotacaoCompra.getDataCadastro(), cotacaoCompra);
            item.setFatorConversao(this.getFatorConversao(necessidadeCompra.getGradeCor()));
            item.setUnidadeMedida(this.getUnidadeMedida(necessidadeCompra.getGradeCor()));
            item.getNecessidadesCompra().add(necessidadeCompra);
            item.setAtivo(necessidadeCompra.getAtivo());
            item.setCentroCustoReq(necessidadeCompra.getCentroCusto());
            item.setObservacao(necessidadeCompra.getObservacao());
            if (ToolMethods.isAffirmative((Number)necessidadeCompra.getAquisicaoPreferencial())) {
                item.setFornecedoresItemCotacaoCompra(this.compFornecedorItemCotCompra.criarFornecedoresItemCotacaoCompra(item, necessidadeCompra, necessidadeCompra.getEmpresa(), opcoesContabeis, opcoesCompra));
            }
            cotacaoCompra.getItensCotacaoCompra().add(item);
        } else {
            item.setQuantidade(Double.valueOf(item.getQuantidade() + necessidadeCompra.getQuantidadeNecessidade()));
            item.setObservacao(item.getObservacao() + " " + necessidadeCompra.getObservacao());
        }
        necessidadeCompra.setItemCotacaoCompraGerada(item);
        return item;
    }

    public List<ItemCotacaoCompra> calculaItens(List<DTOCotacaoCompra.DTOItemCotacaoCompra> itens, Empresa empresa, OpcoesContabeis opcoesContabeis, OpcoesCompraSuprimentos opcoes) throws Exception {
        if (itens != null) {
            ArrayList<ItemCotacaoCompra> result = new ArrayList<ItemCotacaoCompra>();
            for (DTOCotacaoCompra.DTOItemCotacaoCompra i : itens) {
                result.add(this.buildItemByDTO(i, empresa, opcoesContabeis, opcoes));
            }
            return result;
        }
        return new ArrayList<ItemCotacaoCompra>();
    }

    public ItemCotacaoCompra buildItemByDTO(DTOCotacaoCompra.DTOItemCotacaoCompra dto, Empresa empresa, OpcoesContabeis opcoesContabeis, OpcoesCompraSuprimentos opcoes) throws Exception {
        ItemCotacaoCompra item = new ItemCotacaoCompra();
        if (dto != null) {
            item.setFatorConversao(dto.getFatorConversao());
            item.setDataCadastro(dto.getDataCadastro());
            item.setQuantidade(dto.getQuantidade());
            item.setGradeCor((GradeCor)this.serviceGradeCor.getOrThrow(dto.getGradeCorIdentificador()));
            item.setUnidadeMedida((UnidadeMedida)this.serviceUnidadeMedida.get(dto.getUnidadeMedidaIdentificador()));
            if (dto.getNaturezaOperacaoIdentificador() != null) {
                item.setNaturezaOperacao((NaturezaOperacao)this.serviceNaturezaOperacao.get(dto.getNaturezaOperacaoIdentificador()));
            }
            if (dto.getCentroCustoReqIdentificador() != null) {
                item.setCentroCustoReq((CentroCusto)this.serviceCentroCusto.get(dto.getCentroCustoReqIdentificador()));
            }
            ArrayList<FornecedorItemCotacaoCompra> fornecedores = new ArrayList<FornecedorItemCotacaoCompra>();
            if (dto.getFornecedoresItemCotacaoCompra() != null) {
                for (DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra f : dto.getFornecedoresItemCotacaoCompra()) {
                    FornecedorItemCotacaoCompra fornecedor = this.buildFornecedorItemCotacaoCompra(item, f, empresa);
                    fornecedores.add(fornecedor);
                }
            }
            if (dto.getSetarFornecedor() != null) {
                UnidadeFatFornecedor unidadeFatFornecedor = (UnidadeFatFornecedor)this.serviceUnidadeFatFornecedor.getOrThrow(dto.getSetarFornecedor().getUnidadeFaturamentoFornecedorIdentificador());
                FornecedorItemCotacaoCompra fornecedor = this.getFornecedorDuplicado(fornecedores, unidadeFatFornecedor);
                if (fornecedor == null) {
                    ArrayList<FornecedorItemCotacaoCompra> novosFornecedores = new ArrayList<FornecedorItemCotacaoCompra>();
                    novosFornecedores.add(this.buildFornecedorItemCotacaoCompra(item, dto.getSetarFornecedor(), empresa));
                    item.setFornecedoresItemCotacaoCompra(novosFornecedores);
                    if (this.validateItem(item).booleanValue()) {
                        this.calculaItens(item, empresa, opcoesContabeis, opcoes);
                    }
                    item.getFornecedoresItemCotacaoCompra().addAll(0, fornecedores);
                } else {
                    if (item.getGradeCor() != null && !this.isAffimative(opcoes.getNaoSugCustoAutoCotCompras())) {
                        fornecedor.setCustoMedio(CompNotaTerceiros.getCustoMedioProd(item.getGradeCor().getProdutoGrade().getProduto(), empresa));
                        fornecedor.setUltimoCusto(CompNotaTerceiros.getUltimoCustoProd(item.getGradeCor().getProdutoGrade().getProduto(), empresa));
                        fornecedor.setMenorCusto(CompNotaTerceiros.getMenorCustoProd(item.getGradeCor().getProdutoGrade().getProduto(), empresa));
                    }
                    item.setFornecedoresItemCotacaoCompra(fornecedores);
                }
            } else {
                item.setFornecedoresItemCotacaoCompra(fornecedores);
                if (this.validateItem(item).booleanValue()) {
                    this.calculaItens(item, empresa, opcoesContabeis, opcoes);
                }
            }
        }
        return item;
    }

    private FornecedorItemCotacaoCompra buildFornecedorItemCotacaoCompra(ItemCotacaoCompra item, DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra f, Empresa empresa) throws Exception {
        FornecedorItemCotacaoCompra fornecedor = new FornecedorItemCotacaoCompra();
        fornecedor.setSelecionado(f.getSelecionado());
        fornecedor.setValorUnitario(f.getValorUnitario());
        fornecedor.setDataCadastro(f.getDataCadastro() != null ? f.getDataCadastro() : new Date());
        fornecedor.setTipoFrete((TipoFrete)this.serviceTipoFrete.get(f.getTipoFreteIdentificador()));
        fornecedor.setCondicoesPagamento((CondicoesPagamento)this.serviceCondicoesPagamento.get(f.getCondicoesPagamentoIdentificador()));
        fornecedor.setCondicaoPagamentoMutante(f.getCondicaoPagamentoMutante());
        fornecedor.setMoeda((Moeda)this.serviceMoeda.get(f.getMoedaIdentificador()));
        fornecedor.setModeloFiscal((ModeloFiscal)this.serviceModeloFiscal.get(f.getModeloFiscalIdentificador()));
        fornecedor.setUnidadeFaturamentoFornecedor((UnidadeFatFornecedor)this.serviceUnidadeFatFornecedor.get(f.getUnidadeFaturamentoFornecedorIdentificador()));
        fornecedor.setValidado(f.getValidado());
        fornecedor.setPessoaContato(f.getPessoaContato());
        fornecedor.setAquisicaoPreferencial(f.getAquisicaoPreferencial());
        if (this.isAffimative(f.getAquisicaoPreferencial())) {
            fornecedor.setJustficativaAquisicaoPreferencial(f.getJustficativaAquisicaoPreferencial());
            fornecedor.setMotivoAquisPref((MotivoAquisicaoPref)this.serviceMotivoAquisicaoPref.get(f.getMotivoAquisPrefIdentificador()));
        }
        fornecedor.setPrazoEntrega(f.getPrazoEntrega());
        fornecedor.setItemCotacaoCompra(item);
        return fornecedor;
    }

    private FornecedorItemCotacaoCompra getFornecedorDuplicado(List<FornecedorItemCotacaoCompra> fornecedoresItemCotacaoCompra, UnidadeFatFornecedor unidadeFatFornecedor) {
        for (FornecedorItemCotacaoCompra fornecedorItem : fornecedoresItemCotacaoCompra) {
            if (!fornecedorItem.getUnidadeFaturamentoFornecedor().equals((Object)unidadeFatFornecedor)) continue;
            return fornecedorItem;
        }
        return null;
    }

    private Boolean validateItem(ItemCotacaoCompra item) {
        ValidGenericEntitiesImpl validator = (ValidGenericEntitiesImpl)ConfApplicationContext.getBean(ValidBeforeCalcItemCotacao.class);
        validator.clearContainer();
        validator.isValidData((InterfaceVO)item);
        if (validator.hasErrors()) {
            throw new ExceptionRuntimeBase(validator.getContainer().toString());
        }
        return true;
    }

    public void calculaItens(ItemCotacaoCompra item, Empresa empresa, OpcoesContabeis opcoesContabeis, OpcoesCompraSuprimentos opcoes) throws Exception {
        if (!this.existeItemSemModeloFiscal(item).booleanValue()) {
            this.calcularValores(item, empresa, opcoes);
            this.setDadosContabeis(empresa, opcoesContabeis, item);
        }
    }

    private void calcularValores(ItemCotacaoCompra item, Empresa empresa, OpcoesCompraSuprimentos opcoes) throws Exception {
        CompCalculoImpostosFiscaisCotacao compCalculo = (CompCalculoImpostosFiscaisCotacao)ConfApplicationContext.getBean(CompCalculoImpostosFiscaisCotacao.class);
        compCalculo.calcularImpostosFiscaisFornecedorItemCotacaoCompra(item.getFornecedoresItemCotacaoCompra(), item.getGradeCor(), item.getQuantidade(), item.getFatorConversao(), empresa, opcoes);
    }

    private Double getFatorConversao(GradeCor gradeCor) {
        List<ItemUnidadeMedida> itens;
        if (gradeCor.getProdutoGrade() != null && gradeCor.getProdutoGrade().getProduto() != null && gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida() != null && !gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida().isEmpty() && !(itens = new HelperProduto().build(gradeCor.getProdutoGrade().getProduto()).getItensUnidMedidasAtivoUnProd()).isEmpty()) {
            return itens.get(0).getFatorConversao();
        }
        return 1.0;
    }

    private UnidadeMedida getUnidadeMedida(GradeCor gradeCor) {
        if (gradeCor.getProdutoGrade() != null && gradeCor.getProdutoGrade().getProduto() != null && gradeCor.getProdutoGrade().getProduto().getUnidadeMedida() != null) {
            return gradeCor.getProdutoGrade().getProduto().getUnidadeMedida();
        }
        if (gradeCor.getProdutoGrade() != null && gradeCor.getProdutoGrade().getProduto() != null && gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida() != null && !gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida().isEmpty()) {
            return ((ItemUnidadeMedida)gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida().get(0)).getUnidadeMedida();
        }
        throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1066.011", new Object[]{gradeCor.getProdutoGrade().getProduto().getIdentificador(), gradeCor.getProdutoGrade().getProduto().getNome()}));
    }

    public DTOValoresProdutoCotacao findValoresProduto(Produto produto, Empresa empresa) {
        DTOValoresProdutoCotacao dto = new DTOValoresProdutoCotacao();
        if (produto != null) {
            dto.setMenorValorCusto(this.findMenorCusto(produto, empresa));
            dto.setValorCustoMedio(this.findValorCustoMedio(produto, empresa));
            dto.setUltimoValorCusto(this.findValorCustoProduto(produto, empresa));
        }
        return dto;
    }

    private Double findValorCustoProduto(Produto produto, Empresa empresa) {
        CompEstoque service = this.getBean(CompEstoque.class);
        Double vlr = service.getUltimoCusto(produto, empresa);
        return vlr;
    }

    private Double findValorCustoMedio(Produto produto, Empresa empresa) {
        ServiceNotaFiscalTerceiros service = (ServiceNotaFiscalTerceiros)ConfApplicationContext.getBean(ServiceNotaFiscalTerceiros.class);
        return service.getCustoMedioProd(produto.getIdentificador(), empresa);
    }

    private Double findMenorCusto(Produto produto, Empresa empresa) {
        ServiceNotaFiscalTerceiros service = (ServiceNotaFiscalTerceiros)ConfApplicationContext.getBean(ServiceNotaFiscalTerceiros.class);
        return service.getMenorCustoProd(produto.getIdentificador(), empresa);
    }
}

