/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.cotacaocompra.calculoitemcotacao;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.naturezaoperacao.EnumConstNatOpEntSaidaFaturamento;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorrules.impostos.ipi.model.IPICalculado;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.components.calculoimpostos.CalculoICMSEntUtilities;
import com.touchcomp.basementorservice.components.cotacaocompra.CompFornecedorItemCotCompra;
import com.touchcomp.basementorservice.components.cotacaocompra.calculoitemcotacao.impl.AuxCalculoIcmsSTItemCotacao;
import com.touchcomp.basementorservice.components.cotacaocompra.calculoitemcotacao.impl.AuxCalculoIpiItemCotacao;
import com.touchcomp.basementorservice.components.cotacaocompra.calculoitemcotacao.impl.AuxCalculoOutrosImpostos;
import com.touchcomp.basementorservice.components.cotacaocompra.calculoitemcotacao.impl.totalizador.AuxTotalizadoresItemCotacao;
import com.touchcomp.basementorservice.components.estoque.CompEstoque;
import com.touchcomp.basementorservice.helpers.impl.cfop.HelperCfop;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperFornecedorItemCotCompra;
import com.touchcomp.basementorservice.service.impl.empresacontabilidade.ServiceEmpresaContabilidadeImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompCalculoImpostosFiscaisCotacao
extends BaseMethods {
    @Autowired
    private AuxTotalizadoresItemCotacao auxTotalizadores;
    @Autowired
    private ServiceEmpresaContabilidadeImpl serviceEmpresaContabilidade;

    public void calcularImpostosFiscaisFornecedorItemCotacaoCompra(List<FornecedorItemCotacaoCompra> itens, GradeCor gradeCor, Double quantidade, Double fatorConversao, Empresa empresa, OpcoesCompraSuprimentos opcoes) throws Exception {
        if (itens != null) {
            CompFornecedorItemCotCompra compFornecedorItemCotCompra = (CompFornecedorItemCotCompra)ConfApplicationContext.getBean(CompFornecedorItemCotCompra.class);
            for (FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra : itens) {
                if (fornecedorItemCotacaoCompra.getModeloFiscal() == null) {
                    throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1066.004", new Object[]{fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor(), gradeCor.getProdutoGrade().getProduto().getNome()}));
                }
                compFornecedorItemCotCompra.setFornecedorItemCotacaoCompraLivroFiscal(fornecedorItemCotacaoCompra, gradeCor.getProdutoGrade().getProduto(), empresa, opcoes);
                if (fornecedorItemCotacaoCompra.getValorUnitario() == null || !(fornecedorItemCotacaoCompra.getValorUnitario() > 0.0)) continue;
                this.calcularImpostosFiscaisFornecedorItemCotacaoCompra(fornecedorItemCotacaoCompra, gradeCor, quantidade, fatorConversao, empresa, opcoes);
            }
        }
    }

    private void setValoresPercentuais(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Double quantidadeTotal) {
        this.auxTotalizadores.calculaTotalizadoresItemCotacao(fornecedorItemCotacaoCompra, quantidadeTotal);
    }

    public void calcularImpostosFiscaisFornecedorItemCotacaoCompra(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, GradeCor gradeCor, Double quantidadeTotal, Double fatorConversao, Empresa empresa, OpcoesCompraSuprimentos opcoes) throws Exception {
        if (fornecedorItemCotacaoCompra.getValorUnitario() <= 0.0) {
            fornecedorItemCotacaoCompra.setValidado(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            return;
        }
        FornecedorItemCotacaoCompraLivroFiscal fornecedorItemCotacaoCompraLivroFiscal = fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal();
        ModeloFiscal modeloFiscal = fornecedorItemCotacaoCompra.getModeloFiscal();
        if (modeloFiscal == null) {
            modeloFiscal = this.getModeloFiscal(fornecedorItemCotacaoCompra, empresa);
            fornecedorItemCotacaoCompra.setModeloFiscal(modeloFiscal);
        }
        if (modeloFiscal == null) {
            return;
        }
        Produto produto = gradeCor.getProdutoGrade().getProduto();
        this.setInfoEstatisticasCusto(fornecedorItemCotacaoCompra, empresa, opcoes);
        if (fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal() == null) {
            fornecedorItemCotacaoCompra.setFornecedorItemCotacaoCompraLivroFiscal(new FornecedorItemCotacaoCompraLivroFiscal());
        }
        if (fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal().getCfop() == null && fornecedorItemCotacaoCompra.getItemCotacaoCompra() != null && fornecedorItemCotacaoCompra.getItemCotacaoCompra().getCotacaoCompra() != null) {
            Cfop c = this.getCfop(fornecedorItemCotacaoCompra, fornecedorItemCotacaoCompra.getItemCotacaoCompra().getCotacaoCompra().getEmpresa());
            fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal().setCfop(c);
        }
        this.setValoresPercentuais(fornecedorItemCotacaoCompra, quantidadeTotal);
        this.iniciaBaseCalculoGeral(fornecedorItemCotacaoCompra, produto, fornecedorItemCotacaoCompraLivroFiscal);
        if (fornecedorItemCotacaoCompraLivroFiscal != null) {
            AuxCalculoIpiItemCotacao compCalculoIpiItemCotacao = new AuxCalculoIpiItemCotacao();
            IPICalculado ipiCalculado = compCalculoIpiItemCotacao.calculaValoresIpiItemCotacao(modeloFiscal, fornecedorItemCotacaoCompraLivroFiscal, fornecedorItemCotacaoCompra, fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor(), quantidadeTotal);
            AuxCalculoIcmsSTItemCotacao compCalculoIcmsSTItemCotacao = new AuxCalculoIcmsSTItemCotacao();
            compCalculoIcmsSTItemCotacao.calculaValoresIcmsSTItemCotacao(modeloFiscal, fornecedorItemCotacaoCompra, fornecedorItemCotacaoCompraLivroFiscal, produto, quantidadeTotal, ipiCalculado, empresa, this.serviceEmpresaContabilidade.findByEmpresa(empresa));
            AuxCalculoOutrosImpostos compCalculoOutrosImpostos = new AuxCalculoOutrosImpostos();
            compCalculoOutrosImpostos.calculoOutrosImpostos(fornecedorItemCotacaoCompraLivroFiscal, fornecedorItemCotacaoCompra, (short)4, produto, quantidadeTotal);
            fornecedorItemCotacaoCompraLivroFiscal.setValorTotal(this.auxTotalizadores.getValorTotalItem(fornecedorItemCotacaoCompra, fornecedorItemCotacaoCompraLivroFiscal, quantidadeTotal));
            this.calcularDiferencaAliquota(modeloFiscal, fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf(), empresa.getPessoa().getEndereco().getCidade().getUf(), fornecedorItemCotacaoCompraLivroFiscal, produto, fornecedorItemCotacaoCompra, quantidadeTotal);
            this.atualizarGrades(fornecedorItemCotacaoCompra, fornecedorItemCotacaoCompraLivroFiscal, modeloFiscal, quantidadeTotal, fatorConversao);
            if (fornecedorItemCotacaoCompra.getValorCusto() > 0.0 && fornecedorItemCotacaoCompra.getValorUnitario() > 0.0) {
                fornecedorItemCotacaoCompra.setValidado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            }
        }
    }

    private void iniciaBaseCalculoGeral(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Produto produto, FornecedorItemCotacaoCompraLivroFiscal fornecedorItemCotacaoCompraLivroFiscal) {
        if (produto.getAliquotaIss() > 0.0) {
            fornecedorItemCotacaoCompraLivroFiscal.setValorIrrf(this.auxTotalizadores.getValorIrrf(fornecedorItemCotacaoCompra, produto));
            fornecedorItemCotacaoCompraLivroFiscal.setValorInss(this.auxTotalizadores.getValorInss(fornecedorItemCotacaoCompra, produto));
            fornecedorItemCotacaoCompraLivroFiscal.setValorIss(this.auxTotalizadores.getValorIss(fornecedorItemCotacaoCompra, produto));
            fornecedorItemCotacaoCompraLivroFiscal.setAliquotaIcms(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setAliquotaIpi(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorBaseCalculoIcmsSt(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorDiferencaAliquota(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorIcms(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorIcmsIsento(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorIcmsOutros(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorIcmsSemAproveitamento(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorIcmsSt(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorIcmsTributado(Double.valueOf(0.0));
        }
    }

    private ModeloFiscal getModeloFiscal(FornecedorItemCotacaoCompra fornecedorItem, Empresa empresa) throws ExceptionObjNotFound {
        return new HelperFornecedorItemCotCompra().build(fornecedorItem).getModeloFiscal(empresa);
    }

    private void setInfoEstatisticasCusto(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Empresa empresa, OpcoesCompraSuprimentos opcoes) {
        if (ToolMethods.isAffirmative((Number)opcoes.getNaoSugCustoAutoCotCompras())) {
            return;
        }
        if (fornecedorItemCotacaoCompra.getItemCotacaoCompra() != null && fornecedorItemCotacaoCompra.getItemCotacaoCompra().getGradeCor() != null) {
            Produto produto = fornecedorItemCotacaoCompra.getItemCotacaoCompra().getGradeCor().getProdutoGrade().getProduto();
            ServiceNotaFiscalTerceirosImpl service = (ServiceNotaFiscalTerceirosImpl)ConfApplicationContext.getBean(ServiceNotaFiscalTerceirosImpl.class);
            CompEstoque compEstoque = (CompEstoque)ConfApplicationContext.getBean(CompEstoque.class);
            Double ultVlrCusto = compEstoque.getUltimoCusto(produto, empresa);
            Double custoMedio = service.getCustoMedioProd(produto.getIdentificador(), empresa);
            Double menorCusto = service.getMenorCustoProd(produto.getIdentificador(), empresa);
            fornecedorItemCotacaoCompra.setCustoMedio(custoMedio);
            fornecedorItemCotacaoCompra.setUltimoCusto(ultVlrCusto);
            fornecedorItemCotacaoCompra.setMenorCusto(menorCusto);
        }
    }

    private Cfop getCfop(FornecedorItemCotacaoCompra f, Empresa emp) {
        HelperCfop helper = (HelperCfop)ConfApplicationContext.getBean(HelperCfop.class);
        Cfop cfop = helper.getCfop(EnumConstNatOpEntSaidaFaturamento.ENT_SAI_FATURAMENTO_ENTRADA, emp.getPessoa().getEndereco().getCidade().getUf(), f.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf(), f.getModeloFiscal());
        return cfop;
    }

    private void calcularDiferencaAliquota(ModeloFiscal modeloFiscal, UnidadeFederativa unidadeFederativaFornecedor, UnidadeFederativa unidadeFederativaEmpresa, FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, Produto produto, FornecedorItemCotacaoCompra itemCotacao, Double quantidadeTotal) throws Exception {
        HashMap h = new CalculoICMSEntUtilities(EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalIcms().getIncluiSeguro()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalIcms().getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalIcms().getIncluiDespAcess()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalIcms().getIncluiDesconto()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalIcms().getIncluiSeguroST()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalIcms().getIncluiFreteST()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalIcms().getIncluiDespAcessST()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalIcms().getIncluiDescontoST()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalIcms().getIncluiIPIST()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalIcms().getIncluirIcmsDesonerado())).calcularDiferencaAliquota(modeloFiscal.getModeloFiscalIcms(), unidadeFederativaFornecedor, unidadeFederativaEmpresa, produto, itemCotacao.getValorFrete(), itemCotacao.getValorSeguro(), itemCotacao.getValorDespesasAcessorias(), itemCotacao.getValorDesconto(), itemCotacao.getValorUnitario() * quantidadeTotal, modeloFiscal.getModeloFiscalIcms().getIpiCompoeBCDifAliquota(), itemCotacaoCompraLivroFiscal.getValorIpiComercio() + itemCotacaoCompraLivroFiscal.getValorIpiIndustria() + itemCotacaoCompraLivroFiscal.getValorIpiObservacao(), itemCotacaoCompraLivroFiscal.getAliquotaIcms());
        itemCotacaoCompraLivroFiscal.setValorDiferencaAliquota((Double)h.get("valorDifAliquota"));
    }

    private void atualizarGrades(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, ModeloFiscal modeloFiscal, Double quantidadeTotal, Double fatorConversao) {
        fornecedorItemCotacaoCompra.setValorCusto(this.auxTotalizadores.getValorCusto(fornecedorItemCotacaoCompra, itemCotacaoCompraLivroFiscal, quantidadeTotal));
        if (this.isAffimative(modeloFiscal.getModeloFiscalIcms().getRecuperarTributosIcms())) {
            fornecedorItemCotacaoCompra.setValorCusto(Double.valueOf(fornecedorItemCotacaoCompra.getValorCusto() - itemCotacaoCompraLivroFiscal.getValorIcms()));
        }
        if (this.isAffimative(modeloFiscal.getModeloFiscalIcms().getCalcularIcmsSimples())) {
            fornecedorItemCotacaoCompra.setValorCusto(Double.valueOf(fornecedorItemCotacaoCompra.getValorCusto() - itemCotacaoCompraLivroFiscal.getValorIcmsSimples()));
        }
        if (fornecedorItemCotacaoCompra.getItemCotacaoCompra() != null) {
            if (fatorConversao == null) {
                fornecedorItemCotacaoCompra.getItemCotacaoCompra().setFatorConversao(Double.valueOf(1.0));
            } else {
                fornecedorItemCotacaoCompra.getItemCotacaoCompra().setFatorConversao(fatorConversao);
            }
        }
        if (fatorConversao == null || fatorConversao == 0.0) {
            fatorConversao = 1.0;
        }
        fornecedorItemCotacaoCompra.setValorCusto(this.auxTotalizadores.getValorCusto(fornecedorItemCotacaoCompra, quantidadeTotal, fatorConversao));
    }
}

