/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.cotacaocompra.calculoitemcotacao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.impostos.contsocial.EnumConstTipoCalcContSocial;
import com.touchcomp.basementor.constants.enums.impostos.funrural.EnumConstTipoCalcFunrural;
import com.touchcomp.basementor.constants.enums.impostos.inss.EnumConstTipoCalcInss;
import com.touchcomp.basementor.constants.enums.impostos.iss.EnumConstTipoCalcIss;
import com.touchcomp.basementor.constants.enums.impostos.outros.EnumConstTipoCalcOutros;
import com.touchcomp.basementor.constants.enums.impostos.piscofins.EnumConstNFeIncidenciaCofins;
import com.touchcomp.basementor.constants.enums.impostos.piscofins.EnumConstTipoCalcPisCofins;
import com.touchcomp.basementor.constants.enums.impostos.sestsenat.EnumConstTipoCalcSestSenat;
import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorrules.impostos.contsocial.CompImpostoContSocial;
import com.touchcomp.basementorrules.impostos.contsocial.model.ContSocialCalculado;
import com.touchcomp.basementorrules.impostos.contsocial.model.ContSocialParams;
import com.touchcomp.basementorrules.impostos.funrural.CompImpostoFunrural;
import com.touchcomp.basementorrules.impostos.funrural.model.FunruralCalculado;
import com.touchcomp.basementorrules.impostos.funrural.model.FunruralParams;
import com.touchcomp.basementorrules.impostos.inss.CompImpostoInss;
import com.touchcomp.basementorrules.impostos.inss.model.InssCalculado;
import com.touchcomp.basementorrules.impostos.inss.model.InssParams;
import com.touchcomp.basementorrules.impostos.iss.CompImpostoIss;
import com.touchcomp.basementorrules.impostos.iss.model.IssCalculado;
import com.touchcomp.basementorrules.impostos.iss.model.IssParams;
import com.touchcomp.basementorrules.impostos.outros.CompImpostoOutros;
import com.touchcomp.basementorrules.impostos.outros.model.OutrosCalculado;
import com.touchcomp.basementorrules.impostos.outros.model.OutrosParams;
import com.touchcomp.basementorrules.impostos.piscofins.CompImpostoPisCofins;
import com.touchcomp.basementorrules.impostos.piscofins.model.PisCofinsCalculado;
import com.touchcomp.basementorrules.impostos.piscofins.model.PisCofinsParams;
import com.touchcomp.basementorrules.impostos.sestsenat.CompImpostoSestSenat;
import com.touchcomp.basementorrules.impostos.sestsenat.model.SestSenatCalculado;
import com.touchcomp.basementorrules.impostos.sestsenat.model.SestSenatParams;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.components.calculoimpostos.CalculoOutrosImpostos;
import java.util.HashMap;
import org.springframework.stereotype.Component;

@Component
public class AuxCalculoOutrosImpostos
extends BaseMethods {
    public void calculoOutrosImpostos(FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Short modoArredondamento, Produto produto, Double quantidadeTotal) throws Exception {
        this.calculaValoresPis(itemCotacaoCompraLivroFiscal, fornecedorItemCotacaoCompra, modoArredondamento, produto, quantidadeTotal);
        this.calculaValoresContribuicaoSocial(itemCotacaoCompraLivroFiscal, fornecedorItemCotacaoCompra, produto, quantidadeTotal);
        this.calculaFunRural(itemCotacaoCompraLivroFiscal, fornecedorItemCotacaoCompra, produto, quantidadeTotal);
        this.calculaLei10833(itemCotacaoCompraLivroFiscal, fornecedorItemCotacaoCompra, produto, quantidadeTotal);
        this.calculoInss(itemCotacaoCompraLivroFiscal, fornecedorItemCotacaoCompra, produto, quantidadeTotal);
        this.calculoIrrf(itemCotacaoCompraLivroFiscal, fornecedorItemCotacaoCompra, produto, quantidadeTotal);
        this.calculoIss(itemCotacaoCompraLivroFiscal, fornecedorItemCotacaoCompra, produto, quantidadeTotal);
        this.calculoOutros(itemCotacaoCompraLivroFiscal, fornecedorItemCotacaoCompra, produto, quantidadeTotal);
        this.calculoSestSenat(itemCotacaoCompraLivroFiscal, fornecedorItemCotacaoCompra, produto, quantidadeTotal);
    }

    private Double getAliquotaPis(Produto produto, ModeloFiscal modeloFiscal) {
        if (this.isAffimative(modeloFiscal.getModeloFiscalPisCofins().getCalcularPisNormal())) {
            if (this.isEquals(modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                return modeloFiscal.getModeloFiscalPisCofins().getAliquotaPis();
            }
            return produto.getAliquotaPis();
        }
        return 0.0;
    }

    private Double getAliquotaPisSt(Produto produto, ModeloFiscal modeloFiscal) {
        if (this.isAffimative(modeloFiscal.getModeloFiscalPisCofins().getCalcularPisSt())) {
            if (this.isEquals(modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                return modeloFiscal.getModeloFiscalPisCofins().getAliquotaPisSt();
            }
            return produto.getAliquotaPisSt();
        }
        return 0.0;
    }

    private Double getAliquotaCofins(Produto produto, ModeloFiscal modeloFiscal) {
        if (this.isAffimative(modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsNormal())) {
            if (this.isEquals(modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                return modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofins();
            }
            return produto.getAliquotaCofins();
        }
        return 0.0;
    }

    private Double getAliquotaCofinsSt(Produto produto, ModeloFiscal modeloFiscal) {
        if (this.isAffimative(modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsSt())) {
            if (this.isEquals(modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                return modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofinsSt();
            }
            return produto.getAliquotaCofinsSt();
        }
        return 0.0;
    }

    private void calculaValoresPis(FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Short modoArredondamento, Produto produto, Double quantidadeTotal) throws Exception {
        ModeloFiscal modeloFiscal = fornecedorItemCotacaoCompra.getModeloFiscal();
        Double aliquotaPis = this.getAliquotaPis(produto, modeloFiscal);
        Double aliquotaPisSt = this.getAliquotaPisSt(produto, modeloFiscal);
        Double aliquotaCofins = this.getAliquotaCofins(produto, modeloFiscal);
        Double aliquotaCofinsSt = this.getAliquotaCofinsSt(produto, modeloFiscal);
        PisCofinsParams params = new PisCofinsParams(EnumConstNFeIncidenciaCofins.valueOfCodigo((String)modeloFiscal.getModeloFiscalPisCofins().getIncidenciaPisCofins().getCodigo()), aliquotaPis, aliquotaCofins, EnumConstantsMentorEntSaida.ENTRADA, EnumConstTipoCalcPisCofins.get((Object)fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getCalcularPisNormal()), EnumConstTipoCalcPisCofins.get((Object)fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getCalcularCofinsNormal()), EnumConstTipoCalcPisCofins.get((Object)fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getCalcularPisSt()), EnumConstTipoCalcPisCofins.get((Object)fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getCalcularCofinsSt()), Double.valueOf(fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), quantidadeTotal, EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getIncluiDesconto()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getIncluirIcmsDesonerado()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getIncluiDespAcess()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getIncluiSeguro()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getIncluiDesconto()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getIncluiDespAcess()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getIncluiSeguro()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getAbaterValorIcms()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getIncluirIcmsDesonerado()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getIncluirIcmsSemAproveitamento()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getIncluirIpiObservacao()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getAbaterValorIcms()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getIncluirIcmsSemAproveitamento()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalPisCofins().getIncluirIpiObservacao()), EnumConstantsMentorSimNao.NAO, aliquotaPisSt, aliquotaCofinsSt, itemCotacaoCompraLivroFiscal.getValorIcms(), itemCotacaoCompraLivroFiscal.getValorIcmsDispensado(), itemCotacaoCompraLivroFiscal.getValorIcmsSemAproveitamento(), itemCotacaoCompraLivroFiscal.getValorIpiObservacao(), Double.valueOf(0.0), Double.valueOf(0.0), modeloFiscal.getModeloFiscalPisCofins().getValorMinimoPis(), modeloFiscal.getModeloFiscalPisCofins().getValorMinimoCofins());
        PisCofinsCalculado calc = CompImpostoPisCofins.calcularPisCofins((PisCofinsParams)params);
        itemCotacaoCompraLivroFiscal.setAliquotaPis(calc.getAliquotaPis());
        itemCotacaoCompraLivroFiscal.setAliquotaCofins(calc.getAliquotaCofins());
        itemCotacaoCompraLivroFiscal.setValorPis(calc.getValorPis());
        itemCotacaoCompraLivroFiscal.setValorCofins(calc.getValorCofins());
        itemCotacaoCompraLivroFiscal.setValorBaseCalculoCofins(calc.getValorBCCofins());
        itemCotacaoCompraLivroFiscal.setValorBaseCalculoPis(calc.getValorBCPis());
        itemCotacaoCompraLivroFiscal.setAliquotaPisSt(calc.getAliquotaPisST());
        itemCotacaoCompraLivroFiscal.setAliquotaCofinsSt(calc.getAliquotaCofinsST());
        itemCotacaoCompraLivroFiscal.setValorPisSt(calc.getValorPisST());
        itemCotacaoCompraLivroFiscal.setValorCofinsSt(calc.getValorCofinsST());
        itemCotacaoCompraLivroFiscal.setValorBaseCalculoCofinsSt(calc.getValorBCCofinsST());
        itemCotacaoCompraLivroFiscal.setValorBaseCalculoPisSt(calc.getValorBCPisST());
    }

    private void calculaValoresContribuicaoSocial(FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Produto produto, Double quantidadeTotal) {
        ContSocialParams params = new ContSocialParams(produto.getAliquotaContSoc(), produto.getPercRedContSoc(), itemCotacaoCompraLivroFiscal.getValorContribuicaoSocial(), fornecedorItemCotacaoCompra.getModeloFiscal().getValorMinimoCSLL(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), Double.valueOf(fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal), EnumConstTipoArredondamento.ROUND_FLOOR, EnumConstTipoCalcContSocial.get((Object)fornecedorItemCotacaoCompra.getModeloFiscal().getTipoContSoc()));
        ContSocialCalculado calc = CompImpostoContSocial.calcularContSocial((ContSocialParams)params);
        itemCotacaoCompraLivroFiscal.setAliquotaContribuicaoSocial(calc.getAliquotaContSocial());
        itemCotacaoCompraLivroFiscal.setValorContribuicaoSocial(calc.getValorContSocial());
    }

    private void calculaFunRural(FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Produto produto, Double quantidadeTotal) {
        FunruralParams params = new FunruralParams(produto.getAliquotaFunrural(), produto.getPercRedFunrural(), itemCotacaoCompraLivroFiscal.getValorFunrural(), fornecedorItemCotacaoCompra.getModeloFiscal().getValorMinimoOutros(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), Double.valueOf(fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal), EnumConstTipoArredondamento.ROUND_FLOOR, EnumConstTipoCalcFunrural.get((Object)fornecedorItemCotacaoCompra.getModeloFiscal().getTipoFunrural()));
        FunruralCalculado calc = CompImpostoFunrural.calcularFunrural((FunruralParams)params);
        itemCotacaoCompraLivroFiscal.setAliquotaFunrural(calc.getAliquotaFunrural());
        itemCotacaoCompraLivroFiscal.setValorFunrural(calc.getValorFunrural());
    }

    private void calculaLei10833(FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Produto produto, Double quantidadeTotal) {
        HashMap h = CalculoOutrosImpostos.calculoLei10833(fornecedorItemCotacaoCompra.getModeloFiscal(), produto.getAliquotaLei10833(), produto.getPercRedLei10833(), itemCotacaoCompraLivroFiscal.getValorLei10833(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal, (short)6);
        itemCotacaoCompraLivroFiscal.setAliquotaLei10833((Double)h.get("aliquotaLei10833"));
        itemCotacaoCompraLivroFiscal.setValorLei10833((Double)h.get("valorLei10833"));
    }

    private void calculoInss(FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Produto produto, Double quantidadeTotal) {
        InssParams params = new InssParams(produto.getAliquotaInss(), produto.getPercRedBCINSS(), itemCotacaoCompraLivroFiscal.getValorInss(), Double.valueOf(0.0), fornecedorItemCotacaoCompra.getModeloFiscal().getValorMinimoInss(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), Double.valueOf(fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal), EnumConstTipoArredondamento.ROUND_FLOOR, EnumConstTipoCalcInss.get((Object)fornecedorItemCotacaoCompra.getModeloFiscal().getTipoINSS()));
        InssCalculado calc = CompImpostoInss.calcularInss((InssParams)params);
        itemCotacaoCompraLivroFiscal.setAliquotaInss(calc.getAliquotaInss());
        itemCotacaoCompraLivroFiscal.setValorInss(calc.getValorInss());
        itemCotacaoCompraLivroFiscal.setPercentualReducaoBaseCalculoInss(calc.getPercRedInss());
    }

    private void calculoIrrf(FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Produto produto, Double quantidadeTotal) {
        HashMap h = CalculoOutrosImpostos.calculoIRRF(fornecedorItemCotacaoCompra.getModeloFiscal().getTipoIRRF(), produto.getAliquotaIrrf(), produto.getPercRedIrrf(), itemCotacaoCompraLivroFiscal.getValorIrrf(), fornecedorItemCotacaoCompra.getModeloFiscal().getValorMinimoIR(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal, (short)6);
        itemCotacaoCompraLivroFiscal.setAliquotaIrrf((Double)h.get("aliquotaIrrf"));
        itemCotacaoCompraLivroFiscal.setValorIrrf((Double)h.get("valorIrrf"));
    }

    private void calculoIss(FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Produto produto, Double quantidadeTotal) {
        IssParams params = new IssParams(produto.getAliquotaIss(), Double.valueOf(0.0), itemCotacaoCompraLivroFiscal.getValorIss(), fornecedorItemCotacaoCompra.getModeloFiscal().getValorMinimoISS(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), Double.valueOf(fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal), EnumConstTipoArredondamento.ROUND_FLOOR, EnumConstTipoCalcIss.get((Object)fornecedorItemCotacaoCompra.getModeloFiscal().getIssRetido()));
        IssCalculado calc = CompImpostoIss.calcularIss((IssParams)params);
        itemCotacaoCompraLivroFiscal.setAliquotaIss(calc.getAliquotaIss());
        itemCotacaoCompraLivroFiscal.setValorIss(calc.getValorIss());
    }

    private void calculoOutros(FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Produto produto, Double quantidadeTotal) {
        OutrosParams params = new OutrosParams(produto.getAliquotaOutros(), produto.getPercRedOutros(), itemCotacaoCompraLivroFiscal.getValorOutros(), fornecedorItemCotacaoCompra.getModeloFiscal().getValorMinimoOutros(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), Double.valueOf(fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal), EnumConstTipoArredondamento.ROUND_FLOOR, EnumConstTipoCalcOutros.get((Object)fornecedorItemCotacaoCompra.getModeloFiscal().getTipoOutros()));
        OutrosCalculado calc = CompImpostoOutros.calcularOutros((OutrosParams)params);
        itemCotacaoCompraLivroFiscal.setAliquotaOutros(calc.getAliquotaOutros());
        itemCotacaoCompraLivroFiscal.setValorOutros(calc.getValorOutros());
    }

    private void calculoSestSenat(FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Produto produto, Double quantidadeTotal) {
        SestSenatParams params = new SestSenatParams(produto.getPercSestSenat(), produto.getPercRedSestSenat(), itemCotacaoCompraLivroFiscal.getValorSestSenat(), Double.valueOf(0.0), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), Double.valueOf(fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal), EnumConstTipoArredondamento.ROUND_FLOOR, EnumConstTipoCalcSestSenat.get((Object)fornecedorItemCotacaoCompra.getModeloFiscal().getTipoSestSenat()));
        SestSenatCalculado calc = CompImpostoSestSenat.calcularSestSenat((SestSenatParams)params);
        itemCotacaoCompraLivroFiscal.setAliquotaSestSenat(calc.getAliquotaSestSenat());
        itemCotacaoCompraLivroFiscal.setValorSestSenat(calc.getValorSestSenat());
        itemCotacaoCompraLivroFiscal.setPercentualReducaoSestSenat(calc.getPercRedSestSenat());
    }
}

