/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.cotacaocompra.calculoitemcotacao.impl.totalizador;

import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.BaseMethods;
import org.springframework.stereotype.Component;

@Component
public class AuxTotalizadoresItemCotacao
extends BaseMethods {
    public void calculaTotalizadoresItemCotacao(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Double quantidadeTotal) {
        if (fornecedorItemCotacaoCompra == null || fornecedorItemCotacaoCompra.getValorUnitario() == null) {
            return;
        }
        this.calculaDesconto(fornecedorItemCotacaoCompra, quantidadeTotal);
        this.calculaDespesasAcessorias(fornecedorItemCotacaoCompra, quantidadeTotal);
        this.calculaFrete(fornecedorItemCotacaoCompra, quantidadeTotal);
        this.calculaSeguro(fornecedorItemCotacaoCompra, quantidadeTotal);
    }

    private void calculaDesconto(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Double quantidadeTotal) {
        Double valorTotalProduto = quantidadeTotal * fornecedorItemCotacaoCompra.getValorUnitario();
        if (this.isAffimative(fornecedorItemCotacaoCompra.getHabilitarPercentualDesconto()) && fornecedorItemCotacaoCompra.getPercentualDesconto() != null) {
            fornecedorItemCotacaoCompra.setValorDesconto(Double.valueOf(fornecedorItemCotacaoCompra.getPercentualDesconto() / 100.0 * valorTotalProduto));
        } else if (valorTotalProduto > 0.0 && fornecedorItemCotacaoCompra.getValorDesconto() != null) {
            fornecedorItemCotacaoCompra.setPercentualDesconto(Double.valueOf(fornecedorItemCotacaoCompra.getValorDesconto() * 100.0 / valorTotalProduto));
        }
    }

    private void calculaDespesasAcessorias(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Double quantidadeTotal) {
        Double valorTotalProduto = quantidadeTotal * fornecedorItemCotacaoCompra.getValorUnitario();
        if (this.isAffimative(fornecedorItemCotacaoCompra.getHabilitarPercentualDespesasAcessorias()) && fornecedorItemCotacaoCompra.getPercentualDespesasAcessorias() != null) {
            fornecedorItemCotacaoCompra.setValorDespesasAcessorias(Double.valueOf(fornecedorItemCotacaoCompra.getPercentualDespesasAcessorias() / 100.0 * valorTotalProduto));
        } else if (valorTotalProduto > 0.0 && fornecedorItemCotacaoCompra.getValorDespesasAcessorias() != null) {
            fornecedorItemCotacaoCompra.setPercentualDespesasAcessorias(Double.valueOf(fornecedorItemCotacaoCompra.getValorDespesasAcessorias() * 100.0 / valorTotalProduto));
        }
    }

    private void calculaFrete(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Double quantidadeTotal) {
        Double valorTotalProduto = quantidadeTotal * fornecedorItemCotacaoCompra.getValorUnitario();
        if (this.isAffimative(fornecedorItemCotacaoCompra.getHabilitarPercentualFrete()) && fornecedorItemCotacaoCompra.getPercentualFrete() != null) {
            fornecedorItemCotacaoCompra.setValorFrete(Double.valueOf(fornecedorItemCotacaoCompra.getPercentualFrete() / 100.0 * valorTotalProduto));
        } else if (valorTotalProduto > 0.0 && fornecedorItemCotacaoCompra.getValorFrete() != null) {
            fornecedorItemCotacaoCompra.setPercentualFrete(Double.valueOf(fornecedorItemCotacaoCompra.getValorFrete() * 100.0 / valorTotalProduto));
        }
    }

    private void calculaSeguro(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Double quantidadeTotal) {
        Double valorTotalProduto = quantidadeTotal * fornecedorItemCotacaoCompra.getValorUnitario();
        if (this.isAffimative(fornecedorItemCotacaoCompra.getHabilitarPercentualSeguro()) && fornecedorItemCotacaoCompra.getPercentualSeguro() != null) {
            fornecedorItemCotacaoCompra.setValorSeguro(Double.valueOf(fornecedorItemCotacaoCompra.getPercentualSeguro() / 100.0 * valorTotalProduto));
        } else if (valorTotalProduto > 0.0 && fornecedorItemCotacaoCompra.getValorSeguro() != null) {
            fornecedorItemCotacaoCompra.setPercentualSeguro(Double.valueOf(fornecedorItemCotacaoCompra.getValorSeguro() * 100.0 / valorTotalProduto));
        }
    }

    public Double getValorIrrf(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Produto produto) {
        Double baseCalculoGeral = this.getBaseCalculoGeral(fornecedorItemCotacaoCompra);
        if (produto.getAliquotaIrrf() == null || baseCalculoGeral == null) {
            return 0.0;
        }
        return produto.getAliquotaIrrf() / 100.0 * baseCalculoGeral;
    }

    public Double getValorInss(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Produto produto) {
        Double baseCalculoGeral = this.getBaseCalculoGeral(fornecedorItemCotacaoCompra);
        if (produto.getAliquotaInss() == null || baseCalculoGeral == null) {
            return 0.0;
        }
        return produto.getAliquotaInss() / 100.0 * baseCalculoGeral;
    }

    public Double getValorIss(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Produto produto) {
        Double baseCalculoGeral = this.getBaseCalculoGeral(fornecedorItemCotacaoCompra);
        if (produto.getAliquotaIss() == null || baseCalculoGeral == null) {
            return 0.0;
        }
        return produto.getAliquotaIss() / 100.0 * baseCalculoGeral;
    }

    public Double getValorTotalItem(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, FornecedorItemCotacaoCompraLivroFiscal fornecedorItemCotacaoCompraLivroFiscal, Double quantidadeTotal) {
        Double total = 0.0;
        if (fornecedorItemCotacaoCompra.getValorUnitario() == null || quantidadeTotal == null) {
            return 0.0;
        }
        total = fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal;
        if (fornecedorItemCotacaoCompra.getValorFrete() != null) {
            total = total + fornecedorItemCotacaoCompra.getValorFrete();
        }
        if (fornecedorItemCotacaoCompra.getValorDesconto() != null) {
            total = total - fornecedorItemCotacaoCompra.getValorDesconto();
        }
        if (fornecedorItemCotacaoCompra.getValorSeguro() != null) {
            total = total + fornecedorItemCotacaoCompra.getValorSeguro();
        }
        if (fornecedorItemCotacaoCompra.getValorDespesasAcessorias() != null) {
            total = total + fornecedorItemCotacaoCompra.getValorDespesasAcessorias();
        }
        if (fornecedorItemCotacaoCompraLivroFiscal.getValorIpiIndustria() != null) {
            total = total + fornecedorItemCotacaoCompraLivroFiscal.getValorIpiIndustria();
        }
        if (fornecedorItemCotacaoCompraLivroFiscal.getValorIpiObservacao() != null) {
            total = total + fornecedorItemCotacaoCompraLivroFiscal.getValorIpiObservacao();
        }
        if (fornecedorItemCotacaoCompraLivroFiscal.getValorIcmsSt() != null) {
            total = total + fornecedorItemCotacaoCompraLivroFiscal.getValorIcmsSt();
        }
        if (fornecedorItemCotacaoCompraLivroFiscal.getValorFunrural() != null) {
            total = total + fornecedorItemCotacaoCompraLivroFiscal.getValorFunrural();
        }
        if (fornecedorItemCotacaoCompraLivroFiscal.getValorLei10833() != null) {
            total = total + fornecedorItemCotacaoCompraLivroFiscal.getValorLei10833();
        }
        if (fornecedorItemCotacaoCompraLivroFiscal.getValorIrrf() != null) {
            total = total + fornecedorItemCotacaoCompraLivroFiscal.getValorIrrf();
        }
        if (fornecedorItemCotacaoCompraLivroFiscal.getValorOutros() != null) {
            total = total + fornecedorItemCotacaoCompraLivroFiscal.getValorOutros();
        }
        return total;
    }

    public Double getValorCusto(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, FornecedorItemCotacaoCompraLivroFiscal fornecedorItemCotacaoCompraLivroFiscal, Double quantidadeTotal) {
        Double total = 0.0;
        if (fornecedorItemCotacaoCompra.getValorUnitario() == null || quantidadeTotal == null) {
            return 0.0;
        }
        total = fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal;
        if (fornecedorItemCotacaoCompra.getValorFrete() != null) {
            total = total - fornecedorItemCotacaoCompra.getValorDesconto();
        }
        if (fornecedorItemCotacaoCompra.getValorFrete() != null) {
            total = total + fornecedorItemCotacaoCompra.getValorFrete();
        }
        if (fornecedorItemCotacaoCompra.getValorSeguro() != null) {
            total = total + fornecedorItemCotacaoCompra.getValorSeguro();
        }
        if (fornecedorItemCotacaoCompra.getValorDespesasAcessorias() != null) {
            total = total + fornecedorItemCotacaoCompra.getValorDespesasAcessorias();
        }
        if (fornecedorItemCotacaoCompraLivroFiscal.getValorIcmsSt() != null) {
            total = total + fornecedorItemCotacaoCompraLivroFiscal.getValorIcmsSt();
        }
        if (fornecedorItemCotacaoCompraLivroFiscal.getValorDiferencaAliquota() != null) {
            total = total + fornecedorItemCotacaoCompraLivroFiscal.getValorDiferencaAliquota();
        }
        if (fornecedorItemCotacaoCompraLivroFiscal.getValorCofins() != null) {
            total = total - fornecedorItemCotacaoCompraLivroFiscal.getValorCofins();
        }
        if (fornecedorItemCotacaoCompraLivroFiscal.getValorPis() != null) {
            total = total - fornecedorItemCotacaoCompraLivroFiscal.getValorPis();
        }
        if (fornecedorItemCotacaoCompraLivroFiscal.getValorIpiObservacao() != null) {
            total = total + fornecedorItemCotacaoCompraLivroFiscal.getValorIpiObservacao();
        }
        if (fornecedorItemCotacaoCompraLivroFiscal.getValorIpiComercio() != null) {
            total = total - fornecedorItemCotacaoCompraLivroFiscal.getValorIpiComercio();
        }
        return total;
    }

    public Double getValorCusto(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Double quantidade, Double fatorConversao) {
        Double aux;
        if (quantidade != null && fatorConversao != null && (aux = Double.valueOf(quantidade * fatorConversao)) > 0.0 && fornecedorItemCotacaoCompra.getValorCusto() != null) {
            return fornecedorItemCotacaoCompra.getValorCusto() / (quantidade * fatorConversao);
        }
        return 0.0;
    }

    public Double getValorIcmsSt(FornecedorItemCotacaoCompraLivroFiscal itemFornCotacaoLivroFiscal) {
        return itemFornCotacaoLivroFiscal.getValorBaseCalculoIcms() * (itemFornCotacaoLivroFiscal.getAliquotaIcmsST() / 100.0) - itemFornCotacaoLivroFiscal.getValorIcms();
    }

    public Double getValorBaseCalculoIcmsS(FornecedorItemCotacaoCompraLivroFiscal itemFornCotacaoLivroFiscal) {
        return itemFornCotacaoLivroFiscal.getValorBaseCalculoIcms() * itemFornCotacaoLivroFiscal.getIndicadorAlteracaoIcmsST() - itemFornCotacaoLivroFiscal.getValorBaseCalculoIcms() * (itemFornCotacaoLivroFiscal.getDescontoPadraoIcmsST() / 100.0);
    }

    private Double getBaseCalculoGeral(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra) {
        Double total = 0.0;
        if (fornecedorItemCotacaoCompra.getValorDesconto() != null) {
            total = total + fornecedorItemCotacaoCompra.getValorDesconto() * -1.0;
        }
        if (fornecedorItemCotacaoCompra.getValorDespesasAcessorias() != null) {
            total = total + fornecedorItemCotacaoCompra.getValorDespesasAcessorias();
        }
        if (fornecedorItemCotacaoCompra.getValorFrete() != null) {
            total = total + fornecedorItemCotacaoCompra.getValorFrete();
        }
        if (fornecedorItemCotacaoCompra.getValorSeguro() != null) {
            total = total + fornecedorItemCotacaoCompra.getValorSeguro();
        }
        return total;
    }
}

