/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.cotacaomoedabancocentral;

import com.touchcomp.basementor.model.vo.CotacaoMoeda;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementorclientwebservices.components.DocCotacaoMoedaBancoCentral;
import com.touchcomp.basementorexceptions.exceptions.impl.moeda.ExceptionCotacaoMoeda;
import com.touchcomp.basementorservice.service.impl.cotacaomoeda.ServiceCotacaoMoedaImpl;
import com.touchcomp.basementorservice.service.impl.moeda.ServiceMoedaImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class CompCotacaoMoedaBancoCentral {
    public CotacaoMoeda consultarCotacao(Moeda moeda) throws ExceptionCotacaoMoeda {
        DocCotacaoMoedaBancoCentral docCotacao = (DocCotacaoMoedaBancoCentral)ConfApplicationContext.getBean(DocCotacaoMoedaBancoCentral.class);
        ServiceCotacaoMoedaImpl serviceCotacao = (ServiceCotacaoMoedaImpl)ConfApplicationContext.getBean(ServiceCotacaoMoedaImpl.class);
        CotacaoMoeda cotBC = docCotacao.getUltCotacao(moeda.getCodModedaBC());
        if (cotBC != null) {
            CotacaoMoeda cot = serviceCotacao.get(moeda, cotBC.getDataCotacao());
            if (cot == null) {
                cot = new CotacaoMoeda();
                cot.setDataCadastro(new Date());
                cot.setDataCotacao(cotBC.getDataCotacao());
                cot.setMoeda(moeda);
            }
            cot.setValor(cotBC.getValor());
            serviceCotacao.saveOrUpdate(cot);
            return cot;
        }
        return null;
    }

    public CotacaoMoeda consultarValorCotacao(Moeda moeda, Date data) throws ExceptionCotacaoMoeda {
        DocCotacaoMoedaBancoCentral docCotacao = (DocCotacaoMoedaBancoCentral)ConfApplicationContext.getBean(DocCotacaoMoedaBancoCentral.class);
        ServiceCotacaoMoedaImpl serviceCotacao = (ServiceCotacaoMoedaImpl)ConfApplicationContext.getBean(ServiceCotacaoMoedaImpl.class);
        Double valor = docCotacao.getValor(moeda.getCodModedaBC(), ToolDate.dateToStr((Date)data));
        if (valor != null && valor > 0.0) {
            CotacaoMoeda cot = new CotacaoMoeda();
            cot.setDataCadastro(new Date());
            cot.setDataCotacao(data);
            cot.setMoeda(moeda);
            cot.setValor(valor);
            serviceCotacao.saveOrUpdate(cot);
            return cot;
        }
        return null;
    }

    public CotacaoMoeda consultarCotacao(Long idMoeda) throws ExceptionCotacaoMoeda {
        ServiceMoedaImpl serviceMoeda = (ServiceMoedaImpl)ConfApplicationContext.getBean(ServiceMoedaImpl.class);
        return this.consultarCotacao((Moeda)serviceMoeda.get(idMoeda));
    }
}

