/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.cte400.cancelarcte;

import com.fincatto.documentofiscal.cte.CTeConfig;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.cte.EnumConstCTeStatus;
import com.touchcomp.basementor.constants.enums.situacaodocumento.EnumConstSituacaoDocumento;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.EvtCTeCancelamento;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoTransp;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfClienteWebservice;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfigCTe;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.cte.cte400.cancelarcte400.impl.UtilCancelarCte;
import com.touchcomp.basementorclientwebservices.cte.cte400.cancelarcte400.model.CancelarCte;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.cte.ServiceCteImpl;
import com.touchcomp.basementorservice.service.impl.evtctecancelamento.ServiceEvtCTeCancelamentoImpl;
import com.touchcomp.basementorservice.service.impl.situacaodocumento.ServiceSituacaoDocumentoImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceLoteContabil;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorxml.model.XMLEventoCTe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLEventoCTe;
import java.util.ArrayList;

public class CancelarCte400 {
    public CancelarCte cancelarCte(OpcoesFaturamentoTransp opcoesFaturamentoTransp, EvtCTeCancelamento cancelamentoCTe) throws Exception {
        CancelarCte c = new UtilCancelarCte().cancelarCte400((CTeConfig)this.getCertificado(opcoesFaturamentoTransp), cancelamentoCTe, opcoesFaturamentoTransp);
        c.setMensagemProcessada(this.criarMensagemProcessada(c));
        if (ToolMethods.isEquals((Object)c.getCodigoStatus(), (Object)EnumConstCTeStatus.CANCELADO.getValue()) || ToolMethods.isEquals((Object)c.getCodigoStatus(), (Object)EnumConstCTeStatus.EVENTO_REGISTRADO_VINC_CTE.getValue())) {
            this.salvarXml(c, cancelamentoCTe);
            cancelamentoCTe.getCte().setEvtCTeCancelamento(cancelamentoCTe);
            if (ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getUsuarioAverbacao()) && ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getSenhaAverbacao()) && ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getCodAtmAverbacao())) {
                cancelamentoCTe.setCte(((ServiceCteImpl)ConfApplicationContext.getBean(ServiceCteImpl.class)).enviarAverbacaoCancelado(cancelamentoCTe.getCte(), opcoesFaturamentoTransp));
            }
            c.setEvtCTeCancelamento(this.atualizarEvento(c, cancelamentoCTe));
        } else {
            c.setEvtCTeCancelamento(cancelamentoCTe);
        }
        return c;
    }

    private CertificadoConfigCTe getCertificado(OpcoesFaturamentoTransp opcoesFaturamentoTransp) throws ExceptionCertificado {
        ConfiguracaoCertificado certificado = ((ServiceConfiguracaoCertificadoImpl)ConfApplicationContext.getBean(ServiceConfiguracaoCertificadoImpl.class)).getByEmpresa(opcoesFaturamentoTransp.getEmpresa());
        new CertificadoConfClienteWebservice().checaCertificado(certificado);
        ParamsCertificado params = ((HelperConfiguracaoCertificado)ConfApplicationContext.getBean(HelperConfiguracaoCertificado.class)).build(certificado).getParamsCertificado(ConstAmbiente.valueOfCodigo((String)opcoesFaturamentoTransp.getTipoAmbiente().toString()));
        new CertificadoConfClienteWebservice().configuraSocketFactoryDinamico(params.getKeystoreCertificado(), params.getSenhaCertificado());
        return new CertificadoConfigCTe(params, opcoesFaturamentoTransp.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
    }

    private String criarMensagemProcessada(CancelarCte c) {
        Object ret = "Resultado do Processamento:\n";
        ret = ToolMethods.isEquals((Object)c.getCodigoStatus(), (Object)EnumConstCTeStatus.CANCELADO.getValue()) || ToolMethods.isEquals((Object)c.getCodigoStatus(), (Object)EnumConstCTeStatus.EVENTO_REGISTRADO_VINC_CTE.getValue()) ? (String)ret + "Status: " + EnumConstCTeStatus.CANCELADO.getValueShort() + "\nChave CTe: " + c.getChave() + "\nProtocolo: " + c.getNumeroProtocolo() + "\nTipo de Ambiente (1 - Producao, 2 - Homologacao): " + c.getAmbiente().getCodigo() + "\nMotivo: " + EnumConstCTeStatus.CANCELADO.getDescricao() : (String)ret + "Status: " + c.getCodigoStatus() + "\nChave CTe: " + c.getChave() + "\nProtocolo: " + c.getNumeroProtocolo() + "\nTipo de Ambiente (1 - Producao, 2 - Homologacao): " + c.getAmbiente().getCodigo() + "\nMotivo: " + c.getMotivo();
        return ret;
    }

    private void salvarXml(CancelarCte c, EvtCTeCancelamento cancelamentoCTe) {
        XMLEventoCTe x = ((ServiceXMLEventoCTe)ConfApplicationContext.getBean(ServiceXMLEventoCTe.class)).getOrCreateXMLEventoCTe(cancelamentoCTe.getIdentificador());
        x.setIdEvento(cancelamentoCTe.getIdentificador());
        x.setConteudoEnviado(c.getXmlEnvio());
        x.setConteudoRecebido(c.getXmlRecebido());
        ((ServiceXMLEventoCTe)ConfApplicationContext.getBean(ServiceXMLEventoCTe.class)).saveOrUpdate((Object)x);
    }

    private EvtCTeCancelamento atualizarEvento(CancelarCte c, EvtCTeCancelamento cancelamentoCTe) {
        cancelamentoCTe.setMotivo(c.getMotivo());
        cancelamentoCTe.setStatus(Short.valueOf(String.valueOf(c.getCodigoStatus())));
        cancelamentoCTe.setNrProtocolo(c.getNumeroProtocolo());
        cancelamentoCTe.getCte().getCteInfo().setMotivo(EnumConstCTeStatus.CANCELADO.getDescricao());
        cancelamentoCTe.getCte().getCteInfo().setStatus(EnumConstCTeStatus.CANCELADO.getValueShort());
        cancelamentoCTe.getCte().getCteInfo().setNumProtocoloCancelamento(c.getNumeroProtocolo());
        LoteContabil loteContabil = cancelamentoCTe.getCte().getLoteContabilFat();
        cancelamentoCTe.setCte(this.atualizarCancelamentoCte(cancelamentoCTe.getCte()));
        cancelamentoCTe = ((ServiceEvtCTeCancelamentoImpl)ConfApplicationContext.getBean(ServiceEvtCTeCancelamentoImpl.class)).saveOrUpdate(cancelamentoCTe);
        ((ServiceLoteContabil)ConfApplicationContext.getBean(ServiceLoteContabil.class)).delete(loteContabil);
        return cancelamentoCTe;
    }

    public Cte atualizarCancelamentoCte(Cte cte) {
        for (LivroFiscal l : cte.getLivrosFiscais()) {
            l.setCancelado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        }
        if (ToolMethods.isNotNull((Object)cte.getProgramacaoViagens()).booleanValue()) {
            cte.getProgramacaoViagens().setQuantidade(Double.valueOf(0.0));
            cte.setProgramacaoViagens(null);
        }
        cte.setSituacaoDocumento(((ServiceSituacaoDocumentoImpl)ConfApplicationContext.getBean(ServiceSituacaoDocumentoImpl.class)).get(EnumConstSituacaoDocumento.CANCELADO));
        cte.setLoteContabilFat(null);
        cte.setTitulos(new ArrayList());
        return cte;
    }
}

