/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.cte400.cartacorrecaocte;

import com.fincatto.documentofiscal.cte.CTeConfig;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.EvtCTeCartaCorrecao;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoTransp;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfClienteWebservice;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfigCTe;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.cte.cte400.cartacorrecaocte400.impl.UtilCartaCorrecaoCte;
import com.touchcomp.basementorclientwebservices.cte.cte400.cartacorrecaocte400.model.CartaCorrecaoCte;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.evtctecartacorrecao.ServiceEvtCTeCartaCorrecaoImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorxml.model.XMLEventoCTe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLEventoCTe;

public class CartaCorrecaoCte400 {
    public CartaCorrecaoCte cartaCorrecaoCTe(OpcoesFaturamentoTransp opcoesFaturamentoTransp, EvtCTeCartaCorrecao cartaCorrecaoCTe) throws Exception {
        CartaCorrecaoCte c = new UtilCartaCorrecaoCte().cartaCorrecaoCte400((CTeConfig)this.getCertificado(opcoesFaturamentoTransp), cartaCorrecaoCTe, opcoesFaturamentoTransp);
        c.setMensagemProcessada(this.criarMensagemProcessada(c));
        this.salvarXml(c, cartaCorrecaoCTe);
        c.setEvtCTeCartaCorrecao(this.atualizarEvento(c, cartaCorrecaoCTe));
        return c;
    }

    private CertificadoConfigCTe getCertificado(OpcoesFaturamentoTransp opcoesFaturamentoTransp) throws ExceptionCertificado {
        ConfiguracaoCertificado certificado = ((ServiceConfiguracaoCertificadoImpl)ConfApplicationContext.getBean(ServiceConfiguracaoCertificadoImpl.class)).getByEmpresa(opcoesFaturamentoTransp.getEmpresa());
        new CertificadoConfClienteWebservice().checaCertificado(certificado);
        ParamsCertificado params = ((HelperConfiguracaoCertificado)ConfApplicationContext.getBean(HelperConfiguracaoCertificado.class)).build(certificado).getParamsCertificado(ConstAmbiente.valueOfCodigo((String)opcoesFaturamentoTransp.getTipoAmbiente().toString()));
        return new CertificadoConfigCTe(params, opcoesFaturamentoTransp.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
    }

    private String criarMensagemProcessada(CartaCorrecaoCte c) {
        String ret = "Resultado do Processamento:\nStatus: " + c.getCodigoStatus() + "\nChave CTe: " + c.getChave() + "\nProtocolo: " + c.getNumeroProtocolo() + "\nTipo de Ambiente (1 - Producao, 2 - Homologacao): " + c.getAmbiente().getCodigo() + "\nMotivo: " + c.getMotivo();
        return ret;
    }

    private void salvarXml(CartaCorrecaoCte c, EvtCTeCartaCorrecao cartaCorrecaoCTeCTe) {
        XMLEventoCTe x = ((ServiceXMLEventoCTe)ConfApplicationContext.getBean(ServiceXMLEventoCTe.class)).getOrCreateXMLEventoCTe(cartaCorrecaoCTeCTe.getIdentificador());
        x.setIdEvento(cartaCorrecaoCTeCTe.getIdentificador());
        x.setConteudoEnviado(c.getXmlEnvio());
        x.setConteudoRecebido(c.getXmlRecebido());
        ((ServiceXMLEventoCTe)ConfApplicationContext.getBean(ServiceXMLEventoCTe.class)).saveOrUpdate((Object)x);
    }

    private EvtCTeCartaCorrecao atualizarEvento(CartaCorrecaoCte c, EvtCTeCartaCorrecao cartaCorrecaoCTe) {
        cartaCorrecaoCTe.setMotivo(c.getMotivo());
        cartaCorrecaoCTe.setStatus(Short.valueOf(String.valueOf(c.getCodigoStatus())));
        cartaCorrecaoCTe.setNrProtocolo(c.getNumeroProtocolo());
        cartaCorrecaoCTe.getCte().getCteInfo().setNumProtocoloCartaCorrecao(c.getNumeroProtocolo());
        return ((ServiceEvtCTeCartaCorrecaoImpl)ConfApplicationContext.getBean(ServiceEvtCTeCartaCorrecaoImpl.class)).saveOrUpdate(cartaCorrecaoCTe);
    }
}

