/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.cte400.consultacte;

import com.fincatto.documentofiscal.cte.CTeConfig;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.cte.EnumConstCTeStatus;
import com.touchcomp.basementor.constants.enums.cte.sefaz.EnumConstCTeTipoEvento;
import com.touchcomp.basementor.constants.enums.situacaodocumento.EnumConstSituacaoDocumento;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.EvtCTeCartaCorrecao;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoTransp;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfClienteWebservice;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfigCTe;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.cte.cte400.consultacte400.impl.UtilConsultaCte;
import com.touchcomp.basementorclientwebservices.cte.cte400.consultacte400.model.ConsultaCte;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.cte400.cancelarcte.CancelarCte400;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.cte.ServiceCteImpl;
import com.touchcomp.basementorservice.service.impl.situacaodocumento.ServiceSituacaoDocumentoImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceLoteContabil;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorxml.model.XMLCTe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLCTe;
import java.util.ArrayList;

public class ConsultaCte400 {
    public ConsultaCte consultarStatusCte(OpcoesFaturamentoTransp opcoesFaturamentoTransp, Cte cte) throws Exception {
        ConsultaCte c = new UtilConsultaCte().consultarCte400((CTeConfig)this.getCertificado(opcoesFaturamentoTransp), cte.getChaveCte());
        c.setMensagemProcessada(this.criarMensagemProcessada(c, cte));
        this.salvarXml(c, cte);
        if (ToolMethods.isNotNull((Object)c.getProtocolo()).booleanValue() && ToolMethods.isEquals((Object)Short.valueOf(c.getProtocolo().getInfo().getStatus()), (Object)EnumConstCTeStatus.AUTORIZADO.getValueShort())) {
            try {
                if (ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getUsuarioAverbacao()) && ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getSenhaAverbacao()) && ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getCodAtmAverbacao())) {
                    ((ServiceCteImpl)ConfApplicationContext.getBean(ServiceCteImpl.class)).enviarAverbacaoAprovadoSemSalvar(cte, opcoesFaturamentoTransp);
                }
            }
            catch (Exception ex) {
                TLogger.get(ex.getClass()).error((Throwable)ex);
            }
        }
        c.setCte(this.atualizarCte(c, cte));
        return c;
    }

    private CertificadoConfigCTe getCertificado(OpcoesFaturamentoTransp opcoesFaturamentoTransp) throws ExceptionCertificado {
        ConfiguracaoCertificado certificado = ((ServiceConfiguracaoCertificadoImpl)ConfApplicationContext.getBean(ServiceConfiguracaoCertificadoImpl.class)).getByEmpresa(opcoesFaturamentoTransp.getEmpresa());
        new CertificadoConfClienteWebservice().checaCertificado(certificado);
        ParamsCertificado params = ((HelperConfiguracaoCertificado)ConfApplicationContext.getBean(HelperConfiguracaoCertificado.class)).build(certificado).getParamsCertificado(ConstAmbiente.valueOfCodigo((String)opcoesFaturamentoTransp.getTipoAmbiente().toString()));
        new CertificadoConfClienteWebservice().configuraSocketFactoryDinamico(params.getKeystoreCertificado(), params.getSenhaCertificado());
        return new CertificadoConfigCTe(params, opcoesFaturamentoTransp.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
    }

    private String criarMensagemProcessada(ConsultaCte c, Cte cte) {
        String ret = "Resultado da Consulta do CTe " + cte.getNumero() + ":\nStatus: " + c.getStatus() + "\nUF: " + c.getUf().getDescricao() + "\n";
        ret = ToolMethods.isEquals((Object)c.getStatus(), (Object)EnumConstCTeStatus.CANCELADO.getValue().toString()) ? ret + "Motivo: Cancelamento de CT-e homologado" : ret + "Motivo: " + c.getMotivo();
        return ret;
    }

    private Cte atualizarCte(ConsultaCte c, Cte cte) {
        LoteContabil loteContabil = null;
        if (ToolMethods.isNotNull((Object)c.getProtocolo()).booleanValue()) {
            cte.getCteInfo().setStatus(Short.valueOf(c.getProtocolo().getInfo().getStatus()));
            cte.getCteInfo().setNumProtocolo(c.getProtocolo().getInfo().getNumeroProtocolo());
            cte.getCteInfo().setMotivo(c.getProtocolo().getInfo().getMotivo());
            cte.setSituacaoDocumento(((ServiceSituacaoDocumentoImpl)ConfApplicationContext.getBean(ServiceSituacaoDocumentoImpl.class)).get(EnumConstSituacaoDocumento.REGULAR));
            for (LivroFiscal l : cte.getLivrosFiscais()) {
                l.setCancelado(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            }
            if (ToolMethods.isNotNull((Object)c.getProtocoloEvento()).booleanValue()) {
                for (ConsultaCte.CTeProtocoloEvento cTeProtocoloEvento : c.getProtocoloEvento()) {
                    if (ToolMethods.isEquals((Object)Long.valueOf(cTeProtocoloEvento.getEventoRetorno().getInfoEventoRetorno().getTipoEvento()), (Object)EnumConstCTeTipoEvento.CANCELAMENTO.getValue())) {
                        cte.getCteInfo().setStatus(EnumConstCTeStatus.CANCELADO.getValueShort());
                        cte.getCteInfo().setNumProtocoloCancelamento(cTeProtocoloEvento.getEventoRetorno().getInfoEventoRetorno().getNumeroProtocolo());
                        cte.getCteInfo().setMotivo(EnumConstCTeStatus.CANCELADO.getDescricao());
                        cte.getEvtCTeCancelamento().setMotivo(cTeProtocoloEvento.getEventoRetorno().getInfoEventoRetorno().getMotivo());
                        cte.getEvtCTeCancelamento().setStatus(EnumConstCTeStatus.CANCELADO.getValueShort());
                        cte.getEvtCTeCancelamento().setNrProtocolo(cTeProtocoloEvento.getEventoRetorno().getInfoEventoRetorno().getNumeroProtocolo());
                        loteContabil = cte.getLoteContabilFat();
                        cte = new CancelarCte400().atualizarCancelamentoCte(cte);
                        continue;
                    }
                    if (!ToolMethods.isEquals((Object)Long.valueOf(cTeProtocoloEvento.getEventoRetorno().getInfoEventoRetorno().getTipoEvento()), (Object)EnumConstCTeTipoEvento.CARTA_CORRECAO.getValue())) continue;
                    cte.getCteInfo().setNumProtocoloCartaCorrecao(cTeProtocoloEvento.getEventoRetorno().getInfoEventoRetorno().getNumeroProtocolo());
                    for (EvtCTeCartaCorrecao evtCTeCartaCorrecao : cte.getEvtCTeCartaCorrecao()) {
                        if (!ToolMethods.isEquals((Object)evtCTeCartaCorrecao.getNumSeqEvento(), (Object)cTeProtocoloEvento.getEventoRetorno().getInfoEventoRetorno().getNumeroSequencialEvento())) continue;
                        evtCTeCartaCorrecao.setMotivo(cTeProtocoloEvento.getEventoRetorno().getInfoEventoRetorno().getMotivo());
                        evtCTeCartaCorrecao.setStatus(EnumConstCTeStatus.EVENTO_REGISTRADO_VINC_CTE.getValueShort());
                        evtCTeCartaCorrecao.setNrProtocolo(cTeProtocoloEvento.getEventoRetorno().getInfoEventoRetorno().getNumeroProtocolo());
                    }
                }
            }
        } else {
            cte.getCteInfo().setStatus(Short.valueOf(c.getStatus()));
            cte.getCteInfo().setMotivo(c.getMotivo());
        }
        if (ToolMethods.isEquals((Object)cte.getTipoCte().getCodigo(), (Object)3) && ToolMethods.isEquals((Object)Short.valueOf(c.getStatus()), (Object)EnumConstCTeStatus.AUTORIZADO.getValueShort())) {
            Cte cteSubstituicacao = cte.getCteSubstituicaoOriginal();
            cteSubstituicacao.setTitulos(new ArrayList());
            cte.setCteSubstituicaoOriginal(((ServiceCteImpl)ConfApplicationContext.getBean(ServiceCteImpl.class)).saveOrUpdate(cteSubstituicacao));
        }
        cte = ((ServiceCteImpl)ConfApplicationContext.getBean(ServiceCteImpl.class)).saveOrUpdate(cte);
        if (ToolMethods.isNotNull(loteContabil).booleanValue()) {
            ((ServiceLoteContabil)ConfApplicationContext.getBean(ServiceLoteContabil.class)).delete(loteContabil);
        }
        return cte;
    }

    private void salvarXml(ConsultaCte c, Cte cte) {
        XMLCTe x = ((ServiceXMLCTe)ConfApplicationContext.getBean(ServiceXMLCTe.class)).getXmlCTeIdCTe(cte.getIdentificador());
        x.setIdCTe(cte.getIdentificador());
        x.setConteudoAprovacao(c.getXmlRecebido());
        ((ServiceXMLCTe)ConfApplicationContext.getBean(ServiceXMLCTe.class)).saveOrUpdate((Object)x);
    }
}

