/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.cte400.distribuicaoctedoc;

import com.fincatto.documentofiscal.cte.classes.distribuicao.CTDistribuicaoDocumentoZip;
import com.fincatto.documentofiscal.cte.classes.distribuicao.CTDistribuicaoIntRetorno;
import com.fincatto.documentofiscal.cte300.classes.CTTomadorServico;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeProcessado;
import com.fincatto.documentofiscal.utils.DFPersister;
import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsDistribuicaoXMLCTes;
import com.touchcomp.basementor.constants.enums.cte.EnumConstCTeStatus;
import com.touchcomp.basementor.constants.enums.cte.EnumConstCTeVersao;
import com.touchcomp.basementor.constants.enums.cte.sefaz.EnumConstCTeTipoEvento;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.ConsultaCTeDest;
import com.touchcomp.basementor.model.vo.ConsultaCTeDestDocs;
import com.touchcomp.basementor.model.vo.ConsultaCTeDestEvt;
import com.touchcomp.basementor.model.vo.ConsultaCTeDestNSU;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorclientwebservices.cte.dto.CTDistribuicaoEvento;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.zip.ExceptionZip;
import com.touchcomp.basementorrules.cte.CompCTe;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.components.cte400.distribuicaoctedoc.CompStatusDistCTeDoc;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.consultactedest.ServiceConsultaCTeDestImpl;
import com.touchcomp.basementorservice.service.impl.consultactedest.ServiceConsultaCTeDestNSUImpl;
import com.touchcomp.basementorservice.service.impl.consultactedestdocs.ServiceConsultaCTeDestDocsImpl;
import com.touchcomp.basementorservice.service.impl.consultactedestevt.ServiceConsultaCTeDestEvtImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativa.ServiceUnidadeFederativaImpl;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.zip.ToolZipUtils;
import com.touchcomp.basementorxml.model.XMLNFeCTe;
import com.touchcomp.basementorxml.model.XMLNFeCTeEvt;
import com.touchcomp.basementorxml.service.impl.xmlnfecteevt.ServiceXMLNFeCTeEvtImpl;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFeCTe;
import java.io.File;
import java.util.Date;

public class AuxDistribuicaoDocCTe
extends BaseMethods {
    private final ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt;
    private final ServiceConsultaCTeDestDocsImpl serviceConsultaCTeDestDocImpl;
    private final ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceirosImpl;
    private final ServiceConsultaCTeDestImpl serviceConsultaCTeDestImpl;
    private final ServiceXMLNFeCTe serviceXmlNFeCte;
    private final ServiceConsultaCTeDestEvtImpl serviceConsultaCTeDestEvtImpl;
    private final ServiceUnidadeFederativaImpl serviceUnidadeFederativaImpl;
    private final CompStatusDistCTeDoc compStatusConsCTeDoc;
    private final ServiceConsultaCTeDestNSUImpl serviceConsultaCTeDestNSUImpl;
    private final HelperConfigServicos helperConfigServicos;
    private final String PROC_EVENTO_CTE_STR = "procEventoCTe";
    private final String CTE_2_0 = "procCTe_v2.00.xsd";
    private final String CTE_3_0 = "procCTe_v3.00.xsd";
    private final ConfigServicos configServicos;
    Short considerarEmpRem = 0;
    Short considerarEmpDest = 0;
    Short considerarEmpExp = 0;
    Short considerarEmpRec = 0;
    Short considerarEmpToma = 1;

    public AuxDistribuicaoDocCTe(ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt, ServiceConsultaCTeDestDocsImpl serviceConsultaCTeDestDocImpl, ServiceConsultaCTeDestImpl serviceConsultaCTeDestImpl, ServiceXMLNFeCTe serviceXmlNFeCte, ServiceConsultaCTeDestEvtImpl serviceConsultaCTeDestEvtImpl, ServiceUnidadeFederativaImpl serviceUnidadeFederativaImpl, CompStatusDistCTeDoc compStatusConsCTeDoc, ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceirosImpl, ServiceConsultaCTeDestNSUImpl serviceConsultaCTeDestNSUImpl, ConfigServicos configServicos, HelperConfigServicos helperConfigServicos) {
        this.serviceXmlNFeCteEvt = serviceXmlNFeCteEvt;
        this.serviceConsultaCTeDestDocImpl = serviceConsultaCTeDestDocImpl;
        this.serviceConsultaCTeDestImpl = serviceConsultaCTeDestImpl;
        this.serviceXmlNFeCte = serviceXmlNFeCte;
        this.serviceConsultaCTeDestEvtImpl = serviceConsultaCTeDestEvtImpl;
        this.serviceUnidadeFederativaImpl = serviceUnidadeFederativaImpl;
        this.compStatusConsCTeDoc = compStatusConsCTeDoc;
        this.serviceNotaFiscalTerceirosImpl = serviceNotaFiscalTerceirosImpl;
        this.serviceConsultaCTeDestNSUImpl = serviceConsultaCTeDestNSUImpl;
        this.configServicos = configServicos;
        this.helperConfigServicos = helperConfigServicos;
        helperConfigServicos.build(configServicos);
        String considerarEmpRemStr = helperConfigServicos.getValue(ConstantsDistribuicaoXMLCTes.CONSIDERAR_EMPRESA_REMETENTE.getChave());
        String considerarEmpDestStr = helperConfigServicos.getValue(ConstantsDistribuicaoXMLCTes.CONSIDERAR_EMPRESA_REMETENTE.getChave());
        String considerarEmpExpStr = helperConfigServicos.getValue(ConstantsDistribuicaoXMLCTes.CONSIDERAR_EMPRESA_EXPEDIDOR.getChave());
        String considerarEmpRecStr = helperConfigServicos.getValue(ConstantsDistribuicaoXMLCTes.CONSIDERAR_EMPRESA_RECEBEDOR.getChave());
        String considerarEmpTomaStr = helperConfigServicos.getValue(ConstantsDistribuicaoXMLCTes.CONSIDERAR_EMPRESA_TOMADOR.getChave());
        if (TMethods.isStrWithData((String)TString.onlyNumbers((String)considerarEmpRemStr))) {
            this.considerarEmpRem = Short.valueOf(considerarEmpRemStr);
        }
        if (TMethods.isStrWithData((String)TString.onlyNumbers((String)considerarEmpRemStr))) {
            this.considerarEmpDest = Short.valueOf(considerarEmpDestStr);
        }
        if (TMethods.isStrWithData((String)TString.onlyNumbers((String)considerarEmpRemStr))) {
            this.considerarEmpExp = Short.valueOf(considerarEmpExpStr);
        }
        if (TMethods.isStrWithData((String)TString.onlyNumbers((String)considerarEmpRecStr))) {
            this.considerarEmpRec = Short.valueOf(considerarEmpRecStr);
        }
        if (TMethods.isStrWithData((String)TString.onlyNumbers((String)considerarEmpRemStr))) {
            this.considerarEmpToma = Short.valueOf(considerarEmpTomaStr);
        }
    }

    protected void efetuaProcessamentoESalva(CTDistribuicaoIntRetorno ret, Empresa empresa, TaskProcessResult result) throws ExceptionDecodeHexString64, Exception {
        if (ret.getLote() == null || ret.getLote() == null) {
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, ret.getMotivo());
            return;
        }
        ConsultaCTeDest consulta = this.getConsulta(ret, empresa);
        for (CTDistribuicaoDocumentoZip doc : ret.getLote().getDocZip()) {
            this.readAndSave(doc, result, empresa, consulta);
        }
        this.salvarConsulta(consulta);
    }

    protected void readAndSave(CTDistribuicaoDocumentoZip doc, TaskProcessResult result, Empresa emp, ConsultaCTeDest consulta) throws ExceptionZip, ExceptionDecodeHexString64, Exception {
        String xml = doc.getValue();
        String schema = doc.getSchema();
        String nsu = doc.getNsu();
        boolean proc = false;
        ConsultaCTeDestNSU nsuCte = this.serviceConsultaCTeDestNSUImpl.getOrCreate(schema, nsu, emp);
        try {
            byte[] data = ToolBase64.decodeBase64((String)xml);
            xml = ToolZipUtils.decompress((byte[])data);
            proc = this.processarXML(xml, schema, nsu, result, consulta, nsuCte);
        }
        catch (Throwable ex) {
            this.logError(ex);
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "E.ERP.1910.004", ex.getMessage());
        }
        nsuCte.setProcessado(Short.valueOf(proc ? (short)1 : 0));
        this.serviceConsultaCTeDestNSUImpl.saveOrUpdateFlush(nsuCte);
    }

    protected boolean processarXML(String xml, String schema, String nsu, TaskProcessResult result, ConsultaCTeDest consulta, ConsultaCTeDestNSU nsuCte) throws Exception {
        if (!this.isProcEventoCTe(schema)) {
            return this.processaCTe(schema, xml, nsu, nsuCte, result, consulta);
        }
        return this.processarEvento(xml, nsu, result, nsuCte, consulta);
    }

    private boolean isProcEventoCTe(String schema) {
        return schema.contains("procEventoCTe");
    }

    protected boolean processaCTe(String schema, String xml, String nsu, ConsultaCTeDestNSU nsuCte, TaskProcessResult result, ConsultaCTeDest consulta) throws Exception {
        if (schema.contains("CTeOs") && schema.contains("2.")) {
            return false;
        }
        if (schema.contains("CTe") && schema.contains("2.")) {
            return false;
        }
        if (schema.contains("CTe") && schema.contains("3.")) {
            return this.readCte3_0(xml, nsu, nsuCte, result, consulta);
        }
        if (schema.contains("CTe") && schema.contains("4.")) {
            return this.readCte4_0(xml, nsu, result, nsuCte, consulta);
        }
        result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "E.ERP.1910.005", schema);
        return false;
    }

    private ConsultaCTeDest getConsulta(CTDistribuicaoIntRetorno ret, Empresa empresa) {
        ConsultaCTeDest toSave = new ConsultaCTeDest();
        toSave.setDataCadastro(new Date());
        toSave.setDataConsulta(new Date());
        toSave.setEmpresa(empresa);
        toSave.setNumeroNSU(ret.getUltimoNSU());
        toSave.setUltNSUConsulta(ret.getMaximoNSU());
        toSave.setConsiderarNSUConsulta(Short.valueOf((short)0));
        return this.serviceConsultaCTeDestImpl.saveOrUpdateFlush(toSave);
    }

    private ConsultaCTeDest salvarConsulta(ConsultaCTeDest toSave) {
        toSave.setConsiderarNSUConsulta(Short.valueOf((short)1));
        return this.serviceConsultaCTeDestImpl.saveOrUpdateFlush(toSave);
    }

    protected boolean processarEvento(String xml, String nsu, TaskProcessResult result, ConsultaCTeDestNSU nsuCte, ConsultaCTeDest consulta) throws Exception {
        try {
            CTDistribuicaoEvento cte = this.getData(CTDistribuicaoEvento.class, xml);
            this.processarEvento(cte.getEventoCTe().getInfEvento().getChaveCTe(), Long.valueOf(cte.getEventoCTe().getInfEvento().getTpEvento()), cte.getEventoCTe().getInfEvento().getnSeqEvento(), nsu, xml, nsuCte, consulta);
        }
        catch (Throwable ex) {
            this.logError(ex);
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "E.ERP.1910.004", ex.getMessage());
            this.saveXmlErroLeitura(xml);
            return false;
        }
        return true;
    }

    private void readCte(String xml, String cnpjClienteTomador, String cnpjRemetente, String cnpjDestinatario, String cnpjExpedidor, String cnpjRecebedor, String cnpjTransportador, String chave, String cnpjTranspAgreg, String nsu, String cnpjEmitente, String ieEmitente, String nomeEmitente, Date dataEmissao, Double valor, ConsultaCTeDestNSU nsuCte, ConsultaCTeDest consulta) {
        if (!this.arquivarCTe(cnpjRemetente, cnpjDestinatario, cnpjExpedidor, cnpjRecebedor, cnpjClienteTomador, consulta.getEmpresa())) {
            return;
        }
        XMLNFeCTe x = this.serviceXmlNFeCte.getXMlNfeCTeChaveNFe(chave);
        if (x == null) {
            x = new XMLNFeCTe();
        }
        x.setChaveNFe(chave);
        x.setCnpjEmitente(cnpjTransportador);
        x.setCnpjTransportador(cnpjTransportador);
        x.setCnpjTranspAgregado(cnpjTranspAgreg);
        x.setCnpjDestinatarioCliente(cnpjClienteTomador);
        x.setFlag(Integer.valueOf(0));
        x.setConteudoXML(xml);
        x.setDataChegada(new Date());
        x = (XMLNFeCTe)this.serviceXmlNFeCte.saveOrUpdate((Object)x);
        ConsultaCTeDestDocs c = this.serviceConsultaCTeDestDocImpl.getByChave(chave);
        if (c == null) {
            c = new ConsultaCTeDestDocs();
        }
        c.setNsu(nsu);
        c.setConsultaCTeDestNSU(nsuCte);
        c.setConsultaCTeDest(consulta);
        nsuCte.setChaveCTe(chave);
        c.setNumeroDoc(CompCTe.getNumeroDoc((EnumConstCTeVersao)EnumConstCTeVersao.VERSAO_4_00, (String)chave));
        c.setSerieDoc(CompCTe.getSerie((EnumConstCTeVersao)EnumConstCTeVersao.VERSAO_4_00, (String)chave));
        c.setUfEmissaoDoc(this.serviceUnidadeFederativaImpl.getByCodIBGE(CompCTe.getCodigoUf((EnumConstCTeVersao)EnumConstCTeVersao.VERSAO_4_00, (String)chave)));
        c.setIdRegXMLTerc(x.getIdentificador());
        c.setCnpjTomador(cnpjClienteTomador);
        c.setStatusSefaz(EnumConstCTeStatus.AUTORIZADO.getValueShort());
        c.setChave(chave);
        c.setCnpjEmitente(cnpjEmitente);
        c.setDataEmissao(dataEmissao);
        c.setValor(valor);
        c.setInscricaoEstadual(ieEmitente);
        c.setNome(nomeEmitente);
        c.setNotaFiscalTerceiros(this.serviceNotaFiscalTerceirosImpl.findNotaTerceirosPorChave(chave));
        ConsultaCTeDestEvt evt = this.serviceConsultaCTeDestEvtImpl.getEvento(chave, EnumConstCTeTipoEvento.CANCELAMENTO.getValue());
        if (evt != null) {
            c.setStatusSefaz(EnumConstCTeStatus.CANCELADO.getValueShort());
        }
        this.compStatusConsCTeDoc.definirStatusConsultaDoc(c);
        this.serviceConsultaCTeDestDocImpl.saveOrUpdateFlush(c);
    }

    private boolean readCte3_0(String xml, String nsu, ConsultaCTeDestNSU nsuCte, TaskProcessResult result, ConsultaCTeDest consulta) {
        try {
            com.fincatto.documentofiscal.cte300.classes.nota.CTeProcessado cte = this.getData(com.fincatto.documentofiscal.cte300.classes.nota.CTeProcessado.class, xml);
            String chaveCTe = cte.getCte().getCteNotaInfo().getChaveAcesso();
            String cnpjAgreg = null;
            String cnpjTransp = cte.getCte().getCteNotaInfo().getEmitente().getCnpj();
            String cnpjTomaCli = this.getCnpjTomador3(cte);
            String cnpjEmitente = cnpjTransp;
            String cnpjRemetente = "";
            if (cte.getCte().getCteNotaInfo().getRemetente() != null) {
                cnpjRemetente = cte.getCte().getCteNotaInfo().getRemetente().getCnpj();
            }
            String cnpjDestinatario = "";
            if (cte.getCte().getCteNotaInfo().getDestinatario() != null) {
                cnpjDestinatario = cte.getCte().getCteNotaInfo().getDestinatario().getCnpj();
            }
            String cnpjExpedidor = "";
            if (cte.getCte().getCteNotaInfo().getExpedidorCarga() != null) {
                cnpjExpedidor = cte.getCte().getCteNotaInfo().getExpedidorCarga().getCnpj();
            }
            String cnpjRecebedor = "";
            if (cte.getCte().getCteNotaInfo().getRecebedorCarga() != null) {
                cnpjExpedidor = cte.getCte().getCteNotaInfo().getRecebedorCarga().getCnpj();
            }
            String ieEmitente = cte.getCte().getCteNotaInfo().getEmitente().getInscricaoEstadual();
            String nomeEmitente = cte.getCte().getCteNotaInfo().getEmitente().getRazaoSocial();
            Date dataEmissao = Date.from(cte.getCte().getCteNotaInfo().getIdentificacao().getDataEmissao().toInstant());
            Double valor = 0.0;
            if (cte.getCte().getCteNotaInfo().getValorPrestacaoServico() != null) {
                valor = Double.valueOf(cte.getCte().getCteNotaInfo().getValorPrestacaoServico().getValorTotalPrestacaoServico());
            }
            if (cte.getCte().getCteNotaInfo().getDadosComplementares() != null) {
                cnpjAgreg = cte.getCte().getCteNotaInfo().getDadosComplementares().getCaracteristicasTransporte();
                if (!ToolMethods.isStrWithData((String)(cnpjAgreg = ToolString.onlyNumbers((String)cnpjAgreg))) || cnpjAgreg.length() != 14) {
                    cnpjAgreg = null;
                }
            }
            this.readCte(xml, cnpjTomaCli, cnpjRemetente, cnpjDestinatario, cnpjExpedidor, cnpjRecebedor, cnpjTransp, chaveCTe, cnpjAgreg, nsu, cnpjEmitente, ieEmitente, nomeEmitente, dataEmissao, valor, nsuCte, consulta);
        }
        catch (Throwable ex) {
            this.logError(ex);
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "E.ERP.0026.004", ex.getMessage());
            this.saveXmlErroLeitura(xml);
            return false;
        }
        return true;
    }

    private boolean readCte4_0(String xml, String nsu, TaskProcessResult result, ConsultaCTeDestNSU nsuCte, ConsultaCTeDest consulta) {
        try {
            CTeProcessado cte = this.getData(CTeProcessado.class, xml);
            String chaveCTe = cte.getCte().getCteNotaInfo().getChaveAcesso();
            String cnpjAgreg = null;
            String cnpjTransp = cte.getCte().getCteNotaInfo().getEmitente().getCnpj();
            String cnpjTomaCli = this.getCnpjTomador4(cte);
            String cnpjEmitente = cnpjTransp;
            String ieEmitente = cte.getCte().getCteNotaInfo().getEmitente().getInscricaoEstadual();
            String nomeEmitente = cte.getCte().getCteNotaInfo().getEmitente().getRazaoSocial();
            Date dataEmissao = Date.from(cte.getCte().getCteNotaInfo().getIdentificacao().getDataEmissao().toInstant());
            Double valor = 0.0;
            if (cte.getCte().getCteNotaInfo().getValorPrestacaoServico() != null) {
                valor = Double.valueOf(cte.getCte().getCteNotaInfo().getValorPrestacaoServico().getValorTotalPrestacaoServico());
            }
            if (cte.getCte().getCteNotaInfo().getDadosComplementares() != null) {
                cnpjAgreg = cte.getCte().getCteNotaInfo().getDadosComplementares().getCaracteristicasTransporte();
                if (!ToolMethods.isStrWithData((String)(cnpjAgreg = ToolString.onlyNumbers((String)cnpjAgreg))) || cnpjAgreg.length() != 14) {
                    cnpjAgreg = null;
                }
            }
            String cnpjRemetente = "";
            if (cte.getCte().getCteNotaInfo().getRemetente() != null) {
                cnpjRemetente = cte.getCte().getCteNotaInfo().getRemetente().getCnpj();
            }
            String cnpjDestinatario = "";
            if (cte.getCte().getCteNotaInfo().getDestinatario() != null) {
                cnpjDestinatario = cte.getCte().getCteNotaInfo().getDestinatario().getCnpj();
            }
            String cnpjExpedidor = "";
            if (cte.getCte().getCteNotaInfo().getExpedidorCarga() != null) {
                cnpjExpedidor = cte.getCte().getCteNotaInfo().getExpedidorCarga().getCnpj();
            }
            String cnpjRecebedor = "";
            if (cte.getCte().getCteNotaInfo().getRecebedorCarga() != null) {
                cnpjRecebedor = cte.getCte().getCteNotaInfo().getRecebedorCarga().getCnpj();
            }
            this.readCte(xml, cnpjTomaCli, cnpjRemetente, cnpjDestinatario, cnpjExpedidor, cnpjRecebedor, cnpjTransp, chaveCTe, cnpjAgreg, nsu, cnpjEmitente, ieEmitente, nomeEmitente, dataEmissao, valor, nsuCte, consulta);
        }
        catch (Throwable ex) {
            this.logError(ex);
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "E.ERP.0026.004", ex.getMessage());
            this.saveXmlErroLeitura(xml);
            return false;
        }
        return true;
    }

    private void processarEvento(String chaveCte, Long tipoEventoSefaz, Integer nrSeq, String nsu, String xml, ConsultaCTeDestNSU nsuCte, ConsultaCTeDest consulta) {
        ConsultaCTeDestEvt evt = this.serviceConsultaCTeDestEvtImpl.getEvento(chaveCte, tipoEventoSefaz, nrSeq);
        if (evt == null) {
            evt = new ConsultaCTeDestEvt();
        }
        evt.setChave(chaveCte);
        evt.setNrSeqEvento(nrSeq);
        evt.setTipoEventoSefaz(tipoEventoSefaz);
        evt.setConsultaCTeDest(consulta);
        evt.setConsultaCTeDestNSU(nsuCte);
        nsuCte.setChaveCTe(chaveCte);
        evt.setNsu(nsu);
        XMLNFeCTeEvt xmlEvt = this.serviceXmlNFeCteEvt.getByNSU(nsu);
        if (xmlEvt == null) {
            xmlEvt = new XMLNFeCTeEvt();
        }
        xmlEvt.setChaveDoc(evt.getChave());
        xmlEvt.setConteudoXML(xml);
        xmlEvt.setDataChegada(new Date());
        xmlEvt.setNsu(nsu);
        this.serviceXmlNFeCteEvt.saveOrUpdate((Object)xmlEvt);
        ConsultaCTeDestDocs doc = this.serviceConsultaCTeDestDocImpl.getByChave(chaveCte);
        if (doc == null) {
            return;
        }
        if (ToolMethods.isEqualsNumber((Number)evt.getTipoEventoSefaz(), (Number)EnumConstCTeTipoEvento.CANCELAMENTO.getValue())) {
            doc.setStatusSefaz(EnumConstCTeStatus.CANCELADO.getValueShort());
        }
        evt = this.serviceConsultaCTeDestEvtImpl.saveOrUpdateFlush(evt);
        this.compStatusConsCTeDoc.definirStatusConsultaDoc(doc);
        this.serviceConsultaCTeDestDocImpl.saveOrUpdateFlush(doc);
    }

    private String getCnpjTomador3(com.fincatto.documentofiscal.cte300.classes.nota.CTeProcessado cte) {
        String codToma = "";
        CTTomadorServico toma = null;
        if (cte.getCte().getCteNotaInfo().getIdentificacao().getTomadorServico3() != null) {
            codToma = cte.getCte().getCteNotaInfo().getIdentificacao().getTomadorServico3().getTomadorServico().getCodigo();
            toma = CTTomadorServico.valueOfCodigo((String)codToma);
        } else if (cte.getCte().getCteNotaInfo().getIdentificacao().getTomadorServico4() != null) {
            codToma = cte.getCte().getCteNotaInfo().getIdentificacao().getTomadorServico4().getTomadorServico().getCodigo();
            toma = CTTomadorServico.valueOfCodigo((String)codToma);
        }
        if (toma == null) {
            return null;
        }
        switch (toma) {
            case DESTINATARIO: {
                if (cte.getCte().getCteNotaInfo().getDestinatario() != null && ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getDestinatario().getCnpj())) {
                    return cte.getCte().getCteNotaInfo().getDestinatario().getCnpj();
                }
                if (cte.getCte().getCteNotaInfo().getDestinatario() == null || !ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getDestinatario().getCpf())) break;
                return cte.getCte().getCteNotaInfo().getDestinatario().getCpf();
            }
            case EXPEDIDOR: {
                if (cte.getCte().getCteNotaInfo().getExpedidorCarga() != null && ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getExpedidorCarga().getCnpj())) {
                    return cte.getCte().getCteNotaInfo().getExpedidorCarga().getCnpj();
                }
                if (cte.getCte().getCteNotaInfo().getExpedidorCarga() == null || !ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getExpedidorCarga().getCpf())) break;
                return cte.getCte().getCteNotaInfo().getExpedidorCarga().getCpf();
            }
            case RECEBEDOR: {
                if (cte.getCte().getCteNotaInfo().getRecebedorCarga() != null && ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getRecebedorCarga().getCnpj())) {
                    return cte.getCte().getCteNotaInfo().getRecebedorCarga().getCnpj();
                }
                if (cte.getCte().getCteNotaInfo().getRecebedorCarga() == null || !ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getRecebedorCarga().getCpf())) break;
                return cte.getCte().getCteNotaInfo().getRecebedorCarga().getCpf();
            }
            case REMETENTE: {
                if (cte.getCte().getCteNotaInfo().getRemetente() != null && ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getRemetente().getCnpj())) {
                    return cte.getCte().getCteNotaInfo().getRemetente().getCnpj();
                }
                if (cte.getCte().getCteNotaInfo().getRemetente() == null || !ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getRemetente().getCpf())) break;
                return cte.getCte().getCteNotaInfo().getRemetente().getCpf();
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private String getCnpjTomador4(CTeProcessado cte) {
        String codToma = "";
        CTTomadorServico toma = null;
        if (cte.getCte().getCteNotaInfo().getIdentificacao().getTomadorServico3() != null) {
            codToma = cte.getCte().getCteNotaInfo().getIdentificacao().getTomadorServico3().getTomadorServico().getCodigo();
            toma = CTTomadorServico.valueOfCodigo((String)codToma);
        } else if (cte.getCte().getCteNotaInfo().getIdentificacao().getTomadorServico4() != null) {
            codToma = cte.getCte().getCteNotaInfo().getIdentificacao().getTomadorServico4().getTomadorServico().getCodigo();
            toma = CTTomadorServico.valueOfCodigo((String)codToma);
        }
        if (toma == null) {
            return null;
        }
        switch (toma) {
            case DESTINATARIO: {
                if (cte.getCte().getCteNotaInfo().getDestinatario() != null && ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getDestinatario().getCnpj())) {
                    return cte.getCte().getCteNotaInfo().getDestinatario().getCnpj();
                }
                if (cte.getCte().getCteNotaInfo().getDestinatario() == null || !ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getDestinatario().getCpf())) break;
                return cte.getCte().getCteNotaInfo().getDestinatario().getCpf();
            }
            case EXPEDIDOR: {
                if (cte.getCte().getCteNotaInfo().getExpedidorCarga() != null && ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getExpedidorCarga().getCnpj())) {
                    return cte.getCte().getCteNotaInfo().getExpedidorCarga().getCnpj();
                }
                if (cte.getCte().getCteNotaInfo().getExpedidorCarga() == null || !ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getExpedidorCarga().getCpf())) break;
                return cte.getCte().getCteNotaInfo().getExpedidorCarga().getCpf();
            }
            case RECEBEDOR: {
                if (cte.getCte().getCteNotaInfo().getRecebedorCarga() != null && ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getRecebedorCarga().getCnpj())) {
                    return cte.getCte().getCteNotaInfo().getRecebedorCarga().getCnpj();
                }
                if (cte.getCte().getCteNotaInfo().getRecebedorCarga() == null || !ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getRecebedorCarga().getCpf())) break;
                return cte.getCte().getCteNotaInfo().getRecebedorCarga().getCpf();
            }
            case REMETENTE: {
                if (cte.getCte().getCteNotaInfo().getRemetente() != null && ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getRemetente().getCnpj())) {
                    return cte.getCte().getCteNotaInfo().getRemetente().getCnpj();
                }
                if (cte.getCte().getCteNotaInfo().getRemetente() == null || !ToolMethods.isStrWithData((String)cte.getCte().getCteNotaInfo().getRemetente().getCpf())) break;
                return cte.getCte().getCteNotaInfo().getRemetente().getCpf();
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private void saveXmlErroLeitura(String xml) {
        try {
            File f = new File(ToolFile.getUserDir() + File.separator + "xml_dist_erro_cte" + File.separator + new Date().getTime() + ".xml");
            f.getParentFile().mkdirs();
            ToolFile.writeStringInFile((File)f, (String)xml);
        }
        catch (ExceptionIO ex) {
            this.logError(ex);
        }
    }

    private void saveXml(String xml, String nsu, String schema) {
        try {
            File f = new File(ToolFile.getUserDir() + File.separator + "xml_dist_cte" + File.separator + nsu + "_" + schema + ".xml");
            f.getParentFile().mkdirs();
            ToolFile.writeStringInFile((File)f, (String)xml);
        }
        catch (ExceptionIO ex) {
            this.logError(ex);
        }
    }

    private <E> E getData(Class<E> aClass, String xml) throws Exception {
        Object e = null;
        try {
            Object data = new DFPersister().read(aClass, xml, true);
            return (E)data;
        }
        catch (Exception ex) {
            this.saveXmlErroLeitura(xml);
            Object data = new DFPersister().read(aClass, xml, false);
            return (E)data;
        }
    }

    private boolean arquivarCTe(String cnpjRemetente, String cnpjDestinatario, String cnpjExpedidor, String cnpjRecebedor, String cnpjClienteTomador, Empresa empresa) {
        String cnpjEmpresa = empresa.getPessoa().getComplemento().getCnpj();
        if (TMethods.isAffirmative((Number)this.considerarEmpToma) && TMethods.isEquals((Object)cnpjClienteTomador, (Object)cnpjEmpresa)) {
            return true;
        }
        if (TMethods.isAffirmative((Number)this.considerarEmpRem) && TMethods.isEquals((Object)cnpjRemetente, (Object)cnpjEmpresa)) {
            return true;
        }
        if (TMethods.isAffirmative((Number)this.considerarEmpDest) && TMethods.isEquals((Object)cnpjDestinatario, (Object)cnpjEmpresa)) {
            return true;
        }
        if (TMethods.isAffirmative((Number)this.considerarEmpExp) && TMethods.isEquals((Object)cnpjExpedidor, (Object)cnpjEmpresa)) {
            return true;
        }
        return TMethods.isAffirmative((Number)this.considerarEmpRec) && TMethods.isEquals((Object)cnpjRecebedor, (Object)cnpjEmpresa);
    }
}

