/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.cte400.distribuicaoctedoc;

import com.fincatto.documentofiscal.cte.classes.distribuicao.CTDistribuicaoIntRetorno;
import com.touchcomp.basementor.constants.enums.configservicos.EnumConstConfigServicos;
import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsDistribuicaoXMLCTes;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.cte.EnumConstDistribuicaoCTeStatus;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.cte.cte400.distribuicaocte.WebDistribuicaoDocXMLCTe;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.ComponentsBase;
import com.touchcomp.basementorservice.components.cte400.distribuicaoctedoc.AuxDistribuicaoDocCTe;
import com.touchcomp.basementorservice.components.cte400.distribuicaoctedoc.CompStatusDistCTeDoc;
import com.touchcomp.basementorservice.components.distribuicaoxmlnfecte.CompDistribuicaoXMLNFeCTe;
import com.touchcomp.basementorservice.components.empresa.CompEmpresa;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.configservicos.ServiceConfigServicosImpl;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.consultactedest.ServiceConsultaCTeDestImpl;
import com.touchcomp.basementorservice.service.impl.consultactedest.ServiceConsultaCTeDestNSUImpl;
import com.touchcomp.basementorservice.service.impl.consultactedestdocs.ServiceConsultaCTeDestDocsImpl;
import com.touchcomp.basementorservice.service.impl.consultactedestevt.ServiceConsultaCTeDestEvtImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativa.ServiceUnidadeFederativaImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorxml.service.impl.xmlnfecteevt.ServiceXMLNFeCTeEvtImpl;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFeCTe;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompDistribuicaoCTeDoc
extends ComponentsBase {
    WebDistribuicaoDocXMLCTe distribuicaoCTe;
    HelperConfiguracaoCertificado helperConfiguracaoCert;
    ServiceConsultaCTeDestImpl serviceConsultaCTeDestImpl;
    HelperConfigServicos helperConfigServicos;
    ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt;
    ServiceConsultaCTeDestDocsImpl serviceConsultaCTeDestDocImpl;
    ServiceXMLNFeCTe serviceXmlNFeCte;
    ServiceConsultaCTeDestEvtImpl serviceConsultaCTeDestEvtImpl;
    ServiceUnidadeFederativaImpl serviceUnidadeFederativaImpl;
    CompStatusDistCTeDoc compStatusConsCTeDoc;
    ServiceConfiguracaoCertificadoImpl serviceConfigCertificado;
    ServiceConfigServicosImpl serviceConfigServicos;
    ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceirosImpl;
    ServiceConsultaCTeDestNSUImpl serviceConsultaCTeDestNSUImpl;
    ServiceEmpresaImpl serviceEmpresaImpl;
    CompEmpresa compEmpresa;
    CompDistribuicaoXMLNFeCTe compDistribuicaoXMLNFeCTe;

    public CompDistribuicaoCTeDoc(WebDistribuicaoDocXMLCTe distribuicaoCTe, HelperConfiguracaoCertificado helperConfiguracaoCert, ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt, ServiceConsultaCTeDestDocsImpl serviceConsultaCTeDestDocImpl, ServiceConsultaCTeDestImpl serviceConsultaCTeDestImpl, ServiceXMLNFeCTe serviceXmlNFeCte, ServiceConsultaCTeDestEvtImpl serviceConsultaCTeDestEvtImpl, ServiceUnidadeFederativaImpl serviceUnidadeFederativaImpl, CompStatusDistCTeDoc compStatusConsCTeDoc, ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceirosImpl, ServiceConsultaCTeDestNSUImpl serviceConsultaCTeDestNSUImpl, ServiceConfigServicosImpl serviceConfigServicos, ServiceConfiguracaoCertificadoImpl serviceConfigCertificado, ServiceEmpresaImpl serviceEmpresaImpl, CompEmpresa compEmpresa, CompDistribuicaoXMLNFeCTe compDistribuicaoXMLNFeCTe, HelperConfigServicos helperConfigServicos) {
        this.distribuicaoCTe = distribuicaoCTe;
        this.helperConfiguracaoCert = helperConfiguracaoCert;
        this.serviceConsultaCTeDestImpl = serviceConsultaCTeDestImpl;
        this.serviceConfigServicos = serviceConfigServicos;
        this.serviceConfigCertificado = serviceConfigCertificado;
        this.serviceXmlNFeCteEvt = serviceXmlNFeCteEvt;
        this.serviceConsultaCTeDestDocImpl = serviceConsultaCTeDestDocImpl;
        this.serviceXmlNFeCte = serviceXmlNFeCte;
        this.serviceConsultaCTeDestEvtImpl = serviceConsultaCTeDestEvtImpl;
        this.serviceUnidadeFederativaImpl = serviceUnidadeFederativaImpl;
        this.compStatusConsCTeDoc = compStatusConsCTeDoc;
        this.serviceNotaFiscalTerceirosImpl = serviceNotaFiscalTerceirosImpl;
        this.serviceConsultaCTeDestNSUImpl = serviceConsultaCTeDestNSUImpl;
        this.serviceEmpresaImpl = serviceEmpresaImpl;
        this.compEmpresa = compEmpresa;
        this.compDistribuicaoXMLNFeCTe = compDistribuicaoXMLNFeCTe;
        this.helperConfigServicos = helperConfigServicos;
    }

    public TaskProcessResult consultaCTes(Empresa empresa) throws Exception {
        TaskProcessResult result = new TaskProcessResult();
        ConfigServicos config = this.serviceConfigServicos.getContainsValueOrThrow(EnumConstConfigServicos.DITRIBUICAO_XML_CTES, ConstantsDistribuicaoXMLCTes.ID_EMPRESA.getChave(), empresa.getIdentificador().toString());
        this.consultaCTes(config, result, empresa);
        return result;
    }

    public TaskProcessResult consultaCTes(String idConfServicos, TaskProcessResult result) throws Exception {
        String[] idsConfs;
        for (String idsConf : idsConfs = ToolString.splitString((String)idConfServicos, (char[])new char[0])) {
            ConfigServicos config = (ConfigServicos)this.serviceConfigServicos.getOrThrow(idsConf);
            if (!TMethods.isEquals((Object)EnumConstConfigServicos.get((Object)config.getChave()), (Object)EnumConstConfigServicos.DITRIBUICAO_XML_CTES)) {
                result.addError("E.TSK.0026.005", EnumConstConfigServicos.DITRIBUICAO_XML_CTES.getChave(), config.getChave());
                continue;
            }
            String idEmpresas = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLCTes.ID_EMPRESA.getChave());
            List<Empresa> empresas = this.compEmpresa.getEmpresas(idEmpresas, result);
            if (empresas == null) continue;
            Empresa[] arrEmpresas = (Empresa[])empresas.toArray(Empresa[]::new);
            this.consultaCTes(config, result, arrEmpresas);
        }
        return result;
    }

    public synchronized void consultaCTes(ConfigServicos config, TaskProcessResult result, Empresa ... empresas) throws Exception {
        ConstAmbiente tpAmb = this.getTipoAmbiente(config);
        String nsuInicial = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLCTes.NSU_INICIAL.getChave());
        if (!TMethods.isStrWithData((String)nsuInicial)) {
            nsuInicial = "0";
        }
        String idCertificados = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLCTes.ID_CONFIGURACAO_CERTIFICADO.getChave());
        for (Empresa empresa : empresas) {
            Long idCertificadoEmpresa = this.compDistribuicaoXMLNFeCTe.getIdCertificado(empresa, idCertificados);
            ConfiguracaoCertificado configCert = this.getConfiguracaoCertificado(idCertificadoEmpresa);
            Long nsuIn = this.compDistribuicaoXMLNFeCTe.getNSUEmpresa(empresa, nsuInicial);
            if (nsuIn < 0L) {
                this.serviceConsultaCTeDestImpl.desconsiderarConsultasEmpresa(empresa);
            }
            this.consultaCTesInternal(empresa, tpAmb, configCert, nsuIn, result, config);
            if (nsuIn >= 0L) continue;
            nsuInicial = this.compDistribuicaoXMLNFeCTe.atualizarNSUEmpresa(empresa, nsuInicial, 0L);
            config = this.atualizarNSUProximaExec(config, nsuInicial);
        }
    }

    private ConfigServicos atualizarNSUProximaExec(ConfigServicos config, String novoNsu) {
        this.helperConfigServicos.build(config).setValue(ConstantsDistribuicaoXMLCTes.NSU_INICIAL.getChave(), novoNsu);
        return this.serviceConfigServicos.saveOrUpdateFlush(config);
    }

    private synchronized TaskProcessResult consultaCTesInternal(Empresa empresa, ConstAmbiente tipoAmbiente, ConfiguracaoCertificado configCert, Long nsuInicial, TaskProcessResult result, ConfigServicos configServicos) throws Exception {
        String maxNsu;
        String ultNsu = this.serviceConsultaCTeDestImpl.getUltimaConsulta(empresa);
        if (nsuInicial == null) {
            nsuInicial = 0L;
        }
        if (!ToolMethods.isStrWithData((String)ultNsu)) {
            ultNsu = nsuInicial.toString();
        }
        if (!ToolMethods.isStrWithData((String)ultNsu)) {
            ultNsu = "0";
        }
        if (nsuInicial < 0L) {
            ultNsu = "0";
        }
        int count = 0;
        ParamsCertificado params = this.helperConfiguracaoCert.build(configCert).getParamsCertificado(tipoAmbiente);
        do {
            CTDistribuicaoIntRetorno ret;
            if (!EnumConstDistribuicaoCTeStatus.isStatusFinal((String)(ret = this.distribuicaoCTe.carregarConfiguracoesEBuscar(params, this.getParamsEnv(ultNsu, empresa, tipoAmbiente.getCodigo(), null))).getCodigoStatusReposta())) {
                result.addDet(EnumConstantsTaskResult.RESULT_ERRO, ret.getCodigoStatusReposta() + " - " + ret.getMotivo());
                break;
            }
            if (!EnumConstDistribuicaoCTeStatus.isDocFound((String)ret.getCodigoStatusReposta())) {
                result.addDet(EnumConstantsTaskResult.RESULT_OK, ret.getCodigoStatusReposta() + " - " + ret.getMotivo());
                break;
            }
            if (EnumConstDistribuicaoCTeStatus.isServicoParado((String)ret.getCodigoStatusReposta())) {
                result.addDet(EnumConstantsTaskResult.RESULT_ADVERTENCIA, ret.getCodigoStatusReposta() + " - " + ret.getMotivo());
                break;
            }
            if (!EnumConstDistribuicaoCTeStatus.isStatusFinal((String)ret.getCodigoStatusReposta())) {
                result.addDet(EnumConstantsTaskResult.RESULT_ERRO, ret.getCodigoStatusReposta() + " - " + ret.getMotivo());
                break;
            }
            this.getAuxConsultaDoc(configServicos).efetuaProcessamentoESalva(ret, empresa, result);
            maxNsu = ret.getMaximoNSU();
            ultNsu = ret.getUltimoNSU();
            ++count;
        } while (!ToolMethods.isEquals((Object)maxNsu, (Object)ultNsu));
        result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0025.001", count);
        return result;
    }

    public void consultaCTeNSUEspecifico(Empresa empresa, String nsuEspecifico, TaskProcessResult result) throws Exception {
        ConfigServicos config = this.serviceConfigServicos.getContainsValueOrThrow(EnumConstConfigServicos.DITRIBUICAO_XML_CTES, ConstantsDistribuicaoXMLCTes.ID_EMPRESA.getChave(), empresa.getIdentificador().toString());
        String idCertificados = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLCTes.ID_CONFIGURACAO_CERTIFICADO.getChave());
        Long idCertificadoEmpresa = this.compDistribuicaoXMLNFeCTe.getIdCertificado(empresa, idCertificados);
        ConfiguracaoCertificado configCert = this.getConfiguracaoCertificado(idCertificadoEmpresa);
        ConstAmbiente tipoAmbiente = this.getTipoAmbiente(config);
        ParamsCertificado params = this.helperConfiguracaoCert.build(configCert).getParamsCertificado(tipoAmbiente);
        CTDistribuicaoIntRetorno ret = this.distribuicaoCTe.carregarConfiguracoesEBuscar(params, this.getParamsEnv(null, empresa, tipoAmbiente.getCodigo(), nsuEspecifico));
        this.getAuxConsultaDoc(config).efetuaProcessamentoESalva(ret, empresa, result);
    }

    private WebDistribuicaoDocXMLCTe.ParamsDistribDocXMLCTe getParamsEnv(String ultNSU, Empresa empresa, String tipoAmbiente, String nsuEspecifico) {
        WebDistribuicaoDocXMLCTe.ParamsDistribDocXMLCTe p = new WebDistribuicaoDocXMLCTe.ParamsDistribDocXMLCTe();
        if (ToolMethods.isEquals((Object)tipoAmbiente, (Object)String.valueOf(ConstAmbiente.PRODUCAO.getCodigo()))) {
            p.setAmbiente(ConstAmbiente.PRODUCAO);
        } else {
            p.setAmbiente(ConstAmbiente.HOMOLOGACAO);
        }
        String cpfCnpj = ToolString.onlyNumbers((String)empresa.getPessoa().getComplemento().getCnpj());
        if (cpfCnpj.length() > 11) {
            p.setCnpj(cpfCnpj);
        } else {
            p.setCpf(cpfCnpj);
        }
        p.setCodIbgeUF(empresa.getPessoa().getEndereco().getCidade().getUf().getCodIbge());
        if (ToolMethods.isStrWithData((String)nsuEspecifico)) {
            p.setNsuEpecifico(nsuEspecifico);
            p.setUltimoNSU(null);
        } else if (ToolMethods.isStrWithData((String)ToolString.onlyNumbers((String)ultNSU))) {
            p.setUltimoNSU(ultNSU);
            p.setNsuEpecifico(null);
        } else {
            p.setUltimoNSU("0");
            p.setNsuEpecifico(null);
        }
        return p;
    }

    private AuxDistribuicaoDocCTe getAuxConsultaDoc(ConfigServicos config) {
        return new AuxDistribuicaoDocCTe(this.serviceXmlNFeCteEvt, this.serviceConsultaCTeDestDocImpl, this.serviceConsultaCTeDestImpl, this.serviceXmlNFeCte, this.serviceConsultaCTeDestEvtImpl, this.serviceUnidadeFederativaImpl, this.compStatusConsCTeDoc, this.serviceNotaFiscalTerceirosImpl, this.serviceConsultaCTeDestNSUImpl, config, this.helperConfigServicos);
    }

    private ConfiguracaoCertificado getConfiguracaoCertificado(Long idCert) throws ExceptionObjNotFound {
        ConfiguracaoCertificado configCert = (ConfiguracaoCertificado)this.serviceConfigCertificado.get(idCert);
        if (configCert == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.TSK.0026.002"));
        }
        return configCert;
    }

    private ConstAmbiente getTipoAmbiente(ConfigServicos config) {
        String tipoAmbiente = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLCTes.HOMOLOGACAO_PRODUCAO.getChave());
        tipoAmbiente = ToolString.onlyNumbers((String)tipoAmbiente);
        return ConstAmbiente.valueOfCodigo((String)tipoAmbiente);
    }
}

