/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.cte400.enviocte;

import com.fincatto.documentofiscal.cte.CTeConfig;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.cte.EnumConstCTeStatus;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.LoteFaturamentoCTe;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoTransp;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfClienteWebservice;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfigCTe;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.cte.cte400.enviocte400.impl.UtilEnvioCte;
import com.touchcomp.basementorclientwebservices.cte.cte400.enviocte400.model.EnvioCte;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.cte.ServiceCteImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorxml.model.XMLCTe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLCTe;
import java.util.ArrayList;

public class EnvioCte400 {
    public EnvioCte envioCte(OpcoesFaturamentoTransp opcoesFaturamentoTransp, Cte cte) throws Exception {
        EnvioCte e = new UtilEnvioCte().enviarCte400((CTeConfig)this.getCertificado(opcoesFaturamentoTransp), cte, opcoesFaturamentoTransp);
        e.setMensagemProcessada(this.criarMensagemProcessada(e, cte));
        this.salvarXml(e, cte);
        if (ToolMethods.isEquals((Object)Short.valueOf(e.getRetorno().getStatus()), (Object)EnumConstCTeStatus.AUTORIZADO.getValueShort())) {
            try {
                if (ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getUsuarioAverbacao()) && ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getSenhaAverbacao()) && ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getCodAtmAverbacao())) {
                    ((ServiceCteImpl)ConfApplicationContext.getBean(ServiceCteImpl.class)).enviarAverbacaoAprovadoSemSalvar(cte, opcoesFaturamentoTransp);
                }
            }
            catch (Exception ex) {
                TLogger.get(ex.getClass()).error((Throwable)ex);
            }
        }
        e.setLote(this.atualizarLote(e, cte));
        return e;
    }

    public String xmlCte(OpcoesFaturamentoTransp opcoesFaturamentoTransp, Cte cte) {
        return new UtilEnvioCte().criarXmlCteNota(cte, opcoesFaturamentoTransp);
    }

    private CertificadoConfigCTe getCertificado(OpcoesFaturamentoTransp opcoesFaturamentoTransp) throws ExceptionCertificado {
        ConfiguracaoCertificado certificado = ((ServiceConfiguracaoCertificadoImpl)ConfApplicationContext.getBean(ServiceConfiguracaoCertificadoImpl.class)).getByEmpresa(opcoesFaturamentoTransp.getEmpresa());
        new CertificadoConfClienteWebservice().checaCertificado(certificado);
        ParamsCertificado params = ((HelperConfiguracaoCertificado)ConfApplicationContext.getBean(HelperConfiguracaoCertificado.class)).build(certificado).getParamsCertificado(ConstAmbiente.valueOfCodigo((String)opcoesFaturamentoTransp.getTipoAmbiente().toString()));
        new CertificadoConfClienteWebservice().configuraSocketFactoryDinamico(params.getKeystoreCertificado(), params.getSenhaCertificado());
        return new CertificadoConfigCTe(params, opcoesFaturamentoTransp.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
    }

    private String criarMensagemProcessada(EnvioCte e, Cte cte) {
        String ret = "Resultado da Consulta do CTe " + cte.getNumero() + ":\nStatus: " + e.getRetorno().getStatus() + "\nUF: " + e.getRetorno().getUf().getDescricao() + "\nMotivo: " + e.getRetorno().getMotivo();
        return ret;
    }

    private LoteFaturamentoCTe atualizarLote(EnvioCte e, Cte cte) {
        if (ToolMethods.isNotNull((Object)e.getRetorno().getProtocolo()).booleanValue()) {
            cte.getCteInfo().setStatus(Short.valueOf(e.getRetorno().getProtocolo().getInfo().getStatus()));
            cte.getCteInfo().setNumProtocolo(e.getRetorno().getProtocolo().getInfo().getNumeroProtocolo());
            cte.getCteInfo().setMotivo(e.getRetorno().getProtocolo().getInfo().getMotivo());
        } else {
            cte.getCteInfo().setStatus(Short.valueOf(e.getRetorno().getStatus()));
            cte.getCteInfo().setMotivo(e.getRetorno().getMotivo());
        }
        if (ToolMethods.isEquals((Object)cte.getTipoCte().getCodigo(), (Object)3) && ToolMethods.isEquals((Object)Short.valueOf(e.getRetorno().getStatus()), (Object)EnumConstCTeStatus.AUTORIZADO.getValueShort())) {
            Cte cteSubstituicacao = cte.getCteSubstituicaoOriginal();
            cteSubstituicacao.setTitulos(new ArrayList());
            cte.setCteSubstituicaoOriginal(((ServiceCteImpl)ConfApplicationContext.getBean(ServiceCteImpl.class)).saveOrUpdate(cteSubstituicacao));
        }
        ((ServiceCteImpl)ConfApplicationContext.getBean(ServiceCteImpl.class)).saveOrUpdate(cte);
        return cte.getLoteFaturamentoCTe();
    }

    private void salvarXml(EnvioCte e, Cte cte) {
        XMLCTe x = ((ServiceXMLCTe)ConfApplicationContext.getBean(ServiceXMLCTe.class)).getXmlCTeIdCTe(cte.getIdentificador());
        x.setIdCTe(cte.getIdentificador());
        x.setConteudoXML(e.getXmlEnvio());
        x.setConteudoAprovacao(e.getXmlRecebido());
        ((ServiceXMLCTe)ConfApplicationContext.getBean(ServiceXMLCTe.class)).saveOrUpdate((Object)x);
    }
}

