/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nfp;

import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClass;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoa;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.interfaces.VODocumento;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.interfaces.VODocumentoItem;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.interfaces.VODocumentoItemGrade;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.LinkedList;
import java.util.List;

public class VONFPropriaItem
implements VODocumentoItem<ItemNotaFiscalPropria, VODocumento> {
    private ItemNotaFiscalPropria vo;
    private List<VODocumentoItemGrade> grades = new LinkedList<VODocumentoItemGrade>();
    private VODocumento parent;
    private ModeloFiscal modeloFiscal;
    private RelacionamentoPessoa relacionamentoPessoa;

    public VONFPropriaItem(ItemNotaFiscalPropria itemNota) {
        this.vo = itemNota;
    }

    @Override
    public Produto getProduto() {
        return this.vo.getProduto();
    }

    @Override
    public Double getValorUnitario() {
        return this.vo.getValorUnitario();
    }

    @Override
    public Double getValorDesconto() {
        return this.vo.getValorDesconto();
    }

    @Override
    public Double getValorDespAcessorias() {
        return this.vo.getValorDespAcessoria();
    }

    @Override
    public Double getValorFrete() {
        return this.vo.getValorFrete();
    }

    @Override
    public Double getValorSeguro() {
        return this.vo.getVrSeguro();
    }

    @Override
    public Double getValorIcmsST() {
        return this.vo.getItemNotaLivroFiscal().getVrIcmsSt();
    }

    @Override
    public Double getValorIcmsSTCusto() {
        if (ToolMethods.isEquals((Object)this.vo.getItemNotaLivroFiscal().getValorStCustoCompTotNota(), (Object)1)) {
            return this.vo.getItemNotaLivroFiscal().getVrCustoICMSST();
        }
        return 0.0;
    }

    @Override
    public Double getValorIPI() {
        return this.vo.getItemNotaLivroFiscal().getVrIpiIndustria() + this.vo.getItemNotaLivroFiscal().getVrIpiComercio() + this.vo.getItemNotaLivroFiscal().getVrIpiObservacao();
    }

    @Override
    public List<VODocumentoItemGrade> getGrades() {
        return this.grades;
    }

    @Override
    public ItemNotaFiscalPropria getSource() {
        return this.vo;
    }

    @Override
    public void build(ItemNotaFiscalPropria vo, VODocumento parent) {
        this.vo = vo;
        this.parent = parent;
    }

    @Override
    public VODocumento getParent() {
        return this.parent;
    }

    @Override
    public ModeloFiscal getModeloFiscal() {
        return this.modeloFiscal;
    }

    @Override
    public void setModeloFiscal(ModeloFiscal modeloFiscal) {
        this.modeloFiscal = modeloFiscal;
    }

    @Override
    public RelacionamentoPessoa getRelacionamentoPessoa() {
        return this.relacionamentoPessoa;
    }

    @Override
    public void setRelacionamentoPessoa(RelacionamentoPessoa relacionamentoPessoa) {
        this.relacionamentoPessoa = relacionamentoPessoa;
    }

    @Override
    public Double getValorFCPSt() {
        return this.vo.getItemNotaLivroFiscal().getValorFCPSt();
    }

    @Override
    public ParamTribCbsIbsClass getParamTribCbsIbsClass() {
        return this.vo.getParamTribCbsIbsClass();
    }

    @Override
    public void setParamTribCbsIbsClass(ParamTribCbsIbsClass paramTrib) {
        this.vo.setParamTribCbsIbsClass(paramTrib);
    }
}

