/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.email;

import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.ExceptionEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.obsdinamica.CompOBSDinamica;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompEmailNovo {
    private CompOBSDinamica compOBSDinamica;

    public CompEmailNovo(CompOBSDinamica compOBSDinamica) {
        this.compOBSDinamica = compOBSDinamica;
    }

    public Email newEmail(ServidorEmail servidorEmail, String assunto, String descricao, String corpoMensagem) throws ExceptionInvalidData {
        if (servidorEmail == null) {
            throw new ExceptionInvalidData("01-02-00732", new Object[0]);
        }
        Email e = new Email();
        e.setAssunto(assunto);
        e.setDescricao(descricao);
        e.setServidor(this.getServidorEmail(servidorEmail));
        e.setCorpoMensagem(corpoMensagem);
        return e;
    }

    public Email newEmail(ModeloEmail modeloEmail, ServidorEmail servidorEmail) throws ExceptionReflection, ExceptionInvalidData {
        return this.newEmail(modeloEmail, servidorEmail, null);
    }

    public Email newEmail(ModeloEmail modeloEmail, ServidorEmail servidorEmail, Object entity) throws ExceptionReflection, ExceptionInvalidData {
        if (modeloEmail == null) {
            throw new ExceptionInvalidData("01-02-00731", new Object[0]);
        }
        Email e = this.newEmail(servidorEmail, modeloEmail.getTituloEmail(), modeloEmail.getDescricao(), "");
        if (modeloEmail.getObjectObsDinamica() != null && ToolMethods.isStrWithData((String)modeloEmail.getObjectObsDinamica().getObservacao())) {
            e.setCorpoMensagem(this.compOBSDinamica.build(entity, modeloEmail.getObjectObsDinamica().getObservacao()));
        } else {
            List tokens = ToolString.getReplaceTokens((String)new String(modeloEmail.getModelo()));
            if (!tokens.isEmpty()) {
                throw new ExceptionInvalidData("E.ERP.0132.002", new Object[0]);
            }
            e.setCorpoMensagem(new String(modeloEmail.getModelo()));
        }
        return e;
    }

    public Email newEmail(ModeloEmail modeloEmail, ServidorEmail servidorEmail, Object entity, List<File> anexos, String destinatarios) throws ExceptionInvalidData, ExceptionReflection {
        if (destinatarios == null || destinatarios.length() == 0) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0748.001"));
        }
        Email e = this.newEmail(modeloEmail, servidorEmail, entity);
        e.addAnexos(anexos);
        e.addDestinatarios(new String[]{destinatarios});
        return e;
    }

    public void newEmailAndSend(Object source, ServidorEmail servidorEmail, ModeloEmail modeloEmail, String ... emails) throws ExceptionReflection, ExceptionInvalidData, ExceptionEmail {
        Email e = this.newEmail(modeloEmail, servidorEmail, source);
        e.addDestinatarios(emails);
        ToolSendEmail.sendEmailWithException((Email)e);
    }

    public void newEmailAndSend(Object source, ServidorEmail servidorEmail, String tituloEmail, String modeloEmail, String ... emails) throws ExceptionReflection, ExceptionInvalidData, ExceptionEmail {
        String corpoEmail = ((CompOBSDinamica)Context.get(CompOBSDinamica.class)).build(source, modeloEmail);
        Email e = this.newEmail(servidorEmail, tituloEmail, tituloEmail, corpoEmail);
        e.addDestinatarios(emails);
        ToolSendEmail.sendEmailWithException((Email)e);
    }

    public Email.ServidorEmail getServidorEmail(ServidorEmail servidorEmail) {
        Email.ServidorEmail serv = new Email.ServidorEmail(servidorEmail.getServidor(), servidorEmail.getServidorImap(), servidorEmail.getServidorPop(), servidorEmail.getEmail(), servidorEmail.getSenha(), servidorEmail.getPortaEmail(), servidorEmail.getNaoAutenticarEmail(), servidorEmail.getLogin(), servidorEmail.getServerProperties(), servidorEmail.getGerarArquivoExtensaoEml(), servidorEmail.getDebugServer());
        serv.setEmailCopia(servidorEmail.getEmailCopia());
        return serv;
    }
}

