/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.email.builders;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.ManifestoCteCte;
import com.touchcomp.basementor.model.vo.ManifestoCteEletronico;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoManifestoCte;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.ExceptionEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.email.CompEmailNovo;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.EnumConstRecipientType;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompEmailBuilderManifestoCteEletronico {
    CompEmailNovo compEmail;

    @Autowired
    public CompEmailBuilderManifestoCteEletronico(CompEmailNovo compEmail) {
        this.compEmail = compEmail;
    }

    public void criarEmailAutorizado(ManifestoCteEletronico vo, ServidorEmail servidorEmail, ModeloEmail modeloEmail, OpcoesFaturamentoManifestoCte opcoesFaturamentoManifestoCte, List<File> anexos) throws ExceptionReflection, ExceptionInvalidData, ExceptionEmail {
        if (vo == null) {
            throw new ExceptionErroProgramacao("Manifesto n\u00e3o informado ou n\u00e3o autorizado para envio de e-mail!");
        }
        Email e = this.compEmail.newEmail(modeloEmail, servidorEmail, vo);
        e.setDestinatarios(this.getDestinatariosAutorizados(vo, opcoesFaturamentoManifestoCte));
        e.addAnexos(anexos);
        ToolSendEmail.sendEmailWithException((Email)e);
    }

    public void criarEmailCancelado(ManifestoCteEletronico vo, ServidorEmail servidorEmail, ModeloEmail modeloEmail, OpcoesFaturamentoManifestoCte opcoesFaturamentoManifestoCte, List<File> anexos) throws ExceptionReflection, ExceptionInvalidData, ExceptionEmail {
        Email e = this.compEmail.newEmail(modeloEmail, servidorEmail, vo);
        e.setDestinatarios(this.getDestinatariosCancelados(vo, opcoesFaturamentoManifestoCte));
        e.addAnexos(anexos);
        ToolSendEmail.sendEmailWithException((Email)e);
    }

    private HashSet<Email.Destinatario> getDestinatariosAutorizados(ManifestoCteEletronico vo, OpcoesFaturamentoManifestoCte opcoesFaturamentoManifestoCte) {
        HashSet<Email.Destinatario> hash = new HashSet<Email.Destinatario>();
        if (ToolMethods.isEquals((Object)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEnviarCopiaEmail(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isStrWithData((String)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEmailCopia())) {
            hash.add(new Email.Destinatario(opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEmailCopia(), EnumConstRecipientType.BCC));
        }
        for (ManifestoCteCte c : vo.getCte()) {
            if (ToolMethods.isEquals((Object)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEnviarEmailFatTomCli(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                for (EmailPessoa e : c.getCte().getClienteTomador().getCliente().getPessoa().getComplemento().getEmails()) {
                    if (!ToolMethods.isEquals((Object)e.getEnviarDadosMdfe(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isEquals((Object)e.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isStrWithData((String)e.getEmail())) continue;
                    hash.add(new Email.Destinatario(e.getEmail(), EnumConstRecipientType.BCC));
                }
            }
            if (ToolMethods.isEquals((Object)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEnviarEmailFatRemet(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                for (EmailPessoa e : c.getCte().getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getComplemento().getEmails()) {
                    if (!ToolMethods.isEquals((Object)e.getEnviarDadosMdfe(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isEquals((Object)e.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isStrWithData((String)e.getEmail())) continue;
                    hash.add(new Email.Destinatario(e.getEmail(), EnumConstRecipientType.BCC));
                }
            }
            if (ToolMethods.isEquals((Object)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEnviarEmailFatDest(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                for (EmailPessoa e : c.getCte().getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa().getComplemento().getEmails()) {
                    if (!ToolMethods.isEquals((Object)e.getEnviarDadosMdfe(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isEquals((Object)e.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isStrWithData((String)e.getEmail())) continue;
                    hash.add(new Email.Destinatario(e.getEmail(), EnumConstRecipientType.BCC));
                }
            }
            if (ToolMethods.isEquals((Object)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEnviarEmailFatExped(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                for (EmailPessoa e : c.getCte().getUnidadeFatTransporteExpedidor().getPessoaTransporte().getPessoa().getComplemento().getEmails()) {
                    if (!ToolMethods.isEquals((Object)e.getEnviarDadosMdfe(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isEquals((Object)e.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isStrWithData((String)e.getEmail())) continue;
                    hash.add(new Email.Destinatario(e.getEmail(), EnumConstRecipientType.BCC));
                }
            }
            if (!ToolMethods.isEquals((Object)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEnviarEmailFatReceb(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) continue;
            for (EmailPessoa e : c.getCte().getUnidadeFatTransporteRecebedor().getPessoaTransporte().getPessoa().getComplemento().getEmails()) {
                if (!ToolMethods.isEquals((Object)e.getEnviarDadosMdfe(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isEquals((Object)e.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isStrWithData((String)e.getEmail())) continue;
                hash.add(new Email.Destinatario(e.getEmail(), EnumConstRecipientType.BCC));
            }
        }
        if (ToolMethods.isEquals((Object)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEnviarEmailFatTranspAgreg(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            for (EmailPessoa e : vo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getComplemento().getEmails()) {
                if (!ToolMethods.isEquals((Object)e.getEnviarDadosMdfe(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isEquals((Object)e.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isStrWithData((String)e.getEmail())) continue;
                hash.add(new Email.Destinatario(e.getEmail(), EnumConstRecipientType.BCC));
            }
        }
        return hash;
    }

    private HashSet<Email.Destinatario> getDestinatariosCancelados(ManifestoCteEletronico vo, OpcoesFaturamentoManifestoCte opcoesFaturamentoManifestoCte) {
        HashSet<Email.Destinatario> hash = new HashSet<Email.Destinatario>();
        if (ToolMethods.isEquals((Object)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEnviarCopiaEmail(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isStrWithData((String)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEmailCopia())) {
            hash.add(new Email.Destinatario(opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEmailCopia(), EnumConstRecipientType.BCC));
        }
        for (ManifestoCteCte c : vo.getCte()) {
            if (ToolMethods.isEquals((Object)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEnviarEmailCancTomCli(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                for (EmailPessoa e : c.getCte().getClienteTomador().getCliente().getPessoa().getComplemento().getEmails()) {
                    if (!ToolMethods.isEquals((Object)e.getEnviarDadosMdfe(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isEquals((Object)e.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isStrWithData((String)e.getEmail())) continue;
                    hash.add(new Email.Destinatario(e.getEmail(), EnumConstRecipientType.BCC));
                }
            }
            if (ToolMethods.isEquals((Object)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEnviarEmailCancRemet(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                for (EmailPessoa e : c.getCte().getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getComplemento().getEmails()) {
                    if (!ToolMethods.isEquals((Object)e.getEnviarDadosMdfe(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isEquals((Object)e.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isStrWithData((String)e.getEmail())) continue;
                    hash.add(new Email.Destinatario(e.getEmail(), EnumConstRecipientType.BCC));
                }
            }
            if (ToolMethods.isEquals((Object)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEnviarEmailCancDest(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                for (EmailPessoa e : c.getCte().getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa().getComplemento().getEmails()) {
                    if (!ToolMethods.isEquals((Object)e.getEnviarDadosMdfe(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isEquals((Object)e.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isStrWithData((String)e.getEmail())) continue;
                    hash.add(new Email.Destinatario(e.getEmail(), EnumConstRecipientType.BCC));
                }
            }
            if (ToolMethods.isEquals((Object)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEnviarEmailCancExped(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                for (EmailPessoa e : c.getCte().getUnidadeFatTransporteExpedidor().getPessoaTransporte().getPessoa().getComplemento().getEmails()) {
                    if (!ToolMethods.isEquals((Object)e.getEnviarDadosMdfe(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isEquals((Object)e.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isStrWithData((String)e.getEmail())) continue;
                    hash.add(new Email.Destinatario(e.getEmail(), EnumConstRecipientType.BCC));
                }
            }
            if (!ToolMethods.isEquals((Object)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEnviarEmailCancReceb(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) continue;
            for (EmailPessoa e : c.getCte().getUnidadeFatTransporteRecebedor().getPessoaTransporte().getPessoa().getComplemento().getEmails()) {
                if (!ToolMethods.isEquals((Object)e.getEnviarDadosMdfe(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isEquals((Object)e.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isStrWithData((String)e.getEmail())) continue;
                hash.add(new Email.Destinatario(e.getEmail(), EnumConstRecipientType.BCC));
            }
        }
        if (ToolMethods.isEquals((Object)opcoesFaturamentoManifestoCte.getOpcoesRelacManifestoCte().getEnviarEmailCancTranspAgreg(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            for (EmailPessoa e : vo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getComplemento().getEmails()) {
                if (!ToolMethods.isEquals((Object)e.getEnviarDadosMdfe(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isEquals((Object)e.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isStrWithData((String)e.getEmail())) continue;
                hash.add(new Email.Destinatario(e.getEmail(), EnumConstRecipientType.BCC));
            }
        }
        return hash;
    }
}

