/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.email.builders;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.EnumExcepEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.ExceptionEmail;
import com.touchcomp.basementorservice.components.email.CompEmailNovo;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.EnumConstRecipientType;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.others.email.ValidateEmail;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompEmailBuilderNotaFiscalPropria {
    CompEmailNovo compEmail;

    @Autowired
    public CompEmailBuilderNotaFiscalPropria(CompEmailNovo compEmailNovo) {
        this.compEmail = compEmailNovo;
    }

    public void criarEmailAutorizado(NotaFiscalPropria vo, ServidorEmail servidorEmail, ModeloEmail modeloEmail, String assunto, String corpoMensagem, OpcoesRelacionamento opcoesRelacionamento, List<File> anexos) throws ExceptionInvalidData, ExceptionEmail {
        if (vo == null) {
            throw new ExceptionErroProgramacao("Nota Fiscal Pr\u00f3pria n\u00e3o informado ou n\u00e3o autorizado para envio de e-mail!");
        }
        Email e = this.compEmail.newEmail(servidorEmail, assunto, assunto, corpoMensagem);
        HashSet<Email.Destinatario> destinatarios = this.getDestinatariosAutorizados(vo, opcoesRelacionamento);
        if (TMethods.isWithData(destinatarios)) {
            HashMap<Email.Destinatario, ExceptionEmail> errosEnvioEmail = new HashMap<Email.Destinatario, ExceptionEmail>();
            for (Email.Destinatario destinatario : destinatarios) {
                try {
                    e.setDestinatarios(new HashSet<Email.Destinatario>(Arrays.asList(destinatario)));
                    e.addAnexos(anexos);
                    ToolSendEmail.sendEmailWithException((Email)e);
                }
                catch (ExceptionEmail ex) {
                    errosEnvioEmail.put(destinatario, ex);
                }
            }
            if (!errosEnvioEmail.isEmpty()) {
                throw new ExceptionEmail(EnumExcepEmail.MESSAGE_EXCEPTION, new Object[0]);
            }
        }
    }

    private HashSet<Email.Destinatario> getDestinatariosAutorizados(NotaFiscalPropria vo, OpcoesRelacionamento opcoesRelacionamento) {
        HashSet<Email.Destinatario> hash = new HashSet<Email.Destinatario>();
        if (ToolMethods.isEquals((Object)opcoesRelacionamento.getEnviarCopiaFaturamento(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isStrWithData((String)opcoesRelacionamento.getEmailCopiaFaturamento())) {
            this.addEmail(opcoesRelacionamento.getEmailCopiaFaturamento(), hash);
        }
        for (EmailPessoa e : vo.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getEmails()) {
            if (!ToolMethods.isEquals((Object)e.getEnviarDadosNfe(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isEquals((Object)e.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isStrWithData((String)e.getEmail())) continue;
            this.addEmail(e.getEmail(), hash);
        }
        if (vo.getDadosTransNfPropria() != null && vo.getDadosTransNfPropria().getTransportador() != null && opcoesRelacionamento != null && opcoesRelacionamento.getEnviarXMLNFeTransportadora() != null && ToolMethods.isEquals((Object)opcoesRelacionamento.getEnviarXMLNFeTransportadora(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            for (EmailPessoa e : vo.getDadosTransNfPropria().getTransportador().getPessoa().getComplemento().getEmails()) {
                if (!ToolMethods.isEquals((Object)e.getEnviarDadosNfe(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isEquals((Object)e.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !ToolMethods.isStrWithData((String)e.getEmail())) continue;
                this.addEmail(e.getEmail(), hash);
            }
        }
        return hash;
    }

    private void addEmail(String email, HashSet<Email.Destinatario> hash) {
        if (TMethods.isStrWithData((String)email) && ValidateEmail.isValid((String)email)) {
            hash.add(new Email.Destinatario(email, EnumConstRecipientType.CC));
        }
    }
}

