/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.email.builders;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.opcoesrelacionamentos.EnumConstEnviarEmailPara;
import com.touchcomp.basementor.model.vo.EmailEnviadoRelPessoa;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoa;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaLog;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.constants.EnumConstantsEmailVal;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolEmail;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class CompEmailBuilderRelPessoa {
    private CompEmailBuilderRelPessoa() {
    }

    public static CompEmailBuilderRelPessoa get() {
        return new CompEmailBuilderRelPessoa();
    }

    private String getTextoEmail(String modelo, RelacionamentoPessoa rec) {
        List tokens = ToolString.getReplaceTokens((String)modelo);
        HashMap<String, String> values = new HashMap<String, String>();
        for (StringToken tk : tokens) {
            String value = this.getValue(tk.getChave(), rec);
            values.put(tk.getChave(), value);
        }
        return ToolString.build((String)modelo, values);
    }

    public Email criarEmail(RelacionamentoPessoa vo, ModeloEmail mod, OpcoesRelacionamento opcoesRelacionamento) {
        HashSet<String> destinatarios = this.getDestinarios(vo, opcoesRelacionamento);
        return this.criarEmail(vo, mod, opcoesRelacionamento.getServidorEmailMarketing(), opcoesRelacionamento, destinatarios);
    }

    public Email criarEmail(RelacionamentoPessoa vo, ModeloEmail mod, ServidorEmail servidor, OpcoesRelacionamento opcoesRelacionamento, HashSet<String> destinatarios) {
        String textoEmail = new String(mod.getModelo());
        textoEmail = this.getTextoEmail(textoEmail, vo);
        Email e = new Email(true);
        e.setAssunto(mod.getTituloEmail());
        e.setDescricao(mod.getTituloEmail());
        e.setCorpoMensagem(textoEmail);
        e.setDestinatariosStr(destinatarios);
        e.setRemetente(servidor.getEmail());
        e.setServidor(new Email.ServidorEmail(servidor.getServidor(), servidor.getServidorImap(), servidor.getServidorPop(), servidor.getEmail(), servidor.getSenha(), servidor.getPortaEmail(), servidor.getNaoAutenticarEmail(), servidor.getLogin(), servidor.getServerProperties(), servidor.getGerarArquivoExtensaoEml(), servidor.getDebugServer()));
        return e;
    }

    public Email criarEmailAlteracao(RelacionamentoPessoa vo, ModeloEmail mod, OpcoesRelacionamento opcoesRelacionamento) {
        String textoEmail = new String(mod.getModelo());
        ServidorEmail servidor = opcoesRelacionamento.getServidorEmailMarketing();
        textoEmail = this.getTextoEmail(textoEmail, vo);
        Email e = new Email(true);
        e.setAssunto(mod.getTituloEmail() + (vo.getIdentificador() == null ? " - Cadastro" : " - Altera\u00e7\u00e3o"));
        e.setDescricao(mod.getTituloEmail() + (vo.getIdentificador() == null ? " - Cadastro" : " - Altera\u00e7\u00e3o"));
        e.setCorpoMensagem(textoEmail);
        e.setDestinatariosStr(this.getDestinatariosAlteracao(vo, opcoesRelacionamento));
        e.setRemetente(opcoesRelacionamento.getServidorEmailMarketing().getEmail());
        e.setServidor(new Email.ServidorEmail(servidor.getServidor(), servidor.getServidorImap(), servidor.getServidorPop(), opcoesRelacionamento.getServidorEmailMarketing().getEmail(), opcoesRelacionamento.getServidorEmailMarketing().getSenha(), opcoesRelacionamento.getServidorEmailMarketing().getPortaEmail(), opcoesRelacionamento.getServidorEmailMarketing().getNaoAutenticarEmail(), opcoesRelacionamento.getServidorEmailMarketing().getLogin(), opcoesRelacionamento.getServidorEmailMarketing().getServerProperties(), opcoesRelacionamento.getServidorEmailMarketing().getGerarArquivoExtensaoEml(), opcoesRelacionamento.getServidorEmailMarketing().getDebugServer()));
        return e;
    }

    private HashSet<String> getDestinarios(RelacionamentoPessoa vo, OpcoesRelacionamento opcoesRelacionamento) {
        HashSet<String> em = new HashSet<String>();
        for (EmailEnviadoRelPessoa e2 : vo.getEmailsEnviados()) {
            em.add(e2.getEmail());
        }
        if (ToolMethods.isStrWithData((String)vo.getEmailsEnviadosPara())) {
            String[] emails;
            for (String email : emails = vo.getEmailsEnviadosPara().split(";")) {
                if (!ToolMethods.isEquals((Object)ToolEmail.isValidEmail((String)email), (Object)EnumConstantsEmailVal.EMAIL_VALIDO)) continue;
                em.add(email);
            }
        }
        if (ToolMethods.isAffirmative((Number)opcoesRelacionamento.getEnviarCopiaRel())) {
            em.add(opcoesRelacionamento.getEmailCopiaRel());
        }
        if (ToolMethods.isEquals((Object)opcoesRelacionamento.getEnviarEmailPara(), (Object)EnumConstEnviarEmailPara.SOMENTE_PARA_CLIENTES.getValue()) || ToolMethods.isEquals((Object)opcoesRelacionamento.getEnviarEmailPara(), (Object)EnumConstEnviarEmailPara.TODOS.getValue())) {
            em.addAll(vo.getPessoa().getComplemento().getEmails().stream().filter(i -> ToolMethods.isEquals((Object)i.getEnviarDadosRelacionamento(), (Object)EnumConstantsMentorSimNao.SIM.getValue())).map(EmailPessoa::getEmail).collect(Collectors.toList()));
        }
        if (ToolMethods.isEquals((Object)opcoesRelacionamento.getEnviarEmailPara(), (Object)EnumConstEnviarEmailPara.SOMENTE_PARA_USUARIOS.getValue()) || ToolMethods.isEquals((Object)opcoesRelacionamento.getEnviarEmailPara(), (Object)EnumConstEnviarEmailPara.TODOS.getValue())) {
            em.addAll(vo.getAgendamentos().stream().flatMap(i -> i.getUsuarioAgendamento().getUsuarioBasico().getPessoa().getComplemento().getEmails().stream()).filter(e -> ToolMethods.isEquals((Object)e.getEnviarDadosRelacionamento(), (Object)EnumConstantsMentorSimNao.SIM.getValue())).map(EmailPessoa::getEmail).collect(Collectors.toList()));
        }
        return em;
    }

    private HashSet<String> getDestinarioCopiaAlteracao(OpcoesRelacionamento opcoesRelacionamento, HashSet<String> em) {
        if (opcoesRelacionamento.getEnviarEmailAltRel() != null && opcoesRelacionamento.getEnviarEmailAltRel() == 1) {
            em.add(opcoesRelacionamento.getEmailAltRel());
        }
        return em;
    }

    public String getValue(String token, RelacionamentoPessoa vo) {
        if (token == null || vo == null) {
            return "";
        }
        if (token.equalsIgnoreCase("cpfcnpj pessoa rel")) {
            return vo.getPessoa().getComplemento().getCnpj();
        }
        if (token.equalsIgnoreCase("data rel")) {
            return ToolDate.dateToStr((Date)vo.getDataRelacionamento(), (String)"dd/MM/yyyy hh:mm");
        }
        if (token.equalsIgnoreCase("data sol. rel")) {
            return ToolDate.dateToStr((Date)vo.getDataSolucao(), (String)"dd/MM/yyyy hh:mm");
        }
        if (token.equalsIgnoreCase("data prev. finaliz. rel")) {
            return ToolDate.dateToStr((Date)vo.getDataPrevistaSol(), (String)"dd/MM/yyyy hh:mm");
        }
        if (token.equalsIgnoreCase("descricao rel")) {
            return vo.getAssunto();
        }
        if (token.equalsIgnoreCase("descricao sol. rel")) {
            return vo.getSolucao();
        }
        if (token.equalsIgnoreCase("id. rel")) {
            return vo.getIdentificador().toString();
        }
        if (token.equalsIgnoreCase("id. pessoa rel")) {
            return vo.getPessoa().getIdentificador().toString();
        }
        if (token.equalsIgnoreCase("id. usu. agend. rel") || token.equalsIgnoreCase("nome usu. agend. rel") || token.equalsIgnoreCase("data agend. rel") || token.equalsIgnoreCase("fone usuario agend rel") || token.equalsIgnoreCase("email usuario agend rel") || token.equalsIgnoreCase("observ. rel")) {
            RelacionamentoPessoaLog agendamento = this.getAgendamentoAberto(vo);
            if (token.equalsIgnoreCase("id. usu. agend. rel") && agendamento != null && agendamento.getUsuarioAgendamento() != null) {
                return agendamento.getUsuarioAgendamento().getIdentificador().toString();
            }
            if (token.equalsIgnoreCase("nome usu. agend. rel") && agendamento != null && agendamento.getUsuarioAgendamento() != null) {
                return agendamento.getUsuarioAgendamento().getUsuarioBasico().getPessoa().getNome();
            }
            if (token.equalsIgnoreCase("data agend. rel") && agendamento != null && agendamento.getDataAgendamento() != null) {
                return ToolDate.dateToStr((Date)agendamento.getDataAgendamento(), (String)"dd/MM/yyyy hh:mm");
            }
            if (token.equalsIgnoreCase("fone usuario agend rel") && agendamento != null && agendamento.getUsuarioAgendamento() != null) {
                return agendamento.getUsuarioAgendamento().getUsuarioBasico().getPessoa().getComplemento().getFone1();
            }
            if (token.equalsIgnoreCase("email usuario agend rel") && agendamento != null && agendamento.getUsuarioAgendamento() != null) {
                EmailPessoa emailAtivo = this.getEmailAtivo(agendamento.getUsuarioAgendamento());
                if (emailAtivo != null) {
                    return emailAtivo.getEmail();
                }
                return "";
            }
            if (token.equalsIgnoreCase("observ. rel") && agendamento != null && agendamento.getObservacao() != null) {
                return agendamento.getObservacao();
            }
            return "";
        }
        if (token.equalsIgnoreCase("id. usu. atend. rel")) {
            return vo.getUsuario().getIdentificador().toString();
        }
        if (token.equalsIgnoreCase("id. usu. sol. rel")) {
            if (vo.getUsuarioSolucao() != null) {
                return vo.getUsuarioSolucao().getIdentificador().toString();
            }
            return "";
        }
        if (token.equalsIgnoreCase("nome pessoa rel")) {
            return vo.getPessoa().getNome();
        }
        if (token.equalsIgnoreCase("nome usu. atend. rel")) {
            if (vo.getUsuario() != null) {
                return vo.getUsuario().getUsuarioBasico().getPessoa().getNome();
            }
            return "";
        }
        if (token.equalsIgnoreCase("nome usu. sol. rel")) {
            if (vo.getUsuarioSolucao() != null) {
                return vo.getUsuarioSolucao().getUsuarioBasico().getPessoa().getNome();
            }
            return "";
        }
        if (token.equalsIgnoreCase("prioridade rel")) {
            if (vo.getPrioridadeMarketing() != null) {
                return vo.getPrioridadeMarketing().getDescricao();
            }
            return "";
        }
        if (token.equalsIgnoreCase("fone usuario cad rel")) {
            if (vo.getUsuario() != null) {
                return vo.getUsuario().getUsuarioBasico().getPessoa().getComplemento().getFone1();
            }
            return "";
        }
        if (token.equalsIgnoreCase("email usuario cad rel")) {
            EmailPessoa emailAtivo = this.getEmailAtivo(vo.getUsuario());
            if (emailAtivo != null) {
                return emailAtivo.getEmail();
            }
            return "";
        }
        if (token.equalsIgnoreCase("fone usuario sol rel")) {
            if (vo.getUsuarioSolucao() != null) {
                return vo.getUsuario().getUsuarioBasico().getPessoa().getComplemento().getFone1();
            }
            return "";
        }
        if (token.equalsIgnoreCase("email usuario sol rel")) {
            EmailPessoa emailAtivo = this.getEmailAtivo(vo.getUsuarioSolucao());
            if (emailAtivo != null) {
                return emailAtivo.getEmail();
            }
            return "";
        }
        if (token.equalsIgnoreCase("procedencia solicitacao rel")) {
            if (vo.getProcedenciaSolicitacao() != null) {
                return vo.getProcedenciaSolicitacao().getDescricao();
            }
            return "";
        }
        if (token.equalsIgnoreCase("classificacao marketing rel")) {
            if (vo.getClassificacaoMarketing() != null) {
                return vo.getClassificacaoMarketing().getDescricao();
            }
            return "";
        }
        if (token.equalsIgnoreCase("nr protocolo marketing rel")) {
            if (vo.getNrProtocolo() != null) {
                return vo.getNrProtocolo().toString();
            }
            return "";
        }
        if (token.equalsIgnoreCase("data hora envio rel")) {
            return ToolDate.dateToStr((Date)new Date(), (String)"dd/MM/yyyy hh:mm:ss");
        }
        return "";
    }

    private RelacionamentoPessoaLog getAgendamentoAberto(RelacionamentoPessoa vo) {
        for (RelacionamentoPessoaLog r : vo.getAgendamentos()) {
            if (r.getFinalizado() != null && r.getFinalizado() == 1) continue;
            return r;
        }
        return null;
    }

    private EmailPessoa getEmailAtivo(Usuario usuario) {
        if (usuario == null) {
            return null;
        }
        for (EmailPessoa em : usuario.getUsuarioBasico().getPessoa().getComplemento().getEmails()) {
            if (em.getAtivo() == null || em.getAtivo() != 1 || em.getEnviarDadosRelacionamento() == null || em.getEnviarDadosRelacionamento() != 1) continue;
            return em;
        }
        return null;
    }

    private HashSet<String> getDestinatariosAlteracao(RelacionamentoPessoa vo, OpcoesRelacionamento opcoesRelacionamento) {
        HashSet<String> destinatarios = this.getDestinarios(vo, opcoesRelacionamento);
        this.getDestinarioCopiaAlteracao(opcoesRelacionamento, destinatarios);
        return destinatarios;
    }
}

