/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.entityxml;

import com.touchcomp.basementor.annotations.datatransfer.IgnorePropEntityTransfer;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.impl.hibernate.ServiceHibernateImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.model.reflection.ClassInfo;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Id;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.codec.binary.Hex;
import org.hibernate.proxy.HibernateProxy;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

class AuxGenerateFile {
    AuxGenerateFile() {
    }

    byte[] entityToByte(Object entity, Long version) throws ExceptionIO {
        try {
            List<ClassInfo> classes = ((ServiceHibernateImpl)Context.get(ServiceHibernateImpl.class)).getMappedClassInfo();
            Element element = new Element("mentor_entity");
            element.setAttribute("class", entity.getClass().getCanonicalName());
            element.setAttribute("version", String.valueOf(1));
            element.setAttribute("system_version", String.valueOf(version));
            this.addEntity(element, entity, classes);
            Document d = new Document(element);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            XMLOutputter xout = new XMLOutputter();
            xout.setFormat(Format.getPrettyFormat().setEncoding("ISO-8859-1"));
            xout.output(d, (OutputStream)bout);
            return bout.toByteArray();
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public File entityToFile(File file, Object entity, String ext, Long version) throws ExceptionIO {
        try {
            byte[] found = this.entityToByte(entity, version);
            file = new File(file.getAbsolutePath() + "." + ext);
            file.getParentFile().mkdirs();
            FileOutputStream fout = new FileOutputStream(file);
            fout.write(found);
            return file;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    private void addEntity(Element father, Object entity, List<ClassInfo> classes) throws Exception {
        Method[] methods = entity.getClass().getMethods();
        Method[] methodsPersintentClass = null;
        if (Proxy.isProxyClass(entity.getClass()) || entity instanceof HibernateProxy) {
            Class<?> persist = entity.getClass().getSuperclass();
            methods = persist.getMethods();
        }
        for (Method mh : methods) {
            Element aux = this.verifyMethodAndAdd(mh, methodsPersintentClass, entity, classes);
            if (aux == null) continue;
            father.addContent((Content)aux);
        }
    }

    private Element verifyMethodAndAdd(Method mh, Method[] methodsPersintentClass, Object entity, List<ClassInfo> classes) throws Exception {
        if (!mh.getName().startsWith("get") || this.constainsTransient(mh, Transient.class) || this.constainsTransient(mh, IgnorePropEntityTransfer.class)) {
            return null;
        }
        Field field = ToolReflections.getField(entity.getClass(), (String)ToolReflections.getFieldName((Method)mh));
        if (field == null || this.constainsTransient(field, Transient.class) || this.constainsTransient(field, IgnorePropEntityTransfer.class)) {
            return null;
        }
        Object value = mh.invoke(entity, (Object[])null);
        Class returned = ToolReflections.getHibernateReturnType((Method)mh, (Method[])methodsPersintentClass);
        Element fieldElement = null;
        if ((this.isEntity(returned, classes) || this.isCollection(value)) && (ToolReflections.hasCascadeAnnotation((Method)mh) || ToolReflections.hasCascadeAnnotation((Field)field))) {
            fieldElement = this.addFieldRoot(mh.getName(), returned.getCanonicalName(), false);
            boolean isCollection = this.isCollection(value);
            if (isCollection) {
                Collection aux = (Collection)value;
                fieldElement.setAttribute("isCollection", "true");
                fieldElement.setAttribute("collectionClass", this.convergeCollectionClass(aux.getClass().getCanonicalName()));
                for (Object ob : aux) {
                    fieldElement.setAttribute("classSetMethod", ob.getClass().getName());
                    Element fieldAux = this.addFieldRoot(mh.getName(), ob.getClass().getCanonicalName(), false);
                    fieldAux.setAttribute("isCollection", "false");
                    fieldElement.addContent((Content)fieldAux);
                    this.addEntity(fieldAux, ob, classes);
                }
            } else if (value != null) {
                this.addEntity(fieldElement, value, classes);
            }
        } else if (this.isPrimitive(returned, mh)) {
            fieldElement = this.addFieldRoot(mh.getName(), this.convertClass(returned.getCanonicalName()), true);
            fieldElement.setAttribute("isCollection", "false");
            if (value != null) {
                fieldElement.setText(this.convertValue(value, returned));
            }
        }
        return fieldElement;
    }

    private boolean isEntity(Class returned, List<ClassInfo> classes) {
        for (ClassInfo cl : classes) {
            if (!cl.getClassType().equals(returned)) continue;
            return true;
        }
        return false;
    }

    private boolean isPrimitive(Class returned, Method mh) {
        Id id = mh.getAnnotation(Id.class);
        Version version = mh.getAnnotation(Version.class);
        if (id != null || version != null) {
            return false;
        }
        if (returned.equals(Long.class)) {
            return true;
        }
        if (returned.equals(Integer.class)) {
            return true;
        }
        if (returned.equals(Short.class)) {
            return true;
        }
        if (returned.equals(Double.class)) {
            return true;
        }
        if (returned.equals(Float.class)) {
            return true;
        }
        if (returned.equals(String.class)) {
            return true;
        }
        if (returned.equals(java.util.Date.class)) {
            return true;
        }
        if (returned.equals(Date.class)) {
            return true;
        }
        return returned.equals(byte[].class);
    }

    private boolean constainsTransient(Method mh, Class annotationType) {
        return mh != null && mh.getAnnotation(annotationType) != null;
    }

    private boolean constainsTransient(Field field, Class annotationType) {
        return field != null && field.getAnnotation(annotationType) != null;
    }

    private Element addFieldRoot(String methodName, String className, Boolean isPrimitive) {
        Element field = new Element("field");
        field.setAttribute("setMethod", "set" + methodName.substring(3));
        field.setAttribute("classSetMethod", className);
        field.setAttribute("isPrimitive", isPrimitive.toString());
        return field;
    }

    private boolean isCollection(Object value) {
        if (value == null) {
            return false;
        }
        return Collection.class.isAssignableFrom(value.getClass());
    }

    private String convertValue(Object value, Class returned) {
        if (java.util.Date.class.equals((Object)returned) || Date.class.equals((Object)returned)) {
            return new SimpleDateFormat("ddMMyyyyHHmmss").format(value);
        }
        if (byte[].class.equals((Object)returned)) {
            return new String(Hex.encodeHex((byte[])((byte[])value)));
        }
        return ToolString.skipInvalidXMLChars((String)value.toString());
    }

    private String convergeCollectionClass(String canonicalName) throws ClassNotFoundException {
        if (Set.class.isAssignableFrom(Class.forName(canonicalName))) {
            return TreeSet.class.getCanonicalName();
        }
        if (Map.class.isAssignableFrom(Class.forName(canonicalName))) {
            return Map.class.getCanonicalName();
        }
        return LinkedList.class.getCanonicalName();
    }

    private String convertClass(String canonicalName) {
        return canonicalName;
    }
}

