/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.entityxml;

import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.file.ToolFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

class AuxImportFile {
    AuxImportFile() {
    }

    Object byteToEntity(byte[] data, Long versaoSistema, boolean showExceptionFieldNotFound, String basePackage) throws ExceptionIO {
        try {
            Document doc = new SAXBuilder().build((InputStream)new ByteArrayInputStream(data));
            return this.readDocument(doc, versaoSistema, showExceptionFieldNotFound, basePackage);
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public Object fileBase64ToEntity(File file, Long versaoSistema, boolean showExceptionFieldNotFound, String basePackage) throws ExceptionIO {
        try {
            String str = ToolFile.getConteudoArquivo((File)file);
            byte[] data = ToolBase64.decodeBase64((String)str);
            return this.byteToEntity(data, versaoSistema, showExceptionFieldNotFound, basePackage);
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public Object fileToEntity(File file, Long versaoSistema, boolean showExceptionFieldNotFound, String basePackage) throws ExceptionIO {
        try {
            Document doc = new SAXBuilder().build(file);
            return this.readDocument(doc, versaoSistema, showExceptionFieldNotFound, basePackage);
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public Object fileToEntity(InputStream file, Long versaoSistema, boolean showExceptionFieldNotFound, String basePackage) throws ExceptionIO {
        try {
            Document doc = new SAXBuilder().build(file);
            return this.readDocument(doc, versaoSistema, showExceptionFieldNotFound, basePackage);
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    private Object readDocument(Document doc, Long versaoSistema, boolean showExceptionFieldNotFound, String basePackage) throws Exception {
        Element el = doc.getRootElement();
        String classe = el.getAttributeValue("class");
        String systemVersionFile = el.getAttributeValue("system_version");
        String version = el.getAttributeValue("version");
        if (version == null || version.trim().length() <= 0) {
            throw new ExceptionInvalidData("E.GEN.000023", new Object[0]);
        }
        if (systemVersionFile == null || systemVersionFile.trim().length() <= 0) {
            throw new ExceptionInvalidData("E.GEN.000023", new Object[0]);
        }
        if (!Integer.valueOf(version).equals(1)) {
            throw new ExceptionInvalidData("E.GEN.000024", new Object[0]);
        }
        return this.buildEntity(el.getChildren(), classe, showExceptionFieldNotFound, basePackage);
    }

    private String getClasse(String basePackage, String classe) {
        if (basePackage != null) {
            basePackage = (String)basePackage + (((String)basePackage).endsWith(".") ? "" : ".");
            classe = ((String)classe).lastIndexOf(".") > 0 ? ((String)classe).substring(((String)classe).lastIndexOf(".") + 1) : classe;
            classe = (String)basePackage + (String)classe;
        }
        return classe;
    }

    private Object buildEntity(List<Element> children, String classe, boolean showExceptionFieldNotFound, String basePackage) throws Exception {
        if (children.isEmpty()) {
            return null;
        }
        Class<?> cl = Class.forName(this.getClasse(basePackage, classe));
        Object ob = cl.newInstance();
        try {
            for (Element ele : children) {
                Object aux;
                Method mh;
                String setMethod = ele.getAttributeValue("setMethod");
                String classSetMethod = ele.getAttributeValue("classSetMethod");
                String isPrimitive = ele.getAttributeValue("isPrimitive");
                String setValue = ele.getText();
                String isCollection = ele.getAttributeValue("isCollection");
                String collectionClass = ele.getAttributeValue("collectionClass");
                boolean autoDecode = true;
                if (Boolean.valueOf(isPrimitive).booleanValue()) {
                    mh = this.getDeclaredMethod(setMethod, cl, this.convertClass(classSetMethod), showExceptionFieldNotFound);
                    if (mh == null) {
                        autoDecode = false;
                    }
                    if (mh == null) continue;
                    aux = this.newPrimitive(setValue, classSetMethod, autoDecode);
                    mh.invoke(ob, aux);
                    continue;
                }
                if (Boolean.valueOf(isCollection).booleanValue()) {
                    mh = this.getDeclaredMethod(setMethod, cl, Class.forName(collectionClass), showExceptionFieldNotFound);
                    if (mh == null) continue;
                    Collection list = (Collection)Class.forName(collectionClass).newInstance();
                    List entitiesChildren = ele.getChildren();
                    for (Element entity : entitiesChildren) {
                        Object aux2 = this.buildEntity(entity.getChildren(), classSetMethod, showExceptionFieldNotFound, basePackage);
                        if (aux2 == null) continue;
                        list.add(aux2);
                    }
                    mh.invoke(ob, list);
                    continue;
                }
                try {
                    mh = this.getDeclaredMethod(setMethod, cl, Class.forName(this.getClasse(basePackage, classSetMethod)), showExceptionFieldNotFound);
                    if (mh == null) continue;
                    aux = this.buildEntity(ele.getChildren(), classSetMethod, showExceptionFieldNotFound, basePackage);
                    mh.invoke(ob, aux);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (NoSuchMethodException ex) {
            if (showExceptionFieldNotFound) {
                throw ex;
            }
            ex.printStackTrace();
        }
        return ob;
    }

    private Object newPrimitive(String setValue, String classSetMethod, boolean decode) throws Exception {
        if (setValue == null) {
            return null;
        }
        if (setValue.trim().length() > 0 && classSetMethod.equalsIgnoreCase(Long.class.getCanonicalName())) {
            return Long.valueOf(setValue);
        }
        if (setValue.trim().length() > 0 && classSetMethod.equalsIgnoreCase(Integer.class.getCanonicalName())) {
            return Integer.valueOf(setValue);
        }
        if (setValue.trim().length() > 0 && classSetMethod.equalsIgnoreCase(Short.class.getCanonicalName())) {
            return Short.valueOf(setValue);
        }
        if (setValue.trim().length() > 0 && classSetMethod.equalsIgnoreCase(Float.class.getCanonicalName())) {
            return Float.valueOf(setValue);
        }
        if (setValue.trim().length() > 0 && classSetMethod.equalsIgnoreCase(Double.class.getCanonicalName())) {
            return Double.valueOf(setValue);
        }
        if (setValue.trim().length() > 0 && classSetMethod.equalsIgnoreCase(String.class.getCanonicalName())) {
            return String.valueOf(setValue);
        }
        if (setValue.trim().length() > 0 && classSetMethod.equalsIgnoreCase(Date.class.getCanonicalName())) {
            return new SimpleDateFormat("ddMMyyyyHHmmss").parse(setValue);
        }
        if (byte[].class.getCanonicalName().equals(classSetMethod)) {
            if (decode) {
                return Hex.decodeHex((char[])setValue.toCharArray());
            }
            if (setValue != null) {
                return setValue.getBytes();
            }
        }
        return null;
    }

    private Method getDeclaredMethod(String setMethod, Class<?> fatherClass, Class setMethodClass, boolean showException) throws ExceptionInvalidData {
        Method[] methods;
        for (Method m : methods = fatherClass.getMethods()) {
            Class<?>[] paramTypes;
            if (!m.getName().equalsIgnoreCase(setMethod) || (paramTypes = m.getParameterTypes()).length != 1 || !paramTypes[0].isAssignableFrom(setMethodClass)) continue;
            return m;
        }
        if (showException) {
            throw new ExceptionInvalidData("E.GEN.000025", new Object[0]);
        }
        return null;
    }

    private Class<?> convertClass(String classe) throws ClassNotFoundException {
        if (classe.equalsIgnoreCase("byte[]")) {
            return byte[].class;
        }
        return Class.forName(classe);
    }

    public Object fileToEntity(String xml, Long versaoSistema, boolean showExceptionFieldNotFound, String basePackage) throws ExceptionIO {
        try {
            Document doc = new SAXBuilder().build((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")));
            return this.readDocument(doc, versaoSistema, showExceptionFieldNotFound, basePackage);
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }
}

