/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.esocfechamentofolha.eventos;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

class AuxFindMovimento1200DecimoTerceiro
extends BaseMethods {
    private final ServiceMovimentoFolhaImpl serviceMovimentoFolha;

    public List<HashMap> findMovimentosS1200(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, EmpresaRh empresaRh) throws ExceptionEsocial {
        ArrayList<HashMap> hashs = new ArrayList<HashMap>();
        List<MovimentoFolha> movFolhas = this.serviceMovimentoFolha.findMovimentosS1200DecTerc(dataInicial, dataFinal, grupoEmpresa);
        if (!AuxFindMovimento1200DecimoTerceiro.isWithData(movFolhas)) {
            return hashs;
        }
        for (MovimentoFolha movFolha : movFolhas) {
            HashMap h;
            if (!this.verificarValidacaoEventosFolha(movFolha).booleanValue() || !this.isNotNull(h = this.criarRubricas120013(movFolha, empresaRh)).booleanValue()) continue;
            hashs.add(h);
        }
        return hashs;
    }

    private Boolean verificarValidacaoEventosFolha(MovimentoFolha movFolha) {
        if (!AuxFindMovimento1200DecimoTerceiro.isWithData(movFolha.getItensMovimentoFolha())) {
            return false;
        }
        for (ItemMovimentoFolha i : movFolha.getItensMovimentoFolha()) {
            if (!(i.getValor() > 0.0)) continue;
            return true;
        }
        return false;
    }

    public HashMap criarRubricas120013(MovimentoFolha mov, EmpresaRh empresaRh) throws ExceptionEsocial {
        if (this.isNull(mov.getRubricas1200()).booleanValue()) {
            mov.setRubricas1200(new ArrayList());
        }
        ArrayList<Rubricas1200> rubricas = new ArrayList<Rubricas1200>();
        Double baseInssDec = 0.0;
        TipoCalculoEvento tp13 = empresaRh.getTpEventoPagDecimoTerceiro();
        if (this.isNull(tp13).booleanValue()) {
            throw new ExceptionEsocial("E.ERP.0050.003");
        }
        Double vlr13 = 0.0;
        for (ItemMovimentoFolha i : mov.getItensMovimentoFolha()) {
            TipoCalculoEvento tpEvento = i.getEventoColaborador().getTipoCalculoEvento();
            if (!(i.getValor() > 0.0) || !this.isNull(tpEvento.getEsocRubricasFolhaPagamento()).booleanValue() && this.isEquals(tpEvento.getEsocRubricasFolhaPagamento().getCodigo(), ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
            if (i.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue()) && (this.isAffimative(i.getEventoColaborador().getTipoCalculoEvento().getMedia13Salario()) || this.isEquals(i.getEventoColaborador().getTipoCalculoEvento(), tp13))) {
                vlr13 = vlr13 + this.arredondaNumero(i.getValor(), 2);
                baseInssDec = baseInssDec + i.getValor();
                continue;
            }
            if (this.isAffimative(i.getEventoColaborador().getTipoCalculoEvento().getMedia13Salario())) {
                baseInssDec = baseInssDec - i.getValor();
                rubricas.add(new Rubricas1200(i.getEventoColaborador().getTipoCalculoEvento(), Double.valueOf(0.0), i.getValor(), mov));
                continue;
            }
            rubricas.add(new Rubricas1200(i.getEventoColaborador().getTipoCalculoEvento(), Double.valueOf(0.0), i.getValor(), mov));
        }
        rubricas.add(new Rubricas1200(tp13, Double.valueOf(0.0), vlr13, mov));
        rubricas.add(new Rubricas1200(empresaRh.getEventoBaseFgtsDecimoTerceiro(), Double.valueOf(0.0), mov.getBcFgts13Sal(), mov));
        rubricas.add(new Rubricas1200(empresaRh.getTpFgts(), Double.valueOf(0.0), mov.getVrFgts13Sal(), mov));
        rubricas.add(new Rubricas1200(empresaRh.getTpIrrfDec(), Double.valueOf(0.0), mov.getVrIrrf13Sal(), mov));
        rubricas.add(new Rubricas1200(empresaRh.getTpInssDec(), mov.getAliqInss13Sal(), mov.getVrInss13Sal(), mov));
        rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInssDec(), Double.valueOf(0.0), baseInssDec, mov));
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("FOLHA", mov);
        h.put("RUBRICAS", rubricas);
        return h;
    }

    @Generated
    public AuxFindMovimento1200DecimoTerceiro(ServiceMovimentoFolhaImpl serviceMovimentoFolha) {
        this.serviceMovimentoFolha = serviceMovimentoFolha;
    }
}

