/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.esocfechamentofolha.eventos;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodo;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodoItem;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemMovimentoFerias;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.RubricasFerias;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.feriascolaborador.ServiceFeriasColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

class AuxFindMovimentosS1200
extends BaseMethods {
    private final ServiceMovimentoFolhaImpl serviceMovimentoFolha;
    private final ServiceFeriasColaboradorImpl serviceFeriasColaborador;

    public List<HashMap> findMovimentosS1200(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, EmpresaRh empresaRh) throws ExceptionEsocial {
        List<FeriasColaborador> ferias;
        ArrayList<HashMap> hashs = new ArrayList<HashMap>();
        List<MovimentoFolha> movFolhas = this.serviceMovimentoFolha.findMovimentosS1200(dataInicial, dataFinal, grupoEmpresa);
        if (AuxFindMovimentosS1200.isWithData(movFolhas)) {
            for (MovimentoFolha movFolha : movFolhas) {
                if (!this.verificarValidacaoEventosFolha(movFolha)) continue;
                HashMap h = null;
                if (!(this.isEquals(movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha(), EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue()) || this.isEquals(movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha(), EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue()) || this.isEquals(movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha(), EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_13O.getValue()))) {
                    if (!this.isEquals(movFolha.getColaborador().getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.AUTONOMO_FRETE.getValue())) {
                        h = this.criarRubricas1200(movFolha, empresaRh);
                    } else {
                        if (this.isNull(empresaRh.getVrBaseInssAutonomoFrete()).booleanValue() || this.isNull(empresaRh.getVrBaseIrrfAutonomoFrete()).booleanValue()) {
                            throw new ExceptionEsocial("E.ERP.0050.001");
                        }
                        h = this.criarRubricas1200AutonomoFrete(movFolha, empresaRh, hashs);
                    }
                } else if (movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_13O.getValue())) {
                    h = this.criarRubricas1200Adiantamento13(movFolha, empresaRh);
                } else if (movFolha.getPagamentoFolhaComplementar() == null && movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue())) {
                    h = this.criarRubricas1200(movFolha, empresaRh);
                } else if (movFolha.getPagamentoFolhaComplementar() != null && movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue())) {
                    h = null;
                    List<HashMap> aux = this.criarRubricas1200FolhaComplementar(movFolha, empresaRh);
                    for (HashMap hashMap : aux) {
                        hashs.add(hashMap);
                    }
                }
                if (h == null) continue;
                hashs.add(h);
            }
        }
        if (AuxFindMovimentosS1200.isWithData(ferias = this.serviceFeriasColaborador.findMovimentosS1200(dataInicial, dataFinal, grupoEmpresa))) {
            for (FeriasColaborador f : ferias) {
                hashs.add(this.criarRubricasFerias(f, empresaRh));
            }
        }
        return hashs;
    }

    private HashMap criarRubricasFerias(FeriasColaborador f, EmpresaRh empresaRh) {
        if (this.isNull(f.getRubricasFerias()).booleanValue()) {
            f.setRubricasFerias(new ArrayList());
        }
        ArrayList<RubricasFerias> rubricasFerias = new ArrayList<RubricasFerias>();
        Double baseIrrfFerias = 0.0;
        Double baseInssFerias = 0.0;
        Double valorAntecipacaoFerias = 0.0;
        for (ItemMovimentoFerias i : f.getItemMovimentoFerias()) {
            TipoCalculoEvento tipo = i.getEventoColaborador().getTipoCalculoEvento();
            String codigoEsocRubricaPrev = i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo();
            String codigoEsocTipoRubrica = i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo();
            if (!this.isEquals(codigoEsocRubricaPrev, "11")) {
                rubricasFerias.add(new RubricasFerias(tipo, Double.valueOf(0.0), i.getValor(), f));
            }
            if (this.isEquals(codigoEsocRubricaPrev, "11") && this.isEquals(codigoEsocTipoRubrica, "1")) {
                baseInssFerias = baseInssFerias + this.arredondaNumero(i.getValor(), 2);
                baseInssFerias = this.arredondaNumero(baseInssFerias, 2);
                valorAntecipacaoFerias = valorAntecipacaoFerias + this.arredondaNumero(i.getValor(), 2);
                valorAntecipacaoFerias = this.arredondaNumero(valorAntecipacaoFerias, 2);
            } else if (this.isEquals(codigoEsocRubricaPrev, "11")) {
                baseInssFerias = baseInssFerias - this.arredondaNumero(i.getValor(), 2);
                baseInssFerias = this.arredondaNumero(baseInssFerias, 2);
                valorAntecipacaoFerias = valorAntecipacaoFerias - this.arredondaNumero(i.getValor(), 2);
                valorAntecipacaoFerias = this.arredondaNumero(valorAntecipacaoFerias, 2);
            }
            String codigoEsocRubricaIrrf = i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo();
            if (this.isEquals(codigoEsocRubricaIrrf, "13") && i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseIrrfFerias = baseIrrfFerias + this.arredondaNumero(i.getValor(), 2);
                baseIrrfFerias = this.arredondaNumero(baseIrrfFerias, 2);
                continue;
            }
            if (!this.isEquals(codigoEsocRubricaIrrf, "13")) continue;
            baseIrrfFerias = baseIrrfFerias - this.arredondaNumero(i.getValor(), 2);
            baseIrrfFerias = this.arredondaNumero(baseIrrfFerias, 2);
        }
        if (valorAntecipacaoFerias > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpAntecipacaoFerias(), Double.valueOf(0.0), valorAntecipacaoFerias, f));
        }
        if (f.getVrIrrfFerias() > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpIrrfFerias(), Double.valueOf(0.0), f.getVrIrrfFerias(), f));
        }
        if (f.getVrInssFerias() > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpInssFerias(), Double.valueOf(0.0), f.getVrInssFerias(), f));
        }
        if (baseIrrfFerias > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getEventoBaseIrrfFerias(), Double.valueOf(0.0), baseIrrfFerias, f));
        }
        if (baseInssFerias > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getEventoBaseInss(), Double.valueOf(0.0), baseInssFerias, f));
        }
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("FERIAS", f);
        h.put("RUBRICAS_FERIAS", rubricasFerias);
        h.put("COLABORADOR", f.getPeriodoAqFeriasColab().getColaborador());
        return h;
    }

    public List<HashMap> criarRubricas1200FolhaComplementar(MovimentoFolha m, EmpresaRh empresaRh) {
        ArrayList<HashMap> hashs = new ArrayList<HashMap>();
        if (this.isNotNull(m.getPagamentoFolhaComplementar()).booleanValue() && AuxFindMovimentosS1200.isWithData(m.getPagamentoFolhaComplementar().getFolhaComplementares())) {
            for (FolhaComplementarPeriodo folha : m.getPagamentoFolhaComplementar().getFolhaComplementares()) {
                if (folha.getRubricas1200() == null) {
                    folha.setRubricas1200(new ArrayList());
                }
                ArrayList<Rubricas1200> rubricas = new ArrayList<Rubricas1200>();
                if (AuxFindMovimentosS1200.isWithData(folha.getFolhaComplementarPeriodoItem())) {
                    for (FolhaComplementarPeriodoItem item : folha.getFolhaComplementarPeriodoItem()) {
                        TipoCalculoEvento tp = item.getTipoCalculoEvento();
                        if (!(item.getValorComplemento() > 0.0) || !this.isNull(tp.getEsocRubricasFolhaPagamento()).booleanValue() && this.isEquals(tp.getEsocRubricasFolhaPagamento().getCodigo(), ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
                        rubricas.add(new Rubricas1200(tp, item.getValorComplemento(), folha));
                    }
                }
                if (folha.getVrInss() > 0.0) {
                    rubricas.add(new Rubricas1200(empresaRh.getTpInss(), folha.getVrInss(), folha));
                }
                if (folha.getVrInssDec() > 0.0) {
                    rubricas.add(new Rubricas1200(empresaRh.getTpInssDec(), folha.getVrInssDec(), folha));
                }
                if (folha.getBaseInss() > 0.0) {
                    rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInss(), folha.getBaseInss(), folha));
                }
                if (folha.getBaseInssDec() > 0.0) {
                    rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInssDec(), folha.getBaseInssDec(), folha));
                }
                if (folha.getBaseFgts() > 0.0) {
                    rubricas.add(new Rubricas1200(empresaRh.getEventoBaseFgts(), folha.getBaseFgts(), folha));
                }
                if (folha.getVrFgts() > 0.0) {
                    rubricas.add(new Rubricas1200(empresaRh.getTpFgts(), folha.getVrFgts(), folha));
                }
                HashMap<String, Object> h = new HashMap<String, Object>();
                h.put("FOLHA", m);
                h.put("FOLHA_COMP", folha);
                h.put("RUBRICAS", rubricas);
                hashs.add(h);
            }
        }
        return hashs;
    }

    public HashMap criarRubricas1200Adiantamento13(MovimentoFolha mov, EmpresaRh empresaRh) throws ExceptionEsocial {
        if (mov.getRubricas1200() == null) {
            mov.setRubricas1200(new ArrayList());
        }
        ArrayList<Rubricas1200> rubricas = new ArrayList<Rubricas1200>();
        TipoCalculoEvento tp = empresaRh.getTpAddDec();
        if (this.isNull(tp).booleanValue()) {
            throw new ExceptionEsocial("E.ERP.0050.002");
        }
        Double vlrAdd = 0.0;
        for (ItemMovimentoFolha i : mov.getItensMovimentoFolha()) {
            TipoCalculoEvento tpEvento = i.getEventoColaborador().getTipoCalculoEvento();
            if (!(i.getValor() > 0.0) || !this.isNull(tpEvento.getEsocRubricasFolhaPagamento()).booleanValue() && this.isEquals(tpEvento.getEsocRubricasFolhaPagamento().getCodigo(), ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
            if (this.isEquals(i.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento(), EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue()) && (this.isAffimative(i.getEventoColaborador().getTipoCalculoEvento().getMedia13Salario()) || this.isEquals(i.getEventoColaborador().getTipoCalculoEvento(), tp))) {
                vlrAdd = vlrAdd + this.arredondaNumero(i.getValor(), 2);
                continue;
            }
            if (this.isAffimative(i.getEventoColaborador().getTipoCalculoEvento().getMedia13Salario())) {
                vlrAdd = vlrAdd - this.arredondaNumero(i.getValor(), 2);
                continue;
            }
            rubricas.add(new Rubricas1200(i.getEventoColaborador().getTipoCalculoEvento(), Double.valueOf(0.0), i.getValor(), mov));
        }
        rubricas.add(new Rubricas1200(tp, Double.valueOf(0.0), vlrAdd, mov));
        rubricas.add(new Rubricas1200(empresaRh.getEventoBaseFgtsDecimoTerceiro(), Double.valueOf(0.0), mov.getBcFgts13Sal(), mov));
        rubricas.add(new Rubricas1200(empresaRh.getTpFgts(), Double.valueOf(0.0), mov.getVrFgts13Sal(), mov));
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("FOLHA", mov);
        h.put("RUBRICAS", rubricas);
        return h;
    }

    public HashMap criarRubricas1200AutonomoFrete(MovimentoFolha movFolha, EmpresaRh empresaRh, List<HashMap> hashs) {
        Double valorRubrica;
        HashMap h = null;
        MovimentoFolha movAux = null;
        for (HashMap hash : hashs) {
            MovimentoFolha m = (MovimentoFolha)hash.get("FOLHA");
            if (!this.isEquals(ToolString.refina((String)movFolha.getColaborador().getPessoa().getComplemento().getCnpj()), ToolString.refina((String)m.getColaborador().getPessoa().getComplemento().getCnpj()))) continue;
            h = hash;
            movAux = m;
            break;
        }
        if (this.isNull(h).booleanValue()) {
            h = new HashMap();
            movAux = movFolha;
        }
        Double bcInss = 0.0;
        Double bcIrrf = 0.0;
        Double totalPrestacaoServico = 0.0;
        TipoCalculoEvento tpPrestacaoServico = null;
        bcInss = movFolha.getBcInssSalario();
        bcIrrf = movFolha.getBcIrrfSalario();
        for (Object item : movFolha.getItensMovimentoFolha()) {
            if (!this.isEquals(item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricasFolhaPagamento().getCodigo(), ConstantsESocial.CODIGO_PRESTACAO_SERVICO)) continue;
            totalPrestacaoServico = totalPrestacaoServico + item.getValor();
            tpPrestacaoServico = item.getEventoColaborador().getTipoCalculoEvento();
        }
        ArrayList<Rubricas1200> rubricas = new ArrayList<Rubricas1200>();
        totalPrestacaoServico = this.arredondaNumero(totalPrestacaoServico - bcInss - bcIrrf, 2);
        for (ItemMovimentoFolha item : movFolha.getItensMovimentoFolha()) {
            TipoCalculoEvento tp = item.getEventoColaborador().getTipoCalculoEvento();
            if (!(item.getValor() > 0.0) || this.isEquals(tp.getEsocRubricasFolhaPagamento().getCodigo(), ConstantsESocial.CODIGO_PRESTACAO_SERVICO)) continue;
            rubricas.add(new Rubricas1200(tp, item.getReferencia(), item.getValor(), movAux));
        }
        if (totalPrestacaoServico > 0.0 && this.isNotNull(tpPrestacaoServico).booleanValue()) {
            rubricas.add(new Rubricas1200(tpPrestacaoServico, Double.valueOf(0.0), totalPrestacaoServico, movAux));
        }
        if (bcInss > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInss(), Double.valueOf(0.0), bcInss, movAux));
            rubricas.add(new Rubricas1200(empresaRh.getVrBaseInssAutonomoFrete(), Double.valueOf(0.0), bcInss, movAux));
        }
        if (bcIrrf > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getVrBaseIrrfAutonomoFrete(), Double.valueOf(0.0), bcIrrf, movAux));
        }
        if ((valorRubrica = Double.valueOf(movFolha.getVrInssSalario() + movFolha.getVrInssFerias())) > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpInss(), movFolha.getAliqInssSalario(), valorRubrica, movAux));
        }
        if (movFolha.getVrInss13Sal() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpInssDec(), movFolha.getAliqInss13Sal(), movFolha.getVrInss13Sal(), movAux));
        }
        if (!this.isNull(h.get("RUBRICAS")).booleanValue()) {
            List rubricasAux = (List)h.get("RUBRICAS");
            rubricas.addAll(rubricasAux);
            h.put("RUBRICAS", rubricas);
            return null;
        }
        h.put("FOLHA", movAux);
        h.put("RUBRICAS", rubricas);
        return h;
    }

    public HashMap criarRubricas1200(MovimentoFolha mov, EmpresaRh empresaRh) {
        if (this.isNull(mov.getRubricas1200()).booleanValue()) {
            mov.setRubricas1200(new ArrayList());
        }
        ArrayList<Rubricas1200> rubricas = new ArrayList<Rubricas1200>();
        Double baseInss = 0.0;
        Double baseInssDec = 0.0;
        Double baseFgts = 0.0;
        Double baseFgtsDec = 0.0;
        for (ItemMovimentoFolha item : mov.getItensMovimentoFolha()) {
            TipoCalculoEvento tp = item.getEventoColaborador().getTipoCalculoEvento();
            if (this.isAffimative(tp.getDescartarRubricaEsocial())) continue;
            if (item.getValor() > 0.0 && this.isNotNull(tp.getEsocRubricasFolhaPagamento()).booleanValue()) {
                rubricas.add(new Rubricas1200(tp, item.getReferencia(), item.getValor(), mov));
            }
            String codigoRubricaPrev = item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo();
            String codigoEsocTipoRubrica = item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo();
            if ((this.isEquals(codigoRubricaPrev, "11") || this.isEquals(codigoRubricaPrev, "15") || this.isEquals(codigoRubricaPrev, "21")) && this.isEquals(codigoEsocTipoRubrica, "1")) {
                baseInss = baseInss + this.arredondaNumero(item.getValor(), 2);
                baseInss = this.arredondaNumero(baseInss, 2);
            } else if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11")) {
                baseInss = baseInss - this.arredondaNumero(item.getValor(), 2);
                baseInss = this.arredondaNumero(baseInss, 2);
            }
            if (this.isEquals(codigoRubricaPrev, "12") && this.isEquals(codigoEsocTipoRubrica, "1")) {
                baseInssDec = baseInssDec + this.arredondaNumero(item.getValor(), 2);
                baseInssDec = this.arredondaNumero(baseInssDec, 2);
            } else if (this.isEquals(codigoRubricaPrev, "12")) {
                baseInssDec = baseInssDec - this.arredondaNumero(item.getValor(), 2);
                baseInssDec = this.arredondaNumero(baseInssDec, 2);
            }
            String codigoRubricaFgts = item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo();
            if (this.isEquals(codigoRubricaFgts, "11") && this.isEquals(codigoEsocTipoRubrica, "1")) {
                baseFgts = baseFgts + this.arredondaNumero(item.getValor(), 2);
                baseFgts = this.arredondaNumero(baseFgts, 2);
            } else if (this.isEquals(codigoRubricaFgts, "11")) {
                baseFgts = baseFgts - this.arredondaNumero(item.getValor(), 2);
                baseFgts = this.arredondaNumero(baseFgts, 2);
            }
            if (this.isEquals(codigoRubricaFgts, "12") && this.isEquals(codigoEsocTipoRubrica, "1")) {
                baseFgtsDec = baseFgtsDec + this.arredondaNumero(item.getValor(), 2);
                baseFgtsDec = this.arredondaNumero(baseFgtsDec, 2);
                continue;
            }
            if (!this.isEquals(codigoRubricaFgts, "12")) continue;
            baseFgtsDec = baseFgtsDec - this.arredondaNumero(item.getValor(), 2);
            baseFgtsDec = this.arredondaNumero(baseFgtsDec, 2);
        }
        Double valorRubrica = mov.getVrInssSalario() + mov.getVrInssFerias();
        if (valorRubrica > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpInss(), mov.getAliqInssSalario(), valorRubrica, mov));
        }
        if (mov.getVrInss13Sal() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpInssDec(), mov.getAliqInss13Sal(), mov.getVrInss13Sal(), mov));
        }
        if (mov.getVrInssFerias() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoDevolucaoInssFerias(), mov.getAliqInssFerias(), mov.getVrInssFerias(), mov));
        }
        if (baseInss > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInss(), Double.valueOf(0.0), baseInss, mov));
        }
        if (baseInssDec > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInssDec(), Double.valueOf(0.0), baseInssDec, mov));
        }
        if (baseFgts > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoBaseFgts(), Double.valueOf(0.0), baseFgts, mov));
        }
        if (baseFgtsDec > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoBaseFgtsDecimoTerceiro(), Double.valueOf(0.0), baseFgtsDec, mov));
        }
        if (mov.getVrIrrfSalario() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpIrrf(), Double.valueOf(0.0), mov.getVrIrrfSalario(), mov));
        }
        if (mov.getVrIrrf13Sal() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpIrrfDec(), Double.valueOf(0.0), mov.getVrIrrf13Sal(), mov));
        }
        if ((valorRubrica = Double.valueOf(mov.getVrFgts13Sal() + mov.getVrFgtsFerias() + mov.getVrFgtsSalario())) > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpFgts(), Double.valueOf(0.0), valorRubrica, mov));
        }
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("FOLHA", mov);
        h.put("RUBRICAS", rubricas);
        return h;
    }

    private boolean verificarValidacaoEventosFolha(MovimentoFolha movFolha) {
        if (!AuxFindMovimentosS1200.isWithData(movFolha.getItensMovimentoFolha())) {
            return false;
        }
        for (ItemMovimentoFolha i : movFolha.getItensMovimentoFolha()) {
            if (!(i.getValor() > 0.0)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public AuxFindMovimentosS1200(ServiceMovimentoFolhaImpl serviceMovimentoFolha, ServiceFeriasColaboradorImpl serviceFeriasColaborador) {
        this.serviceMovimentoFolha = serviceMovimentoFolha;
        this.serviceFeriasColaborador = serviceFeriasColaborador;
    }
}

