/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.esocfechamentofolha.eventos;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstRegistroESocial;
import com.touchcomp.basementor.model.vo.ESocS1020;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocItemS1020;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodo;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodoItem;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemMovimentoFerias;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.ItemMovimentoRescisao;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.Rubricas1210;
import com.touchcomp.basementor.model.vo.RubricasFerias;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.components.esocfechamentofolha.eventos.AuxFindMovimentoS1210;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import com.touchcomp.basementorservice.service.impl.feriascolaborador.ServiceFeriasColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import com.touchcomp.basementorservice.service.impl.recisao.ServiceRecisaoImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

class AuxGeracao1210
extends BaseMethods {
    private final HelperEsocPreEvento helperEsocPreEvento;
    private final ServiceEsocPreEventoImpl serviceEsocPreEvento;
    private final ServiceMovimentoFolhaImpl serviceMovimentoFolha;
    private final ServiceFeriasColaboradorImpl serviceFeriasColaborador;
    private final ServiceRecisaoImpl serviceRecisao;

    public List findMovimentosS1210(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, EmpresaRh empresaRh) {
        List<MovimentoFolha> movFolhas;
        ArrayList<HashMap> hashs = new ArrayList<HashMap>();
        List<Recisao> retornoRescisoes = this.serviceRecisao.findMovimentosS1210(dataInicial, dataFinal, grupoEmpresa);
        if (AuxGeracao1210.isWithData(retornoRescisoes)) {
            for (Recisao recisao : retornoRescisoes) {
                if (!this.validarRescisao(recisao).booleanValue()) continue;
                HashMap<String, Object> h = new HashMap<String, Object>();
                h.put("RECISAO", recisao);
                h.put("COLABORADOR", recisao.getColaborador());
                hashs.add(h);
            }
        }
        if (AuxGeracao1210.isWithData(movFolhas = this.serviceMovimentoFolha.findMovimentosS1210(dataInicial, dataFinal, grupoEmpresa))) {
            for (MovimentoFolha m : movFolhas) {
                if (!this.verificarValidacaoEventosFolha(m).booleanValue()) continue;
                if (this.isNull(m.getPagamentoFolhaComplementar()).booleanValue()) {
                    HashMap h = this.criarRubricas1210Folha(m, empresaRh);
                    hashs.add(h);
                    continue;
                }
                if (!this.isNotNull(m.getPagamentoFolhaComplementar()).booleanValue()) continue;
                List<HashMap> hashComp = this.criarRubricaFolhaComplementar(m, empresaRh);
                for (HashMap hashMap : hashComp) {
                    hashs.add(hashMap);
                }
            }
        }
        List<FeriasColaborador> list = this.serviceFeriasColaborador.findMovimentosS1210(dataInicial, dataFinal, grupoEmpresa);
        for (FeriasColaborador f : list) {
            hashs.add(this.criarRubricasFerias(f, empresaRh));
        }
        if (!AuxGeracao1210.isWithData(hashs)) {
            return new ArrayList();
        }
        return hashs;
    }

    private HashMap criarRubricasFerias(FeriasColaborador f, EmpresaRh empresaRh) {
        if (AuxGeracao1210.isWithData(f.getRubricasFerias())) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("FERIAS", f);
            h.put("COLABORADOR", f.getPeriodoAqFeriasColab().getColaborador());
            return h;
        }
        ArrayList<RubricasFerias> rubricasFerias = new ArrayList<RubricasFerias>();
        Double baseIrrfFerias = 0.0;
        Double baseInssFerias = 0.0;
        Double valorAntecipacaoFerias = 0.0;
        for (ItemMovimentoFerias i : f.getItemMovimentoFerias()) {
            TipoCalculoEvento tipo = i.getEventoColaborador().getTipoCalculoEvento();
            if (!this.isEquals(i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo(), "11")) {
                rubricasFerias.add(new RubricasFerias(tipo, Double.valueOf(0.0), i.getValor(), f));
            }
            if (this.isEquals(i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo(), "11") && this.isEquals(i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo(), "1")) {
                baseInssFerias = baseInssFerias + this.arredondaNumero(i.getValor(), 2);
                baseInssFerias = this.arredondaNumero(baseInssFerias, 2);
                valorAntecipacaoFerias = valorAntecipacaoFerias + this.arredondaNumero(i.getValor(), 2);
                valorAntecipacaoFerias = this.arredondaNumero(valorAntecipacaoFerias, 2);
            } else if (this.isEquals(i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo(), "11")) {
                baseInssFerias = baseInssFerias - this.arredondaNumero(i.getValor(), 2);
                baseInssFerias = this.arredondaNumero(baseInssFerias, 2);
                valorAntecipacaoFerias = valorAntecipacaoFerias - this.arredondaNumero(i.getValor(), 2);
                valorAntecipacaoFerias = this.arredondaNumero(valorAntecipacaoFerias, 2);
            }
            if (this.isEquals(i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo(), "13") && this.isEquals(i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo(), "1")) {
                baseIrrfFerias = baseIrrfFerias + this.arredondaNumero(i.getValor(), 2);
                baseIrrfFerias = this.arredondaNumero(baseIrrfFerias, 2);
                continue;
            }
            if (!this.isEquals(i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo(), "13")) continue;
            baseIrrfFerias = baseIrrfFerias - this.arredondaNumero(i.getValor(), 2);
            baseIrrfFerias = this.arredondaNumero(baseIrrfFerias, 2);
        }
        if (valorAntecipacaoFerias > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpAntecipacaoFerias(), Double.valueOf(0.0), valorAntecipacaoFerias, f));
        }
        if (f.getVrIrrfFerias() > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpIrrfFerias(), Double.valueOf(0.0), f.getVrIrrfFerias(), f));
        }
        if (f.getVrInssFerias() > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpInssFerias(), Double.valueOf(0.0), f.getVrInssFerias(), f));
        }
        if (baseIrrfFerias > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getEventoBaseIrrfFerias(), Double.valueOf(0.0), baseIrrfFerias, f));
        }
        if (baseInssFerias > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getEventoBaseInss(), Double.valueOf(0.0), baseInssFerias, f));
        }
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("FERIAS", f);
        h.put("RUBRICAS_FERIAS", rubricasFerias);
        h.put("COLABORADOR", f.getPeriodoAqFeriasColab().getColaborador());
        return h;
    }

    private List<HashMap> criarRubricaFolhaComplementar(MovimentoFolha mov, EmpresaRh empresaRh) {
        ArrayList<HashMap> hashs = new ArrayList<HashMap>();
        if (AuxGeracao1210.isWithData(mov.getPagamentoFolhaComplementar().getFolhaComplementares())) {
            for (FolhaComplementarPeriodo folhaComp : mov.getPagamentoFolhaComplementar().getFolhaComplementares()) {
                ArrayList<Rubricas1210> rubricas = new ArrayList<Rubricas1210>();
                if (this.isNull(folhaComp.getRubricas1210()).booleanValue()) {
                    folhaComp.setRubricas1210(new ArrayList());
                }
                if (AuxGeracao1210.isWithData(folhaComp.getFolhaComplementarPeriodoItem())) {
                    for (FolhaComplementarPeriodoItem i : folhaComp.getFolhaComplementarPeriodoItem()) {
                        TipoCalculoEvento tp = i.getTipoCalculoEvento();
                        if (!(i.getValorComplemento() > 0.0) || !this.isNotNull(tp.getEsocRubricasFolhaPagamento()).booleanValue() || !this.isEquals(tp.getEsocRubricasFolhaPagamento().getCodigo(), ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
                        rubricas.add(new Rubricas1210(tp, i.getValorComplemento(), folhaComp));
                    }
                }
                if (folhaComp.getVrIrrf() > 0.0) {
                    rubricas.add(new Rubricas1210(empresaRh.getTpIrrf(), folhaComp.getVrIrrf(), folhaComp));
                }
                if (folhaComp.getVrIrrfDec() > 0.0) {
                    rubricas.add(new Rubricas1210(empresaRh.getTpIrrfDec(), folhaComp.getVrIrrfDec(), folhaComp));
                }
                HashMap<String, Object> h = new HashMap<String, Object>();
                h.put("FOLHA", mov);
                h.put("RUBRICAS", rubricas);
                h.put("FOLHA_COMP", folhaComp);
                h.put("COLABORADOR", mov.getColaborador());
                hashs.add(h);
            }
        }
        return hashs;
    }

    public HashMap criarRubricas1210Folha(MovimentoFolha m, EmpresaRh empresaRh) {
        Double valorRubrica;
        if (this.isNull(m.getRubricas1210()).booleanValue()) {
            m.setRubricas1210(new ArrayList());
        }
        if (this.isEquals(m.getColaborador().getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.AUTONOMO.getValue()) && this.isEquals(m.getColaborador().getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.AUTONOMO_FRETE.getValue()) && !AuxGeracao1210.isWithData(m.getRubricas1200())) {
            return null;
        }
        ArrayList<Rubricas1210> rubricas = new ArrayList<Rubricas1210>();
        Double baseIrrf = 0.0;
        Double baseIrrfDec = 0.0;
        for (ItemMovimentoFolha i : m.getItensMovimentoFolha()) {
            TipoCalculoEvento tp = i.getEventoColaborador().getTipoCalculoEvento();
            if (!(i.getValor() > 0.0) || !this.isNotNull(tp.getEsocRubricasFolhaPagamento()).booleanValue() || this.isEquals(tp.getEsocRubricasFolhaPagamento().getCodigo(), ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) {
                // empty if block
            }
            if (this.isEquals(i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo(), "11") && this.isEquals(i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo(), "1")) {
                baseIrrf = baseIrrf + this.arredondaNumero(i.getValor(), 2);
                baseIrrf = this.arredondaNumero(baseIrrf, 2);
            } else if (this.isEquals(i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo(), "11")) {
                baseIrrf = baseIrrf - this.arredondaNumero(i.getValor(), 2);
                baseIrrf = this.arredondaNumero(baseIrrf, 2);
            }
            if (this.isEquals(i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo(), "12") && this.isEquals(i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo(), "1")) {
                baseIrrfDec = baseIrrfDec + this.arredondaNumero(i.getValor(), 2);
                baseIrrfDec = this.arredondaNumero(baseIrrfDec, 2);
                continue;
            }
            if (!this.isEquals(i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo(), "12")) continue;
            baseIrrfDec = baseIrrfDec - this.arredondaNumero(i.getValor(), 2);
            baseIrrfDec = this.arredondaNumero(baseIrrfDec, 2);
        }
        if (m.getVrIrrfSalario() > 0.0) {
            rubricas.add(new Rubricas1210(empresaRh.getTpIrrf(), Double.valueOf(0.0), m.getVrIrrfSalario(), m));
        }
        if (m.getVrIrrf13Sal() > 0.0) {
            rubricas.add(new Rubricas1210(empresaRh.getTpIrrfDec(), Double.valueOf(0.0), m.getVrIrrf13Sal(), m));
        }
        if ((valorRubrica = Double.valueOf(baseIrrf - m.getVrInssSalario())) > 0.0) {
            rubricas.add(new Rubricas1210(empresaRh.getEventoBaseIrrf(), Double.valueOf(0.0), valorRubrica, m));
        }
        if ((valorRubrica = Double.valueOf(baseIrrfDec - m.getVrInss13Sal())) > 0.0) {
            rubricas.add(new Rubricas1210(empresaRh.getEventoBaseIrrfDec(), Double.valueOf(0.0), valorRubrica, m));
        }
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("FOLHA", m);
        h.put("RUBRICAS", rubricas);
        h.put("COLABORADOR", m.getColaborador());
        return h;
    }

    private Boolean validarRescisao(Recisao r) {
        if (!AuxGeracao1210.isWithData(r.getItemRescisao())) {
            return false;
        }
        for (ItemMovimentoRescisao item : r.getItemRescisao()) {
            if (!(item.getValor() > 0.0)) continue;
            return true;
        }
        return false;
    }

    private Boolean verificarValidacaoEventosFolha(MovimentoFolha movFolha) {
        if (!AuxGeracao1210.isWithData(movFolha.getItensMovimentoFolha())) {
            return false;
        }
        for (ItemMovimentoFolha i : movFolha.getItensMovimentoFolha()) {
            if (!(i.getValor() > 0.0)) continue;
            return true;
        }
        return false;
    }

    public void geracaoEventoRetificacaoS1210(ESocS1020 vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao tipoEvento, EmpresaRh empresaRh) throws ExceptionEsocial {
        for (EsocPreEvento esocPreEvento : vo.getPreEventosEsocial()) {
            if (!this.isEquals(esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa(), empresa.getEmpresaDados().getGrupoEmpresa()) || !this.isNull(esocPreEvento.getEventoPosterior()).booleanValue() || !this.isEquals(esocPreEvento.getTipoEventoEsocial().getIdentificador(), EnumConstRegistroESocial.REGISTRO_1210.getValue()) || !this.isEquals(esocPreEvento.getEventoProdRestritaProducao(), tipoEvento.getValue())) continue;
            if (this.isNull(esocPreEvento.getEsocEvento()).booleanValue() || !this.isStrWithData(esocPreEvento.getEsocEvento().getNrRecibo())) {
                this.recalcularEventos(vo, empresaRh);
                return;
            }
            EsocPreEvento preEvento = this.helperEsocPreEvento.getEvento(vo, usuario, empresa, tipoEvento, (Short)EnumConstantsMentorSimNao.SIM.getValue());
            if (!this.isNotNull(preEvento).booleanValue()) continue;
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.getValue()));
            preEvento.setEventoAnterior(esocPreEvento);
            esocPreEvento.setEventoPosterior(preEvento);
            this.serviceEsocPreEvento.saveOrUpdate(esocPreEvento);
            this.recalcularEventos(vo, empresaRh);
        }
    }

    private void recalcularEventos(ESocS1020 vo, EmpresaRh empresa) {
        for (EsocItemS1020 i : vo.getItensS1020()) {
            MovimentoFolha mov = i.getMovimentoFolha();
            if (!this.isNotNull(mov).booleanValue()) continue;
            new AuxFindMovimentoS1210().criarRubricas1210FolhaRetificacao(mov, empresa);
            this.serviceMovimentoFolha.saveOrUpdate(mov);
        }
    }

    @Generated
    public AuxGeracao1210(HelperEsocPreEvento helperEsocPreEvento, ServiceEsocPreEventoImpl serviceEsocPreEvento, ServiceMovimentoFolhaImpl serviceMovimentoFolha, ServiceFeriasColaboradorImpl serviceFeriasColaborador, ServiceRecisaoImpl serviceRecisao) {
        this.helperEsocPreEvento = helperEsocPreEvento;
        this.serviceEsocPreEvento = serviceEsocPreEvento;
        this.serviceMovimentoFolha = serviceMovimentoFolha;
        this.serviceFeriasColaborador = serviceFeriasColaborador;
        this.serviceRecisao = serviceRecisao;
    }
}

