/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.esocfechamentofolha.eventos;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ESocS1020;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocItemS1010;
import com.touchcomp.basementor.model.vo.EsocItemS1020;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocS1010;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodo;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.EnumEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.esocfechamentofolha.eventos.AuxFindMovimento1200DecimoTerceiro;
import com.touchcomp.basementorservice.components.esocfechamentofolha.eventos.AuxFindMovimentosS1200;
import com.touchcomp.basementorservice.components.esocfechamentofolha.eventos.AuxGeracao1210;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import com.touchcomp.basementorservice.service.impl.feriascolaborador.ServiceFeriasColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import com.touchcomp.basementorservice.service.impl.recisao.ServiceRecisaoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompCarregarEventosEsocFecFolha
extends ServiceGenericImpl {
    @Autowired
    private HelperEsocPreEvento helperEsocPreEvento;
    @Autowired
    private ServiceEsocPreEventoImpl serviceEsocPreEvento;
    @Autowired
    private ServiceMovimentoFolhaImpl serviceMovimentoFolha;
    @Autowired
    private ServiceFeriasColaboradorImpl serviceFeriasColaborador;
    @Autowired
    private ServiceRecisaoImpl serviceRecisao;

    public List<ESocS1020> preencherDadosEsocialS1020(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Short tipoFolha, EmpresaRh empresaRh) throws ExceptionReflection, ExceptionValidacaoDados {
        if (this.isEquals(tipoFolha, EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue()) && this.isValidBefore(grupoEmpresa, dataInicial, dataFinal).booleanValue()) {
            List itens = new AuxGeracao1210(this.helperEsocPreEvento, this.serviceEsocPreEvento, this.serviceMovimentoFolha, this.serviceFeriasColaborador, this.serviceRecisao).findMovimentosS1210(dataInicial, dataFinal, grupoEmpresa, empresaRh);
            List<ESocS1020> esocs = this.carregarInformacao1210(itens);
            this.ordenaColaboradoresS1020(esocs);
            return esocs;
        }
        return new ArrayList<ESocS1020>();
    }

    public List<EsocS1010> preencherDadosEsocialS1010(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Short tipoFolha, EmpresaRh empresaRh) throws ExceptionValidacaoDados, ExceptionEsocial, ExceptionReflection {
        if (this.isValidBefore(grupoEmpresa, dataInicial, dataFinal).booleanValue()) {
            List<HashMap> list = this.isEquals(tipoFolha, EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue()) ? new AuxFindMovimentosS1200(this.serviceMovimentoFolha, this.serviceFeriasColaborador).findMovimentosS1200(dataInicial, dataFinal, grupoEmpresa, empresaRh) : new AuxFindMovimento1200DecimoTerceiro(this.serviceMovimentoFolha).findMovimentosS1200(dataInicial, dataFinal, grupoEmpresa, empresaRh);
            List<EsocS1010> esocs = this.carregarInformacaoS1200(list);
            this.validarItens(esocs, grupoEmpresa, empresaRh);
            this.ordenaColaboradoresS1010(esocs);
            return esocs;
        }
        return new ArrayList<EsocS1010>();
    }

    public List<EsocS1010> carregarAdvertenciasDadosEsocialS1010(List<EsocS1010> esocs) {
        List<EsocS1010> esocsAdvertencias = new ArrayList<EsocS1010>();
        if (!CompCarregarEventosEsocFecFolha.isWithData(esocs)) {
            return esocsAdvertencias;
        }
        esocsAdvertencias = this.carregarInformacaoAdvertencias(esocs);
        this.ordenaColaboradoresS1010(esocsAdvertencias);
        return esocsAdvertencias;
    }

    private Boolean isValidBefore(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal) throws ExceptionValidacaoDados {
        if (this.isNull(grupoEmpresa).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.1710.002", new Object[0]);
        }
        if (this.isNull(dataInicial).booleanValue() || this.isNull(dataFinal).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.1710.003", new Object[0]);
        }
        return true;
    }

    private List<ESocS1020> carregarInformacao1210(List<HashMap> hashs) {
        ArrayList<ESocS1020> itens = new ArrayList<ESocS1020>();
        for (HashMap h : hashs) {
            ESocS1020 esoc;
            MovimentoFolha m = (MovimentoFolha)h.get("FOLHA");
            Colaborador colaborador = (Colaborador)h.get("COLABORADOR");
            FolhaComplementarPeriodo folhaComp = (FolhaComplementarPeriodo)h.get("FOLHA_COMP");
            FeriasColaborador f = (FeriasColaborador)h.get("FERIAS");
            Recisao r = (Recisao)h.get("RECISAO");
            boolean achou = false;
            for (ESocS1020 e : itens) {
                String cnpjColab;
                String cnpjColabEvt = ToolString.refina((String)e.getColaborador().getPessoa().getComplemento().getCnpj());
                if (!this.isEquals(cnpjColabEvt, cnpjColab = ToolString.refina((String)colaborador.getPessoa().getComplemento().getCnpj()))) continue;
                if (this.isNotNull(m).booleanValue()) {
                    if (this.isNull(folhaComp).booleanValue()) {
                        e.getItensS1020().add(new EsocItemS1020(e, m, ConstantsESocial.S1020_FOLHA));
                    } else {
                        boolean achouTab = false;
                        for (EsocItemS1020 esocItem : e.getItensS1020()) {
                            if (!this.isNotNull(esocItem.getFolhaComplementar()).booleanValue() || !this.isEquals(esocItem.getFolhaComplementar(), folhaComp)) continue;
                            esocItem.getFolhaComplementar().setRubricas1210((List)h.get("RUBRICAS"));
                            achouTab = true;
                            break;
                        }
                        if (!this.verificarExistenciaFolha(e, m)) {
                            e.getItensS1020().add(new EsocItemS1020(e, m, ConstantsESocial.S1020_FOLHA));
                        }
                        if (!achouTab) {
                            folhaComp.setRubricas1210((List)h.get("RUBRICAS"));
                            e.getItensS1020().add(new EsocItemS1020(folhaComp, ConstantsESocial.S1020_FOLHA));
                        }
                    }
                } else if (this.isNotNull(f).booleanValue()) {
                    e.getItensS1020().add(new EsocItemS1020(e, f, ConstantsESocial.S1020_FERIAS));
                } else if (this.isNotNull(r).booleanValue()) {
                    e.getItensS1020().add(new EsocItemS1020(e, r, ConstantsESocial.S1020_RESCISAO));
                }
                achou = true;
                break;
            }
            if (achou) continue;
            if (this.isNotNull(m).booleanValue()) {
                if (this.isNull(folhaComp).booleanValue()) {
                    esoc = new ESocS1020(m.getColaborador());
                    esoc.getItensS1020().add(new EsocItemS1020(esoc, m, ConstantsESocial.S1020_FOLHA));
                    itens.add(esoc);
                    continue;
                }
                esoc = new ESocS1020(m.getColaborador());
                esoc.getItensS1020().add(new EsocItemS1020(esoc, m, ConstantsESocial.S1020_FOLHA));
                boolean achouTab = false;
                for (EsocItemS1020 esocItem : esoc.getItensS1020()) {
                    if (!this.isNotNull(esocItem.getFolhaComplementar()).booleanValue() || !this.isEquals(esocItem.getFolhaComplementar(), folhaComp)) continue;
                    esocItem.getFolhaComplementar().setRubricas1210((List)h.get("RUBRICAS"));
                    achouTab = true;
                    break;
                }
                if (!achouTab) {
                    folhaComp.setRubricas1210((List)h.get("RUBRICAS"));
                    esoc.getItensS1020().add(new EsocItemS1020(folhaComp, ConstantsESocial.S1020_FOLHA));
                }
                itens.add(esoc);
                continue;
            }
            if (this.isNotNull(f).booleanValue()) {
                f.getRubricasFerias().clear();
                f.getRubricasFerias().addAll((List)h.get("RUBRICAS_FERIAS"));
                esoc = new ESocS1020(f.getPeriodoAqFeriasColab().getColaborador());
                esoc.getItensS1020().add(new EsocItemS1020(esoc, f, ConstantsESocial.S1020_FERIAS));
                itens.add(esoc);
                continue;
            }
            if (!this.isNotNull(r).booleanValue()) continue;
            esoc = new ESocS1020(r.getColaborador());
            esoc.getItensS1020().add(new EsocItemS1020(esoc, r, ConstantsESocial.S1020_RESCISAO));
            itens.add(esoc);
        }
        return itens;
    }

    private boolean verificarExistenciaFolha(ESocS1020 e, MovimentoFolha m) {
        for (EsocItemS1020 ee : e.getItensS1020()) {
            if (!this.isNotNull(ee.getMovimentoFolha()).booleanValue() || !this.isEquals(ee.getMovimentoFolha(), m)) continue;
            return true;
        }
        return false;
    }

    private List ordenaColaboradoresS1020(List<ESocS1020> s1020) {
        if (s1020 != null) {
            Collections.sort(s1020, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    ESocS1020 f1 = (ESocS1020)o1;
                    ESocS1020 f2 = (ESocS1020)o2;
                    String vlr1 = f1.getColaborador().getPessoa().getNome();
                    String vlr2 = f2.getColaborador().getPessoa().getNome();
                    return vlr1.compareTo(vlr2);
                }
            });
            return s1020;
        }
        return null;
    }

    private List ordenaColaboradoresS1010(List<EsocS1010> s1010) {
        if (this.isNotNull(s1010).booleanValue()) {
            Collections.sort(s1010, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    EsocS1010 f1 = (EsocS1010)o1;
                    EsocS1010 f2 = (EsocS1010)o2;
                    String vlr1 = f1.getColaborador().getPessoa().getNome();
                    String vlr2 = f2.getColaborador().getPessoa().getNome();
                    return vlr1.compareTo(vlr2);
                }
            });
            return s1010;
        }
        return null;
    }

    private List<EsocS1010> validarItens(List<EsocS1010> itens, GrupoEmpresa grupo, EmpresaRh empresaRh) throws ExceptionEsocial, ExceptionEsocial {
        for (EsocS1010 esoc : itens) {
            if (!this.validarColaborador(esoc.getColaborador()).booleanValue()) {
                esoc.setObservacao(MessagesBaseMentor.getMsg((String)"colaboradorNaoEnviado", (Object[])new Object[0]));
            }
            for (EsocItemS1010 i : esoc.getItensS1010()) {
                if (!this.isNotNull(i.getMovimentoFolha()).booleanValue()) continue;
                this.validarEventoFolha(i.getMovimentoFolha(), grupo, esoc);
                this.validarBaseCalculoInss(i.getMovimentoFolha(), esoc, empresaRh);
                this.validarValoresNegativos(i.getMovimentoFolha(), esoc);
            }
        }
        return itens;
    }

    private void validarValoresNegativos(MovimentoFolha movimentoFolha, EsocS1010 esoc) throws ExceptionEsocial {
        Object obs = "";
        if (this.isNotNull(movimentoFolha.getAberturaPeriodo()).booleanValue() && this.isNotNull(movimentoFolha.getAberturaPeriodo().getTipoCalculo()).booleanValue() && !this.isEquals(movimentoFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha(), EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue()) && !CompCarregarEventosEsocFecFolha.isWithData(movimentoFolha.getRubricas1200())) {
            throw new ExceptionEsocial(EnumEsocial.MOVIMENTO_FOLHA_SEM_RUBRICAS, new Object[]{movimentoFolha.getIdentificador()});
        }
        Double liquido = 0.0;
        for (Rubricas1200 r : movimentoFolha.getRubricas1200()) {
            if (!this.isNotNull(r.getTipoCalculo()).booleanValue() || !this.isNotNull(r.getTipoCalculo().getEsocTipoRubrica()).booleanValue()) continue;
            if (this.isEquals(r.getTipoCalculo().getEsocTipoRubrica().getCodigo(), "1")) {
                liquido = liquido + this.arredondaNumero(r.getValorRubrica(), 2);
                liquido = this.arredondaNumero(liquido, 2);
                continue;
            }
            if (!this.isEquals(r.getTipoCalculo().getEsocTipoRubrica().getCodigo(), "2")) continue;
            liquido = liquido - this.arredondaNumero(r.getValorRubrica(), 2);
            liquido = this.arredondaNumero(liquido, 2);
        }
        if (liquido < 0.0) {
            obs = (String)obs + MessagesBaseMentor.getMsg((String)"liquidoNegativo", (Object[])new Object[0]);
            obs = esoc.getObservacao() + (String)obs;
            if (TMethods.isStrWithDataLengthG((String)obs, (int)1000)) {
                esoc.setObservacao(ToolString.cut((String)obs, (int)999));
            } else {
                esoc.setObservacao((String)obs);
            }
        }
    }

    private void validarBaseCalculoInss(MovimentoFolha movimentoFolha, EsocS1010 esoc, EmpresaRh empresaRh) {
        if (this.isNotNull(movimentoFolha.getAberturaPeriodo()).booleanValue() && this.isNotNull(movimentoFolha.getAberturaPeriodo().getTipoCalculo()).booleanValue() && this.isEquals(movimentoFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha(), EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue()) && this.isNotNull(movimentoFolha.getColaborador()).booleanValue() && this.isNotNull(movimentoFolha.getColaborador().getTipoColaborador()).booleanValue() && !this.isEquals(movimentoFolha.getColaborador().getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.AUTONOMO.getValue()) && !this.isEquals(movimentoFolha.getColaborador().getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.AUTONOMO_FRETE.getValue())) {
            Double baseInssESocial = 0.0;
            Double baseCalculoInss = this.arredondaNumero(movimentoFolha.getBcInssSalario() + movimentoFolha.getBcInssFerias(), 2);
            for (Rubricas1200 r : movimentoFolha.getRubricas1200()) {
                if (!this.isEquals(r.getTipoCalculo(), empresaRh.getEventoBaseInss())) continue;
                baseInssESocial = r.getValorRubrica();
                break;
            }
            if (!this.isEquals(baseInssESocial, baseCalculoInss)) {
                String obs = MessagesBaseMentor.getMsg((String)"baseCalculoInssDifere", (Object[])new Object[]{esoc.getObservacao()});
                if (TMethods.isStrWithDataLengthG((String)obs, (int)1000)) {
                    esoc.setObservacao(ToolString.cut((String)obs, (int)999));
                } else {
                    esoc.setObservacao(obs);
                }
            }
        }
    }

    private List<EsocS1010> carregarInformacaoAdvertencias(List<EsocS1010> esocs) {
        ArrayList<EsocS1010> advertencias = new ArrayList<EsocS1010>();
        for (EsocS1010 esoc : esocs) {
            if (!this.isStrWithData(esoc.getObservacao())) continue;
            advertencias.add(esoc);
        }
        return advertencias;
    }

    private Boolean validarColaborador(Colaborador colaborador) {
        if (this.isNotNull(colaborador.getEsocCategoriaTrabalhador()).booleanValue() && !this.isEquals(colaborador.getEsocCategoriaTrabalhador().getCodigo(), "103") && !this.isEquals(colaborador.getEsocCategoriaTrabalhador().getCodigo(), "101")) {
            return true;
        }
        if (this.isAffimative(colaborador.getInformarReciboManual())) {
            return true;
        }
        if (TMethods.isWithData((Collection)colaborador.getPreEventosEsocial())) {
            for (EsocPreEvento esoc : colaborador.getPreEventosEsocial()) {
                if (!this.isNotNull(esoc.getEsocEvento()).booleanValue() || !this.isEquals(esoc.getTipoEventoEsocial().getIdentificador(), ConstantsESocial.REGISTRO_2200) || !this.isEquals(esoc.getEsocEvento().getStatus(), EnumConstESocialStatus.STATUS_SUCESSO.getValue()) && !this.isEquals(esoc.getEsocEvento().getStatus(), EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private void validarEventoFolha(MovimentoFolha movimentoFolha, GrupoEmpresa grupo, EsocS1010 esoc) {
        Object obs = "";
        for (ItemMovimentoFolha i : movimentoFolha.getItensMovimentoFolha()) {
            if (this.eventoValidado(i.getEventoColaborador().getTipoCalculoEvento(), grupo).booleanValue()) continue;
            obs = (String)obs + MessagesBaseMentor.getMsg((String)"eventoNaoEnviadoParam", (Object[])new Object[]{i.getEventoColaborador().getTipoCalculoEvento().getEvento().getDescricao()});
        }
        if (this.isStrWithData((String)obs)) {
            obs = esoc.getObservacao() + (String)obs;
            if (TMethods.isStrWithDataLengthG((String)obs, (int)1000)) {
                esoc.setObservacao(((String)obs).substring(0, 999));
            } else {
                esoc.setObservacao((String)obs);
            }
        } else if (TMethods.isStrWithDataLengthG((String)esoc.getObservacao(), (int)1000)) {
            esoc.setObservacao(esoc.getObservacao().substring(0, 999));
        }
    }

    private Boolean eventoValidado(TipoCalculoEvento tipoCalculoEvento, GrupoEmpresa grupoEmpresa) {
        if (CompCarregarEventosEsocFecFolha.isWithData(tipoCalculoEvento.getPreEventosEsocial())) {
            for (EsocPreEvento esoc : tipoCalculoEvento.getPreEventosEsocial()) {
                if (!this.isEquals(esoc.getEmpresa().getEmpresaDados().getGrupoEmpresa(), grupoEmpresa) || !this.isNotNull(esoc.getEsocEvento()).booleanValue() || !this.isEquals(esoc.getEsocEvento().getStatus(), EnumConstESocialStatus.STATUS_SUCESSO.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private List<EsocS1010> carregarInformacaoS1200(List<HashMap> list) {
        ArrayList<EsocS1010> itens = new ArrayList<EsocS1010>();
        for (HashMap hash : list) {
            EsocS1010 esoc3;
            Object rubricas;
            FolhaComplementarPeriodo folhaComp = (FolhaComplementarPeriodo)hash.get("FOLHA_COMP");
            MovimentoFolha movFolha = (MovimentoFolha)hash.get("FOLHA");
            FeriasColaborador ferias = (FeriasColaborador)hash.get("FERIAS");
            if (this.isNull(folhaComp).booleanValue() && this.isNull(ferias).booleanValue()) {
                Boolean achou = false;
                rubricas = (List)hash.get("RUBRICAS");
                for (EsocS1010 esoc2 : itens) {
                    String cnpjColabEvt = ToolString.refina((String)esoc2.getColaborador().getPessoa().getComplemento().getCnpj());
                    String cnpjColabMovFolha = ToolString.refina((String)movFolha.getColaborador().getPessoa().getComplemento().getCnpj());
                    if (!this.isEquals(cnpjColabMovFolha, cnpjColabEvt)) continue;
                    achou = true;
                    movFolha.setRubricas1200((List)rubricas);
                    esoc2.getItensS1010().add(new EsocItemS1010(esoc2, movFolha));
                    break;
                }
                if (achou.booleanValue()) continue;
                movFolha.setRubricas1200((List)rubricas);
                esoc3 = new EsocS1010(movFolha.getColaborador());
                esoc3.getItensS1010().add(new EsocItemS1010(esoc3, movFolha));
                itens.add(esoc3);
                continue;
            }
            if (this.isNotNull(folhaComp).booleanValue()) {
                boolean achou = false;
                rubricas = (List)hash.get("RUBRICAS");
                for (EsocS1010 esoc2 : itens) {
                    if (!this.isEquals(esoc2.getColaborador(), movFolha.getColaborador())) continue;
                    achou = true;
                    folhaComp.setRubricas1200((List)rubricas);
                    if (this.verificarExistenciaFolhaComplementar(esoc2, movFolha).booleanValue()) break;
                    esoc2.getItensS1010().add(new EsocItemS1010(esoc2, movFolha, folhaComp));
                    break;
                }
                if (achou) continue;
                folhaComp.setRubricas1200((List)rubricas);
                esoc3 = new EsocS1010(movFolha.getColaborador());
                esoc3.getItensS1010().add(new EsocItemS1010(esoc3, movFolha, folhaComp));
                itens.add(esoc3);
                continue;
            }
            boolean achou = false;
            for (EsocS1010 esoc3 : itens) {
                String cnpjColabFerias;
                String cnpjColabEvt = ToolString.refina((String)esoc3.getColaborador().getPessoa().getComplemento().getCnpj());
                if (!this.isEquals(cnpjColabEvt, cnpjColabFerias = ToolString.refina((String)ferias.getPeriodoAqFeriasColab().getColaborador().getPessoa().getComplemento().getCnpj()))) continue;
                achou = true;
                ferias.getRubricasFerias().clear();
                ferias.getRubricasFerias().addAll((List)hash.get("RUBRICAS_FERIAS"));
                esoc3.getItensS1010().add(new EsocItemS1010(esoc3, ferias));
                break;
            }
            if (achou) continue;
            EsocS1010 esoc4 = new EsocS1010(ferias.getPeriodoAqFeriasColab().getColaborador());
            ferias.getRubricasFerias().clear();
            ferias.getRubricasFerias().addAll((List)hash.get("RUBRICAS_FERIAS"));
            esoc4.getItensS1010().add(new EsocItemS1010(esoc4, ferias));
            itens.add(esoc4);
        }
        return itens;
    }

    private Boolean verificarExistenciaFolhaComplementar(EsocS1010 esoc, MovimentoFolha movFolha) {
        if (CompCarregarEventosEsocFecFolha.isWithData(esoc.getItensS1010())) {
            for (EsocItemS1010 i : esoc.getItensS1010()) {
                if (!this.isEquals(i.getMovimentoFolha(), movFolha)) continue;
                return true;
            }
        }
        return false;
    }
}

