/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.esocfechamentofolha.eventos;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstRegistroESocial;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.ESocS1020;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocFechamentoFolha;
import com.touchcomp.basementor.model.vo.EsocItemS1010;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocS1010;
import com.touchcomp.basementor.model.vo.ExclusaoEventosEsocial;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodo;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodoItem;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.components.esocfechamentofolha.eventos.AuxFindMovimento1200DecimoTerceiro;
import com.touchcomp.basementorservice.components.esocfechamentofolha.eventos.AuxFindMovimentosS1200;
import com.touchcomp.basementorservice.components.esocfechamentofolha.eventos.AuxGeracao1210;
import com.touchcomp.basementorservice.components.esocfechamentofolha.eventos.AuxGeracao1280;
import com.touchcomp.basementorservice.components.esocfechamentofolha.eventos.AuxGeracao3000;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import com.touchcomp.basementorservice.service.impl.exclusaoeventosesocial.ServiceExclusaoEventosEsocialImpl;
import com.touchcomp.basementorservice.service.impl.feriascolaborador.ServiceFeriasColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.folhacomplementarperiodo.ServiceFolhaComplementarPeriodoImpl;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import com.touchcomp.basementorservice.service.impl.recisao.ServiceRecisaoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompEventosEsocFecFolha
extends BaseMethods {
    @Autowired
    private HelperEsocPreEvento helper;
    @Autowired
    private ServiceEsocPreEventoImpl serviceEsocPreEvento;
    @Autowired
    private ServiceMovimentoFolhaImpl serviceMovimentoFolha;
    @Autowired
    private ServiceFolhaComplementarPeriodoImpl serviceFolhaComplementarPeriodo;
    @Autowired
    private ServiceFeriasColaboradorImpl serviceFeriasColaborador;
    @Autowired
    private ServiceExclusaoEventosEsocialImpl serviceExclusaoEventosEsocial;
    @Autowired
    private ServiceRecisaoImpl serviceRecisao;

    public void gerarEventosFechamentoESocial(EsocFechamentoFolha vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        if (CompEventosEsocFecFolha.isWithData(vo.getEsocS1010())) {
            for (EsocS1010 item : vo.getEsocS1010()) {
                this.gerarEventoEsocialS1010(item, usuario, empresa);
            }
        }
        if (CompEventosEsocFecFolha.isWithData(vo.getEsocS1020())) {
            for (EsocS1010 item : vo.getEsocS1020()) {
                this.gerarEventoEsocialS1020((ESocS1020)item, usuario, empresa);
            }
        }
        if (TMethods.isAffirmative((Number)vo.getGerarInformacoesComplementares())) {
            new AuxGeracao1280(this.helper, this.serviceEsocPreEvento).gerarEventosFechamentoESocial(vo, usuario, empresa);
        }
    }

    public void gerarEventoEsocialS1020(ESocS1020 vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        if (!CompEventosEsocFecFolha.isWithData(vo.getPreEventosEsocial())) {
            EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, EnumConstantsMentorSimNao.NAO);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
            this.serviceEsocPreEvento.saveOrUpdate(preEvento);
            preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, EnumConstantsMentorSimNao.NAO);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
            this.serviceEsocPreEvento.saveOrUpdate(preEvento);
        }
    }

    public void gerarEventoEsocialS1010(EsocS1010 vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        if (!CompEventosEsocFecFolha.isWithData(vo.getPreEventosEsocial())) {
            EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, EnumConstantsMentorSimNao.NAO);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
            this.serviceEsocPreEvento.saveOrUpdate(preEvento);
            preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, EnumConstantsMentorSimNao.NAO);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
            this.serviceEsocPreEvento.saveOrUpdate(preEvento);
        }
    }

    public void gerarExclusaoEvento1200(EsocFechamentoFolha vo) throws ExceptionEsocial {
        if (TMethods.isWithData((Collection)vo.getEsocS1010())) {
            block0: for (EsocS1010 esoc : vo.getEsocS1010()) {
                for (EsocPreEvento e : esoc.getPreEventosEsocial()) {
                    if (!TMethods.isNotNull((Object)e.getEsocEvento()).booleanValue() || !TMethods.isNull((Object)e.getEventoPosterior()).booleanValue() || !TMethods.isEquals((Object)e.getEsocEvento().getStatus(), (Object)EnumConstESocialStatus.STATUS_SUCESSO.getValue()) && !TMethods.isEquals((Object)e.getEsocEvento().getStatus(), (Object)EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue())) continue;
                    this.criarExclusaoEvento1200(e);
                    continue block0;
                }
            }
        }
    }

    public void retificarEvento1200(EsocFechamentoFolha vo, Usuario usuario, Empresa empresa, EmpresaRh empresaRh, Short tipoEvento) throws ExceptionEsocial, ExceptionInvalidData {
        if (!TMethods.isWithData((Collection)vo.getEsocS1010())) {
            throw new ExceptionInvalidData("E.ERP.1710.007", new Object[]{vo.getIdentificador()});
        }
        for (EsocS1010 e : vo.getEsocS1010()) {
            this.geracaoEventoRetificacaoS1200(e, usuario, empresa, EnumConstEventoProducao.get((Object)tipoEvento), empresaRh);
        }
    }

    public void retificarEvento1210(EsocFechamentoFolha vo, Usuario usuario, Empresa empresa, EmpresaRh empresaRh, Short tipoEvento) throws ExceptionEsocial, ExceptionInvalidData {
        if (!TMethods.isWithData((Collection)vo.getEsocS1020())) {
            throw new ExceptionInvalidData("E.ERP.1710.008", new Object[]{vo.getIdentificador()});
        }
        for (ESocS1020 e : vo.getEsocS1020()) {
            new AuxGeracao1210(this.helper, this.serviceEsocPreEvento, this.serviceMovimentoFolha, this.serviceFeriasColaborador, this.serviceRecisao).geracaoEventoRetificacaoS1210(e, usuario, empresa, EnumConstEventoProducao.get((Object)tipoEvento), empresaRh);
        }
    }

    public void retificarEvento1280(EsocFechamentoFolha vo, Usuario usuario, Empresa empresa, Short tipoEvento) throws ExceptionEsocial {
        new AuxGeracao1280(this.helper, this.serviceEsocPreEvento).geracaoEventoRetificacaoS1280(vo, usuario, empresa, EnumConstEventoProducao.get((Object)tipoEvento));
    }

    private void criarExclusaoEvento1200(EsocPreEvento e) throws ExceptionEsocial {
        ExclusaoEventosEsocial vo = this.serviceExclusaoEventosEsocial.criarExclusaoEvento1200(e);
        new AuxGeracao3000(this.helper, this.serviceEsocPreEvento).geracaoEventoS3000(vo, e.getUsuario(), e.getEmpresa());
    }

    public void gerarExclusaoEvento1210(EsocFechamentoFolha vo) throws ExceptionEsocial {
        if (TMethods.isWithData((Collection)vo.getEsocS1010())) {
            block0: for (ESocS1020 esoc : vo.getEsocS1020()) {
                for (EsocPreEvento e : esoc.getPreEventosEsocial()) {
                    if (!TMethods.isNotNull((Object)e.getEsocEvento()).booleanValue() || !TMethods.isNull((Object)e.getEventoPosterior()).booleanValue() || !TMethods.isEquals((Object)e.getEsocEvento().getStatus(), (Object)EnumConstESocialStatus.STATUS_SUCESSO.getValue()) && !TMethods.isEquals((Object)e.getEsocEvento().getStatus(), (Object)EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue())) continue;
                    this.criarExclusaoEvento1210(e);
                    continue block0;
                }
            }
        }
    }

    private void criarExclusaoEvento1210(EsocPreEvento e) throws ExceptionEsocial {
        ExclusaoEventosEsocial vo = this.serviceExclusaoEventosEsocial.criarExclusaoEvento1200(e);
        new AuxGeracao3000(this.helper, this.serviceEsocPreEvento).geracaoEventoS3000(vo, e.getUsuario(), e.getEmpresa());
    }

    private EsocPreEvento createNewPreEventoColaborador(EsocS1010 vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, EnumConstantsMentorSimNao eventoRetificacao) throws ExceptionEsocial {
        return this.helper.getEvento(vo, usuario, empresa, prodEvento, (Short)eventoRetificacao.getValue());
    }

    private EsocPreEvento createNewPreEventoColaborador(ESocS1020 vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, EnumConstantsMentorSimNao eventoRetificacao) throws ExceptionEsocial {
        return this.helper.getEvento(vo, usuario, empresa, prodEvento, (Short)eventoRetificacao.getValue());
    }

    public void geracaoEventoRetificacaoS1200(EsocS1010 vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao tipoEvento, EmpresaRh empresaRh) throws ExceptionEsocial, ExceptionInvalidData {
        for (EsocPreEvento esocPreEvento : vo.getPreEventosEsocial()) {
            if (!this.isEquals(esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa(), empresa.getEmpresaDados().getGrupoEmpresa()) || !this.isNull(esocPreEvento.getEventoPosterior()).booleanValue() || !this.isEquals(esocPreEvento.getTipoEventoEsocial().getIdentificador(), EnumConstRegistroESocial.REGISTRO_1200.getEnumId()) || !this.isEquals(esocPreEvento.getEventoProdRestritaProducao(), tipoEvento.getValue())) continue;
            if (this.isNull(esocPreEvento.getEsocEvento()).booleanValue() || !this.isStrWithData(esocPreEvento.getEsocEvento().getNrRecibo())) {
                this.recalcularEventos(vo, empresaRh);
                return;
            }
            EsocPreEvento preEvento = this.helper.getEvento(vo, usuario, empresa, tipoEvento, (Short)EnumConstantsMentorSimNao.SIM.getValue());
            if (!this.isNotNull(preEvento).booleanValue()) continue;
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.getValue()));
            preEvento.setEventoAnterior(esocPreEvento);
            this.serviceEsocPreEvento.saveOrUpdateFlush(preEvento);
            esocPreEvento.setEventoPosterior(preEvento);
            this.serviceEsocPreEvento.saveOrUpdate(esocPreEvento);
            this.recalcularEventos(vo, empresaRh);
        }
    }

    private void recalcularEventos(EsocS1010 vo, EmpresaRh empresaRh) throws ExceptionEsocial, ExceptionInvalidData {
        for (EsocItemS1010 esocItemS1010 : vo.getItensS1010()) {
            if (esocItemS1010.getMovimentoFolha() == null) continue;
            esocItemS1010.getMovimentoFolha().getAberturaPeriodo().getTipoCalculo().getDescricao();
            MovimentoFolha movFolha = esocItemS1010.getMovimentoFolha();
            movFolha.setRubricas1200(new ArrayList());
            HashMap h = null;
            if (movFolha.getPagamentoFolhaComplementar() == null && !movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue()) && !movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_13O.getValue())) {
                if (!movFolha.getColaborador().getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.AUTONOMO_FRETE.getValue())) {
                    h = new AuxFindMovimentosS1200(this.serviceMovimentoFolha, this.serviceFeriasColaborador).criarRubricas1200(movFolha, empresaRh);
                } else {
                    if (this.isNull(empresaRh.getVrBaseInssAutonomoFrete()).booleanValue() || this.isNull(empresaRh.getVrBaseIrrfAutonomoFrete()).booleanValue()) {
                        throw new ExceptionInvalidData("E.ERP.0050.001", new Object[0]);
                    }
                    h = new AuxFindMovimentosS1200(this.serviceMovimentoFolha, this.serviceFeriasColaborador).criarRubricas1200AutonomoFrete(movFolha, empresaRh, new ArrayList<HashMap>());
                }
            } else if (movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_13O.getValue())) {
                h = new AuxFindMovimentosS1200(this.serviceMovimentoFolha, this.serviceFeriasColaborador).criarRubricas1200Adiantamento13(movFolha, empresaRh);
            } else if (movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())) {
                h = new AuxFindMovimento1200DecimoTerceiro(this.serviceMovimentoFolha).criarRubricas120013(movFolha, empresaRh);
            } else if (movFolha.getPagamentoFolhaComplementar() != null && movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue())) {
                h = null;
                this.criarRubricas1200FolhaComplementar(movFolha, empresaRh);
            }
            if (h == null) continue;
            List rubricas = (List)h.get("RUBRICAS");
            movFolha.setRubricas1200(rubricas);
            this.serviceMovimentoFolha.saveOrUpdate(movFolha);
        }
    }

    public List<HashMap> criarRubricas1200FolhaComplementar(MovimentoFolha m, EmpresaRh empresaRh) {
        ArrayList<HashMap> hashs = new ArrayList<HashMap>();
        for (FolhaComplementarPeriodo folha : m.getPagamentoFolhaComplementar().getFolhaComplementares()) {
            if (folha.getRubricas1200() == null) {
                folha.setRubricas1200(new ArrayList());
            }
            ArrayList<Rubricas1200> rubricas = new ArrayList<Rubricas1200>();
            for (FolhaComplementarPeriodoItem item : folha.getFolhaComplementarPeriodoItem()) {
                TipoCalculoEvento tp = item.getTipoCalculoEvento();
                if (!(item.getValorComplemento() > 0.0) || tp.getEsocRubricasFolhaPagamento() != null && tp.getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
                System.err.println(tp.getEvento().getCodigo());
                rubricas.add(new Rubricas1200(tp, item.getValorComplemento(), folha));
            }
            if (folha.getVrInss() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getTpInss(), folha.getVrInss(), folha));
            }
            if (folha.getVrInssDec() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getTpInssDec(), folha.getVrInssDec(), folha));
            }
            if (folha.getBaseInss() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInss(), folha.getBaseInss(), folha));
            }
            if (folha.getBaseInssDec() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInssDec(), folha.getBaseInssDec(), folha));
            }
            if (folha.getBaseFgts() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getEventoBaseFgts(), folha.getBaseFgts(), folha));
            }
            if (folha.getVrFgts() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getTpFgts(), folha.getVrFgts(), folha));
            }
            if (folha.getVrIrrf() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getTpIrrf(), folha.getVrIrrf(), folha));
            }
            if (folha.getVrIrrfDec() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getTpIrrfDec(), folha.getVrIrrfDec(), folha));
            }
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("FOLHA", m);
            h.put("FOLHA_COMP", folha);
            h.put("RUBRICAS", rubricas);
            folha.setRubricas1200(rubricas);
            this.serviceFolhaComplementarPeriodo.saveOrUpdate(folha);
            hashs.add(h);
        }
        return hashs;
    }

    public void criarRubricas1200(MovimentoFolha mov, EmpresaRh empresaRh) {
        if (this.isNull(mov).booleanValue()) {
            return;
        }
        HashMap hash = new AuxFindMovimentosS1200(this.serviceMovimentoFolha, this.serviceFeriasColaborador).criarRubricas1200(mov, empresaRh);
        if (this.isNotNull(hash).booleanValue()) {
            List rubricas = (List)hash.get("RUBRICAS");
            mov.getRubricas1200().clear();
            if (CompEventosEsocFecFolha.isWithData(rubricas)) {
                for (Rubricas1200 rubrica : rubricas) {
                    rubrica.setMovimentoFolha(mov);
                }
                mov.getRubricas1200().addAll(rubricas);
            }
        }
    }
}

