/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.estoque;

import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.impl.SaldosReservaEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.InfoUltEntradaProduto;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.service.impl.infoultentradaproduto.ServiceInfoUltEntradaProdutoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompEstoque {
    @Autowired
    private ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl;
    @Autowired
    private ServiceInfoUltEntradaProdutoImpl serviceInfoUltEntradaProdutoImpl;

    public Double getUltimoCusto(Produto produto, Empresa empresa) {
        return this.getUltimoCusto(produto.getIdentificador(), empresa.getIdentificador());
    }

    public Double getUltimoVlrTransf(Long idProduto, Long idEmpresa) {
        InfoUltEntradaProduto inf = this.serviceInfoUltEntradaProdutoImpl.getUltInfoProd(idProduto, idEmpresa);
        if (inf != null) {
            return inf.getVrUltCusto();
        }
        return 0.0;
    }

    public Double getUltimoCusto(Long idProduto, Long idEmpresa) {
        InfoUltEntradaProduto inf = this.serviceInfoUltEntradaProdutoImpl.getUltInfoProd(idProduto, idEmpresa);
        if (inf != null) {
            return inf.getVrUltCusto();
        }
        return 0.0;
    }

    public Double getUltimoCusto(Produto produto) {
        return this.getUltimoCusto(produto.getIdentificador());
    }

    public Double getUltimoCusto(Long idProduto) {
        InfoUltEntradaProduto inf = this.serviceInfoUltEntradaProdutoImpl.getUltInfoProd(idProduto);
        if (inf != null) {
            return inf.getVrUltCusto();
        }
        return 0.0;
    }

    public Double getUltimoCustoNF(Long idProduto) {
        Double ret = this.serviceInfoUltEntradaProdutoImpl.getUltimoCustoNF(idProduto);
        if (ret != null) {
            return ret;
        }
        return 0.0;
    }

    public Double getUltimoCustoNF(Long idProduto, Long idEmpresa) {
        Double ret = this.serviceInfoUltEntradaProdutoImpl.getUltimoCustoNF(idProduto, idEmpresa);
        if (ret != null) {
            return ret;
        }
        return 0.0;
    }

    public Double getUltCustoVlrTransf(Produto prod, Empresa emp) {
        InfoUltEntradaProduto inf = this.serviceInfoUltEntradaProdutoImpl.getUltInfoProd(prod.getIdentificador(), emp.getIdentificador());
        if (inf != null) {
            return inf.getVrUltTransfFiscal();
        }
        return 0.0;
    }

    public Double getUltValorCompra(Produto prod, Empresa emp) {
        InfoUltEntradaProduto inf = this.serviceInfoUltEntradaProdutoImpl.getUltInfoProd(prod.getIdentificador(), emp.getIdentificador());
        if (inf != null) {
            return inf.getVrUltCompra();
        }
        return 0.0;
    }

    public Double getUltValorCompra(Produto prod) {
        InfoUltEntradaProduto inf = this.serviceInfoUltEntradaProdutoImpl.getUltInfoProd(prod.getIdentificador());
        if (inf != null) {
            return inf.getVrUltCompra();
        }
        return 0.0;
    }

    public Double getUltPrecoCompraNF(Produto prod) {
        Double ret = this.serviceInfoUltEntradaProdutoImpl.getUltPrecoCompraNF(prod.getIdentificador());
        if (ret != null) {
            return ret;
        }
        return 0.0;
    }

    public Double getUltPrecoCompraNF(Produto prod, Empresa emp) {
        Double ret = this.serviceInfoUltEntradaProdutoImpl.getUltPrecoCompraNF(prod.getIdentificador(), emp);
        if (ret != null) {
            return ret;
        }
        return 0.0;
    }

    public Double getCustoMedioEstoque(Produto produto, Empresa empresa, Date data) {
        if (produto == null) {
            return 0.0;
        }
        if (empresa == null) {
            return 0.0;
        }
        return this.getCustoMedioEstoque(produto.getIdentificador(), empresa.getIdentificador(), data);
    }

    public Double getCustoMedioEstoque(Produto produto, Empresa empresa) {
        return this.getCustoMedioEstoque(produto, empresa, new Date());
    }

    public Double getCustoMedioEstoque(Long idProduto, Long idEmpresa, Date data) {
        if (data == null) {
            data = new Date();
        }
        return this.serviceSaldoEstoqueImpl.findPrecoMedioIdProduto(idProduto, idEmpresa, data);
    }

    public Double getCustoMedioEstoque(Long idProduto, Long idEmpresa) {
        return this.getCustoMedioEstoque(idProduto, idEmpresa, new Date());
    }

    public SaldosReservaEstoque processaRetReservaEstoque(List<SaldoEstoqueGeral> saldos, Double qtdSol) {
        SaldosReservaEstoque s = new SaldosReservaEstoque();
        s.setQtdAtendida(Double.valueOf(0.0));
        s.setQtdSolicitada(qtdSol);
        if (saldos.isEmpty()) {
            return s;
        }
        int i = 0;
        double qtdRemas = qtdSol;
        double totQtdAtend = 0.0;
        do {
            double qtdAtend;
            SaldoEstoqueGeral sal;
            if (qtdRemas > (sal = saldos.get(i)).getQuantidade()) {
                qtdRemas -= sal.getQuantidade().doubleValue();
                qtdAtend = sal.getQuantidade();
            } else {
                qtdAtend = qtdRemas = 0.0;
            }
            SaldosReservaEstoque.Saldos sr = new SaldosReservaEstoque.Saldos();
            sr.setSaldoEstoque(sal);
            sr.setQuantidadeDisponivel(Double.valueOf(qtdAtend));
            totQtdAtend += sr.getQuantidadeDisponivel().doubleValue();
            ++i;
        } while (!(qtdRemas > 0.0 && i >= saldos.size()) && qtdRemas > 0.0);
        s.setQtdAtendida(Double.valueOf(totQtdAtend));
        return s;
    }
}

