/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.estoquepeps;

import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueEstrategia;
import com.touchcomp.basementor.model.interfaces.InterfaceEstoqueDisp;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.components.estoquepeps.comparators.ComparatorDataCrescente;
import com.touchcomp.basementorservice.components.estoquepeps.comparators.ComparatorDataDecrescente;
import com.touchcomp.basementorservice.components.estoquepeps.comparators.ComparatorQtdCrescente;
import com.touchcomp.basementorservice.components.estoquepeps.comparators.ComparatorQtdDecrescente;
import com.touchcomp.basementorservice.components.estoquepeps.single.EstoqueDisponivel;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class CompEstoqueDisponibilidade<E> {
    public List<EstoqueDisponivel<E>> getDisponibilidades(List<? extends InterfaceEstoqueDisp> saldosDisponiveis, Double qtdDesejada, GradeCor gradeCor, EnumConstOpEstoqueEstrategia estrategia, OpcaoSaldoParcial opcaoSaldoParcial, OpcaoTotalmenteSemSaldo opcaoTotalmenteSemSaldo) throws ExceptionInvalidState {
        return this.getDisponibilidades(saldosDisponiveis, qtdDesejada, gradeCor, estrategia, opcaoSaldoParcial, opcaoTotalmenteSemSaldo, false);
    }

    public List<EstoqueDisponivel<E>> getDisponibilidades(List<? extends InterfaceEstoqueDisp> saldosDisponiveis, final Double qtdDesejada, GradeCor gradeCor, EnumConstOpEstoqueEstrategia estrategia, OpcaoSaldoParcial opcaoSaldoParcial, OpcaoTotalmenteSemSaldo opcaoTotalmenteSemSaldo, boolean replaceQtdOrigem) throws ExceptionInvalidState {
        InterfaceEstoqueDisp i;
        LinkedList ret = new LinkedList();
        if (saldosDisponiveis == null) {
            if (opcaoTotalmenteSemSaldo.equals((Object)OpcaoTotalmenteSemSaldo.LANCAR_EXCECAO_FALTA_ESTOQUE)) {
                throw new ExceptionInvalidState("E.ERP.XXXX.001", new Object[]{gradeCor, qtdDesejada});
            }
            return ret;
        }
        if (saldosDisponiveis.size() == 1 && !ToolMethods.isWithData((Number)(i = saldosDisponiveis.get(0)).getQuantidadeAvaliacao())) {
            saldosDisponiveis.clear();
        }
        if (saldosDisponiveis.isEmpty()) {
            if (opcaoTotalmenteSemSaldo.equals((Object)OpcaoTotalmenteSemSaldo.LANCAR_EXCECAO_FALTA_ESTOQUE)) {
                throw new ExceptionInvalidState("E.ERP.XXXX.001", new Object[]{gradeCor, qtdDesejada});
            }
            if (opcaoTotalmenteSemSaldo.equals((Object)OpcaoTotalmenteSemSaldo.ESTOQUE_SEM_DADOS)) {
                InterfaceEstoqueDisp sal = new InterfaceEstoqueDisp(){

                    public Object getSource() {
                        return null;
                    }

                    public Double getQuantidadeAvaliacao() {
                        return qtdDesejada;
                    }

                    public void setQuantidadeAvaliacao(Double aValue) {
                    }

                    public Date getDataAvaliacao() {
                        return new Date();
                    }
                };
                EstoqueDisponivel est = new EstoqueDisponivel(sal);
                ret.add(est);
            }
            return ret;
        }
        saldosDisponiveis = this.sortIt(saldosDisponiveis, qtdDesejada, estrategia);
        LinkedList<? extends InterfaceEstoqueDisp> queue = new LinkedList<InterfaceEstoqueDisp>(saldosDisponiveis);
        double qtdRemas = qtdDesejada;
        do {
            InterfaceEstoqueDisp sal = (InterfaceEstoqueDisp)queue.remove();
            EstoqueDisponivel est = new EstoqueDisponivel(sal);
            ret.add(est);
            if (qtdRemas > sal.getQuantidadeAvaliacao()) {
                qtdRemas -= sal.getQuantidadeAvaliacao().doubleValue();
                est.setQuantidade(sal.getQuantidadeAvaliacao());
                if (replaceQtdOrigem) {
                    sal.setQuantidadeAvaliacao(Double.valueOf(0.0));
                }
            } else {
                est.setQuantidade(qtdRemas);
                if (replaceQtdOrigem) {
                    sal.setQuantidadeAvaliacao(Double.valueOf(sal.getQuantidadeAvaliacao() - qtdRemas));
                }
                qtdRemas = 0.0;
            }
            if (!queue.isEmpty()) continue;
            if (replaceQtdOrigem) {
                sal.setQuantidadeAvaliacao(Double.valueOf(0.0));
            }
            if (opcaoSaldoParcial.equals((Object)OpcaoSaldoParcial.SETAR_QTD_ULT_ITEM)) {
                est.setQuantidade(est.getQuantidade() + qtdRemas);
                break;
            }
            if (!(ToolFormatter.arrredondarNumero((Double)qtdRemas, (int)6) > 0.0)) break;
            throw new ExceptionInvalidState("E.ERP.XXXX.002", new Object[]{gradeCor, qtdRemas});
        } while (qtdRemas > 0.0);
        return ret;
    }

    public List<? extends InterfaceEstoqueDisp> sortIt(List<? extends InterfaceEstoqueDisp> saldosDisponiveis, Double qtdDesejada, EnumConstOpEstoqueEstrategia estrategia) {
        switch (estrategia) {
            case MENOS_VARIACOES: {
                List aux = saldosDisponiveis.stream().filter(i -> i.getQuantidadeAvaliacao() >= qtdDesejada).collect(Collectors.toList());
                if (!aux.isEmpty()) {
                    Collections.sort(aux, new ComparatorQtdCrescente());
                    return aux;
                }
                Collections.sort(saldosDisponiveis, new ComparatorQtdDecrescente());
                return saldosDisponiveis;
            }
            case PEPS_MAIS_ANTIGO: {
                Collections.sort(saldosDisponiveis, new ComparatorDataCrescente());
                return saldosDisponiveis;
            }
        }
        Collections.sort(saldosDisponiveis, new ComparatorDataDecrescente());
        return saldosDisponiveis;
    }

    public static enum OpcaoSaldoParcial {
        LANCAR_EXCECAO_FALTA_ESTOQUE,
        SETAR_QTD_ULT_ITEM;

    }

    public static enum OpcaoTotalmenteSemSaldo {
        LANCAR_EXCECAO_FALTA_ESTOQUE,
        ESTOQUE_SEM_DADOS,
        LISTA_EST_VAZIA;

    }
}

