/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.estoquepeps;

import com.touchcomp.basementor.constants.enums.wmsopcoes.EnumConstOpEstMultiEstrategia;
import com.touchcomp.basementor.model.interfaces.InterfaceEstoqueDispMult;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.components.estoquepeps.multi.EstoqueDisponivelMult;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompEstoqueMultipleDisp<E> {
    public List<EstoqueDisponivelMult<E>> getDisponibilidades(List<? extends InterfaceEstoqueDispMult> saldosDisponiveis, Double qtdDesejada, GradeCor gradeCor, EnumConstOpEstMultiEstrategia estrategia, OpcaoSaldoParcial opcaoSaldoParcial, OpcaoTotalmenteSemSaldo opcaoTotalmenteSemSaldo) throws ExceptionInvalidState {
        return this.getDisponibilidades(saldosDisponiveis, qtdDesejada, gradeCor, estrategia, opcaoSaldoParcial, opcaoTotalmenteSemSaldo, false);
    }

    public List<EstoqueDisponivelMult<E>> getDisponibilidades(List<? extends InterfaceEstoqueDispMult> saldosDisponiveis, Double qtdDesejada, GradeCor gradeCor, EnumConstOpEstMultiEstrategia estrategia, OpcaoSaldoParcial opcaoSaldoParcial, OpcaoTotalmenteSemSaldo opcaoTotalmenteSemSaldo, boolean replaceQtdOrigem) throws ExceptionInvalidState {
        InterfaceEstoqueDispMult i;
        LinkedList ret = new LinkedList();
        if (saldosDisponiveis == null) {
            if (opcaoTotalmenteSemSaldo.equals((Object)OpcaoTotalmenteSemSaldo.LANCAR_EXCECAO_FALTA_ESTOQUE)) {
                throw new ExceptionInvalidState("E.ERP.XXXX.001", new Object[]{gradeCor, qtdDesejada});
            }
            saldosDisponiveis = new LinkedList<InterfaceEstoqueDispMult>();
        }
        if (saldosDisponiveis.size() == 1 && !ToolMethods.isWithData((Collection)(i = saldosDisponiveis.get(0)).getSourcesAvaliacao())) {
            saldosDisponiveis.clear();
        }
        if (saldosDisponiveis.isEmpty()) {
            return this.processaSaldosIndisponiveis(saldosDisponiveis, qtdDesejada, gradeCor, estrategia, opcaoSaldoParcial, opcaoTotalmenteSemSaldo);
        }
        saldosDisponiveis = this.sortIt(saldosDisponiveis, qtdDesejada, estrategia);
        LinkedList<? extends InterfaceEstoqueDispMult> queue = new LinkedList<InterfaceEstoqueDispMult>(saldosDisponiveis);
        double qtdRemas = qtdDesejada;
        if (!queue.isEmpty()) {
            do {
                InterfaceEstoqueDispMult sal;
                EstoqueDisponivelMult est;
                InterfaceEstoqueDispMult.Source source;
                if ((source = this.getQtdAvaliacao(est = new EstoqueDisponivelMult(sal = (InterfaceEstoqueDispMult)queue.remove()))) == null || !ToolMethods.isWithData((Number)ToolFormatter.arrredondarNumero((Double)source.getQuantidadeAvaliacao(), (int)6)) || !this.checkDisponibilidade(est.getEstoque(), source.getQuantidadeAvaliacao())) continue;
                boolean added = false;
                if (source.getQuantidadeAvaliacao() > 0.0) {
                    added = true;
                    ret.add(est);
                    if (qtdRemas > source.getQuantidadeAvaliacao()) {
                        qtdRemas -= source.getQuantidadeAvaliacao().doubleValue();
                        est.setQuantidade(source.getQuantidadeAvaliacao());
                        if (replaceQtdOrigem) {
                            this.updateSources(est, source.getQuantidadeAvaliacao());
                        }
                    } else {
                        est.setQuantidade(qtdRemas);
                        if (replaceQtdOrigem) {
                            this.updateSources(est, qtdRemas);
                        }
                        qtdRemas = 0.0;
                    }
                }
                if (!queue.isEmpty()) continue;
                if (!added) {
                    ret.add(est);
                }
                if (replaceQtdOrigem) {
                    this.updateSources(est, qtdRemas);
                }
                if (opcaoSaldoParcial.equals((Object)OpcaoSaldoParcial.SETAR_QTD_ULT_ITEM)) {
                    est.setQuantidade(est.getQuantidade() + qtdRemas);
                    break;
                }
                if (!(ToolFormatter.arrredondarNumero((Double)qtdRemas, (int)6) > 0.0)) break;
                throw new ExceptionInvalidState("E.ERP.XXXX.002", new Object[]{gradeCor, qtdRemas});
            } while (qtdRemas > 0.0);
        }
        return ret;
    }

    public List<? extends InterfaceEstoqueDispMult> sortIt(List<? extends InterfaceEstoqueDispMult> saldosDisponiveis, Double qtdDesejada, EnumConstOpEstMultiEstrategia estrategia) {
        switch (estrategia) {
            case MENOS_VARIACOES: {
                Collections.sort(saldosDisponiveis, (a1, a2) -> {
                    Double t1 = 1.0;
                    for (Object obj : a1.getSourcesAvaliacao()) {
                        InterfaceEstoqueDispMult.Source source = (InterfaceEstoqueDispMult.Source)obj;
                        t1 = t1 * source.getQuantidadeAvaliacao();
                    }
                    Double t2 = 1.0;
                    for (Object obj : a2.getSourcesAvaliacao()) {
                        InterfaceEstoqueDispMult.Source source = (InterfaceEstoqueDispMult.Source)obj;
                        t2 = t2 * source.getQuantidadeAvaliacao();
                    }
                    return t2.compareTo(t1);
                });
                return saldosDisponiveis;
            }
            case MAIOR_SCORE: {
                Collections.sort(saldosDisponiveis, (a1, a2) -> a2.getScore().compareTo(a1.getScore()));
                return saldosDisponiveis;
            }
        }
        Collections.sort(saldosDisponiveis, (a1, a2) -> a1.getScore().compareTo(a2.getScore()));
        return saldosDisponiveis;
    }

    private InterfaceEstoqueDispMult.Source getQtdAvaliacao(EstoqueDisponivelMult est) {
        InterfaceEstoqueDispMult.Source ret = null;
        for (Object obj : est.getEstoque().getSourcesAvaliacao()) {
            InterfaceEstoqueDispMult.Source source = (InterfaceEstoqueDispMult.Source)obj;
            if (ret != null && !(source.getQuantidadeAvaliacao() < ret.getQuantidadeAvaliacao())) continue;
            ret = source;
        }
        return ret;
    }

    private void updateSources(EstoqueDisponivelMult est, double qtdUtilizada) {
        for (Object obj : est.getEstoque().getSourcesAvaliacao()) {
            InterfaceEstoqueDispMult.Source source = (InterfaceEstoqueDispMult.Source)obj;
            source.setQuantidadeAvaliacao(Double.valueOf(qtdUtilizada));
        }
    }

    private boolean checkDisponibilidade(InterfaceEstoqueDispMult<E> estoque, Double quantidadeAvaliacao) {
        List rules = estoque.getRulesAvaliacao();
        if (rules == null) {
            return true;
        }
        for (InterfaceEstoqueDispMult.Rule rule : rules) {
            if (rule.isValid(estoque.getSource(), quantidadeAvaliacao)) continue;
            return false;
        }
        return true;
    }

    private List<EstoqueDisponivelMult<E>> processaSaldosIndisponiveis(List<? extends InterfaceEstoqueDispMult> saldosDisponiveis, final Double qtdDesejada, GradeCor gradeCor, EnumConstOpEstMultiEstrategia estrategia, OpcaoSaldoParcial opcaoSaldoParcial, OpcaoTotalmenteSemSaldo opcaoTotalmenteSemSaldo) throws ExceptionInvalidState {
        if (opcaoTotalmenteSemSaldo.equals((Object)OpcaoTotalmenteSemSaldo.LANCAR_EXCECAO_FALTA_ESTOQUE)) {
            throw new ExceptionInvalidState("E.ERP.XXXX.001", new Object[]{gradeCor, qtdDesejada});
        }
        LinkedList ret = new LinkedList();
        if (opcaoTotalmenteSemSaldo.equals((Object)OpcaoTotalmenteSemSaldo.ESTOQUE_SEM_DADOS)) {
            InterfaceEstoqueDispMult.Source source = new InterfaceEstoqueDispMult.Source(){

                public Double getQuantidadeAvaliacao() {
                    return qtdDesejada;
                }

                public void setQuantidadeAvaliacao(Double aValue) {
                }
            };
            final LinkedList<1> sources = new LinkedList<1>();
            sources.add(source);
            InterfaceEstoqueDispMult sal = new InterfaceEstoqueDispMult(){

                public Object getSource() {
                    return null;
                }

                public Double getScore() {
                    return 0.0;
                }

                public List getSourcesAvaliacao() {
                    return sources;
                }

                public List getRulesAvaliacao() {
                    return new LinkedList();
                }
            };
            EstoqueDisponivelMult est = new EstoqueDisponivelMult(sal);
            ret.add(est);
        }
        return ret;
    }

    public static enum OpcaoSaldoParcial {
        LANCAR_EXCECAO_FALTA_ESTOQUE,
        SETAR_QTD_ULT_ITEM;

    }

    public static enum OpcaoTotalmenteSemSaldo {
        LANCAR_EXCECAO_FALTA_ESTOQUE,
        ESTOQUE_SEM_DADOS,
        LISTA_EST_VAZIA;

    }
}

