/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.evtmanifestodest;

import com.touchcomp.basementor.constants.enums.eventonfe.NFeConstStatusEventoNFe;
import com.touchcomp.basementor.constants.enums.eventonfe.NFeConstTipoManifestoDestNFe;
import com.touchcomp.basementor.model.vo.EvtNFeManifestoDest;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.nfe.impl.manifestonfe.WebManifestoNFe;
import com.touchcomp.basementorclientwebservices.nfe.model.env.evtmannfe.ParamsManifestoNFe;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.RetRetornoEvento;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.components.ComponentsBase;
import com.touchcomp.basementorservice.service.impl.evtnfemanifestodest.ServiceEvtNFeManifestoDestImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompEvtManifestoDest
extends ComponentsBase {
    @Autowired
    ServiceEvtNFeManifestoDestImpl serviceEvtManifestoNFe;
    @Autowired
    WebManifestoNFe webManifestoNFe;

    public EvtNFeManifestoDest manifestarNFeEnviarEventoSalvar(EvtNFeManifestoDest ev, ParamsCertificado params) throws ExceptionInvalidState {
        ev = this.manifestarNFeEnviarEvento(ev, params);
        ev = this.serviceEvtManifestoNFe.saveOrUpdateFlush(ev);
        return ev;
    }

    public EvtNFeManifestoDest manifestarNFeEnviarEvento(EvtNFeManifestoDest ev, ParamsCertificado params) throws ExceptionInvalidState {
        try {
            NFeConstStatusEventoNFe stat = NFeConstStatusEventoNFe.valueOfCodigo((Object)ev.getStatus());
            if (stat == null || !stat.isStatusFinal()) {
                RetRetornoEvento ret;
                ParamsManifestoNFe manifesto = new ParamsManifestoNFe();
                manifesto.setChaveAcesso(ev.getChave());
                manifesto.setCnpj(ev.getEmpresa().getPessoa().getComplemento().getCnpj());
                manifesto.setCodIbgeUF(ev.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
                manifesto.setTipoManifesto(NFeConstTipoManifestoDestNFe.valueOfCodigo((String)ev.getTipoEvento().getCodEvento()));
                if (manifesto.getTipoManifesto().exigeJustificativa()) {
                    if (!TMethods.isStrWithDataLengthAtLeast((String)ev.getJustificativaEvento(), (int)15)) {
                        throw new ExceptionInvalidState("E.ERP.0858.002", new Object[0]);
                    }
                    manifesto.setMotivo(ev.getJustificativaEvento());
                }
                if ((ret = this.webManifestoNFe.manifestaNFe(params, manifesto)) == null || ret.getEventoRetorno() == null || ret.getEventoRetorno().isEmpty()) {
                    throw new ExceptionInvalidState("E.ERP.0858.001", new Object[]{ev.getChave()});
                }
                RetRetornoEvento.Evento evtRet = (RetRetornoEvento.Evento)ret.getEventoRetorno().get(0);
                ev.setStatus(Short.valueOf(evtRet.getInfoEventoRetorno().getCodigoStatus().shortValue()));
                ev.setMotivo(evtRet.getInfoEventoRetorno().getMotivo());
                ev.setNrProtocolo(evtRet.getInfoEventoRetorno().getNumeroProtocolo());
                ev.getConsultaNFeDestDocDist().setObservacao(evtRet.getInfoEventoRetorno().getMotivo());
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionInvalidState("E.ERP.0858.001", new Object[]{ev.getChave(), ex.getMessage()});
        }
        return ev;
    }
}

