/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.evtossobencomenda;

import com.touchcomp.basementor.constants.enums.eventoosproducao.EnumConstOrigemEventoOSProd;
import com.touchcomp.basementor.model.vo.ClassificacaoEvtOsPCP;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorEvtOsProdSobEnc;
import com.touchcomp.basementor.model.vo.ConfiguracaoPCPAtivo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.EvtOSSobEncomendaEquip;
import com.touchcomp.basementor.model.vo.FaseProdutivaEquip;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdSobEnc;
import com.touchcomp.basementor.model.vo.TipoEvento;
import com.touchcomp.basementor.model.vo.TurnoDeTrabalho;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.service.impl.classificacaoevtoslinprod.ServiceClassificacaoEvtOsPCPImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.configuracaopcpativo.ServiceConfiguracaoPCPAtivoImpl;
import com.touchcomp.basementorservice.service.impl.horariotrabalho.ServiceHorarioTrabalhoImpl;
import com.touchcomp.basementorservice.service.impl.ordemservicoprodsobenc.ServiceSubdivisaoOSProdSobEncImpl;
import com.touchcomp.basementorservice.service.impl.roteiroproducao.ServiceRoteiroProdFaseProdEquipImpl;
import com.touchcomp.basementorservice.service.impl.tipoevento.ServiceTipoEventoImpl;
import com.touchcomp.basementorservice.service.impl.turnodetrabalho.ServiceTurnoDeTrabalhoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.eventoossobencomenda.DTOEventoOSSobEncomendaSimples;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;

public class AuxEventoOSProdSobEnc {
    final ServiceRoteiroProdFaseProdEquipImpl serviceEquipamento;
    final ServiceColaboradorImpl serviceColaborador;
    final ServiceSubdivisaoOSProdSobEncImpl serviceSubOs;
    final ServiceTipoEventoImpl serviceTipoEvento;
    final ServiceHorarioTrabalhoImpl serviceHorarioTraballho;
    final ServiceTurnoDeTrabalhoImpl serviceTurnoTrabalho;
    final ServiceConfiguracaoPCPAtivoImpl serviceConfiguracaoPCPAtivoImpl;
    final ServiceClassificacaoEvtOsPCPImpl serviceClassificacaoEvtOsPCPImpl;

    public AuxEventoOSProdSobEnc(ServiceRoteiroProdFaseProdEquipImpl serviceEquipamento, ServiceColaboradorImpl serviceColaborador, ServiceSubdivisaoOSProdSobEncImpl serviceSubOs, ServiceTipoEventoImpl serviceTipoEvento, ServiceHorarioTrabalhoImpl serviceHorarioTraballho, ServiceTurnoDeTrabalhoImpl serviceTurnoTrabalho, ServiceConfiguracaoPCPAtivoImpl serviceConfiguracaoPCPAtivoImpl, ServiceClassificacaoEvtOsPCPImpl serviceClassificacaoEvtOsPCPImpl) {
        this.serviceEquipamento = serviceEquipamento;
        this.serviceColaborador = serviceColaborador;
        this.serviceSubOs = serviceSubOs;
        this.serviceTipoEvento = serviceTipoEvento;
        this.serviceHorarioTraballho = serviceHorarioTraballho;
        this.serviceTurnoTrabalho = serviceTurnoTrabalho;
        this.serviceConfiguracaoPCPAtivoImpl = serviceConfiguracaoPCPAtivoImpl;
        this.serviceClassificacaoEvtOsPCPImpl = serviceClassificacaoEvtOsPCPImpl;
    }

    EventoOsProdSobEnc getEvento(DTOEventoOSSobEncomendaSimples input, Empresa empresa, OpcoesPCP opcoes) throws ExceptionObjNotFound, ExceptionInvalidData {
        Colaborador colaborador = (Colaborador)this.serviceColaborador.get(input.getIdentificadorColaborador());
        if (colaborador == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0516.002", new Object[]{input.getIdentificadorColaborador()}));
        }
        TipoEvento tipoEvento = (TipoEvento)this.serviceTipoEvento.get(input.getIdentificadorTipoEvento());
        if (tipoEvento == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0533.001", new Object[]{input.getIdentificadorTipoEvento()}));
        }
        SubdivisaoOSProdSobEnc subOS = (SubdivisaoOSProdSobEnc)this.serviceSubOs.get(input.getIdentificadorSubOs());
        if (subOS == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0430.002", new Object[]{input.getIdentificadorSubOs()}));
        }
        HorarioTrabalho hor = this.serviceHorarioTraballho.getHorarioTrabalho(empresa, input.getDataEvento(), ToolDate.getHorasEmNumero((Date)input.getDataEvento()));
        EventoOsProdSobEnc evento = new EventoOsProdSobEnc();
        evento.setOrigemEvento(EnumConstOrigemEventoOSProd.SIMPLIFICADO.getValue());
        evento.setDataAbertura(input.getDataEvento());
        evento.setDataCadastro(new Date());
        evento.setEmpresa(empresa);
        evento.setFaseProdutiva(subOS.getFaseProdutiva());
        if (ToolMethods.isWithData((Number)input.getIdentificadorColaborador())) {
            ColaboradorEvtOsProdSobEnc colab = new ColaboradorEvtOsProdSobEnc();
            colab.setColaborador(colaborador);
            evento.setColaboradoresEvtProd(ToolMethods.toList((Object[])new Object[]{colab}));
        }
        if (ToolMethods.isWithData((Number)input.getIdentificadorFaseProdEquip()) && subOS.getFaseProdutiva() != null && ToolMethods.isWithData((Collection)subOS.getFaseProdutiva().getEquipamentos())) {
            Optional<FaseProdutivaEquip> opt = subOS.getFaseProdutiva().getEquipamentos().stream().filter(i -> ToolMethods.isEquals((Object)i.getCelProdutivaEquip().getCelulaProdutiva(), (Object)subOS.getFaseProdutiva().getCelulaProdutiva()) && ToolMethods.isEquals((Object)i.getCelProdutivaEquip().getEquipamento().getIdentificador(), (Object)input.getIdentificadorFaseProdEquip())).findFirst();
            if (opt.isEmpty()) {
                throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0129.011", new Object[]{input.getIdentificadorFaseProdEquip(), subOS.getFaseProdutiva().getCelulaProdutiva().toString()}));
            }
            FaseProdutivaEquip faseProdutivaEquip = opt.get();
            EvtOSSobEncomendaEquip evtEquip = new EvtOSSobEncomendaEquip();
            evtEquip.setFaseProdutivaEquip(faseProdutivaEquip);
            evento.setEquipamentos(ToolMethods.toList((Object[])new Object[]{evtEquip}));
            if (ToolMethods.isWithData((Number)input.getIdentificadorConfiguracaoEquipamento())) {
                evtEquip.setConfiguracaoAtivo((ConfiguracaoPCPAtivo)this.serviceConfiguracaoPCPAtivoImpl.get(input.getIdentificadorConfiguracaoEquipamento()));
            }
        }
        if (ToolMethods.isWithData((Number)input.getIdentificadorClassificacaoEvento())) {
            evento.setClassificacaoEvento((ClassificacaoEvtOsPCP)this.serviceClassificacaoEvtOsPCPImpl.get(input.getIdentificadorClassificacaoEvento()));
        }
        evento.setSubdivisaoOSProdSobEnc(subOS);
        evento.setTipoEvento(tipoEvento);
        if (hor != null) {
            evento.setTurnoDeTrabalho(hor.getTurnoDeTrabalho());
        }
        if (evento.getTurnoDeTrabalho() == null) {
            evento.setTurnoDeTrabalho((TurnoDeTrabalho)this.serviceTurnoTrabalho.getFirst());
        }
        if (evento.getClassificacaoEvento() == null) {
            evento.setClassificacaoEvento((ClassificacaoEvtOsPCP)this.serviceClassificacaoEvtOsPCPImpl.getFirst());
        }
        return evento;
    }
}

