/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.exceptions;

import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementortools.tools.exception.ToolException;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Enumeration;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class CompExceptions {
    public Data process(Throwable ex) {
        Throwable temp = ToolException.getException((Throwable)ex, DataAccessException.class);
        if (temp != null) {
            return this.checkDataViolationEx((DataAccessException)temp);
        }
        if (ex instanceof ExceptionBase) {
            ExceptionBase aux = (ExceptionBase)ex;
            return new Data(ex, aux.getFormattedMessage(), true);
        }
        if (ex instanceof ExceptionRuntimeBase) {
            ExceptionRuntimeBase aux = (ExceptionRuntimeBase)ex;
            return new Data(ex, aux.getFormattedMessage(), true);
        }
        return new Data(ex, ex.getMessage() != null ? ex.getMessage() : ToolException.getFullPrintStrack((Throwable)ex));
    }

    private Data checkDataViolationEx(DataAccessException ex) {
        Enumeration<String> keys = MessagesBaseMentor.getResourceBundleErrorsBD().getKeys();
        String full = ToolException.getFullPrintStrack((Throwable)ex);
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!full.contains(key)) continue;
            Object[] tokensToReplace = ToolString.getReplaceTokensInArray((String)full);
            return new Data((Throwable)ex, MessagesBaseMentor.getErrorMsgBD((String)key, (Object[])tokensToReplace), true);
        }
        if (full.contains("generator") && full.contains("is not defined")) {
            return new Data((Throwable)ex, MessagesBaseMentor.getErrorMsgBD((String)"E.BD.GEN.03", (Object[])new Object[]{ex.getMessage()}), true);
        }
        if (full.contains("could not prepare")) {
            return new Data((Throwable)ex, MessagesBaseMentor.getErrorMsgBD((String)"E.BD.GEN.04", (Object[])new Object[]{ex.getMessage()}), true);
        }
        if (full.contains("org.hibernate.exception.ConstraintViolationException")) {
            return new Data((Throwable)ex, MessagesBaseMentor.getErrorMsgBD((String)"E.BD.GEN.05", (Object[])new Object[]{ex.getMessage(), ex.getRootCause()}), true);
        }
        return new Data((Throwable)ex, MessagesBaseMentor.getErrorMsgBD((String)"E.BD.GEN.02", (Object[])new Object[0]), true);
    }

    public static class Data {
        private Throwable ex;
        private String formattedMessage;
        private boolean formatted;

        public Data(Throwable ex, String formattedMessage) {
            this.ex = ex;
            this.formattedMessage = formattedMessage;
        }

        public Data(Throwable ex, String formattedMessage, boolean formatted) {
            this.ex = ex;
            this.formattedMessage = formattedMessage;
            this.formatted = formatted;
        }

        public Throwable getEx() {
            return this.ex;
        }

        public void setEx(Throwable ex) {
            this.ex = ex;
        }

        public String getFormattedMessage() {
            return this.formattedMessage;
        }

        public void setFormattedMessage(String formattedMessage) {
            this.formattedMessage = formattedMessage;
        }

        public boolean isFormatted() {
            return this.formatted;
        }

        public void setFormatted(boolean formatted) {
            this.formatted = formatted;
        }
    }
}

