/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.expedicao;

import com.touchcomp.basementor.model.deprecated.PreFaturamentoPed;
import com.touchcomp.basementor.model.vo.EmbalagemExpedicao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.ItemEmbalagemExpedicao;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.PreFaturamentoNF;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class CompExpedicao {
    public Expedicao getExpedicaoAberta(Pedido pedido) {
        if (ToolMethods.isWithData((Collection)pedido.getExpedicao())) {
            return (Expedicao)pedido.getExpedicao().get(0);
        }
        return this.getNovaExpedicao(pedido);
    }

    public Expedicao getNovaExpedicao(Pedido pedido) {
        Expedicao exp = this.getNovaExpedicao(pedido.getEmpresa());
        exp.setPedido(pedido);
        pedido.getExpedicao().add(exp);
        return exp;
    }

    public Expedicao getExpedicaoAberta(PreFaturamentoNF vo) {
        if (vo.getExpedicao() != null) {
            return vo.getExpedicao();
        }
        return this.getNovaExpedicao(vo);
    }

    public Expedicao getNovaExpedicao(PreFaturamentoNF pedido) {
        Expedicao exp = this.getNovaExpedicao(pedido.getEmpresa());
        exp.setPreFaturamentoNF(pedido);
        pedido.setExpedicao(exp);
        return exp;
    }

    public Expedicao getNovaExpedicao(PreFaturamentoPed preFaturamentoPed, Pedido pedido) {
        Expedicao exp = this.getNovaExpedicao(preFaturamentoPed.getEmpresa());
        exp.setPreFaturamentoPed(preFaturamentoPed);
        preFaturamentoPed.setExpedicao(exp);
        exp.setPedido(pedido);
        return exp;
    }

    public Expedicao clonarExpedicao(Expedicao expOld) {
        Expedicao expNew = new Expedicao();
        expNew.setConferida(expOld.getConferida());
        expNew.setDataCadastro(expOld.getDataCadastro());
        expNew.setDataAtualizacao(expOld.getDataAtualizacao());
        expNew.setEmbalagemExpedicao(expOld.getEmbalagemExpedicao());
        expNew.setEmpresa(expOld.getEmpresa());
        expNew.setUsuario(expOld.getUsuario());
        ArrayList<EmbalagemExpedicao> embalagens = new ArrayList<EmbalagemExpedicao>();
        for (EmbalagemExpedicao embOld : expOld.getEmbalagemExpedicao()) {
            EmbalagemExpedicao embNew = new EmbalagemExpedicao();
            embNew.setDataConferencia(embOld.getDataConferencia());
            embNew.setEmbalagem(embOld.getEmbalagem());
            embNew.setEmbalagemProdOS(embOld.getEmbalagemProdOS());
            embNew.setExpedicao(expNew);
            embNew.setLacraEmbalagem(embOld.getLacraEmbalagem());
            embNew.setNrEmbalagem(embOld.getNrEmbalagem());
            embNew.setOpcaoCaixa(embOld.getOpcaoCaixa());
            embNew.setPesoBruto(embOld.getPesoBruto());
            embNew.setPesoLiquido(embOld.getPesoLiquido());
            embNew.setUsuario(embOld.getUsuario());
            embNew.setVolume(embOld.getVolume());
            embNew.setVolumeUtilizado(embOld.getVolumeUtilizado());
            ArrayList<ItemEmbalagemExpedicao> itens = new ArrayList<ItemEmbalagemExpedicao>();
            for (ItemEmbalagemExpedicao itemOld : embOld.getItemEmbalagemExpedicao()) {
                ItemEmbalagemExpedicao itemNew = new ItemEmbalagemExpedicao();
                itemNew.setEmbalagemExpedicao(embNew);
                itemNew.setGradeCor(itemOld.getGradeCor());
                itemNew.setQuantidade(itemOld.getQuantidade());
                itens.add(itemNew);
            }
            embNew.setItemEmbalagemExpedicao(itens);
            embalagens.add(embNew);
        }
        expNew.setEmbalagemExpedicao(embalagens);
        return expNew;
    }

    private Expedicao getNovaExpedicao(Empresa e) {
        Expedicao exp = new Expedicao();
        exp.setDataCadastro(new Date());
        exp.setEmbalagemExpedicao(new ArrayList());
        exp.setEmpresa(e);
        return exp;
    }
}

