/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.fechamentoordemservico;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.fechamentoordemservico.status.EnumConstStatusServico;
import com.touchcomp.basementor.constants.enums.opcoesmanutencaoativos.EnumConstTipoMovimentoConsumo;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivo;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoItens;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServProc;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.PreProcedimento;
import com.touchcomp.basementor.model.vo.PreProdutoPrevManutencao;
import com.touchcomp.basementor.model.vo.PreServicoProcedimento;
import com.touchcomp.basementor.model.vo.Procedimento;
import com.touchcomp.basementor.model.vo.ProdutoPrevManutencao;
import com.touchcomp.basementor.model.vo.ServicoProcedimento;
import com.touchcomp.basementor.model.vo.SetorExecutanteServicos;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorservice.service.impl.naturezarequisicao.ServiceNaturezaRequisicaoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class AuxServicosProcFechamentoOS {
    final ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicaoImpl;
    final ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl;

    public AuxServicosProcFechamentoOS(ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicaoImpl, ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl) {
        this.serviceNaturezaRequisicaoImpl = serviceNaturezaRequisicaoImpl;
        this.serviceSaldoEstoqueImpl = serviceSaldoEstoqueImpl;
    }

    public List<ServicoProcedimento> geraServicosFechamentoOs(OrdemServico os, Empresa empresa) throws ExceptionParamCtbRequisicao {
        LinkedList<ServicoProcedimento> aux = new LinkedList<ServicoProcedimento>();
        if (os != null) {
            this.atualizarDiagnosticoFechamento(os, aux, empresa);
            this.adicionarPlanoManutencaoFechamento(os, aux, empresa);
        }
        return aux;
    }

    private void adicionarPlanoManutencaoFechamento(OrdemServico os, List<ServicoProcedimento> servicosProcedimentos, Empresa empresa) {
        if (os == null || os.getPlanosManutencaoAtivo() != null && os.getPlanosManutencaoAtivo().isEmpty()) {
            return;
        }
        for (PlanoManutencaoAtivo p : os.getPlanosManutencaoAtivo()) {
            for (SetorExecutanteServicos s : p.getSetorExecutantesServicos()) {
                for (PreServicoProcedimento ps : s.getPreServicoProcedimentos()) {
                    ServicoProcedimento servico = new ServicoProcedimento();
                    servico.setDataCadastro(new Date());
                    servico.setEmpresa(empresa);
                    servico.setExecutado(Short.valueOf((short)0));
                    servico.setDiagnosticoOSServico(null);
                    servico.setServico(ps.getServico());
                    this.addProcedimentosPlanoManutencao(ps, servico, empresa);
                    servicosProcedimentos.add(servico);
                }
            }
        }
    }

    private void addProcedimentosPlanoManutencao(PreServicoProcedimento ps, ServicoProcedimento servico, Empresa empresa) {
        for (PreProcedimento p : ps.getPreProcedimento()) {
            Procedimento procedimento = new Procedimento();
            procedimento.setDataCadastro(new Date());
            procedimento.setEmpresa(empresa);
            procedimento.setExecutado(Short.valueOf((short)0));
            procedimento.setDiagnosticoOSServProc(null);
            procedimento.setDescricao(p.getDescricao());
            procedimento.setServicoProcedimento(servico);
            servico.getProcedimento().add(procedimento);
            this.addItensPlanoManutencao(p, procedimento, empresa);
        }
    }

    private void addItensPlanoManutencao(PreProcedimento pp, Procedimento procedimento, Empresa empresa) {
        ArrayList<ProdutoPrevManutencao> produtosPrevManutencao = new ArrayList<ProdutoPrevManutencao>();
        for (PreProdutoPrevManutencao p : pp.getPreProdutosPrevisaoManutencao()) {
            ProdutoPrevManutencao produtoPrev = new ProdutoPrevManutencao();
            produtoPrev.setDataCadastro(new Date());
            produtoPrev.setEmpresa(empresa);
            produtoPrev.setGradeCor(p.getGradeCor());
            produtoPrev.setProcedimento(procedimento);
            produtoPrev.setGerarPagamentoAgregado(Short.valueOf((short)1));
            produtoPrev.setQtdPrevista(p.getQtdPrevista());
            produtosPrevManutencao.add(produtoPrev);
        }
        procedimento.setProdutosPrevisaoManutencao(produtosPrevManutencao);
    }

    private void atualizarDiagnosticoFechamento(OrdemServico os, List<ServicoProcedimento> servicosProcedimentos, Empresa empresa) throws ExceptionParamCtbRequisicao {
        if (os == null) {
            return;
        }
        DiagnosticoOSAtivo d = os.getDiagnosticoOSAtivo();
        if (d != null) {
            for (DiagnosticoOSAtivoServico dServ : d.getServicos()) {
                List filtered = servicosProcedimentos.stream().filter(item -> dServ.equals((Object)item.getDiagnosticoOSServico())).collect(Collectors.toList());
                ServicoProcedimento found = null;
                if (filtered.isEmpty()) {
                    found = new ServicoProcedimento();
                    found.setDataCadastro(new Date());
                    found.setEmpresa(empresa);
                    found.setExecutado(Short.valueOf((short)0));
                    found.setDiagnosticoOSServico(dServ);
                    found.setServico(dServ.getServico());
                    servicosProcedimentos.add(found);
                } else {
                    found = (ServicoProcedimento)filtered.get(0);
                }
                this.addProcedimentos(dServ, found, empresa);
            }
        }
    }

    void addProcedimentos(DiagnosticoOSAtivoServico dServ, ServicoProcedimento servProc, Empresa empresa) throws ExceptionParamCtbRequisicao {
        for (DiagnosticoOSAtivoServProc procedimento : dServ.getProcedimentos()) {
            List filtered = servProc.getProcedimento().stream().filter(item -> procedimento.equals((Object)item.getDiagnosticoOSServProc())).collect(Collectors.toList());
            Procedimento found = null;
            if (filtered.isEmpty()) {
                found = new Procedimento();
                found.setDataCadastro(new Date());
                found.setEmpresa(empresa);
                found.setExecutado(Short.valueOf(EnumConstStatusServico.EXECUTADO.getValue()));
                found.setDiagnosticoOSServProc(procedimento);
                found.setDescricao(procedimento.getObservacaoProcedimento());
                found.setServicoProcedimento(servProc);
                servProc.getProcedimento().add(found);
            } else {
                found = (Procedimento)filtered.get(0);
            }
            this.addItens(procedimento, found, empresa);
        }
    }

    private void addItens(DiagnosticoOSAtivoServProc dServ, Procedimento procedimento, Empresa empresa) throws ExceptionParamCtbRequisicao {
        procedimento.getProdutosPrevisaoManutencao().clear();
        for (DiagnosticoOSAtivoItens item : dServ.getItens()) {
            this.addItensReqAtendidos(item, procedimento, empresa);
            this.addItensTransfAtendidos(item, procedimento, empresa);
            this.addItensSemPedOuAtend(item, procedimento, empresa);
        }
    }

    private void addItensSemPedOuAtend(DiagnosticoOSAtivoItens item, Procedimento procedimento, Empresa empresa) throws ExceptionParamCtbRequisicao {
        if (item != null && item.getGradeCor() != null) {
            GradeCor gradeCor = item.getGradeCor();
            LoteFabricacao lote = null;
            if (ToolMethods.isAffirmative((Number)gradeCor.getProdutoGrade().getProduto().getLoteUnico())) {
                lote = this.serviceSaldoEstoqueImpl.findMelhorLoteFabricacao(new Date(), item.getGradeCor(), empresa, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO);
            }
            NaturezaRequisicao nat = this.serviceNaturezaRequisicaoImpl.getFirstOrThrow(item.getGradeCor().getProdutoGrade().getProduto(), empresa);
            this.newProdutoPrevManutencao(item, procedimento, lote, item.getQuantidade(), nat, EnumConstTipoMovimentoConsumo.CONSUMO_INTERNO, empresa);
        }
    }

    private void addItensReqAtendidos(DiagnosticoOSAtivoItens item, Procedimento procedimento, Empresa empresa) {
        if (item.getItemPedidoAlmoxarifado() == null) {
            return;
        }
        ItemPedidoAlmoxarifado itAlmox = item.getItemPedidoAlmoxarifado();
        for (GradeItemPedidoAlmoxarifado gradeItemPedidoAlmoxarifado : itAlmox.getGradesItensAlmoxarifado()) {
            if (gradeItemPedidoAlmoxarifado.getAtendimentoPedAlmoxItemGrade() == null) continue;
            for (ItemRequisicao itemRequisicao : gradeItemPedidoAlmoxarifado.getAtendimentoPedAlmoxItemGrade().getItensRequisicao()) {
                for (GradeItemRequisicao gradeItemRequisicao : itemRequisicao.getGradeItemRequisicao()) {
                    this.newProdutoPrevManutencao(item, procedimento, gradeItemRequisicao.getLoteFabricacao(), gradeItemRequisicao.getQuantidade(), itemRequisicao.getNaturezaRequisicao(), EnumConstTipoMovimentoConsumo.CONSUMO_INTERNO_SEM_BAIXA_EST, empresa);
                }
            }
        }
    }

    private void addItensTransfAtendidos(DiagnosticoOSAtivoItens item, Procedimento procedimento, Empresa empresa) throws ExceptionParamCtbRequisicao {
        if (item.getItemPedidoAlmoxarifado() == null) {
            return;
        }
        ItemPedidoAlmoxarifado itAlmox = item.getItemPedidoAlmoxarifado();
        for (GradeItemPedidoAlmoxarifado gradeItemPedidoAlmoxarifado : itAlmox.getGradesItensAlmoxarifado()) {
            if (gradeItemPedidoAlmoxarifado.getAtendimentoPedAlmoxItemGrade() == null) continue;
            for (ItemTransfCentroEstoque itemTransf : gradeItemPedidoAlmoxarifado.getAtendimentoPedAlmoxItemGrade().getItemTransfCentroEst()) {
                for (GradeItemTransfCentroEstoque gradeItemTransf : itemTransf.getGradeItemTransCentroEst()) {
                    NaturezaRequisicao nat = this.serviceNaturezaRequisicaoImpl.getFirstOrThrow(itemTransf.getProduto(), empresa);
                    this.newProdutoPrevManutencao(item, procedimento, gradeItemTransf.getLoteFabricacao(), gradeItemTransf.getQuantidade(), nat, EnumConstTipoMovimentoConsumo.CONSUMO_INTERNO, empresa);
                }
            }
        }
    }

    public void newProdutoPrevManutencao(DiagnosticoOSAtivoItens item, Procedimento procedimento, LoteFabricacao loteFabricacao, Double quantidade, NaturezaRequisicao naturezaRequisicao, EnumConstTipoMovimentoConsumo tipoBaixa, Empresa e) {
        ProdutoPrevManutencao found = new ProdutoPrevManutencao();
        found.setDataCadastro(new Date());
        found.setEmpresa(e);
        found.setGradeCor(item.getGradeCor());
        found.setItemDiagnostico(item);
        found.setProcedimento(procedimento);
        found.setTipoMovProdutoCons(tipoBaixa.getValue());
        found.setLoteFabricacao(loteFabricacao);
        found.setQtdPrevista(quantidade);
        found.setQtdReal(quantidade);
        found.setNaturezaRequisicao(naturezaRequisicao);
        found.setTipoMovProdutoCons(tipoBaixa.getValue());
        procedimento.getProdutosPrevisaoManutencao().add(found);
    }
}

