/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.gradeformulaproduto;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormProdModFichaTec;
import com.touchcomp.basementor.model.vo.GradeFormProdTpSpedProd;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProdutoSubstituto;
import com.touchcomp.basementor.model.vo.ItemPerdaFormProduto;
import com.touchcomp.basementor.model.vo.ItemSobraFormProduto;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.TipoProducaoSped;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorservice.helpers.impl.produto.HelperProduto;
import com.touchcomp.basementorservice.service.impl.naturezarequisicao.ServiceNaturezaRequisicaoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompGradeFormulaProduto {
    private ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicao;
    private HelperProduto helperProduto;

    @Autowired
    public CompGradeFormulaProduto(ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicao, HelperProduto helperProduto) {
        this.serviceNaturezaRequisicao = serviceNaturezaRequisicao;
        this.helperProduto = helperProduto;
    }

    public GradeFormProdTpSpedProd getGradeFormProdTpSpedProd(TipoProducaoSped tipoProducaoSped) {
        GradeFormProdTpSpedProd it = new GradeFormProdTpSpedProd();
        it.setTipoProducaoSped(tipoProducaoSped);
        return it;
    }

    public GradeFormProdModFichaTec getGradeFormProdModFichaTec(ModeloFichaTecnica modFichaTecnica) {
        GradeFormProdModFichaTec it = new GradeFormProdModFichaTec();
        it.setModeloFichaTecnica(modFichaTecnica);
        return it;
    }

    public ItemPerdaFormProduto getItemPerdaFormProduto(GradeFormulaProduto g) {
        ItemPerdaFormProduto it = new ItemPerdaFormProduto();
        it.setGradeFormulaProdutoPerda(g);
        return it;
    }

    public List<ItemSobraFormProduto> getItemSobraFormProduto(List<GradeCor> g) throws ExceptionInvalidData {
        if (g == null || g.isEmpty()) {
            throw new ExceptionInvalidData("E.ERP.0425.003", new Object[0]);
        }
        ArrayList<ItemSobraFormProduto> ret = new ArrayList<ItemSobraFormProduto>();
        for (GradeCor gc : g) {
            ret.add(this.getItemSobraFormProduto(gc));
        }
        return ret;
    }

    public ItemSobraFormProduto getItemSobraFormProduto(GradeCor g) throws ExceptionInvalidData {
        if (g == null || !TMethods.isAffirmative((Number)g.getAtivo())) {
            throw new ExceptionInvalidData("E.ERP.0425.003", new Object[0]);
        }
        ItemSobraFormProduto it = new ItemSobraFormProduto();
        it.setGradeCor(g);
        return it;
    }

    public List<ItemGradeFormulaProduto> getItemGradeFormulaProduto(List<GradeCor> g, Empresa empresa) throws ExceptionParamCtbRequisicao, ExceptionInvalidData {
        if (g == null || g.isEmpty()) {
            throw new ExceptionInvalidData("E.ERP.0425.003", new Object[0]);
        }
        ArrayList<ItemGradeFormulaProduto> ret = new ArrayList<ItemGradeFormulaProduto>();
        for (GradeCor gc : g) {
            ret.add(this.getItemGradeFormulaProduto(gc, empresa));
        }
        return ret;
    }

    public ItemGradeFormulaProduto getItemGradeFormulaProduto(GradeCor g, Empresa empresa) throws ExceptionParamCtbRequisicao, ExceptionInvalidData {
        if (g == null || !TMethods.isAffirmative((Number)g.getAtivo())) {
            throw new ExceptionInvalidData("E.ERP.0425.003", new Object[0]);
        }
        ItemGradeFormulaProduto it = new ItemGradeFormulaProduto();
        it.setGradeCor(g);
        it.setLargura(g.getProdutoGrade().getProduto().getLargura());
        it.setAltura(g.getProdutoGrade().getProduto().getAltura());
        it.setComprimento(g.getProdutoGrade().getProduto().getComprimento());
        it.setNaturezaRequisicao(this.getNaturezaRequisicao(it, empresa));
        it.setCodReferencia(this.helperProduto.build(g.getProdutoGrade().getProduto()).getCodReferencia());
        return it;
    }

    public ItemGradeFormulaProdutoSubstituto getItemGradeFormulaProdutoSubstituto(GradeCor g) throws ExceptionInvalidData {
        if (g == null || !TMethods.isAffirmative((Number)g.getAtivo())) {
            throw new ExceptionInvalidData("E.ERP.0425.003", new Object[0]);
        }
        ItemGradeFormulaProdutoSubstituto it = new ItemGradeFormulaProdutoSubstituto();
        it.setGradeCor(g);
        it.setCodReferencia(this.helperProduto.build(g.getProdutoGrade().getProduto()).getCodReferencia());
        return it;
    }

    private NaturezaRequisicao getNaturezaRequisicao(ItemGradeFormulaProduto it, Empresa empresa) throws ExceptionParamCtbRequisicao {
        return this.serviceNaturezaRequisicao.getFirstOrThrow(it.getGradeCor().getProdutoGrade().getProduto(), empresa);
    }
}

