/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.gradeitempedido;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.produto.ExceptionProdutoSemGrades;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.helpers.impl.centroestoque.HelperCentroEstoque;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompGradeItemPedido
extends BaseMethods {
    @Autowired
    private ServiceGradeCorImpl serviceGradeCor;

    public List<GradeItemPedido> findGradesItemPedidoExlusiveAll(Produto produto, List<GradeItemPedido> grades, NaturezaOperacao nat, UnidadeFatCliente unidade, OpcoesEstoque opcoesEstoque, Empresa empresa, Usuario usuario) throws ExceptionProdutoSemGrades {
        List<GradeItemPedido> result = this.findGradeItemPedidoByProdutoExcAll(produto, grades);
        if (result == null || result.isEmpty()) {
            throw new ExceptionProdutoSemGrades("01-02-00738", new Object[0]);
        }
        HelperCentroEstoque helperCentroEstoque = this.getBean(HelperCentroEstoque.class);
        CentroEstoque cc = null;
        if (nat != null && unidade != null) {
            cc = helperCentroEstoque.getCentroEstoque(opcoesEstoque, empresa, produto, usuario, nat, unidade);
        }
        for (GradeItemPedido gradeItemPedido : result) {
            gradeItemPedido.setDataMovimentacao(new Date());
            gradeItemPedido.setEmpresa(empresa);
            gradeItemPedido.setMovimentacaoFisica(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            gradeItemPedido.setCentroEstoque(cc);
        }
        return result;
    }

    public List<GradeItemPedido> findGradeItemPedidoByProdutoExcAll(Produto produto, List<GradeItemPedido> grades) {
        List<GradeCor> aux = this.serviceGradeCor.findGradeItemPedidoByProdutoExcAll(produto, grades);
        if (aux != null) {
            for (GradeCor gc : aux) {
                GradeItemPedido g = new GradeItemPedido();
                g.setGradeCor(gc);
                grades.add(g);
            }
        }
        return grades;
    }
}

