/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.historicopadrao;

import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.obsdinamica.CompOBSDinamica;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompHistoricoPadrao {
    @Autowired
    CompOBSDinamica compObsDinamica;

    public String buildHistoricoDinamico(HistoricoPadrao hist, Object source) throws ExceptionReflection, ExceptionInvalidData {
        if (hist == null) {
            return "";
        }
        if (hist.getObservacaoDinamica() == null) {
            return hist.getDescricao();
        }
        return this.compObsDinamica.build(source, hist.getObservacaoDinamica().getObservacao());
    }

    public String buildHistoricoDinamico(HistoricoPadrao hist, Object source, List<StringToken> tokens) throws ExceptionReflection, ExceptionInvalidData {
        if (hist == null) {
            return "";
        }
        if (hist.getObservacaoDinamica() == null) {
            return ToolString.build((String)hist.getDescricao(), tokens);
        }
        return this.compObsDinamica.build(source, hist.getObservacaoDinamica().getObservacao(), hist.getObservacaoDinamica().getCondicaoAplicacao(), tokens);
    }

    public List<StringToken> getAuxTokens(HistoricoPadrao historico) {
        if (historico == null) {
            return new LinkedList<StringToken>();
        }
        if (historico.getObservacaoDinamica() == null) {
            return ToolString.getReplaceTokens((String)historico.getDescricao());
        }
        return this.compObsDinamica.getTokensAux(historico.getObservacaoDinamica().getObservacao());
    }
}

