/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.indiceeconomico;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.IndiceEconomico;
import com.touchcomp.basementor.model.vo.LinhasIndiceEconomico;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import org.springframework.stereotype.Component;

@Component
public class CompIndiceEconomico {
    public String getFormatLinha(Integer indice) {
        if (indice == null) {
            return "";
        }
        Object prefix = "linha_" + indice;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public String getFormatPlanoConta(String planoConta, String centroCusto) {
        if (planoConta == null) {
            return "";
        }
        Object prefix = "plano.conta_" + planoConta;
        if (centroCusto != null) {
            prefix = (String)prefix + "_" + centroCusto;
        }
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public String getFormatPlanoConta(String planoConta) {
        if (planoConta == null) {
            return "";
        }
        Object prefix = "plano.conta_" + planoConta;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public String getFormatVariavel(String variavel) {
        if (variavel == null) {
            return "";
        }
        Object prefix = "var_" + variavel;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public String getFormatVariavelSemMarcacoes(String variavel) {
        if (variavel == null) {
            return "";
        }
        Object prefix = "var_" + variavel;
        prefix = ((String)prefix).trim();
        return ((String)prefix).trim();
    }

    public String getFormatValorFinalContaValores(Long idContaValor) {
        if (idContaValor == null) {
            return "";
        }
        Object prefix = "valor.final.conta_" + idContaValor;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public String getFormatValorLinhaAcumulada(Integer indice) {
        if (indice == null) {
            return "";
        }
        Object prefix = "valor.linha.acumulada_" + indice;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public String getFormatValorInicialContaValores(Long idContaValor) {
        if (idContaValor == null) {
            return "";
        }
        Object prefix = "valor.inicial.conta_" + idContaValor;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public IndiceEconomico criarLinhaIndiceEconomico(IndiceEconomico vo, Integer numeroLinha) {
        Integer nrLinha = this.getMaxLinha(vo) + 1;
        if (TMethods.isNotNull((Object)numeroLinha).booleanValue() && numeroLinha >= 0) {
            nrLinha = numeroLinha;
        }
        LinhasIndiceEconomico toAdd = this.getNewRow(nrLinha);
        this.addToLines(vo.getLinhas(), toAdd);
        this.reorderIndex(vo);
        return vo;
    }

    public void reorderIndex(IndiceEconomico vo) {
        for (int i = 0; i < vo.getLinhas().size(); ++i) {
            LinhasIndiceEconomico l = (LinhasIndiceEconomico)vo.getLinhas().get(i);
            l.setIndice(Integer.valueOf(i + 1));
        }
    }

    private Integer getMaxLinha(IndiceEconomico vo) {
        OptionalInt tmp = vo.getLinhas().stream().mapToInt(i -> i.getIndice()).max();
        return tmp.isPresent() ? tmp.getAsInt() : 0;
    }

    private LinhasIndiceEconomico getNewRow(Integer nrLinha) {
        LinhasIndiceEconomico vo = new LinhasIndiceEconomico();
        vo.setIndice(nrLinha);
        vo.setNegrito(Integer.valueOf(EnumConstantsMentorSimNao.NAO.getValueInt()));
        return vo;
    }

    private void addToLines(List<LinhasIndiceEconomico> aux, LinhasIndiceEconomico toAdd) {
        aux.forEach(i -> {
            if (i.getIndice() >= toAdd.getIndice()) {
                i.setIndice(Integer.valueOf(i.getIndice() + 1));
            }
        });
        aux.add(toAdd);
        Collections.sort(aux, (item1, item2) -> item1.getIndice().compareTo(item2.getIndice()));
    }

    public String criarVariavelPlanoConta(List<PlanoConta> planos, Short filtrarCentroCusto, String codigoCC) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < planos.size(); ++i) {
            PlanoConta p = planos.get(i);
            if (TMethods.isAffirmative((Number)filtrarCentroCusto)) {
                sb.append(this.getFormatPlanoConta(p.getCodigo(), codigoCC));
            } else {
                sb.append(this.getFormatPlanoConta(p.getCodigo()));
            }
            if (i + 1 < planos.size()) {
                sb.append(" + ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getFormatVariavelSaldoAnterior(String codigoPlanoConta) {
        if (codigoPlanoConta == null) {
            return "";
        }
        Object prefix = "saldo.anterior.pc_" + codigoPlanoConta;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public String getFormatVariavelDebitos(String codigoPlanoConta) {
        if (codigoPlanoConta == null) {
            return "";
        }
        Object prefix = "debitos.pc_" + codigoPlanoConta;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public String getFormatVariavelCreditos(String codigoPlanoConta) {
        if (codigoPlanoConta == null) {
            return "";
        }
        Object prefix = "creditos.pc_" + codigoPlanoConta;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }
}

