/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.indicegerencial;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.IndiceGerencial;
import com.touchcomp.basementor.model.vo.LinhasIndiceGerencial;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import org.springframework.stereotype.Component;

@Component
public class CompIndiceGerencial {
    public String getFormatLinha(Integer indice) {
        if (indice == null) {
            return "";
        }
        Object prefix = "linha_" + indice;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public String getFormatPlanoConta(String planoConta, String centroCusto) {
        if (planoConta == null) {
            return "";
        }
        Object prefix = "plano.conta_" + planoConta;
        if (centroCusto != null) {
            prefix = (String)prefix + "_" + centroCusto;
        }
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public String getFormatPlanoConta(String planoConta) {
        if (planoConta == null) {
            return "";
        }
        Object prefix = "plano.conta_" + planoConta;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public String getFormatVariavel(String variavel) {
        if (variavel == null) {
            return "";
        }
        Object prefix = "var_" + variavel;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public String getFormatVariavelSemMarcacoes(String variavel) {
        if (variavel == null) {
            return "";
        }
        Object prefix = "var_" + variavel;
        prefix = ((String)prefix).trim();
        return ((String)prefix).trim();
    }

    public String getFormatValorFinalContaValores(Long idContaValor) {
        if (idContaValor == null) {
            return "";
        }
        Object prefix = "var.final.conta_" + idContaValor;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public String getFormatValorLinhaAcumulada(Integer indice) {
        if (indice == null) {
            return "";
        }
        Object prefix = "valor.linha.acumulada_" + indice;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public String getFormatValorInicialContaValores(Long idContaValor) {
        if (idContaValor == null) {
            return "";
        }
        Object prefix = "valor.inicial.conta_" + idContaValor;
        prefix = ((String)prefix).trim();
        return "@" + (String)prefix + "@".trim();
    }

    public IndiceGerencial criarLinhaIndiceGerencial(IndiceGerencial vo, Integer numeroLinha) {
        Integer nrLinha = this.getMaxLinha(vo) + 1;
        if (TMethods.isNotNull((Object)numeroLinha).booleanValue() && numeroLinha >= 0) {
            nrLinha = numeroLinha;
        }
        LinhasIndiceGerencial toAdd = this.getNewRow(nrLinha);
        this.addToLines(vo.getLinhas(), toAdd);
        this.reorderIndex(vo);
        return vo;
    }

    public void reorderIndex(IndiceGerencial vo) {
        for (int i = 0; i < vo.getLinhas().size(); ++i) {
            LinhasIndiceGerencial l = (LinhasIndiceGerencial)vo.getLinhas().get(i);
            l.setIndice(Integer.valueOf(i + 1));
        }
    }

    private Integer getMaxLinha(IndiceGerencial vo) {
        OptionalInt tmp = vo.getLinhas().stream().mapToInt(i -> i.getIndice()).max();
        return tmp.isPresent() ? tmp.getAsInt() : 0;
    }

    private LinhasIndiceGerencial getNewRow(Integer nrLinha) {
        LinhasIndiceGerencial vo = new LinhasIndiceGerencial();
        vo.setIndice(nrLinha);
        vo.setNegrito(Integer.valueOf(EnumConstantsMentorSimNao.NAO.getValueInt()));
        return vo;
    }

    private void addToLines(List<LinhasIndiceGerencial> aux, LinhasIndiceGerencial toAdd) {
        aux.forEach(i -> {
            if (i.getIndice() >= toAdd.getIndice()) {
                i.setIndice(Integer.valueOf(i.getIndice() + 1));
            }
        });
        aux.add(toAdd);
        Collections.sort(aux, (item1, item2) -> item1.getIndice().compareTo(item2.getIndice()));
    }

    public String criarVariavelPlanoConta(List<PlanoContaGerencial> planos, Short filtrarCentroCusto, String codigoCC) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < planos.size(); ++i) {
            PlanoContaGerencial p = planos.get(i);
            if (TMethods.isAffirmative((Number)filtrarCentroCusto)) {
                sb.append(this.getFormatPlanoConta(p.getCodigo(), codigoCC));
            } else {
                sb.append(this.getFormatPlanoConta(p.getCodigo()));
            }
            if (i + 1 < planos.size()) {
                sb.append(" + ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

