/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.integracaocustoprodvendido;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntegCustoProdVendidoData;
import com.touchcomp.basementor.model.vo.IntegCustoProdVendidoItem;
import com.touchcomp.basementor.model.vo.IntegracaoCustoProdVendido;
import com.touchcomp.basementor.model.vo.IntegracaoCustoProdVendidoLancCtbGerencial;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.service.impl.integracaocustoprodvendido.ServiceIntegracaoCustoProdVendidoImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidImpl;
import com.touchcomp.basementorvalidator.others.date.ValidateDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompIntegracaoCustoProdutoVendido
extends CompLancamentoBase {
    @Autowired
    private HelperLancamentoCtbGerencial helperLancamentoCtbGerencial;

    public void validIntervaloBloqueio(Long dataInicial, Long dataFinal, Empresa empresa) {
        ValidImpl valid = this.validIntervalo(dataInicial, dataFinal);
        if (valid != null) {
            throw new ExceptionRuntimeBase(valid.getContainer().toString());
        }
        this.haBloqueio(dataInicial, dataFinal, empresa);
    }

    private ValidImpl validIntervalo(Long dataInicial, Long dataFinal) {
        ValidateDate validatorDates = (ValidateDate)ConfApplicationContext.getBean(ValidateDate.class);
        ValidImpl resultValidator = validatorDates.isValidDates(dataInicial, dataFinal);
        if (TMethods.isEquals((Object)resultValidator.hasErrors(), (Object)true)) {
            return resultValidator;
        }
        return null;
    }

    public Boolean haBloqueio(Long dataInicial, Long dataFinal, Empresa empresa) {
        this.haBloqueio(new Date(dataInicial), new Date(dataFinal), empresa);
        return false;
    }

    public Boolean haBloqueio(Date dataInicial, Date dataFinal, Empresa empresa) {
        ServiceIntegracaoCustoProdVendidoImpl serviceIntegracaoCustoProdVendido = (ServiceIntegracaoCustoProdVendidoImpl)ConfApplicationContext.getBean(ServiceIntegracaoCustoProdVendidoImpl.class);
        List<IntegracaoCustoProdVendido> bloqueios = serviceIntegracaoCustoProdVendido.getBloqueio(dataInicial, dataFinal, empresa);
        if (bloqueios != null && !bloqueios.isEmpty()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0971.001"));
        }
        return false;
    }

    public void contabilizarCustoProdVendido(IntegCustoProdVendidoData i, Empresa empresa, Short gerarLancAnaliticos) {
        LoteContabil lote = this.criarLoteContabil(i.getLoteContabil(), i.getDataIntegracao(), empresa, ConstEnumOrigemLoteContabil.INTEG_CUSTO_PROD_VEND_DATA);
        List<Lancamento> lancamentos = this.getLancamentos(i, lote, gerarLancAnaliticos, empresa);
        lote.setLancamentos(lancamentos);
        i.setLoteContabil(lote);
    }

    private List<Lancamento> getLancamentos(IntegCustoProdVendidoData i, LoteContabil lote, Short gerarLancAnaliticos, Empresa e) {
        ArrayList<Lancamento> lanc = new ArrayList<Lancamento>();
        for (IntegCustoProdVendidoItem ig : i.getIntegCustoProdVendItem()) {
            Optional<Lancamento> aux = lanc.stream().filter(j -> Objects.equals(j.getPlanoContaDeb(), ig.getPcDebito()) && Objects.equals(j.getPlanoContaCred(), ig.getPcCredito())).findFirst();
            if (aux.isPresent() && !TMethods.isAffirmative((Number)gerarLancAnaliticos)) {
                aux.get().setValor(Double.valueOf(aux.get().getValor() + ig.getValorTotal()));
                continue;
            }
            Lancamento found = CompIntegracaoCustoProdutoVendido.newLancamento(lote, e);
            if (TMethods.isAffirmative((Number)gerarLancAnaliticos)) {
                found.setHistorico("Lancamento gerado pelo custo do produto vendido pelo " + ig.getProduto().getIdentificador() + " - " + ig.getProduto().getNome() + " em " + ToolDate.dateToStr((Date)i.getDataIntegracao()));
            } else {
                found.setHistorico("Lancamento gerado pelo custo do produto vendido em " + ToolDate.dateToStr((Date)i.getDataIntegracao()));
            }
            found.setPlanoContaCred(ig.getPcCredito());
            found.setPlanoContaDeb(ig.getPcDebito());
            found.setValor(ig.getValorTotal());
            lanc.add(found);
        }
        return lanc;
    }

    public void criaLancamentoCtbGerencialIntegrandoCustoProdVendido(IntegCustoProdVendidoData i, Empresa empresa, Short gerarLancAnaliticos) {
        ArrayList<IntegracaoCustoProdVendidoLancCtbGerencial> listReturn = new ArrayList<IntegracaoCustoProdVendidoLancCtbGerencial>();
        for (IntegCustoProdVendidoItem item : i.getIntegCustoProdVendItem()) {
            Double valorCusto = item.getPrecoMedio();
            valorCusto = valorCusto * item.getQuantidade();
            Optional<IntegracaoCustoProdVendidoLancCtbGerencial> aux = listReturn.stream().filter(j -> Objects.equals(j.getLacamentoCtbGerencial().getPlanoContaGerencial(), item.getPlanoContaGerencial())).findFirst();
            if (aux.isPresent() && !TMethods.isAffirmative((Number)gerarLancAnaliticos)) {
                IntegracaoCustoProdVendidoLancCtbGerencial found = aux.get();
                found.getLacamentoCtbGerencial().setValor(Double.valueOf(found.getLacamentoCtbGerencial().getValor() + valorCusto));
                continue;
            }
            LancamentoCtbGerencial lancCtbGerencial = this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(null, i.getDataIntegracao(), i.getDataIntegracao(), EnumLancamentoCTBGerencial.DEBITO.getValue(), empresa, EnumConstantsMentorSimNao.NAO.getValue(), "Lancamento gerado pelo custo do produto vendido pelo " + item.getProduto().getIdentificador() + " - " + item.getProduto().getNome() + " em " + ToolDate.dateToStr((Date)i.getDataIntegracao()), item.getPlanoContaGerencial(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue(), null, valorCusto, null);
            IntegracaoCustoProdVendidoLancCtbGerencial integracao = new IntegracaoCustoProdVendidoLancCtbGerencial();
            integracao.setIntegCustoProdVendidoData(i);
            integracao.setLacamentoCtbGerencial(lancCtbGerencial);
            listReturn.add(integracao);
        }
        i.setLancamentosCtbGerenciais(listReturn);
    }
}

