/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.integracaopontoeletronico;

import com.touchcomp.basementor.constants.enums.configservicosterceiros.EnumConstConfigServicosTerceiros;
import com.touchcomp.basementor.constants.enums.configservicosterceiros.impl.ConstantsIntegracaoPonto;
import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ConfigServicosTercItem;
import com.touchcomp.basementor.model.vo.ConfigServicosTerceiros;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.LogSincronizacao;
import com.touchcomp.basementor.model.vo.LogSincronizacaoEntidade;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementorclientwebservices.ponto.model.abono.DTOPontoAfastamentoColaborador;
import com.touchcomp.basementorclientwebservices.ponto.model.abono.DTOPontoFeriasColaborador;
import com.touchcomp.basementorclientwebservices.ponto.model.cargo.DTOPontoCargo;
import com.touchcomp.basementorclientwebservices.ponto.model.cargo.result.tangerino.DTOResultCargoTangerino;
import com.touchcomp.basementorclientwebservices.ponto.model.demissao.DTOPontoDemissao;
import com.touchcomp.basementorclientwebservices.ponto.model.departamento.DTOPontoDepartamento;
import com.touchcomp.basementorclientwebservices.ponto.model.departamento.result.tangerino.DTOResultDepartamentoTangerino;
import com.touchcomp.basementorclientwebservices.ponto.model.funcionario.DTOPontoFuncionario;
import com.touchcomp.basementorclientwebservices.ponto.model.funcionario.result.DTOResultFuncionarioTangerino;
import com.touchcomp.basementorexceptions.exceptions.impl.integracaoponto.ExceptionIntegracaoPontoEletronico;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.components.integracaopontoeletronico.AuxSincTangerino;
import com.touchcomp.basementorservice.service.impl.afastamentocolaborador.ServiceAfastamentoColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.centrocusto.ServiceCentroCustoImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.configservicosterceiros.ServiceConfigServicosTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.feriascolaborador.ServiceFeriasColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.funcao.ServiceFuncaoImpl;
import com.touchcomp.basementorservice.service.impl.logsincronizacao.ServiceLogSincronizacaoImpl;
import com.touchcomp.basementorservice.service.impl.recisao.ServiceRecisaoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompIntegracaoPontoEletronico
extends BaseMethods {
    @Autowired
    private ServiceLogSincronizacaoImpl serviceLogSincronizacao;
    @Autowired
    private ServiceColaboradorImpl serviceColaborador;
    @Autowired
    private ServiceFuncaoImpl serviceFuncao;
    @Autowired
    private ServiceCentroCustoImpl serviceCentroCusto;
    @Autowired
    private ServiceRecisaoImpl serviceRescisao;
    @Autowired
    private ServiceFeriasColaboradorImpl serviceFeriasColaborador;
    @Autowired
    private ServiceAfastamentoColaboradorImpl serviceAfastamentoColaborador;
    @Autowired
    private ServiceConfigServicosTerceirosImpl serviceConfigServico;

    public List<DTOPontoFuncionario> findColaboradoresToSinc() throws ExceptionInvalidState {
        return this.serviceColaborador.findColaboradoresPonto(this.getDataBaseSincronizacaoDados(), this.getDataUltimaSincronizacao(Colaborador.class.getCanonicalName()));
    }

    public List<DTOPontoAfastamentoColaborador> findAfastamentosColabToSinc() throws ExceptionInvalidState {
        return this.serviceAfastamentoColaborador.findAfastamentoColaboradorPonto(this.getDataBaseSincronizacaoDados(), this.getDataUltimaSincronizacao(AfastamentoColaborador.class.getCanonicalName()));
    }

    public List<DTOPontoCargo> findFuncoesToSinc() throws ExceptionInvalidState {
        return this.serviceFuncao.findFuncoesPonto(this.getDataBaseSincronizacaoDados(), this.getDataUltimaSincronizacao(Funcao.class.getCanonicalName()));
    }

    public List<DTOPontoDepartamento> findDepartamentosToSinc() throws ExceptionInvalidState {
        return this.serviceCentroCusto.findDepartamentosPonto(this.getDataBaseSincronizacaoDados(), this.getDataUltimaSincronizacao(CentroCusto.class.getCanonicalName()));
    }

    public List<DTOPontoDemissao> findRescisoesToSinc() throws ExceptionInvalidState {
        return this.serviceRescisao.findRescisoesPonto(this.getDataBaseSincronizacaoDados(), this.getDataUltimaSincronizacao(Recisao.class.getCanonicalName()));
    }

    public List<DTOPontoFeriasColaborador> findFeriasToSinc(EmpresaRh empresaRh) throws ExceptionInvalidState {
        return this.serviceFeriasColaborador.findFeriasColaboradorPonto(this.getDataBaseSincronizacaoDados(), this.getDataUltimaSincronizacao(FeriasColaborador.class.getCanonicalName()));
    }

    public DTOResultFuncionarioTangerino findColaborador(Long identificador) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionInvalidData, ExceptionIO {
        return new AuxSincTangerino().getColaborador(identificador);
    }

    public DTOResultDepartamentoTangerino findDepartamento(Long identificador) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionInvalidData, ExceptionIO {
        return new AuxSincTangerino().getDepartamento(identificador);
    }

    public DTOResultCargoTangerino findFuncao(Long identificador) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionInvalidData, ExceptionIO {
        return new AuxSincTangerino().getFuncao(identificador);
    }

    public void sincFerias(List<DTOPontoFeriasColaborador> ferias) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionInvalidData, ExceptionIO {
        new AuxSincTangerino().sincFerias(ferias);
        this.registerLog(FeriasColaborador.class.getCanonicalName(), null);
    }

    public void sincRescisoes(List<DTOPontoDemissao> rescisoes) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionInvalidData, ExceptionIO {
        new AuxSincTangerino().sincRescisoes(rescisoes);
        this.registerLog(AfastamentoColaborador.class.getCanonicalName(), null);
    }

    public void sincDepartamentos(List<DTOPontoDepartamento> departamentos) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionInvalidData, ExceptionIO {
        new AuxSincTangerino().sincDepartamentos(departamentos);
        this.registerLog(CentroCusto.class.getCanonicalName(), null);
    }

    public void sincFuncoes(List<DTOPontoCargo> funcoes) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionInvalidData, ExceptionIO {
        new AuxSincTangerino().sincFuncoes(funcoes);
        this.registerLog(Funcao.class.getCanonicalName(), null);
    }

    public void sincAfastamentos(List<DTOPontoAfastamentoColaborador> afastamentos) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionInvalidData, ExceptionIO {
        this.registerLog(AfastamentoColaborador.class.getCanonicalName(), null);
        new AuxSincTangerino().sincAfastamentos(afastamentos);
    }

    public void sincColaboradores(List<DTOPontoFuncionario> colaboradores) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionInvalidData, ExceptionIO {
        this.registerLog(Colaborador.class.getCanonicalName(), null);
        new AuxSincTangerino().sincColaboradores(colaboradores);
    }

    private Date getDataUltimaSincronizacao(String chave) {
        LogSincronizacao ultimaSinc = this.serviceLogSincronizacao.getUltimoLog(EnumConstConfigServicosTerceiros.INTEGRACAO_PONTO_TANGERINO, chave);
        if (this.isNotNull(ultimaSinc).booleanValue()) {
            return ultimaSinc.getDataSincronizacao();
        }
        return null;
    }

    private void registerLog(String chave, LogSincronizacao log) {
        if (this.isNull(log).booleanValue()) {
            log = new LogSincronizacao();
            log.setDataSincronizacao(new Date());
            log.setSincronizacoes(new LinkedList());
        }
        log.setChaveSincronizacao(EnumConstConfigServicosTerceiros.INTEGRACAO_PONTO_TANGERINO.getChave());
        LogSincronizacaoEntidade logEnt = new LogSincronizacaoEntidade();
        logEnt.setChaveEntidade(chave);
        logEnt.setLogSincronizacao(log);
        log.getSincronizacoes().add(logEnt);
        this.serviceLogSincronizacao.saveOrUpdate(log);
    }

    public Date getDataBaseSincronizacaoDados() throws ExceptionInvalidState {
        ConfigServicosTerceiros config = this.serviceConfigServico.get(EnumConstConfigServicosTerceiros.INTEGRACAO_PONTO_TANGERINO);
        if (this.isNull(config).booleanValue()) {
            throw new ExceptionInvalidState("A configura\u00e7\u00e3o de acesso ao servi\u00e7o n\u00e3o foi configurada", new Object[0]);
        }
        Optional<ConfigServicosTercItem> result = config.getItensConfig().stream().filter(i -> this.isEquals(i.getItem(), ConstantsIntegracaoPonto.DATA_BASE_SINCRONIZACAO_DADOS.getChave())).findFirst();
        if (result.isEmpty()) {
            throw new ExceptionInvalidState("A data base de sincroniza\u00e7\u00e3o dos dados com o sistema externo de ponto n\u00e3o foi configurada.", new Object[0]);
        }
        ConfigServicosTercItem configData = result.get();
        if (this.isNull(configData.getValor()).booleanValue()) {
            throw new ExceptionInvalidState("A data base de sincroniza\u00e7\u00e3o dos dados com o sistema externo de ponto n\u00e3o foi configurada.", new Object[0]);
        }
        return ToolDate.strToDate((String)configData.getValor(), (String)"dd/MM/yyyy");
    }
}

