/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.integrandorequisicoes;

import com.touchcomp.basementor.model.vo.BloqueioRequisicao;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.bloqueiocontabil.ExceptionBloqueioRequisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.bloqueiorequisicao.ServiceBloqueioRequisicaoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompIntegracaoRequisicao
extends BaseMethods {
    private ServiceBloqueioRequisicaoImpl serviceBloqueioRequisicao;

    @Autowired
    public CompIntegracaoRequisicao(ServiceBloqueioRequisicaoImpl serviceBloqueioRequisicao) {
        this.serviceBloqueioRequisicao = serviceBloqueioRequisicao;
    }

    public List<BloqueioRequisicao> checkBloqueios(IntegracaoRequisicao vo) throws ExceptionInvalidData, ExceptionBloqueioRequisicao {
        if (this.isNull(vo).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0375.001", new Object[0]);
        }
        if (this.isNull(vo.getDataInicial()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0375.002", new Object[0]);
        }
        if (this.isNull(vo.getDataFinal()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0375.003", new Object[0]);
        }
        if (vo.getDataInicial().after(vo.getDataFinal())) {
            throw new ExceptionInvalidData("E.ERP.0375.004", new Object[0]);
        }
        List<BloqueioRequisicao> bloqueios = this.serviceBloqueioRequisicao.buscaBloqueios(vo.getDataFinal(), vo.getEmpresa());
        if (bloqueios != null && !bloqueios.isEmpty()) {
            throw new ExceptionBloqueioRequisicao("E.ERP.0375.005", new Object[]{ToolDate.dateToStr((Date)vo.getDataInicial()), ToolDate.dateToStr((Date)vo.getDataFinal())});
        }
        return bloqueios;
    }
}

