/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocentrocusto;

import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LancamentoCentroCusto;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class CompBaseLancCentroCusto {
    public LancamentoCentroCusto newLancamento(CentroCusto centrocusto, Empresa empresa, GradeCor gradeCor, Date dataLancamento, Short entSai, Short provRel, Double quantidade, Double valor) {
        LancamentoCentroCusto lanc = new LancamentoCentroCusto();
        lanc.setCentroCusto(centrocusto);
        lanc.setEmpresa(empresa);
        lanc.setDataCadastro(new Date());
        lanc.setDataLancamento(dataLancamento);
        lanc.setGradeCor(gradeCor);
        lanc.setQuantidade(quantidade);
        lanc.setValor(valor);
        lanc.setEntSaida(Short.valueOf((short)1));
        lanc.setProvisao(Short.valueOf((short)1));
        return lanc;
    }

    public List<LancamentoCentroCusto> aglutinarLancamentos(List<LancamentoCentroCusto> lancs) {
        LinkedList<LancamentoCentroCusto> ret = new LinkedList<LancamentoCentroCusto>();
        for (LancamentoCentroCusto lanc : lancs) {
            Optional<LancamentoCentroCusto> found = ret.stream().filter(l -> Objects.equals(lanc.getCentroCusto(), l.getCentroCusto())).findFirst();
            if (found.isPresent()) {
                found.get().setValor(Double.valueOf(found.get().getValor() + lanc.getValor()));
                found.get().setQuantidade(Double.valueOf(found.get().getQuantidade() + lanc.getQuantidade()));
                continue;
            }
            ret.add(lanc);
        }
        return ret;
    }
}

