/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil;

import com.google.common.base.Objects;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.paramhistoricolancctb.EnumConstParamHistLancCtb;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoCTBCentroCustos;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.ParamHistoricoLancCtbItem;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.historicopadrao.CompHistoricoPadrao;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorservice.service.impl.paramhistoricolancctb.ServiceParamHistoricoLancCtbItem;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CompLancamentoBase {
    @Autowired
    HelperLoteContabil helperLoteContabil;
    @Autowired
    ServiceParamHistoricoLancCtbItem serviceParamHistorico;
    @Autowired
    protected CompHistoricoPadrao compHistoricoPadrao;
    HashMap<String, ParamHistoricoLancCtbItem> params = new HashMap();

    public LoteContabil criarLoteContabil(Date dataLote, Empresa empresa, ConstEnumOrigemLoteContabil origem) {
        return this.criarLoteContabil(null, dataLote, empresa, origem);
    }

    public LoteContabil criarLoteContabil(LoteContabil lote, Date dataLote, Empresa empresa, ConstEnumOrigemLoteContabil origem) {
        return this.helperLoteContabil.criaRecriaLoteContabil(lote, dataLote, empresa, origem);
    }

    protected boolean isEquals(Object ob1, Object ob2) {
        return Objects.equal((Object)ob1, (Object)ob2);
    }

    protected boolean isNotEquals(Object ob1, Object ob2) {
        return !this.isEquals(ob1, ob2);
    }

    protected boolean isAffimative(Number valor) {
        return ToolMethods.isAffirmative((Number)valor);
    }

    protected boolean addLancamentoLote(LoteContabil lote, Lancamento lancamento, Empresa empresa) {
        lancamento.setValor(Double.valueOf(this.arrredondarNumero(lancamento.getValor(), 2)));
        if (!ToolMethods.isWithData((Number)lancamento.getValor())) {
            return false;
        }
        if (lancamento.getCentroResultadoContFin() == null) {
            lancamento.setCentroResultadoContFin(empresa.getEmpresaDados().getCentroResultadoContFin());
        }
        lancamento.setDataLancamento(lote.getDataLote());
        lancamento.setGrupoEmpresa(empresa.getEmpresaDados().getGrupoEmpresa());
        lancamento.setLoteContabil(lote);
        lote.getLancamentos().add(lancamento);
        return true;
    }

    protected Lancamento newLancamento(PlanoConta pcDebito, PlanoConta pcCredito, Double valor, String historico, HistoricoPadrao hitoricoPadrao, Empresa empresa, CentroCusto centroCusto) throws ExceptionInvalidData {
        Lancamento l = this.newLancamento(pcDebito, pcCredito, valor, historico, hitoricoPadrao, empresa);
        l.getLancamentosCtbCentroCustos().add(new LancamentoCTBCentroCustos(centroCusto, valor, l));
        return l;
    }

    protected Lancamento newLancamento(PlanoConta pcDebito, PlanoConta pcCredito, Double valor, String historico, HistoricoPadrao hitoricoPadrao, Empresa empresa) throws ExceptionInvalidData {
        return this.newLancamento(pcDebito, pcCredito, valor, historico, hitoricoPadrao, empresa, empresa.getEmpresaDados().getCentroResultadoContFin());
    }

    protected Lancamento newLancamento(PlanoConta pcDebito, PlanoConta pcCredito, Double valor, String historico, HistoricoPadrao hitoricoPadrao, Empresa empresa, CentroResultadoContFin centro) throws ExceptionInvalidData {
        if (pcDebito == null && pcCredito == null && valor > 0.0) {
            throw new ExceptionInvalidData("E.ERP.0378.001", new Object[]{historico, ToolFormatter.formataNumero((Number)valor, (int)2), empresa});
        }
        Lancamento lanc = CompLancamentoBase.newLancamento(empresa);
        lanc.setPlanoContaDeb(pcDebito);
        lanc.setPlanoContaCred(pcCredito);
        lanc.setHistoricoPadrao(hitoricoPadrao);
        lanc.setValor(valor);
        lanc.setHistorico(historico);
        if (centro != null) {
            lanc.setCentroResultadoContFin(centro);
        }
        return lanc;
    }

    public static Lancamento newLancamento(LoteContabil lote, Empresa empresa) {
        Lancamento lanc = CompLancamentoBase.newLancamento(empresa);
        lanc.setDataLancamento(lote.getDataLote());
        lanc.setLoteContabil(lote);
        return lanc;
    }

    public static Lancamento newLancamento(Empresa empresa) {
        Lancamento lanc = new Lancamento();
        lanc.setGrupoEmpresa(empresa.getEmpresaDados().getGrupoEmpresa());
        lanc.setEmpresa(empresa);
        lanc.setCentroResultadoContFin(empresa.getEmpresaDados().getCentroResultadoContFin());
        lanc.setGerado(Short.valueOf((short)1));
        lanc.setDataCadastro(new Date());
        return lanc;
    }

    protected void newLancamento(PlanoConta pcDebito, PlanoConta pcCredito, Double valor, String historico, LoteContabil lote, HistoricoPadrao hitoricoPadrao, Empresa empresa) throws ExceptionInvalidData {
        this.addLancamentoLote(lote, this.newLancamento(pcDebito, pcCredito, valor, historico, hitoricoPadrao, empresa), empresa);
    }

    protected Double getDouble(Double vr) {
        return vr != null ? vr : 0.0;
    }

    public List<Lancamento> removerLancContasIguais(List<Lancamento> lancs) {
        LinkedList<Lancamento> aux = new LinkedList<Lancamento>();
        for (Lancamento l : lancs) {
            if (ToolMethods.isEquals((Object)l.getPlanoContaDeb(), (Object)l.getPlanoContaCred())) continue;
            aux.add(l);
        }
        return aux;
    }

    protected List aglutinaLancamentos(List<Lancamento> lancamentos) {
        ArrayList<Lancamento> toRet = new ArrayList<Lancamento>(lancamentos);
        lancamentos.clear();
        for (Lancamento lancamento : toRet) {
            Optional<Lancamento> found = lancamentos.stream().filter(aux -> this.isEquals(aux.getCentroResultadoContFin(), lancamento.getCentroResultadoContFin()) && this.isEquals(aux.getPlanoContaDeb(), lancamento.getPlanoContaDeb()) && this.isEquals(aux.getPlanoContaCred(), lancamento.getPlanoContaCred())).findFirst();
            if (!found.isPresent() && lancamento.getValor() > 0.0) {
                lancamentos.add(lancamento);
                continue;
            }
            if (!found.isPresent()) continue;
            found.get().setValor(Double.valueOf(found.get().getValor() + lancamento.getValor()));
            this.aglutinaLancamentosCentroCusto(found.get(), lancamento);
        }
        return lancamentos;
    }

    private void aglutinaLancamentosCentroCusto(Lancamento main, Lancamento lanc2) {
        for (LancamentoCTBCentroCustos lcc : lanc2.getLancamentosCtbCentroCustos()) {
            Optional<LancamentoCTBCentroCustos> found = main.getLancamentosCtbCentroCustos().stream().filter(aux -> this.isEquals(aux.getCentroCusto(), lcc.getCentroCusto())).findFirst();
            if (!found.isPresent() && lcc.getValor() > 0.0) {
                main.getLancamentosCtbCentroCustos().add(lcc);
                lcc.setLancamentoContabil(main);
                continue;
            }
            if (!found.isPresent()) continue;
            found.get().setValor(Double.valueOf(found.get().getValor() + lcc.getValor()));
        }
    }

    protected void aglutinarLancamentos(LoteContabil lote) {
        if (lote != null && lote.getLancamentos() != null) {
            List lista = this.aglutinaLancamentos(lote.getLancamentos());
            lote.setLancamentos(lista);
        }
    }

    protected double arrredondarNumero(double number, int decimal) {
        return ToolFormatter.arrredondarNumero((Double)number, (int)decimal);
    }

    protected double arrredondarNumero(double number) {
        return this.arrredondarNumero(number, 2);
    }

    protected void removerLancValorZero(LoteContabil lote) {
        lote.getLancamentos().removeIf(i -> !ToolMethods.isWithData((Number)i.getValor()));
    }

    public String getHistorico(EnumConstParamHistLancCtb type, String codHistPersonalizado, Object origem) throws ExceptionReflection, ExceptionInvalidData {
        ParamHistoricoLancCtbItem found;
        String codigoHistDefault = "D" + codHistPersonalizado;
        String key = type.getCodigo() + codHistPersonalizado;
        if (this.params.containsKey(key) && this.params.get(key) == null) {
            return MessagesBaseMentor.getBaseHistoricoLancamentos((String)codigoHistDefault, (Object[])new Object[]{origem});
        }
        if (!this.params.containsKey(key)) {
            found = this.serviceParamHistorico.getHistoricoPadrao(EnumConstParamHistLancCtb.INTEGRACAO_COM_PRODUCAO, codHistPersonalizado);
            this.params.put(key, found);
        }
        if ((found = this.params.get(key)) != null) {
            return this.compHistoricoPadrao.buildHistoricoDinamico(found.getHistoricoPadrao(), origem);
        }
        return MessagesBaseMentor.getBaseHistoricoLancamentos((String)codigoHistDefault, (Object[])new Object[]{origem});
    }
}

