/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.apuracaocooperados;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.opcoescontabeis.EnumConstOpContabeisTipoCont;
import com.touchcomp.basementor.model.vo.ApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.ItemApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.ItemTituloApuracCooperado;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CompLancamentoApuracaoCoop
extends CompLancamentoBase {
    public LoteContabil contabilizar(ApuracaoValoresCooperados vo, OpcoesContabeis opContabeis, boolean forcarIndConfOpcoes) throws ExceptionInvalidData {
        if (!this.isValidParamsByContabilizacao(vo, opContabeis, forcarIndConfOpcoes)) {
            return null;
        }
        LoteContabil lote = vo.getLoteContabil();
        if (lote == null) {
            lote = this.criarLoteContabil(lote, vo.getDataBaixa(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.APURACAO_VALORES_COOPERADOS);
        }
        List<Object> lancs = new LinkedList<Lancamento>();
        this.contabilizarLancamentos(vo, opContabeis, lancs);
        if (ToolMethods.isEquals((Object)opContabeis.getTipoContabilizacaoApCooperados(), (Object)EnumConstOpContabeisTipoCont.CONTABILIZAR_SINTETICO.getValue())) {
            lancs = this.aglutinaLancamentos(lancs);
        }
        lote.getLancamentos().clear();
        lancs = this.removerLancContasIguais(lancs);
        for (Lancamento lancamento : lancs) {
            this.addLancamentoLote(lote, lancamento, vo.getEmpresa());
        }
        return lote;
    }

    private boolean isValidParamsByContabilizacao(ApuracaoValoresCooperados vo, OpcoesContabeis opContabeis, boolean forcarIndConfOpcoes) {
        if (ToolMethods.isEquals((Object)opContabeis, null)) {
            return false;
        }
        return forcarIndConfOpcoes || !ToolMethods.isEquals((Object)opContabeis.getTipoContabilizacaoApCooperados(), (Object)EnumConstOpContabeisTipoCont.NAO_CONTABILIZAR);
    }

    private void contabilizarLancamentos(ApuracaoValoresCooperados vo, OpcoesContabeis opContabeis, List<Lancamento> lancs) throws ExceptionInvalidData {
        for (ItemApuracaoValoresCooperados v : vo.getValoresCooperados()) {
            List<ResumoConta> res = this.getRes(v);
            double totPagarD = res.stream().mapToDouble(i -> this.isEquals(i.pagRec, (short)0) ? i.valor : 0.0).sum();
            double totRecebimentoD = res.stream().mapToDouble(i -> this.isEquals(i.pagRec, (short)1) ? i.valor : 0.0).sum();
            if (!ToolMethods.isWithData((Number)totPagarD) || !ToolMethods.isWithData((Number)totRecebimentoD)) continue;
            this.contabilizarLancamentos(vo, v, opContabeis, lancs, res, totPagarD, totRecebimentoD);
        }
    }

    private List<ResumoConta> getRes(ItemApuracaoValoresCooperados v) {
        LinkedList<ResumoConta> res = new LinkedList<ResumoConta>();
        for (ItemTituloApuracCooperado t : v.getTitulos()) {
            Optional<ResumoConta> found = res.stream().filter(i -> this.isEquals(i.planoConta, t.getTitulo().getPlanoConta()) && this.isEquals(i.pagRec, t.getTitulo().getPagRec())).findFirst();
            if (!found.isPresent()) {
                r = new ResumoConta(this, t.getTitulo().getPlanoConta(), t.getTitulo().getPagRec());
                res.add(r);
            } else {
                r = found.get();
            }
            r.valor += t.getSaldoTitulo().doubleValue();
        }
        return res;
    }

    private void contabilizarLancamentos(ApuracaoValoresCooperados vo, ItemApuracaoValoresCooperados item, OpcoesContabeis opContabeis, List<Lancamento> lancs, List<ResumoConta> res, double totPagarD, double totRecebimentoD) throws ExceptionInvalidData {
        while (true) {
            double vlrLanc;
            Optional<ResumoConta> foundPag = res.stream().filter(i -> this.isEquals(i.pagRec, (short)0) && i.valor > 0.0).findFirst();
            Optional<ResumoConta> foundRec = res.stream().filter(i -> this.isEquals(i.pagRec, (short)1) && i.valor > 0.0).findFirst();
            if (!foundPag.isPresent() || !foundRec.isPresent()) break;
            ResumoConta p1 = foundPag.get();
            ResumoConta r1 = foundRec.get();
            if (p1.valor > r1.valor) {
                vlrLanc = r1.valor;
                p1.valor -= r1.valor;
                r1.valor = 0.0;
            } else if (p1.valor < r1.valor) {
                vlrLanc = p1.valor;
                r1.valor -= p1.valor;
                p1.valor = 0.0;
            } else {
                vlrLanc = r1.valor;
                p1.valor = 0.0;
                r1.valor = 0.0;
            }
            if (ToolMethods.isEquals((Object)p1.planoConta, (Object)r1.planoConta)) continue;
            lancs.add(this.newLancamento(p1.planoConta, r1.planoConta, vlrLanc, this.getHistorico(vo), this.getHistorico(opContabeis), vo.getEmpresa()));
        }
    }

    private HistoricoPadrao getHistorico(OpcoesContabeis opContabeis) {
        return null;
    }

    private String getHistorico(ApuracaoValoresCooperados i) {
        return "Lancamento apura\u00e7\u00e3o valores: " + i.getDescricao();
    }

    private class ResumoConta {
        private PlanoConta planoConta;
        private double valor;
        private Short pagRec;

        public ResumoConta(CompLancamentoApuracaoCoop compLancamentoApuracaoCoop, PlanoConta planoConta, Short pagRec) {
            this.planoConta = planoConta;
            this.pagRec = pagRec;
        }
    }
}

