/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.baixatitulo.EnumConstFormaPagamentoBaixaTitulo;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.IntegracaoBaixaTituloGrupoBaixaFormas;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos.CompLancBaixaTituloAntecipacao;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos.CompLancBaixaTituloBorderoTitulos;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos.CompLancBaixaTituloCartao;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos.CompLancBaixaTituloCheque;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos.CompLancBaixaTituloChequeTerc;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos.CompLancBaixaTituloCompensacao;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos.CompLancBaixaTituloContaValor;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos.CompLancBaixaTituloFaltaPag;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompIntegBaixaTitulos
extends CompLancamentoBase {
    @Autowired
    CompLancBaixaTituloCheque compLancCheque;
    @Autowired
    CompLancBaixaTituloContaValor compLancContaValor;
    @Autowired
    CompLancBaixaTituloFaltaPag compLancFaltaPagamento;
    @Autowired
    CompLancBaixaTituloChequeTerc compLancChequeTerceiros;
    @Autowired
    CompLancBaixaTituloBorderoTitulos compLancBorderoTitulos;
    @Autowired
    CompLancBaixaTituloAntecipacao compLancAntecipacao;
    @Autowired
    CompLancBaixaTituloCartao compLancCartao;
    @Autowired
    CompLancBaixaTituloCompensacao compLancCompensacao;

    public LoteContabil getLancamentosBaixa(GrupoDeBaixaFormas vo, OpcoesContabeis opcCont, Empresa empresa) throws ExceptionBase {
        ArrayList<Lancamento> lancamentos = new ArrayList<Lancamento>();
        this.validarDadosBaixaConfOpContabeis(vo.getGrupoDeBaixa(), opcCont);
        if (vo.getIntegracaoBaixaTituloGrupoBaixaFormas() == null) {
            IntegracaoBaixaTituloGrupoBaixaFormas i = new IntegracaoBaixaTituloGrupoBaixaFormas();
            vo.setIntegracaoBaixaTituloGrupoBaixaFormas(i);
            i.setGrupoDeBaixaFormas(vo);
        }
        LoteContabil lote = this.criarLoteContabil(vo.getIntegracaoBaixaTituloGrupoBaixaFormas().getLoteContabil(), vo.getGrupoDeBaixa().getDataLiquidacao(), empresa, ConstEnumOrigemLoteContabil.INTEGRACAO_BAIXA_TITULOS_LOTE);
        if (this.isEquals(vo.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.CHEQUE.getValue())) {
            this.compLancCheque.getLancamentosPorCheque(vo, lote, lancamentos, opcCont, empresa);
        } else if (this.isEquals(vo.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.CONTA_VALOR.getValue())) {
            this.compLancContaValor.getLancamentosPorContaValor(vo, lote, lancamentos, opcCont, empresa);
        } else if (this.isEquals(vo.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.FALTA_PAGAMENTO.getValue())) {
            this.compLancFaltaPagamento.getLancamentosPorFaltaPagamento(vo, lote, lancamentos, empresa);
        } else if (this.isEquals(vo.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.CHEQUE_TERCEIROS.getValue())) {
            this.compLancChequeTerceiros.getLancamentosPorChequeTerceiros(vo, lote, lancamentos, empresa);
        } else if (this.isEquals(vo.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.BORDERO_COBRANCA.getValue())) {
            this.compLancBorderoTitulos.getLancamentosPorBorderoTitulos(vo, lote, lancamentos, empresa);
        } else if (this.isEquals(vo.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.TITULO_ANTECIPADO.getValue()) || this.isEquals(vo.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.ANTECIPADO.getValue())) {
            this.compLancAntecipacao.getLancamentosPorAntecipacao(vo, lote, lancamentos, empresa);
        } else if (this.isEquals(vo.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.CARTAO_CREDITO.getValue()) || this.isEquals(vo.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.CARTAO_DEBITO.getValue())) {
            this.compLancCartao.getLancamentoPorCartao(vo, lote, lancamentos, opcCont, empresa);
        } else if (this.isEquals(vo.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.COMPENSACAO_TITULOS.getValue()) && vo.getGrupoBaixaCompensacao() != null) {
            this.compLancCompensacao.getLancamentoPorCompensacao(vo, lote, lancamentos, empresa);
        }
        lote.getLancamentos().addAll(lancamentos);
        if (lote.getLancamentos() != null && !lote.getLancamentos().isEmpty()) {
            vo.getIntegracaoBaixaTituloGrupoBaixaFormas().setLoteContabil(lote);
            return lote;
        }
        vo.setIntegracaoBaixaTituloGrupoBaixaFormas(null);
        return null;
    }

    public void validarDadosBaixaConfOpContabeis(GrupoDeBaixa grupo, OpcoesContabeis opcCont) {
        for (GrupoDeBaixaFormas grupoDeBaixaForma : grupo.getGrupoDeBaixaFormas()) {
            for (BaixaTitulo baixaTitulo : grupoDeBaixaForma.getBaixaTitulo()) {
                if (this.isEquals(opcCont.getBloqIntDataBaixaMenorEmissao(), EnumConstantsMentorSimNao.SIM.getValue()) && grupo.getDataLiquidacao().before(baixaTitulo.getTitulo().getDataEmissao())) {
                    throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0376.003", new String[]{baixaTitulo.getTitulo().toString()}));
                }
                if (!this.isEquals(opcCont.getBloqIntDataBaixaMenorEntEmi(), EnumConstantsMentorSimNao.SIM.getValue()) || !grupo.getDataLiquidacao().before(baixaTitulo.getTitulo().getDataCompetencia())) continue;
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0376.004", new String[]{baixaTitulo.getTitulo().toString()}));
            }
        }
    }
}

